/*
 * Decompiled with CFR 0.152.
 */
package emitters.bindings.gobject;

import emitters.bindings.gobject.GObjectEmitter;
import emitters.model.DataObject;
import emitters.model.Enum;
import emitters.model.ManagedObject;
import emitters.model.Method;
import emitters.model.Property;
import emitters.model.Version;
import emitters.model.VmodlDecl;
import emitters.model.VmodlObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

public class GObjectInterfaceEmitter
extends GObjectEmitter {
    private String _directory;
    private List<String> _includeList;
    private boolean _emitAggregateHeader;
    private String _packageName;

    public GObjectInterfaceEmitter(Map<String, String> options, String directory) {
        super(options);
        this._directory = directory;
        this._includeList = new ArrayList<String>();
        this._includeList.add("gvmomi/gvmomi.h");
        this._includeList.add("gVmomi/Vmodl/Vmomi/DataObject.h");
        this._includeList.add("gVmomi/Vmodl/Vmomi/ManagedObject.h");
        this._emitAggregateHeader = true;
    }

    @Override
    public boolean isBindingEmitter() {
        return true;
    }

    @Override
    public void processOptions() {
        for (Map.Entry entry : this._emitterOptions.entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            if (key.equals("include")) {
                for (String header : value.split(",")) {
                    if (header.equals(this.getFilename())) continue;
                    this._includeList.add(header);
                }
                continue;
            }
            if (key.equals("aggregate.header")) {
                if (!value.equals("0") && !value.equals("false")) continue;
                this._emitAggregateHeader = false;
                continue;
            }
            if (key.equals("header.dir")) {
                this._directory = value;
                continue;
            }
            if (!key.equals("package.name")) continue;
            this._packageName = value;
        }
    }

    @Override
    public void emitObjects(List<VmodlObject> objects) {
        ArrayList<VmodlObject> allObjects = new ArrayList<VmodlObject>();
        allObjects.addAll(objects);
        allObjects.addAll(this.collectNestedObjects(objects));
        objects = allObjects;
        for (VmodlObject obj : objects) {
            this.beginFile(obj);
            this.emitObject(obj);
            this.endFile(obj);
            if (obj instanceof Enum) continue;
            this.writeClassDeclFile(obj);
        }
        if (this._emitAggregateHeader) {
            TreeMap<String, Set<String>> headerMap = new TreeMap<String, Set<String>>();
            for (VmodlObject obj : objects) {
                if (obj.getContainer() != null) break;
                String className = this.getQualifiedClassName(obj);
                String dirPath = this._directory.length() > 0 ? this._directory + "/" : "";
                String prefixPath = "";
                for (String dir : className.split("::")) {
                    if (prefixPath.length() > 0) {
                        Set<String> headerSet;
                        String aggHeader = dirPath + prefixPath + ".h";
                        if (headerMap.containsKey(aggHeader)) {
                            headerSet = (Set)headerMap.get(aggHeader);
                        } else {
                            headerSet = new TreeSet();
                            headerMap.put(aggHeader, headerSet);
                        }
                        if (className.equals(obj.getClassName())) {
                            headerSet.add(this.getHeaderFile(obj));
                            continue;
                        }
                        prefixPath = prefixPath + "/" + dir;
                        headerSet.add(dirPath + prefixPath + ".h");
                        continue;
                    }
                    prefixPath = dir;
                }
            }
            for (String aggHeader : headerMap.keySet()) {
                this.beginFile(aggHeader);
                this.emitFileHeader();
                String poundDefine = this.getPoundDefine(aggHeader);
                this.emitLine("#ifndef " + poundDefine);
                this.emitLine("#define " + poundDefine);
                this.emitLine();
                Set headerSet = (Set)headerMap.get(aggHeader);
                for (String objHeader : headerSet) {
                    this.emitLine("#include " + GObjectInterfaceEmitter.qq(objHeader));
                }
                this.emitLine("#endif");
                this.endFile();
            }
        }
        this.emitNameMapHeader();
        this.emitVersionMapHeader();
    }

    private void emitObject(VmodlObject obj) {
        if (obj instanceof ManagedObject) {
            this.emitManagedObject((ManagedObject)obj);
        } else if (obj instanceof DataObject) {
            this.emitDataObject((DataObject)obj);
        } else if (obj instanceof Enum) {
            this.emitDependencyHeaders(obj);
            this.emitEnum((Enum)obj);
        } else {
            throw new RuntimeException("Unexpected object type");
        }
    }

    private void emitManagedObject(ManagedObject obj) {
        this.emitBoilerPlate(obj);
        this.emitDependencyClassDecls(obj);
        this.emitInstanceHeader(obj);
        this.emitLine();
        this.emitPropDecls(obj);
        if (obj.getBaseObject() == null) {
            this.emitLine("/* <private> */");
            this.emitLine("GVmomiSession *session;");
            this.emitLine("gchar *instanceID;");
            this.emitLine("guint loaded;");
            this.emitLine("gboolean partialUpdates;");
        }
        this.emitStructFooter(obj);
        this.emitClassHeader(obj);
        if (obj.getBaseObject() == null) {
            this.emitLine();
            this.emitLeaveDecl();
            this.emitArrayNotifyDecl();
        }
        this.emitStructFooter(obj);
        this.emitTypeMethod(obj);
        this.emitLine();
        this.emitLine();
        for (Method method : obj.getMethodList()) {
            this.emitLine(this.formatMethodDecl(method, obj));
            this.emitLine();
        }
        this.emitDependencyHeaders(obj);
    }

    private void emitDataObject(DataObject obj) {
        this.emitBoilerPlate(obj);
        this.emitDependencyClassDecls(obj);
        this.emitInstanceHeader(obj);
        this.emitLine();
        this.emitPropDecls(obj);
        if (obj.getBaseObject() == null) {
            this.emitLine("/* <private> */");
            this.emitLine("GVmomiSession *session;");
            if (obj.isFault()) {
                this.emitLine("/*<public read only>*/");
                this.emitLine("char *code;");
                this.emitLine("char *string;");
            }
        }
        this.emitStructFooter(obj);
        this.emitClassHeader(obj);
        if (obj.getBaseObject() == null) {
            this.emitLine();
            this.emitArrayNotifyDecl();
        }
        this.emitStructFooter(obj);
        this.emitTypeMethod(obj);
        this.emitLine();
        this.emitLine();
        this.emitDependencyHeaders(obj);
    }

    private void emitEnum(Enum obj) {
        String enumType = this.getGInstanceName(obj);
        this.emitLine("#define " + this.getGTypeName(obj) + "\t(" + this.getGetType(obj) + "())");
        this.emitLine();
        this.emitLine("typedef enum {");
        this.indent();
        for (String value : obj.getValueList()) {
            String valueString = this.getGEnumValue(value, obj);
            this.emitLine(valueString + ", /* " + value + " */");
        }
        this.unindent();
        this.emitLine("} " + enumType + ";");
        this.emitLine();
        this.emitTypeMethod(obj);
        this.emitLine();
    }

    private void emitTypeMethod(VmodlObject obj) {
        this.emitLine("GVMOMI_EXPORT GType " + this.getGetType(obj) + "(void);");
    }

    private void emitInstanceHeader(VmodlObject obj) {
        this.emitLine("struct _" + this.getGInstanceName(obj));
        this.emitLine("{");
        this.indent();
        String baseParent = obj instanceof ManagedObject ? "GInitiallyUnowned" : "GObject";
        String baseObj = obj.getBaseObject() != null ? this.getGInstanceName(obj.getBaseObject()) : baseParent;
        this.emitLine(baseObj + " parent;");
    }

    private void emitPropDecls(VmodlObject obj) {
        for (Property property : obj.getPropertyList()) {
            String memberName = this.getMemberName(property);
            VmodlDecl decl = property.getDecl();
            this.emitLine(this.formatDecl(this.getPropDeclString(decl), memberName) + ";" + (decl.isOptional() ? " /* Optional */" : ""));
            if (!decl.isAny() && !decl.isManaged()) continue;
            if (decl.isArray()) {
                this.emitLine(this.formatDecl("GArray *", memberName + "_managed_type") + ";");
                continue;
            }
            this.emitLine(this.formatDecl("GType", memberName + "_managed_type") + ";");
        }
    }

    private void emitClassHeader(VmodlObject obj) {
        this.emitLine("struct _" + this.getGClassName(obj));
        this.emitLine("{");
        this.indent();
        String baseParent = obj instanceof ManagedObject ? "GInitiallyUnownedClass" : "GObjectClass";
        String baseObj = obj.getBaseObject() != null ? this.getGClassName(obj.getBaseObject()) : baseParent;
        this.emitLine(baseObj + " parent_class;");
    }

    private void emitLeaveDecl() {
        this.emitLine("void (*leave) (GObject *object);");
    }

    private void emitArrayNotifyDecl() {
        this.emitLine("void (*array_notify) (GObject *object,");
        this.emitLine("                      GParamSpec *psec,");
        this.emitLine("                      gboolean added,");
        this.emitLine("                      const GValue *value);");
    }

    private void emitStructFooter(VmodlObject obj) {
        this.unindent();
        this.emitLine("};");
        this.emitLine();
    }

    private void emitBoilerPlate(VmodlObject obj) {
        String usUName = this.getUnderscoreName(obj).toUpperCase();
        String typeName = this.getGTypeName(obj);
        String instanceName = this.getGInstanceName(obj);
        String className = this.getGClassName(obj);
        this.emitLine("/* GObject type query macros */");
        this.emitLine();
        this.emitLine("#define " + typeName + "\t(" + this.getGetType(obj) + "())");
        this.emitLine("#define " + this.getGTypeCast(obj) + "(obj)\t(G_TYPE_CHECK_INSTANCE_CAST((obj), " + typeName + ", " + instanceName + "))");
        this.emitLine("#define " + this.getGTypeCast(obj) + "_CLASS(klass)\t(G_TYPE_CHECK_CLASS_CAST((klass), " + typeName + ", " + className + "))");
        this.emitLine("#define VMODL_IS_" + usUName + "(obj)\t(G_TYPE_CHECK_INSTANCE_TYPE((obj), " + typeName + "))");
        this.emitLine("#define VMODL_IS_" + usUName + "_CLASS(klass)\t(G_TYPE_CHECK_CLASS_TYPE((klass), " + typeName + "))");
        this.emitLine("#define " + this.getGTypeCast(obj) + "_GET_CLASS(klass)\t(G_TYPE_INSTANCE_GET_CLASS_((obj), " + typeName + ", " + className + "))");
        this.emitLine();
        this.emitLine("G_END_DECLS");
        this.emitLine();
        this.emitLine("/* Class declaration */");
        this.emitLine();
        this.emitLine("#include " + GObjectInterfaceEmitter.qq(this.getClassDeclFile(obj)));
        this.emitLine();
        this.emitLine("G_BEGIN_DECLS");
        this.emitLine();
    }

    private void writeClassDeclFile(VmodlObject obj) {
        String filename = this.getClassDeclFile(obj);
        String instanceName = this.getGInstanceName(obj);
        String className = this.getGClassName(obj);
        this.beginFile(filename);
        this.emitFileHeader();
        String poundDefine = this.getPoundDefine(filename);
        this.emitLine("#ifndef " + poundDefine);
        this.emitLine("#define " + poundDefine);
        this.emitLine();
        this.emitLine("#ifdef WIN32");
        this.emitLine("#pragma pack(push, 8)");
        this.emitLine("#endif // WIN32");
        this.emitLine("#include <glib.h>");
        this.emitLine("#ifdef WIN32");
        this.emitLine("#pragma pack(pop)");
        this.emitLine("#endif // WIN32");
        this.emitLine();
        this.emitLine("G_BEGIN_DECLS");
        this.emitLine();
        this.emitLine("typedef struct _" + instanceName + "\t" + instanceName + ";");
        this.emitLine("typedef struct _" + className + "\t" + className + ";");
        this.emitLine();
        this.emitLine("G_END_DECLS");
        this.emitLine();
        this.emitLine("#endif");
        this.endFile();
    }

    private void beginFile(VmodlObject obj) {
        String filename = this.getHeaderFile(obj);
        this.beginFile(filename);
        this.emitFileHeader();
        String poundDefine = this.getPoundDefine(filename);
        this.emitLine("#ifndef " + poundDefine);
        this.emitLine("#define " + poundDefine);
        this.emitLine();
        for (String includeFile : this._includeList) {
            this.emitLine("#include " + GObjectInterfaceEmitter.qq(includeFile));
        }
        this.emitLine("G_BEGIN_DECLS");
        this.emitLine();
    }

    private void emitDependencyHeaders(VmodlObject obj) {
        String dependHeader;
        String filename = this.getHeaderFile(obj);
        Set<VmodlObject> ignored = this.getIgnoredDependencies(obj);
        TreeSet<String> includeSet = new TreeSet<String>();
        for (VmodlObject dependObj : obj.getAllAsToplevelDependencies(false)) {
            dependHeader = this.getHeaderFile(dependObj);
            if (dependHeader.equals(filename) || ignored.contains(dependObj)) continue;
            includeSet.add(dependHeader);
        }
        for (VmodlObject dependObj : obj.getNestedList()) {
            dependHeader = this.getHeaderFile(dependObj);
            if (dependHeader.equals(filename)) continue;
            includeSet.add(dependHeader);
        }
        this.emitLine("G_END_DECLS");
        for (String includeFile : includeSet) {
            this.emitLine("#include " + GObjectInterfaceEmitter.qq(includeFile));
        }
        this.emitLine("G_BEGIN_DECLS");
        this.emitLine();
        this.emitLine();
    }

    private void emitDependencyClassDecls(VmodlObject obj) {
        String filename = this.getClassDeclFile(obj);
        Set<VmodlObject> ignored = this.getIgnoredDependencies(obj);
        TreeSet<String> includeSet = new TreeSet<String>();
        for (VmodlObject dependObj : obj.getAllAsToplevelDependencies(false)) {
            String dependHeader = this.getClassDeclFile(dependObj);
            if (dependHeader.equals(filename) || ignored.contains(dependObj)) continue;
            includeSet.add(dependHeader);
        }
        this.emitLine("G_END_DECLS");
        for (String includeFile : includeSet) {
            this.emitLine("#include " + GObjectInterfaceEmitter.qq(includeFile));
        }
        if (obj.getBaseObject() != null) {
            this.emitLine("#include " + GObjectInterfaceEmitter.qq(this.getHeaderFile(obj.getBaseObject())));
        }
        this.emitLine("G_BEGIN_DECLS");
        this.emitLine();
        this.emitLine();
    }

    private void endFile(VmodlObject obj) {
        this.emitLine("G_END_DECLS");
        this.emitLine();
        this.emitLine("#endif");
        this.endFile();
    }

    private String getHeaderFile(VmodlObject obj) {
        return this.getHeaderFile(obj, this._directory);
    }

    private String getClassDeclFile(VmodlObject obj) {
        if (obj instanceof Enum) {
            return this.getHeaderFile(obj);
        }
        return this.getClassDeclFile(obj, this._directory);
    }

    private String getPoundDefine(String filename) {
        return "_" + filename.toUpperCase().replaceAll("[./]", "_") + "_";
    }

    private Set<VmodlObject> getIgnoredDependencies(VmodlObject obj) {
        HashSet<VmodlObject> refs = new HashSet<VmodlObject>();
        HashSet<VmodlObject> unRefs = new HashSet<VmodlObject>();
        HashSet<VmodlObject> rets = new HashSet<VmodlObject>();
        VmodlObject baseObj = obj.getBaseObject();
        if (baseObj != null) {
            unRefs.add(baseObj);
        }
        if (obj instanceof ManagedObject) {
            ManagedObject mobj = (ManagedObject)obj;
            for (Method m : mobj.getMethodList()) {
                VmodlObject retObj = m.getReturnDecl().getObject();
                if (retObj == null) continue;
                rets.add(retObj);
            }
        }
        Collection<VmodlDecl> referencedDecls = obj instanceof ManagedObject ? ((ManagedObject)obj).getReferencedDecls(true, false) : obj.getReferencedDecls(true);
        for (VmodlDecl decl : referencedDecls) {
            VmodlObject refObj = decl.getObject();
            if (refObj == null) continue;
            if (decl.isArray() && !unRefs.contains(refObj)) {
                refs.add(refObj);
                continue;
            }
            unRefs.add(refObj);
            if (refs.contains(refObj)) {
                refs.remove(refObj);
            }
            if (!rets.contains(refObj)) continue;
            rets.remove(refObj);
        }
        refs.addAll(rets);
        return refs;
    }

    private void emitNameMapHeader() {
        String filename = this._directory + "/" + this._packageName + "NameMap.h";
        this.beginFile(filename);
        this.emitFileHeader();
        String poundDefine = this.getPoundDefine(filename);
        this.emitLine("#ifndef " + poundDefine);
        this.emitLine("#define " + poundDefine);
        this.emitLine();
        this.emitLine("#ifdef WIN32");
        this.emitLine("#pragma pack(push, 8)");
        this.emitLine("#endif // WIN32");
        this.emitLine("#include <glib.h>");
        this.emitLine("#ifdef WIN32");
        this.emitLine("#pragma pack(pop)");
        this.emitLine("#endif // WIN32");
        this.emitLine("#include " + GObjectInterfaceEmitter.qq("gvmomi/gvmomiExport.h"));
        this.emitLine();
        this.emitLine("G_BEGIN_DECLS");
        this.emitLine();
        this.emitLine("void vmodl_" + this._packageName + "_populate_name_map(GHashTable *table);");
        this.emitLine();
        this.emitLine("G_END_DECLS");
        this.emitLine();
        this.emitLine("#endif");
        this.endFile();
    }

    private void emitVersionMapHeader() {
        String filename = this._directory + "/" + this._packageName + "VersionMap.h";
        this.beginFile(filename);
        this.emitFileHeader();
        String poundDefine = this.getPoundDefine(filename);
        this.emitLine("#ifndef " + poundDefine);
        this.emitLine("#define " + poundDefine);
        this.emitLine();
        this.emitLine("#ifdef WIN32");
        this.emitLine("#pragma pack(push, 8)");
        this.emitLine("#endif // WIN32");
        this.emitLine("#include <glib.h>");
        this.emitLine("#ifdef WIN32");
        this.emitLine("#pragma pack(pop)");
        this.emitLine("#endif // WIN32");
        this.emitLine("#include " + GObjectInterfaceEmitter.qq("gvmomi/gvmomiExport.h"));
        this.emitLine();
        this.emitLine("G_BEGIN_DECLS");
        this.emitLine();
        this.emitLine("void vmodl_" + this._packageName + "_populate_version_map(GHashTable *table);");
        this.emitLine();
        this.emitLine("/* Version Quarks */");
        for (Version version : GObjectEmitter.getTargetVersions()) {
            String quarkName;
            if (!this.shouldEmitVersionForClass(version, this._packageName) || (quarkName = this.getVersionQuarkName(version)).isEmpty()) continue;
            String quarkLower = quarkName.toLowerCase();
            this.emitLine("#define " + quarkName + " (" + quarkLower + "())");
            this.emitLine("#define " + this.getVersionName(version) + " (g_quark_to_string(" + quarkName + "))");
            this.emitLine("GVMOMI_EXPORT GQuark " + quarkLower + "(void);");
            this.emitLine();
        }
        this.emitLine();
        this.emitLine("G_END_DECLS");
        this.emitLine();
        this.emitLine("#endif");
        this.endFile();
    }
}

