/*
 * Decompiled with CFR 0.152.
 */
package emitters.bindings.gobject;

import emitters.bindings.gobject.GObjectEmitter;
import emitters.core.PrivilegeDefinitionBuilder;
import emitters.model.DataObject;
import emitters.model.ManagedObject;
import emitters.model.Method;
import emitters.model.Parameter;
import emitters.model.Privilege;
import emitters.model.Property;
import emitters.model.VmodlObject;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class GObjectPrivilegeEmitter
extends GObjectEmitter {
    private final String _directory;
    private List<Privilege> _privList;
    private List<String> _noPrivMethods;
    private Set<String> _privs;
    private Set<String> _unusedPrivs;
    private Set<String> _systemPrivs;
    private String _privXml;

    public GObjectPrivilegeEmitter(Map<String, String> options, String directory) {
        super(options);
        this._directory = directory;
        this._privList = new ArrayList<Privilege>();
        this._noPrivMethods = new ArrayList<String>();
        this._privs = new HashSet<String>();
        this._unusedPrivs = new HashSet<String>();
        this._systemPrivs = new HashSet<String>();
    }

    @Override
    public boolean isBindingEmitter() {
        return true;
    }

    @Override
    public void processOptions() {
        for (Map.Entry entry : this._emitterOptions.entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            if (!key.equals("xml")) continue;
            this._privXml = value;
        }
    }

    @Override
    public void emitObjects(List<VmodlObject> objects) {
        PrivilegeDefinitionBuilder privBuilder = new PrivilegeDefinitionBuilder();
        this._systemPrivs.addAll(privBuilder.systemDefinedPrivileges());
        this._privList = privBuilder.loadPrivileges(this._privXml);
        for (Privilege priv : this._privList) {
            this._privs.add(priv.GetId());
            this._unusedPrivs.add(priv.GetId());
        }
        for (VmodlObject obj : objects) {
            this.processObject(obj);
        }
        if (this._noPrivMethods.size() > 0) {
            System.out.println("Methods without a privilege annotation:");
            for (String method : this._noPrivMethods) {
                System.out.println("    " + method);
            }
            throw new RuntimeException("Fix managed methods missing privileges.");
        }
        this.beginFile(this._directory + "/VmodlPrivilege.h");
        this.emitHeader();
        this.emitPrivilegeDecl();
        this.emitFooter();
        this.endFile();
        this.beginFile(this._directory + "/VmodlPrivilege.c");
        this.emitLine("#include " + GObjectPrivilegeEmitter.qq("VmodlPrivilege.h"));
        this.emitLine();
        this.emitPrivilegeInit();
        this.emitLine();
        this.emitPrivilegeUpdate();
        this.emitLine();
        this.emitPrivilegeCheck();
        this.emitLine();
        this.endFile();
        this.beginFile(this._directory + "/Subdir.mk");
        this.emitLine("SUBDIR_FILES += VmodlPrivilege.c");
        this.endFile();
    }

    private void emitHeader() {
        this.emitFileHeader();
        this.emitLine();
        this.emitLine("#ifndef _VMODL_PRIVILEGE_H_");
        this.emitLine("#define _VMODL_PRIVILEGE_H_");
        this.emitLine("#include <glib-object.h>");
        this.emitLine();
        this.emitLine("G_BEGIN_DECLS");
        this.emitLine();
    }

    private void emitFooter() {
        this.emitLine();
        this.emitLine("G_END_DECLS");
        this.emitLine();
        this.emitLine("#endif /* _VMODL_PRIVILEGE_H_ */");
    }

    private void emitPrivilegeDecl() {
        this.emitLine();
        for (Privilege priv : this._privList) {
            String privConstant = priv.GetId().toUpperCase().replaceAll("\\.", "_");
            this.emitLine("#define PRIV_" + privConstant + " " + GObjectPrivilegeEmitter.qq(priv.GetId()));
        }
        this.emitLine();
        this.emitLine("GHashTable *vmodl_privilege_create_table(void);");
        this.emitLine();
        this.emitLine("void vmodl_privilege_update(GHashTable *table, const gchar *privilege, gboolean value);");
        this.emitLine();
        this.emitLine("gboolean vmodl_privilege_check(GHashTable *table, const gchar *privilege);");
    }

    private void emitPrivilegeInit() {
        this.emitLine("GHashTable *");
        this.emitLine("vmodl_privilege_create_table(void)");
        this.emitLine("{");
        this.indent();
        this.emitLine("GHashTable *table;");
        this.emitLine("table = g_hash_table_new_full(g_str_hash, g_str_equal, g_free, NULL);");
        this.emitLine("g_return_val_if_fail(table != NULL, table);");
        this.emitLine();
        for (Privilege priv : this._privList) {
            this.emitLine("g_hash_table_replace(table, g_strdup(" + GObjectPrivilegeEmitter.qq(priv.GetId()) + "), (gpointer)" + (priv.IsOnParent() ? "TRUE" : "FALSE") + ");");
        }
        this.emitLine();
        this.emitLine("return table;");
        this.unindent();
        this.emitLine("}");
    }

    private void emitPrivilegeUpdate() {
        this.emitLine("void");
        this.emitLine("vmodl_privilege_update(GHashTable *table,");
        this.emitLine("                       const gchar *privilege,");
        this.emitLine("                       gboolean value)");
        this.emitLine("{");
        this.indent();
        this.emitLine("g_assert(table != NULL);");
        this.emitLine();
        this.emitLine("g_hash_table_replace(table, g_strdup(privilege), (gpointer)(size_t)value);");
        this.unindent();
        this.emitLine("}");
    }

    private void emitPrivilegeCheck() {
        this.emitLine("gboolean");
        this.emitLine("vmodl_privilege_check(GHashTable *table,");
        this.emitLine("                      const gchar *privilege)");
        this.emitLine("{");
        this.indent();
        this.emitLine("g_assert(table != NULL);");
        this.emitLine();
        this.emitLine("return (gboolean)(size_t)g_hash_table_lookup(table, privilege);");
        this.unindent();
        this.emitLine("}");
    }

    private void checkPrivilege(String objName, String method, String privId) {
        if (!this._privs.contains(privId) && !this._systemPrivs.contains(privId)) {
            throw new RuntimeException("Method/Property \"" + objName + "." + method + "\" refers to unknown privilege " + privId);
        }
        if (this._unusedPrivs.contains(privId)) {
            this._unusedPrivs.remove(privId);
        }
    }

    private void processObject(VmodlObject obj) {
        for (VmodlObject nestedObj : obj.getNestedList()) {
            this.processObject(nestedObj);
        }
        if (obj instanceof DataObject) {
            this.processDataObject((DataObject)obj);
        } else if (obj instanceof ManagedObject) {
            this.processManagedObject((ManagedObject)obj);
        }
    }

    private void processDataObject(DataObject dobj) {
        for (Property prop : dobj.getPropertyList()) {
            String privId = prop.getPrivilegeId();
            if (privId == null) continue;
            this.checkPrivilege(dobj.getQualifiedVmodlType(), prop.getName(), privId);
        }
    }

    private void processManagedObject(ManagedObject mobj) {
        String objName = mobj.getQualifiedVmodlType();
        for (Method method : mobj.getMethodList()) {
            boolean hasPrivilege = false;
            String methodPrivId = method.getPrivilegeId();
            if (methodPrivId != null) {
                hasPrivilege = true;
                this.checkPrivilege(objName, method.getName(), methodPrivId);
            }
            for (Parameter param : method.getParameterList()) {
                String privId = param.getPrivilegeId();
                if (privId == null) continue;
                hasPrivilege = true;
                if (!param.getDecl().isManaged()) {
                    throw new RuntimeException(method.getName() + "." + param.getName() + ": not a managed object and cannot have an associated privilege");
                }
                this.checkPrivilege(objName, method.getName() + "." + param.getName(), privId);
            }
            if (mobj.isSessionSpecific()) {
                if (methodPrivId == null) continue;
                throw new RuntimeException(objName + "." + method.getName() + ": Session specific managed object methods cannot declare privileges");
            }
            if (hasPrivilege || method.getSubclassPrivileges() != null || method.isDynamicPrivs()) continue;
            this._noPrivMethods.add(objName + "." + method.getName());
        }
    }
}

