/*
 * Decompiled with CFR 0.152.
 */
package emitters.core;

import emitters.Utils;
import emitters.Versions;
import emitters.VmodlEmitter;
import emitters.bindings.JavaServerEmitter;
import emitters.bindings.PythonStubEmitter;
import emitters.bindings.cpp.CppImplementationEmitter;
import emitters.bindings.cpp.CppInterfaceEmitter;
import emitters.bindings.cpp.CppPrivilegeEmitter;
import emitters.bindings.csharp.CsEmitter;
import emitters.bindings.csharp.CsPrivilegeEmitter;
import emitters.bindings.gobject.GObjectImplementationEmitter;
import emitters.bindings.gobject.GObjectInterfaceEmitter;
import emitters.bindings.gobject.GObjectPrivilegeEmitter;
import emitters.generators.LifecycleEmitter;
import emitters.generators.RecursiveDefsInfo;
import emitters.generators.VersionsEmitter;
import emitters.generators.joap.OpenApi3Emitter;
import emitters.generators.vmodl.SourceEmitter;
import emitters.generators.xml.BeanTypesEmitter;
import emitters.generators.xml.EventExtensionEmitter;
import emitters.generators.xml.ListInternalApiEmitter;
import emitters.wsdl.XMLTypeInfoEmitter;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class Options {
    public Collection<VmodlEmitter> filteredEmitters;
    public Collection<VmodlEmitter> filteredNonDynamicEmitters;
    public Collection<VmodlEmitter> unfilteredEmitters;
    public Collection<VmodlEmitter> unfilteredNonDynamicEmitters;
    public String verTarget = null;
    public static String taskTypeName;
    public boolean wsdl2Requested;
    public boolean wsdlRequested;
    public boolean skipCoreObjects = true;
    public Map<String, String> xmlOptions = new HashMap<String, String>();
    public Map<String, String> wsdlOptions = new HashMap<String, String>();
    public Map<String, String> versionsOptions = new HashMap<String, String>();
    public Map<String, String> expectedVersionIds = new HashMap<String, String>();
    private Set<String> _emitSourceSet = new HashSet<String>();
    private Set<String> _noEmitSourceSet = new HashSet<String>();
    private Map<String, String> _cppOptions = new HashMap<String, String>();
    private Map<String, String> _cppPrivOptions = new HashMap<String, String>();
    private Map<String, String> _csOptions = new HashMap<String, String>();
    private Map<String, String> _dotOptions = new HashMap<String, String>();
    private Map<String, String> _eventOptions = new HashMap<String, String>();
    private Map<String, String> _cOptions = new HashMap<String, String>();
    private Map<String, String> _cPrivOptions = new HashMap<String, String>();
    private Map<String, String> _javaOptions = new HashMap<String, String>();
    private Map<String, String> _reemitterOptions = new HashMap<String, String>();
    private Map<String, String> _openapi3Options = new HashMap<String, String>();
    private Map<String, String> _lifecycleOptions = new HashMap<String, String>();
    private OptionProcessor[] _optionProcessors;
    private boolean _haveEmitFile = false;
    private boolean _haveEmitArg = false;

    public boolean shouldEmit(String source) {
        if (source == null || source.isEmpty()) {
            return false;
        }
        return !this._emitSourceSet.isEmpty() ? this._emitSourceSet.contains(source) : !this._noEmitSourceSet.contains(source);
    }

    protected Options() {
        this.filteredEmitters = new ArrayList<VmodlEmitter>();
        this.filteredNonDynamicEmitters = new ArrayList<VmodlEmitter>();
        this.unfilteredEmitters = new ArrayList<VmodlEmitter>();
        this.unfilteredNonDynamicEmitters = new ArrayList<VmodlEmitter>();
        this._optionProcessors = new OptionProcessor[]{new EmitterFactory("hpp.dir"){

            @Override
            VmodlEmitter newInstance(String value) {
                return new CppInterfaceEmitter(Options.this._cppOptions, value);
            }
        }, new EmitterFactory("cpp.dir"){

            @Override
            VmodlEmitter newInstance(String value) {
                return new CppImplementationEmitter(Options.this._cppOptions, value);
            }
        }, new EmitterFactory("privhpp"){

            @Override
            VmodlEmitter newInstance(String value) {
                return new CppPrivilegeEmitter(Options.this._cppPrivOptions, value);
            }
        }, new EmitterFactory("cs"){

            @Override
            VmodlEmitter newInstance(String value) {
                return new CsEmitter(Options.this._csOptions, value);
            }
        }, new EmitterFactory("cs.priv.consts"){

            @Override
            VmodlEmitter newInstance(String value) {
                return new CsPrivilegeEmitter(Options.this._csOptions, value);
            }
        }, new EmitterFactory("events.base.event"){

            @Override
            VmodlEmitter newInstance(String value) {
                return new EventExtensionEmitter(Options.this._eventOptions, value);
            }
        }, new EmitterFactory("py"){

            @Override
            VmodlEmitter newInstance(String value) {
                return new PythonStubEmitter(value, false);
            }
        }, new EmitterFactory("pypublic"){

            @Override
            VmodlEmitter newInstance(String value) {
                return new PythonStubEmitter(value, true);
            }
        }, new EmitterFactory("xti"){

            @Override
            VmodlEmitter newInstance(String value) {
                return new XMLTypeInfoEmitter(value);
            }
        }, new EmitterFactory("header.dir"){

            @Override
            VmodlEmitter newInstance(String value) {
                return new GObjectInterfaceEmitter(Options.this._cOptions, value);
            }
        }, new EmitterFactory("c"){

            @Override
            VmodlEmitter newInstance(String value) {
                return new GObjectImplementationEmitter(Options.this._cOptions, value);
            }
        }, new EmitterFactory("privheader"){

            @Override
            VmodlEmitter newInstance(String value) {
                return new GObjectPrivilegeEmitter(Options.this._cPrivOptions, value);
            }
        }, new EmitterFactory("java.vmomi"){

            @Override
            VmodlEmitter newInstance(String value) {
                return new JavaServerEmitter(Options.this._javaOptions, value);
            }
        }, new EmitterFactory("versions"){

            @Override
            VmodlEmitter newInstance(String value) {
                return new VersionsEmitter(Options.this.versionsOptions, value);
            }
        }, new EmitterFactory("openapi3.folder"){

            @Override
            VmodlEmitter newInstance(String value) {
                return new OpenApi3Emitter(Options.this._openapi3Options, value);
            }
        }, new EmitterFactory("reemit.folder"){

            @Override
            VmodlEmitter newInstance(String value) {
                return new SourceEmitter(Options.this._reemitterOptions, value);
            }
        }, new EmitterFactory("bean.types"){

            @Override
            VmodlEmitter newInstance(String value) {
                return new BeanTypesEmitter(value);
            }
        }, new EmitterFactory("list.api"){

            @Override
            VmodlEmitter newInstance(String value) {
                return new ListInternalApiEmitter(value);
            }
        }, new EmitterFactory("lifecycle.folder"){

            @Override
            VmodlEmitter newInstance(String value) {
                return new LifecycleEmitter(Options.this._lifecycleOptions, value);
            }
        }, new EmitterFactory("rdef.output"){

            @Override
            VmodlEmitter newInstance(String value) {
                return new RecursiveDefsInfo(value);
            }
        }, new OptionGroup("ver.prefix.", Versions._onUnspecifiedVersion), new OptionGroup("package.", VmodlEmitter._packageMap), new OptionGroup("cpp.", this._cppOptions), new OptionGroup("privhpp.", this._cppPrivOptions), new OptionGroup("cs.", this._csOptions), new OptionGroup("dot.", this._dotOptions), new OptionGroup("c.", this._cOptions), new OptionGroup("privheader.", this._cPrivOptions), new OptionGroup("java.", this._javaOptions), new OptionGroup("xml.", this.xmlOptions), new OptionGroup("wsdl.", this.wsdlOptions), new OptionGroup("versions.", this.versionsOptions), new OptionGroup("events.", this._eventOptions), new OptionGroup("reemit.", this._reemitterOptions), new OptionGroup("openapi3.", this._openapi3Options), new OptionGroup("lifecycle.", this._lifecycleOptions), new OptionSet("ver.is.legacy", Versions._legacyVersionNames), new OptionSet("ver.is.default", Versions._legacyVersionNames)};
    }

    protected void processOption(String optionName, String optionValue) {
        if (this.parseWithProcessors(optionName, optionValue)) {
            if (optionName.startsWith("wsdl")) {
                this.wsdlRequested = true;
            }
            if (optionName.equals("wsdl.sharing")) {
                this.wsdl2Requested = true;
            }
        } else if (this.handleEmit(optionName, optionValue)) {
            this._haveEmitArg = true;
        } else if (optionName.equals("emit.defs.file")) {
            List<String> lines;
            Path path = Paths.get(optionValue, new String[0]);
            this._haveEmitFile = true;
            try {
                lines = Files.readAllLines(path, Charset.defaultCharset());
            }
            catch (Exception e) {
                throw new RuntimeException("Can't read args file '" + path + "': " + e.toString());
            }
            for (String line : lines) {
                String val;
                String[] pair = line.split("=");
                if (pair.length != 2) {
                    throw new RuntimeException("Illegal string format in emit arg file: " + line);
                }
                String opt = pair[0].substring(2);
                if (this.handleEmit(opt, val = pair[1])) continue;
                throw new RuntimeException("Illegal option in emit args file: " + opt);
            }
        } else if (optionName.equals("emit.dir")) {
            this._emitSourceSet = Utils.discoverEmitFiles(optionValue);
        } else if (optionName.equals("dir")) {
            this._emitSourceSet = Utils.resolve(this._emitSourceSet, optionValue);
            this._noEmitSourceSet = Utils.resolve(this._noEmitSourceSet, optionValue);
        } else if (optionName.equals("task.return.type")) {
            taskTypeName = optionValue;
        } else if (optionName.equals("ver.target")) {
            this.verTarget = optionValue;
        } else if (optionName.equals("two.operations.for.task.methods")) {
            Versions.setTwoOperationsForTaskMethod(Boolean.parseBoolean(optionValue));
        } else if (optionName.startsWith("xsd")) {
            this.wsdlOptions.put("xsd", optionValue);
            this.wsdlRequested = true;
        } else if (optionName.equals("vmodl.want.core.objects")) {
            this.skipCoreObjects = false;
        } else if (optionName.equals("xml")) {
            this.xmlOptions.put("", optionValue);
        } else if (optionName.equals("debug.digest")) {
            if (Boolean.parseBoolean(optionValue)) {
                Versions.enableDigestLogging();
            }
        } else if (optionName.equals("assert.ver.id")) {
            String[] keys = optionValue.split(":");
            if (keys.length != 2) {
                throw new RuntimeException("assert.ver.id's argument should be 'version_id:value'");
            }
            this.expectedVersionIds.put(keys[0], keys[1]);
            Versions.enableDigestLogging();
        } else {
            throw new RuntimeException("Unsupported option -A" + optionName);
        }
    }

    private boolean handleEmit(String optionName, String optionValue) {
        if (optionName.equals("emit")) {
            this.handleEmit(this._emitSourceSet, optionValue);
        } else if (optionName.equals("noemit")) {
            this.handleEmit(this._noEmitSourceSet, optionValue);
        } else {
            return false;
        }
        return true;
    }

    private void handleEmit(Set<String> emitSet, String optionValue) {
        for (String value : optionValue.split(",")) {
            emitSet.add(value);
        }
    }

    protected void finalizeParsing() {
        if (this._haveEmitArg && this._haveEmitFile) {
            throw new RuntimeException("Usage of both -A(no)emit and -Aemit.defs.file is forbidden");
        }
        if (!this._emitSourceSet.isEmpty() && !this._noEmitSourceSet.isEmpty()) {
            throw new RuntimeException("Cannot specify both -Aemit and -Anoemit");
        }
    }

    protected abstract void Parse(Map<String, String> var1);

    private void registerEmitter(VmodlEmitter emitter) {
        if (emitter.isBindingEmitter()) {
            if (emitter.nonDynamicEmitter()) {
                this.unfilteredNonDynamicEmitters.add(emitter);
            } else {
                this.unfilteredEmitters.add(emitter);
            }
        } else if (emitter.nonDynamicEmitter()) {
            this.filteredNonDynamicEmitters.add(emitter);
        } else {
            this.filteredEmitters.add(emitter);
        }
    }

    private boolean parseWithProcessors(String optionName, String optionValue) {
        for (OptionProcessor optionProcessor : this._optionProcessors) {
            if (!optionProcessor.processOption(optionName, optionValue)) continue;
            return true;
        }
        return false;
    }

    private class OptionSet
    extends OptionProcessor {
        private final String _optionName;
        private final Set<String> _set;

        OptionSet(String optionName, Set<String> set) {
            this._optionName = optionName;
            this._set = set;
        }

        @Override
        boolean processOption(String optionName, String optionValue) {
            if (!optionName.equals(this._optionName)) {
                return false;
            }
            this._set.add(optionValue);
            return true;
        }
    }

    private class OptionGroup
    extends OptionProcessor {
        private final String _prefix;
        private final Map<String, String> _optionsList;

        OptionGroup(String prefix, Map<String, String> optionsList) {
            this._prefix = prefix;
            this._optionsList = optionsList;
        }

        @Override
        boolean processOption(String optionName, String optionValue) {
            if (!optionName.startsWith(this._prefix)) {
                return false;
            }
            String innerOption = optionName.substring(this._prefix.length());
            this._optionsList.put(innerOption, optionValue);
            return true;
        }
    }

    private abstract class EmitterFactory
    extends OptionProcessor {
        private final String _optionName;

        EmitterFactory(String optionName) {
            this._optionName = optionName;
        }

        @Override
        boolean processOption(String optionName, String optionValue) {
            if (!this._optionName.equals(optionName)) {
                return false;
            }
            Options.this.registerEmitter(this.newInstance(optionValue));
            return true;
        }

        abstract VmodlEmitter newInstance(String var1);
    }

    private abstract class OptionProcessor {
        private OptionProcessor() {
        }

        abstract boolean processOption(String var1, String var2);
    }
}

