/*
 * Decompiled with CFR 0.152.
 */
package emitters.generators;

import emitters.Versions;
import emitters.VmodlEmitter;
import emitters.model.Feature;
import emitters.model.Namespace;
import emitters.model.Product;
import emitters.model.Release;
import emitters.model.ReleaseVersions;
import emitters.model.Version;
import emitters.model.VmodlObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import vmodl.internalBefore;
import vmodl.nsDescription;
import vmodl.release;
import vmodl.releaseList;
import vmodl.releaseVersions;
import vmodl.releaseVersionsList;
import vmodl.supportsManagedObjectsOf;
import vmodl.versionDef;

public class LifecycleEmitter
extends VmodlEmitter {
    private static final String PRODUCT = "product.";
    private static final String TP_PREFIX = "m";
    private static final String LTS_PREFIX = "v";
    private static final String VERSION_KIND_PREFIX = versionDef.Kind.class.getCanonicalName() + ".";
    private static final String VERSION_KIND_FEATURE = VERSION_KIND_PREFIX + versionDef.Kind.FEATURE;
    private static final String VERSION_KIND_LTS = VERSION_KIND_PREFIX + versionDef.Kind.LTS;
    private static final String VERSION_KIND_TP = VERSION_KIND_PREFIX + versionDef.Kind.TP;
    private final String _folder;
    private final Map<String, String> _productNextVersionMap;

    public LifecycleEmitter(Map<String, String> options, String folder) {
        super(options);
        this._folder = folder;
        this._productNextVersionMap = new HashMap<String, String>();
    }

    @Override
    public void processOptions() {
        super.processOptions();
        for (Map.Entry entry : this._emitterOptions.entrySet()) {
            String key = (String)entry.getKey();
            if (!key.startsWith(PRODUCT)) {
                throw new RuntimeException("Unknown option key given -Alifecycle." + key);
            }
            String product = key.substring(PRODUCT.length());
            this._productNextVersionMap.put(product, (String)entry.getValue());
        }
    }

    @Override
    public void emitObjects(List<VmodlObject> objects) {
        this.emitPackageInfo(Versions.getVmodlNamespace());
        this.emitSedScripts(Versions.getVmodlNamespace());
        this.emitNextRelease();
    }

    private void emitNextRelease() {
        for (Map.Entry<String, String> entry : this._productNextVersionMap.entrySet()) {
            String productKey = entry.getKey();
            String nextRelease = entry.getValue();
            Product product = Product.getProduct(productKey);
            if (product == null) {
                throw new RuntimeException("Unknown product given " + productKey);
            }
            this.beginFile(productKey + "-next-release.pseudo-java");
            this.indent("@" + releaseList.class.getSimpleName() + "({");
            this.createNextRelease(nextRelease, product.getProposedFeatures());
            ArrayList<Map.Entry<String, Release>> naturalOrderReleleases = new ArrayList<Map.Entry<String, Release>>(product.getReleases().entrySet());
            Collections.reverse(naturalOrderReleleases);
            for (Map.Entry entry2 : naturalOrderReleleases) {
                this.reemitRelease((String)entry2.getKey(), (Release)entry2.getValue());
            }
            this.unindent("})");
            this.endFile();
        }
    }

    private void emitFeatureArray(String prefix, Collection<Feature> features) {
        this.emitPartial(prefix);
        for (Feature feature : features) {
            this.emitPartial("\"" + feature.id + "\", ");
        }
        this.emitPartial("}");
    }

    private void reemitRelease(String releaseId, Release release2) {
        this.emitPartial("@" + release.class.getSimpleName() + "(");
        this.emitPartial("id = \"" + releaseId + "\"");
        if (release2.ltsId != null) {
            this.emitPartial(", ltsId = \"" + release2.ltsId + "\"");
        }
        if (release2.tpId != null) {
            this.emitPartial(", tpId = \"" + release2.tpId + "\"");
        }
        if (release2.ltsFeatures.size() != 0) {
            this.emitFeatureArray(", ltsId = { ", release2.ltsFeatures);
        }
        if (release2.tpFeatures.size() != 0) {
            this.emitFeatureArray(", tpId = { ", release2.tpFeatures);
        }
        this.emitLine("),");
    }

    private String fixupReleaseId(String releaseId, boolean isTp) {
        String versionId = releaseId.replace('.', '_');
        if (Character.isDigit(versionId.codePointAt(0))) {
            versionId = isTp ? TP_PREFIX + versionId : LTS_PREFIX + versionId;
        }
        return versionId;
    }

    private void emitRelease(String releaseId, boolean isTp, List<Feature> features) {
        this.emitPartial("@" + release.class.getSimpleName() + "(");
        this.emitPartial("id = \"" + releaseId + "\", ");
        String versionKindId = "ltsId";
        String featurePromotedKind = "ltsFeatures";
        if (isTp) {
            versionKindId = "tpId";
            featurePromotedKind = "tpFeatures";
        }
        this.emitPartial(versionKindId + " = \"" + this.fixupReleaseId(releaseId, isTp) + "\", ");
        this.emitFeatureArray(featurePromotedKind + " = { ", features);
        this.emitLine("),");
    }

    private void createNextRelease(String releaseId, Set<Feature> features) {
        boolean haveLts;
        ArrayList<Feature> ltsFeatures = new ArrayList<Feature>();
        ArrayList<Feature> tpFeatures = new ArrayList<Feature>();
        for (Feature feature : features) {
            if (feature.isTechPreview()) {
                tpFeatures.add(feature);
                continue;
            }
            ltsFeatures.add(feature);
        }
        boolean haveTp = tpFeatures.size() != 0;
        boolean bl = haveLts = ltsFeatures.size() != 0;
        if (haveTp && !haveLts) {
            this.emitRelease(releaseId, true, tpFeatures);
        } else {
            if (haveLts) {
                this.emitRelease(releaseId, false, ltsFeatures);
            }
            if (haveTp) {
                this.emitRelease(TP_PREFIX + releaseId, true, tpFeatures);
            }
        }
    }

    private void emitSedCommands(String releaseId, Version version) {
        if (version == null) {
            return;
        }
        String fullyQualified = version.getVmodlName();
        String simpleName = version.getSimpleName();
        this.emitLine("sed -i \\");
        this.indent();
        this.emitLine("-e '/import " + fullyQualified + "/d' \\");
        this.emitLine("-e '/import " + internalBefore.class.getCanonicalName() + "/d' \\");
        this.emitLine("-e 's/@" + simpleName + "/@released(\"" + releaseId + "\")/' \\");
        this.emitLine("-e 's/@" + fullyQualified + "/@released(\"" + releaseId + "\")/' \\");
        this.emitLine("-e 's/@internalBefore(" + simpleName + ".class)/@wasInternalBefore(\"" + releaseId + "\")/' \\");
        this.emitLine("-e 's/@internalBefore(" + fullyQualified + ".class)/@wasInternalBefore(\"" + releaseId + "\")/' \\");
        this.emitLine("$1");
        this.unindent();
    }

    private void emitSedScripts(String vmodlNamespace) {
        Namespace ns = Versions.getNamespace(vmodlNamespace);
        if (ns == null) {
            return;
        }
        this.beginFile(vmodlNamespace + "-version-sed.sh");
        for (Map.Entry<String, ReleaseVersions> entry : ns.getReleaseVersionsMap().entrySet()) {
            String releaseId = entry.getKey();
            ReleaseVersions vRelease = entry.getValue();
            this.emitSedCommands(releaseId, vRelease.ltsVersion());
            this.emitSedCommands(releaseId, vRelease.tpVersion());
        }
        this.endFile();
    }

    private void emitPackageInfo(String vmodlNamespace) {
        this.beginFile(vmodlNamespace + "-package-info.java");
        this.emitNamespaceDescription(vmodlNamespace);
        this.emitLine("package " + vmodlNamespace + ";");
        this.endFile();
    }

    private void emitNamespaceDescription(String vmodlNamespace) {
        Namespace ns = Versions.getNamespace(vmodlNamespace);
        this.indent(this.makeAnnotation(nsDescription.class) + "(");
        this.indent("releases = " + this.makeAnnotation(releaseVersionsList.class) + "({");
        if (ns != null) {
            this.emitWithNs(ns);
        } else {
            this.emitFromVersionList(Versions.enumerateVersions());
        }
        this.unindent("}),");
        this.indent("versions = {");
        if (ns != null) {
            this.emitVersionDefsFromNS(ns);
        } else {
            this.emitVersionDefsFromVersionList(Versions.enumerateVersions());
        }
        this.unindent("}");
        this.unindent(")");
    }

    private void emitVersionDefsFromNS(Namespace ns) {
        for (ReleaseVersions rv : ns.getReleaseVersions()) {
            if (rv.tpVersion() != null) {
                this.emitVersionDef(rv.tpVersion());
            }
            if (rv.ltsVersion() == null) continue;
            this.emitVersionDef(rv.ltsVersion());
        }
    }

    private void emitVersionDefsFromVersionList(List<Version> versions) {
        for (Version version : versions) {
            if (version.getKind() != Version.Kind.LTS) continue;
            this.emitVersionDef(version);
        }
    }

    private void emitWithNs(Namespace ns) {
        Iterator<Map.Entry<String, ReleaseVersions>> releaseIt = ns.getReleaseVersionsMap().entrySet().iterator();
        while (releaseIt.hasNext()) {
            Map.Entry<String, ReleaseVersions> entry = releaseIt.next();
            ReleaseVersions release2 = entry.getValue();
            this.indent(this.makeAnnotation(releaseVersions.class) + "(");
            this.emitPartial("id = \"" + entry.getKey() + "\"");
            if (release2.ltsVersion() != null) {
                this.emitLine(",");
                this.emitPartial("ltsVersion = \"" + release2.ltsVersion().getVmodlName() + "\"");
            }
            if (release2.tpVersion() != null) {
                this.emitLine(",");
                this.emitPartial("tpVersion = \"" + release2.tpVersion().getVmodlName() + "\"");
            }
            this.unindent(")" + (releaseIt.hasNext() ? "," : ""));
        }
    }

    private void emitFromVersionList(List<Version> versions) {
        for (int i = 0; i < versions.size(); ++i) {
            Version version = versions.get(i);
            Version.Kind kind = version.getKind();
            if (kind != Version.Kind.LTS) continue;
            this.indent(this.makeAnnotation(releaseVersions.class) + "(");
            this.emitPartial("id = \"" + version.getWireId() + "\"");
            if (kind == Version.Kind.TP) {
                this.emitLine(",");
                this.emitPartial("tpVersion = \"" + version.getVmodlName() + "\"");
            } else {
                this.emitLine(",");
                this.emitPartial("ltsVersion = \"" + version.getVmodlName() + "\"");
            }
            this.unindent(")" + (i + 1 < versions.size() ? "," : ""));
        }
    }

    private String getVersionKind(Version version) {
        switch (version.getKind()) {
            case FEATURE: {
                return VERSION_KIND_FEATURE;
            }
            case TP: {
                return VERSION_KIND_TP;
            }
        }
        return VERSION_KIND_LTS;
    }

    private void emitVersionDef(Version version) {
        this.indent("@" + versionDef.class.getCanonicalName() + "(");
        this.emitLine("id = \"" + version.getSimpleName() + "\",");
        this.emitLine("kind = " + this.getVersionKind(version) + ",");
        this.emitLine("wsdlName = \"" + version.getWireNs() + "\",");
        this.emitLine("versionId = \"" + version.getWireId() + "\",");
        this.emitLine("displayName = \"" + version.getDisplayName() + "\",");
        supportsManagedObjectsOf supportedMOs = version.getSupportedMO();
        if (supportedMOs != null) {
            String[] mos = supportedMOs.value();
            ArrayList<String> outMOs = new ArrayList<String>();
            this.emitPartial("supportedMO = ");
            this.emitPartial(this.makeAnnotation(supportsManagedObjectsOf.class) + "({");
            for (String mo : mos) {
                outMOs.add("\"" + mo + "\"");
            }
            this.emitJoin(outMOs, ",");
            this.emitLine("}),");
        }
        Set<Version> parents = version.getDirectParents();
        TreeSet<String> asStrings = new TreeSet<String>();
        for (Version parent : parents) {
            asStrings.add("\"" + parent.getVmodlName() + "\"");
        }
        if (asStrings.size() != 0) {
            String compatibleVersions = "{ " + LifecycleEmitter.join(asStrings, ", ") + " }";
            this.emitLine("compatible = " + compatibleVersions);
        }
        this.unindent("),");
    }

    private void emitJoin(List<String> toEmit, String sep) {
        if (sep.equals("\n")) {
            for (String str : toEmit) {
                this.emitLine(str);
            }
        } else {
            String joined = LifecycleEmitter.join(toEmit, sep);
            this.emitPartial(joined);
        }
    }

    private String makeAnnotation(Class<?> cls) {
        return "@" + cls.getCanonicalName();
    }

    @Override
    protected void beginFile(String filename) {
        super.beginFile(this._folder + "/" + filename);
    }
}

