/*
 * Decompiled with CFR 0.152.
 */
package emitters.generators;

import emitters.VmodlEmitter;
import emitters.model.DataObject;
import emitters.model.DataProperty;
import emitters.model.Property;
import emitters.model.VmodlDecl;
import emitters.model.VmodlObject;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;

public class RecursiveDefsInfo
extends VmodlEmitter {
    String _fileName;
    List<Property> _propertyList = new ArrayList<Property>();
    Set<DataObject> _dataObjects = new HashSet<DataObject>();
    Set<DataObject> _processedDO = new HashSet<DataObject>();

    public RecursiveDefsInfo(String fileName) {
        this._fileName = fileName;
    }

    @Override
    public boolean isBindingEmitter() {
        return true;
    }

    @Override
    public void emitObjects(List<VmodlObject> objects) {
        this.beginFile(this._fileName);
        for (VmodlObject obj : objects) {
            this.verifyObject(obj);
        }
        this.endFile();
    }

    void verifyObject(VmodlObject obj) {
        if (obj.getKind() == VmodlObject.Kind.DataObject) {
            DataProperty dummyProperty = new DataProperty(null, obj.getQualifiedVmodlType(), obj.getWsdlName(), new VmodlDecl(VmodlDecl.TypeId.DATA, obj), false, null, null, null, -1);
            this.verifyProperties(dummyProperty, (DataObject)obj);
        }
        for (VmodlObject nestedObject : obj.getNestedList()) {
            this.verifyObject(nestedObject);
        }
    }

    void verifyProperties(Property parentProperty, DataObject dataObject) {
        if (this._processedDO.contains(dataObject)) {
            return;
        }
        this._propertyList.add(parentProperty);
        this._dataObjects.add(dataObject);
        for (Property property : dataObject.getFullPropertyList()) {
            DataObject propertyType;
            VmodlDecl vmodlDecl = property.getDecl();
            if (vmodlDecl.getTypeId() != VmodlDecl.TypeId.DATA || this._processedDO.contains(propertyType = (DataObject)vmodlDecl.getObject())) continue;
            if (this._dataObjects.contains(propertyType)) {
                this.reportTypeLoop(property, propertyType);
                continue;
            }
            this.verifyProperties(property, propertyType);
        }
        this._propertyList.remove(this._propertyList.size() - 1);
        this._dataObjects.remove(dataObject);
        this._processedDO.add(dataObject);
    }

    void reportTypeLoop(Property property, DataObject propertyType) {
        ListIterator<Property> lit = this._propertyList.listIterator();
        while (lit.next().getDecl().getObject() != propertyType) {
        }
        this.emitLine("Encountered loop for ", propertyType.getQualifiedVmodlType());
        this.indent();
        while (lit.hasNext()) {
            this.printDecl(lit.next());
        }
        this.printDecl(property);
        this.unindent();
    }

    void printDecl(Property property) {
        this.emitLine(property.getDecl().getObject().getQualifiedVmodlType(), " ", property.getName());
    }
}

