/*
 * Decompiled with CFR 0.152.
 */
package emitters.generators;

import emitters.Versions;
import emitters.VmodlEmitter;
import emitters.model.Version;
import emitters.model.VmodlObject;
import java.io.File;
import java.util.List;
import java.util.Map;

public class VersionsEmitter
extends VmodlEmitter {
    private final String _serviceName;
    private final String _path;
    private static final String BASE_DIR = "Versions";
    private static final String XML_PATH = File.separator + "newest" + File.separator + "list";
    private static final String NAME_LIST_FILE = "names.xml";
    private static final String ID_LIST_FILE = "ids.xml";
    private static final String XML_HEADER = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?>";

    public VersionsEmitter(Map<String, String> options, String serviceName) {
        super(options);
        this._serviceName = serviceName;
        this._path = BASE_DIR + File.separator + serviceName + File.separator + XML_PATH;
    }

    @Override
    public boolean isBindingEmitter() {
        return true;
    }

    @Override
    public void emitObjects(List<VmodlObject> objects) {
        List<Version> versionsList = Versions.enumerateVersions();
        this.emitNameListInXmlFile(versionsList);
        this.emitIdListInXmlFile(versionsList);
    }

    private void emitNameListInXmlFile(Iterable<Version> versionsList) {
        this.beginFile(this._path + File.separator + NAME_LIST_FILE);
        this.emitPartial(XML_HEADER);
        this.emitPartial("<versions-list>");
        this.emitPartial("<" + this._serviceName + ">");
        for (Version version : versionsList) {
            this.emitPartial("<version>" + version.getVmodlName() + "</version>");
        }
        this.emitPartial("</" + this._serviceName + ">");
        this.emitPartial("</versions-list>");
        this.emitLine();
        this.endFile();
    }

    private void emitIdListInXmlFile(Iterable<Version> versionsList) {
        this.beginFile(this._path + File.separator + ID_LIST_FILE);
        this.emitPartial("<?xml version=\"1.0\" encoding=\"UTF-8\" ?><namespaces version=\"1.0\">");
        String currentName = null;
        boolean inNamespaceSection = false;
        boolean inPriorVersionsSection = false;
        for (Version version : versionsList) {
            if (!version.getWireNs().equals(currentName)) {
                this.emitClosePriorVersionsSection(inPriorVersionsSection);
                inPriorVersionsSection = false;
                this.emitCloseNamespaceSection(inNamespaceSection);
                currentName = version.getWireNs();
                this.emitPartial("<namespace>");
                this.emitVersionNameSection(version);
                this.emitVersionIdSection(version);
                inNamespaceSection = true;
                continue;
            }
            if (!inPriorVersionsSection) {
                this.emitPartial("<priorVersions>");
                inPriorVersionsSection = true;
            }
            this.emitVersionIdSection(version);
        }
        this.emitClosePriorVersionsSection(inPriorVersionsSection);
        this.emitCloseNamespaceSection(inNamespaceSection);
        this.emitPartial("</namespaces>");
        this.emitLine();
        this.endFile();
    }

    private void emitCloseNamespaceSection(boolean inNamespaceSection) {
        if (inNamespaceSection) {
            this.emitPartial("</namespace>");
        }
    }

    private void emitClosePriorVersionsSection(boolean inPriorVersionsSection) {
        if (inPriorVersionsSection) {
            this.emitPartial("</priorVersions>");
        }
    }

    private void emitVersionNameSection(Version version) {
        this.emitPartial("<name>urn:" + version.getWireNs() + "</name>");
    }

    private void emitVersionIdSection(Version version) {
        this.emitPartial("<version>" + version.getWireId() + "</version>");
    }
}

