/*
 * Decompiled with CFR 0.152.
 */
package emitters.generators.joap;

import emitters.ObjectRegistry;
import emitters.Utils;
import emitters.Versions;
import emitters.VmodlEmitter;
import emitters.generators.joap.OpenApiFilter;
import emitters.generators.joap.PreviousReleaseFilter;
import emitters.generators.joap.ReleasedOnlyFilter;
import emitters.generators.joap.StableVmodlFilter;
import emitters.model.DataObject;
import emitters.model.Enum;
import emitters.model.Field;
import emitters.model.ManagedObject;
import emitters.model.Method;
import emitters.model.Parameter;
import emitters.model.Property;
import emitters.model.Version;
import emitters.model.VmodlDecl;
import emitters.model.VmodlObject;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class OpenApi3Emitter
extends VmodlEmitter {
    private static final String FILTER = "filter";
    private static final String FOLDER_EXT = "folder.ext";
    private static final String STABLE_VMODL = "stable";
    private static final String RELEASED_ONLY = "released";
    private static final String PREV_RELEASE = "previous.release";
    private static final String EMIT_BUILTINS = "emitBuiltins";
    private static final String SLICE_SUFFIX = "_s";
    private static final String GROUP_SUFFIX = "_g";
    private static final String METHOD_INPUT_SUFFIX = "_i";
    private Map<String, OpenApiFilter> _filterMap;
    private final String _originalFolder;
    private String _namespace;
    private String _folderExt;
    private String _folder;
    private OpenApiFilter _filter;
    private VmodlObject _managedObjectReference;
    private VmodlObject _dataObject;
    private VmodlObject _dynamicData;
    private VmodlObject _managedObjectNotFound;
    private VmodlObject _runtimeFault;
    private VmodlObject _methodFault;
    private VmodlObject _any;
    private Set<VmodlObject> _externalNsObjects;
    private Set<VmodlObject> _coreObjects;
    private Set<VmodlObject> _groupObjects;
    private Set<VmodlObject> _fileTags;
    private boolean _emitBuiltins;
    private StringBuilder _dotBuffer;
    private List<ManagedObject> _queuedObjects;
    private List<ManagedObject> _emittedMoObjects;
    private List<DataObject> _emittedDoObjects;
    private List<Enum> _emittedEnumObjects;
    private boolean _hasCompSchemas;
    private boolean _hasPaths;
    private boolean _forceLocalRefs;

    public OpenApi3Emitter(Map<String, String> options, String folder) {
        super(options);
        this._originalFolder = folder;
        this._filterMap = new HashMap<String, OpenApiFilter>();
    }

    @Override
    public boolean isBindingEmitter() {
        return true;
    }

    @Override
    public boolean nonDynamicEmitter() {
        return false;
    }

    @Override
    public void processOptions() {
        String[] filters;
        String rawEmitBuiltins = (String)this._emitterOptions.get(EMIT_BUILTINS);
        String rawFilterOption = (String)this._emitterOptions.get(FILTER);
        for (String filter : filters = rawFilterOption.split(":")) {
            if (filter.equals(STABLE_VMODL)) {
                this._filterMap.put(filter, new StableVmodlFilter());
                continue;
            }
            if (filter.equals(RELEASED_ONLY)) {
                this._filterMap.put(filter, new ReleasedOnlyFilter());
                continue;
            }
            if (filter.equals(PREV_RELEASE)) {
                this._filterMap.put(filter, new PreviousReleaseFilter());
                continue;
            }
            throw new RuntimeException("Unknown filter option given: \"" + filter + "\"");
        }
        if (this._filterMap.isEmpty()) {
            throw new RuntimeException("No filter given for VmodlReemitter");
        }
        this._folderExt = this._emitterOptions.containsKey(FOLDER_EXT) ? (String)this._emitterOptions.get(FOLDER_EXT) : null;
        this._managedObjectReference = ObjectRegistry.getObject(Utils.ManagedObjectReferenceClassName);
        this._dataObject = ObjectRegistry.getObject(Utils.DataObjectClassName);
        this._dynamicData = ObjectRegistry.getObject(Utils.DynamicDataClassName);
        this._managedObjectNotFound = ObjectRegistry.getObject(Utils.ManagedObjectNotFoundClassName);
        this._runtimeFault = ObjectRegistry.getObject(Utils.RuntimeFaultClassName);
        this._methodFault = ObjectRegistry.getObject(Utils.MethodFaultClassName);
        this._any = ObjectRegistry.getObject(Utils.AnyClassName);
        this._externalNsObjects = new HashSet<VmodlObject>();
        this._coreObjects = new HashSet<VmodlObject>();
        this._coreObjects.add(ObjectRegistry.getObject("vmodl.Any"));
        this._coreObjects.add(ObjectRegistry.getObject("vmodl.Binary"));
        this._coreObjects.add(ObjectRegistry.getObject("vmodl.DateTime"));
        this._coreObjects.add(ObjectRegistry.getObject("vmodl.MethodName"));
        this._coreObjects.add(ObjectRegistry.getObject("vmodl.PropertyPath"));
        this._coreObjects.add(ObjectRegistry.getObject("vmodl.TypeName"));
        this._coreObjects.add(ObjectRegistry.getObject("vmodl.URI"));
        this._coreObjects.add(ObjectRegistry.getObject("vmodl.LocalizedMethodFault"));
        this._coreObjects.add(this._managedObjectReference);
        this._groupObjects = new HashSet<VmodlObject>();
        this._fileTags = new HashSet<VmodlObject>();
        this.addGroupObjects(this._groupObjects);
        this._queuedObjects = new ArrayList<ManagedObject>();
        this._emittedMoObjects = new ArrayList<ManagedObject>();
        this._emittedDoObjects = new ArrayList<DataObject>();
        this._emittedEnumObjects = new ArrayList<Enum>();
        this._emitBuiltins = Boolean.parseBoolean(rawEmitBuiltins);
        this._namespace = Versions.getTargetVersion().getNamespace();
        this._hasCompSchemas = false;
        this._hasPaths = false;
        this._forceLocalRefs = false;
        this._dotBuffer = new StringBuilder();
        this.dotEmitLine("digraph ", this._namespace, " {");
        this.dotEmitLine("ranksep=", OpenApi3Emitter.qq("3.0"), ";");
        this.dotEmitLine("rankdir=RL;");
    }

    private void addGroupObjects(Set<VmodlObject> groupObjects) {
        String[] objectList;
        groupObjects.add(this._runtimeFault);
        for (String objectName : objectList = new String[]{"vim.action.Action", "vim.alarm.AlarmExpression", "vim.cbrc.DigestOperationResult", "vim.cluster.Action", "vim.cluster.DasAdmissionControlInfo", "vim.cluster.DasAdmissionControlPolicy", "vim.cluster.RuleInfo", "vim.Datastore.Info", "vim.Description", "vim.dvs.DistributedVirtualSwitchManager.HostDvsFilterSpec", "vim.dvs.TrafficRule.Action", "vim.dvs.TrafficRule.IpPort", "vim.dvs.TrafficRule.Qualifier", "vim.dvs.VmwareDistributedVirtualSwitch.VlanSpec", "vim.ElementDescription", "vim.encryption.CryptoSpec", "vim.event.AlarmEvent", "vim.event.ClusterEvent", "vim.event.CustomFieldDefEvent", "vim.event.CustomizationEvent", "vim.event.CustomizationFailed", "vim.event.DatastoreEvent", "vim.event.DatastoreFileEvent", "vim.event.DVPortgroupEvent", "vim.event.DvsEvent", "vim.event.DvsHealthStatusChangeEvent", "vim.event.EntityEventArgument", "vim.event.Event", "vim.event.EventArgument", "vim.event.GeneralEvent", "vim.event.HostDasEvent", "vim.event.HostEvent", "vim.event.LicenseEvent", "vim.event.MigrationEvent", "vim.event.PermissionEvent", "vim.event.ProfileEvent", "vim.event.ResourcePoolEvent", "vim.event.RoleEvent", "vim.event.ScheduledTaskEvent", "vim.event.SessionEvent", "vim.event.TemplateUpgradeEvent", "vim.event.UpgradeEvent", "vim.event.VmCloneEvent", "vim.event.VmEvent", "vim.event.VmRelocateSpecEvent", "vim.fault.ActiveDirectoryFault", "vim.fault.CannotAccessNetwork", "vim.fault.CpuIncompatible", "vim.fault.CustomizationFault", "vim.fault.DeviceBackingNotSupported", "vim.fault.DeviceNotSupported", "vim.fault.DvsFault", "vim.fault.EVCAdmissionFailed", "vim.fault.EVCConfigFault", "vim.fault.FileFault", "vim.fault.GatewayConnectFault", "vim.fault.GatewayToHostConnectFault", "vim.fault.GuestOperationsFault", "vim.fault.GuestRegistryKeyFault", "vim.fault.HostConfigFault", "vim.fault.HostConnectFault", "vim.fault.HostPowerOpFailed", "vim.fault.InsufficientHostCapacityFault", "vim.fault.InsufficientResourcesFault", "vim.fault.InvalidDatastore", "vim.fault.InvalidDeviceSpec", "vim.fault.InvalidState", "vim.fault.InvalidVmConfig", "vim.fault.IscsiFault", "vim.fault.MigrationFault", "vim.fault.MigrationFeatureNotSupported", "vim.fault.NasConfigFault", "vim.fault.NotSupportedHost", "vim.fault.OvfConsumerCallbackFault", "vim.fault.OvfElement", "vim.fault.OvfExport", "vim.fault.OvfFault", "vim.fault.OvfHardwareExport", "vim.fault.OvfImport", "vim.fault.OvfInvalidPackage", "vim.fault.OvfInvalidValue", "vim.fault.OvfProperty", "vim.fault.OvfSystemFault", "vim.fault.OvfUnsupportedElement", "vim.fault.OvfUnsupportedPackage", "vim.fault.PatchNotApplicable", "vim.fault.PlatformConfigFault", "vim.fault.ReplicationFault", "vim.fault.SnapshotCopyNotSupported", "vim.fault.SnapshotFault", "vim.fault.VAppConfigFault", "vim.fault.VAppPropertyFault", "vim.fault.VimFault", "vim.fault.VirtualHardwareCompatibilityIssue", "vim.fault.VmConfigFault", "vim.fault.VmFaultToleranceIssue", "vim.fault.VmMetadataManagerFault", "vim.fault.VMotionInterfaceIssue", "vim.fault.VmToolsUpgradeFault", "vim.fault.VsanDiskFault", "vim.fault.VsanFault", "vim.host.DatastoreBrowser.FileInfo", "vim.host.DatastoreBrowser.Query", "vim.host.FileSystemVolume", "vim.host.HostBusAdapter", "vim.host.NvmeTransportParameters", "vim.host.SystemSwapConfiguration.SystemSwapOption", "vim.host.TargetTransport", "vim.host.TpmEventDetails", "vim.host.VirtualSwitch.Bridge", "vim.host.VmfsDatastoreSpec", "vim.InheritablePolicy", "vim.IpAddress", "vim.LicenseManager.LicenseSource", "vim.MacAddress", "vim.NegatableExpression", "vim.option.ArrayUpdateSpec", "vim.option.OptionType", "vim.OvfManager.CommonParams", "vim.profile.ApplyProfile", "vim.profile.host.PortGroupProfile", "vim.profile.Profile.CreateSpec", "vim.ProxyService.EndpointSpec", "vim.ProxyService.ServiceSpec", "vim.ProxyService.TunnelSpec", "vim.scheduler.TaskScheduler", "vim.SelectionSet", "vim.TaskReason", "vim.vm.BootOptions.BootableDevice", "vim.vm.customization.IdentitySettings", "vim.vm.customization.IpGenerator", "vim.vm.customization.IpV6Generator", "vim.vm.customization.NameGenerator", "vim.vm.device.VirtualController", "vim.vm.device.VirtualControllerOption", "vim.vm.device.VirtualDevice", "vim.vm.device.VirtualDevice.BackingInfo", "vim.vm.device.VirtualDevice.DeviceBackingInfo", "vim.vm.device.VirtualDevice.FileBackingInfo", "vim.vm.device.VirtualDeviceOption", "vim.vm.device.VirtualDeviceOption.BackingOption", "vim.vm.device.VirtualDeviceOption.DeviceBackingOption", "vim.vm.device.VirtualDeviceOption.FileBackingOption", "vim.vm.device.VirtualDeviceOption.RemoteDeviceBackingOption", "vim.vm.device.VirtualDevice.RemoteDeviceBackingInfo", "vim.vm.device.VirtualEthernetCard", "vim.vm.device.VirtualEthernetCardOption", "vim.vm.device.VirtualSCSIController", "vim.vm.device.VirtualSCSIControllerOption", "vim.vm.device.VirtualSoundCard", "vim.vm.device.VirtualSoundCardOption", "vim.vm.guest.GuestAuthentication", "vim.vm.guest.WindowsRegistryManager.RegistryValueData", "vim.vm.ProfileSpec", "vim.vm.TargetInfo", "vim.VsanUpgradeSystem.PreflightCheckIssue", "vmodl.fault.InvalidArgument", "vmodl.fault.NotEnoughLicenses", "vmodl.MethodFault"}) {
            groupObjects.add(ObjectRegistry.getObject(objectName));
        }
    }

    @Override
    public void emitObjects(List<VmodlObject> objects) {
        for (Map.Entry<String, OpenApiFilter> entry : this._filterMap.entrySet()) {
            this._folder = this._originalFolder + "/" + entry.getKey();
            if (this._folderExt != null) {
                this._folder = this._folder + "/" + this._folderExt;
            }
            this._filter = entry.getValue();
            for (VmodlObject obj : objects) {
                this.emitObj(obj);
            }
            if (this._emitBuiltins) {
                this.emitBuiltins();
            }
            HashSet<VmodlObject> exEmitted = new HashSet<VmodlObject>();
            HashSet<VmodlObject> exToEmit = new HashSet<VmodlObject>(this._externalNsObjects);
            while (!exToEmit.isEmpty()) {
                for (VmodlObject obj : exToEmit) {
                    this.emitObj(obj);
                    exEmitted.add(obj);
                }
                exToEmit = new HashSet<VmodlObject>(this._externalNsObjects);
                exToEmit.removeAll(exEmitted);
            }
        }
        this.dotEndFile();
        this.emitNsPaths();
        this.emitNsAll();
    }

    private void emitBuiltins() {
        for (String bname : _builtins) {
            VmodlObject obj = ObjectRegistry.getObject(bname);
            this.emitObj(obj);
        }
        for (VmodlObject obj : this._coreObjects) {
            this.emitObj(obj);
        }
    }

    private void emitObj(VmodlObject obj) {
        if (!this._filter.shouldEmit(obj)) {
            return;
        }
        this.beginFileForObject(obj);
        this.dispatchEmitObject(obj, true);
        this.emitFileTags();
        this.endFile();
    }

    @Override
    protected String getIndentGap() {
        return "  ";
    }

    private String kebaplize(String s) {
        return s;
    }

    private String tagName(VmodlObject obj) {
        return obj.getWsdlName();
    }

    private String tagDescription(VmodlObject obj) {
        return obj.getQualifiedVmodlType();
    }

    private void emitFileTags() {
        if (this._fileTags.isEmpty()) {
            return;
        }
        this.indent("tags:");
        for (VmodlObject obj : this._fileTags) {
            this.indent("- name: " + OpenApi3Emitter.qq(this.tagName(obj)));
            this.emitLine("description: ", OpenApi3Emitter.qq(this.tagDescription(obj)));
            this.unindent();
        }
        this.unindent();
    }

    private void emitNsPaths() {
        this.beginFile(this._namespace.replace(".", "/") + "/" + this._namespace + "_paths.yaml");
        String title = this._namespace + " namespace paths";
        this.emitHeader(title, Versions.getTargetVersion().getVmodlName());
        for (ManagedObject mo : this._emittedMoObjects) {
            this.emitMoPaths(mo);
        }
        this.emitFileTags();
        this.endFile();
    }

    private void emitNsAll() {
        this._forceLocalRefs = true;
        this.beginFile(this._namespace.replace(".", "/") + "/" + this._namespace + "_all.yaml");
        String title = this._namespace + " namespace paths";
        this.emitHeader(title, Versions.getTargetVersion().getVmodlName());
        for (String string : _builtins) {
            VmodlObject obj = ObjectRegistry.getObject(string);
            if (obj.getKind() != VmodlObject.Kind.DataObject || this._emittedDoObjects.contains(obj)) continue;
            this.emitDoImpl((DataObject)obj, false);
        }
        for (VmodlObject vmodlObject : this._coreObjects) {
            if (vmodlObject.getKind() != VmodlObject.Kind.DataObject || this._emittedDoObjects.contains(vmodlObject)) continue;
            this.emitDoImpl((DataObject)vmodlObject, false);
        }
        for (Enum enum_ : this._emittedEnumObjects) {
            this.emitEnumImpl(enum_);
        }
        for (DataObject dataObject : this._emittedDoObjects) {
            this.emitDoImpl(dataObject, false);
        }
        for (ManagedObject managedObject : this._emittedMoObjects) {
            this.emitMoMethodInputs(managedObject);
        }
        for (ManagedObject managedObject : this._emittedMoObjects) {
            this.emitMoPaths(managedObject);
        }
        this.emitFileTags();
        this.endFile();
        this._forceLocalRefs = false;
    }

    private void emitMo(ManagedObject obj, boolean topLevel) {
        if (topLevel) {
            this.emitHeader(obj, "ManagedObject");
        }
        this.emitNestedObjects(obj);
        this._queuedObjects.add(obj);
        if (!topLevel) {
            return;
        }
        for (ManagedObject mo : this._queuedObjects) {
            if (this.isExternalNsObj(mo)) continue;
            this.emitMoMethodInputs(mo);
        }
        for (ManagedObject mo : this._queuedObjects) {
            if (this.isExternalNsObj(mo)) continue;
            this.emitMoPaths(mo);
            this._emittedMoObjects.add(mo);
        }
        this._queuedObjects.clear();
    }

    private void emitMoMethodInputs(ManagedObject obj) {
        TreeSet<Method> methods = new TreeSet<Method>(new MethodComparator());
        methods.addAll(obj.getMethodList());
        for (Method meth : methods) {
            if (!this._filter.shouldEmit(meth) || !this.hasUnfilteredField(meth.getParameterList())) continue;
            int levels = this.emitCompSchemas();
            int ilevels = this.emitMethodInputHeader(meth);
            this.emitDoSliceFields(meth.getParameterList());
            this.unindent(ilevels);
            this.unindent(levels);
            this.emitGap();
        }
    }

    private void emitMoPaths(ManagedObject obj) {
        this.emitMoProperties(obj);
        this.emitMethods(obj);
    }

    private void emitMoProperties(VmodlObject obj) {
        for (Property prop : obj.getPropertyListWithOverrides()) {
            if (!this._filter.shouldEmit(prop)) continue;
            int plevels = this.emitPaths();
            VmodlDecl decl = prop.getDecl();
            String opId = obj.getWsdlName() + prop.getWsdlName();
            int levels = this.emitMethodHeader("get", obj, prop.getName(), "ManagedProperty", opId);
            this.indent("responses:");
            this.emitResult(decl);
            this.emitFaultResponse("404", this._managedObjectNotFound);
            this.emitFaultResponse("500", this._runtimeFault);
            this.unindent();
            this.unindent(levels);
            this.unindent(plevels);
            this.emitGap();
        }
    }

    private int emitMethodHeader(String verb, VmodlObject obj, String method, String type, String operationId) {
        this.emitLine("/", obj.getQualifiedVmodlType().replace(".", "/"), "/{mo_id}/", this.kebaplize(method), ":");
        this.indent();
        this.emitLine("summary: ", OpenApi3Emitter.qq(obj.getName() + " " + method + " " + type));
        this.indent("parameters:");
        this.indent("- name: " + OpenApi3Emitter.qq("mo_id"));
        this.emitLine("in: path");
        this.emitLine("description: ", OpenApi3Emitter.qq("Managed object Id"));
        this.emitLine("required: true");
        this.indent("schema:");
        this.emitLine("type: string");
        this.unindent();
        this.unindent();
        this.unindent();
        this.indent(verb + ":");
        this.emitLine("tags: [", OpenApi3Emitter.qq(this.tagName(obj)), "]");
        this.emitLine("operationId: ", operationId);
        this.emitLine("description: ", OpenApi3Emitter.qq(obj.getName() + " " + method + " " + type));
        this.emitMethodSecurity();
        this._fileTags.add(obj);
        return 2;
    }

    private void emitMethodSecurity() {
        this.emitLine("security: []");
    }

    private void emitResult(VmodlDecl decl) {
        this.indent("'200':");
        this.emitLine("description: ", "success");
        if (decl.getTypeId() == VmodlDecl.TypeId.VOID) {
            this.unindent();
            return;
        }
        this.indent("content:");
        this.indent(OpenApi3Emitter.qq("application/json") + ":");
        this.indent("schema:");
        this.emitDecl(decl);
        this.unindent();
        this.unindent();
        this.unindent();
        this.unindent();
    }

    void emitWrapDecl(VmodlDecl decl) {
        if (!decl.isPrimitive()) {
            this.emitDecl(decl);
            return;
        }
        this.emitLine("type: object");
        this.indent("properties:");
        this.indent("value:");
        this.emitDecl(decl);
        this.unindent(2);
    }

    private void emitFaultResponse(String code, VmodlObject obj) {
        this.indent(OpenApi3Emitter.qs(code) + ":");
        this.emitLine("description: ", OpenApi3Emitter.qq(obj.getName()));
        this.indent("content:");
        this.indent(OpenApi3Emitter.qq("application/json") + ":");
        this.indent("schema:");
        this.emitRefRemap(obj);
        this.unindent();
        this.unindent();
        this.unindent();
        this.unindent();
    }

    private void emitMethodParams(Method meth) {
        List<Parameter> params = meth.getParameterList();
        if (params.size() == 0 || !this.hasUnfilteredField(params)) {
            return;
        }
        this.indent("requestBody:");
        this.emitLine("required: true");
        this.indent("content:");
        this.indent(OpenApi3Emitter.qq("application/json") + ":");
        this.indent("schema:");
        this.emitMethodInputRef(meth);
        this.unindent();
        this.unindent();
        this.unindent();
        this.unindent();
    }

    private void emitMethodInputRef(Method meth) {
        VmodlObject cont = meth.getContainer().getRootContainer();
        String mname = this.getMethodInputTypeName(meth);
        this.emitLine("$ref: ", this.makeRef(this.getRefFileNameRemap(cont), mname));
    }

    private void emitMethods(ManagedObject obj) {
        TreeSet<Method> methods = new TreeSet<Method>(new MethodComparator());
        methods.addAll(obj.getMethodList());
        for (Method meth : methods) {
            if (!this._filter.shouldEmit(meth)) continue;
            int plevels = this.emitPaths();
            int levels = this.emitMethodHeader("post", obj, meth.getName(), "ManagedMethod", meth.getWsdlName());
            this.emitMethodParams(meth);
            this.indent("responses:");
            this.emitResult(meth.getReturnDecl());
            this.emitFaultResponse("404", this._managedObjectNotFound);
            this.emitFaultResponse("500", this._runtimeFault);
            int faultCode = 490;
            for (VmodlObject vmodlObject : meth.getFaultList()) {
                if (!this._filter.shouldEmit(vmodlObject)) continue;
                this.emitFaultResponse(Integer.toString(faultCode), vmodlObject);
                --faultCode;
            }
            this.unindent();
            this.unindent(levels);
            this.unindent(plevels);
            this.emitGap();
        }
    }

    private void emitEnum(Enum obj, boolean topLevel) {
        if (topLevel) {
            this.emitHeader(obj, "EnumObject");
        }
        this._emittedEnumObjects.add(obj);
        this.emitEnumImpl(obj);
    }

    private void emitEnumImpl(Enum obj) {
        int levels = this.emitCompSchemas();
        this.indent(obj.getWsdlName() + ":");
        this.emitLine("type: string");
        this.indent("enum:");
        List<Version> vers = obj.getValueVersionList();
        List<String> values = obj.getValueList();
        for (int i = 0; i < values.size(); ++i) {
            Version ver = vers.get(i);
            if (ver != null && !this._filter.shouldEmit(ver)) continue;
            this.emitLine("- ", OpenApi3Emitter.qq(values.get(i)));
        }
        this.unindent();
        this.unindent();
        this.unindent(levels);
    }

    private void emitEnumExample(Enum obj) {
        List<Version> vers = obj.getValueVersionList();
        List<String> values = obj.getValueList();
        for (int i = 0; i < values.size(); ++i) {
            Version ver = vers.get(i);
            if (ver != null && !this._filter.shouldEmit(ver)) continue;
            this.emitPartial(OpenApi3Emitter.qq(values.get(i)));
            return;
        }
    }

    private void emitDo(DataObject obj, boolean topLevel) {
        if (topLevel) {
            this.emitHeader(obj, "DataObject");
        }
        this.emitNestedObjects(obj);
        this._emittedDoObjects.add(obj);
        this.emitDoImpl(obj, topLevel);
    }

    private void emitDoAsString(DataObject obj, String format, String example, boolean topLevel) {
        this.indent(obj.getWsdlName() + ":");
        this.emitLine("description: ", this.makeDescription(obj, topLevel));
        this.emitLine("example: ", OpenApi3Emitter.qq(example));
        this.emitLine("type: string");
        if (!format.isEmpty()) {
            this.emitLine("format: ", format);
        }
        this.unindent();
    }

    private boolean emitSpecialDo(DataObject obj, boolean topLevel) {
        if (obj == this._any) {
            this.emitAnySchema(obj, topLevel);
            return true;
        }
        if (obj == ObjectRegistry.getObject("vmodl.Binary")) {
            this.emitDoAsString(obj, "byte", "QmluYXJ5REF0YQ==", topLevel);
            return true;
        }
        if (obj == ObjectRegistry.getObject("vmodl.DateTime")) {
            this.emitDoAsString(obj, "date-time", "1985-04-28T23:20:50.52Z", topLevel);
            return true;
        }
        if (obj == ObjectRegistry.getObject("vmodl.MethodName")) {
            this.emitDoAsString(obj, "", "methodname", topLevel);
            return true;
        }
        if (obj == ObjectRegistry.getObject("vmodl.PropertyPath")) {
            this.emitDoAsString(obj, "", "property.path", topLevel);
            return true;
        }
        if (obj == ObjectRegistry.getObject("vmodl.TypeName")) {
            this.emitDoAsString(obj, "", "typename", topLevel);
            return true;
        }
        if (obj == ObjectRegistry.getObject("vmodl.URI")) {
            this.emitDoAsString(obj, "", "http://localhost/sdk", topLevel);
            return true;
        }
        return false;
    }

    private void emitDoImpl(DataObject obj, boolean topLevel) {
        int levels = this.emitCompSchemas();
        this.emitDoGraph(obj);
        if (!this.emitSpecialDo(obj, topLevel)) {
            this.emitDoSlice(obj, topLevel);
            if (this.isGroupObject(obj)) {
                this.emitDoGroup(obj, topLevel);
            }
            this.emitDoSchema(obj, topLevel);
        }
        this.emitGap();
        this.unindent(levels);
    }

    private void emitDoGraph(DataObject obj) {
        String shape = obj.isFault() ? "box" : "ellipse";
        this.dotEmitLine(OpenApi3Emitter.qq(obj.getQualifiedVmodlType()), " [ shape=", shape, " ];");
        if (obj.getBaseObject() != null) {
            this.dotEmitLine(OpenApi3Emitter.qq(obj.getQualifiedVmodlType()), " -> ", OpenApi3Emitter.qq(obj.getBaseObject().getQualifiedVmodlType()), ";");
        }
    }

    private void emitDoSlice(DataObject obj, boolean topLevel) {
        int levels = this.emitDoHeader(obj, SLICE_SUFFIX, topLevel);
        this.emitDoSliceFields(obj.getPropertyListWithOverrides());
        this.unindent(levels);
    }

    private void emitDoSliceExample(DataObject obj) {
        this.emitPartial("{");
        this.emitDoSliceFieldsExample(obj.getPropertyListWithOverrides());
        this.emitPartial("}");
    }

    private boolean hasUnfilteredField(Collection<? extends Field> fields) {
        for (Field field : fields) {
            if (!this._filter.shouldEmit(field)) continue;
            return true;
        }
        return false;
    }

    private void emitDoSliceFields(Collection<? extends Field> fields) {
        boolean hasProps = false;
        ArrayList<String> required = new ArrayList<String>();
        for (Field field : fields) {
            VmodlDecl decl;
            if (!this._filter.shouldEmit(field)) continue;
            if (!hasProps) {
                this.indent("properties:");
                hasProps = true;
            }
            if (!(decl = field.getDecl()).isOptional()) {
                required.add(field.getName());
            }
            this.indent(field.getName() + ":");
            this.emitDecl(decl);
            this.unindent();
        }
        if (!hasProps) {
            this.indent("properties: {}");
        }
        this.unindent();
        if (!required.isEmpty()) {
            this.emitLine("required: [", OpenApi3Emitter.join(required), "]");
        }
    }

    private void emitDoSliceFieldsExample(Collection<? extends Field> fields) {
        boolean firstProp = true;
        for (Field field : fields) {
            VmodlDecl decl;
            if (!this._filter.shouldEmit(field) || (decl = field.getDecl()).isOptional()) continue;
            if (!firstProp) {
                this.emitPartial(", ");
            } else {
                firstProp = false;
            }
            this.emitPartial(OpenApi3Emitter.qq(field.getName()), ":");
            this.emitDeclExample(decl);
        }
    }

    private void emitDoSchema(DataObject obj, boolean topLevel) {
        int levels = this.emitDoHeader(obj, "", topLevel);
        if (obj == this._any) {
            throw new RuntimeException("Unexpected object type : " + obj.getQualifiedVmodlType());
        }
        this.emitDoSchemaFields(obj);
        this.unindent(levels);
    }

    private void emitDoGroupExample(DataObject obj) {
        this.emitPartial("{");
        String propName = this.toPropName(obj);
        this.emitPartial(OpenApi3Emitter.qq(propName) + ":");
        this.emitDoSliceExample(obj);
        this.emitPartial("}");
    }

    private void emitDoSchemaExample(DataObject obj) {
        this.emitPartial("{");
        if (obj == this._any) {
            this.emitAnyFieldsExample();
        } else {
            this.emitDoSchemaFieldsExample(obj);
        }
        this.emitPartial("}");
    }

    private void emitDoSchemaFields(DataObject obj) {
        this.indent("properties:");
        List<String> required = this.emitDoBaseSliceFields(obj);
        if (this.isGroupObject(obj)) {
            required.add(this.emitGroupProperty(obj));
        } else {
            this.emitDoChildSliceFields(obj);
        }
        this.unindent();
        if (!required.isEmpty()) {
            this.emitLine("required: [", OpenApi3Emitter.join(required), "]");
        }
    }

    private void emitDoSchemaFieldsExample(DataObject obj) {
        boolean hasBaseFields = this.emitDoBaseSliceFieldsExample(obj);
        if (this.isGroupObject(obj)) {
            if (hasBaseFields) {
                this.emitPartial(",");
            }
            this.emitGroupPropertyExample(obj);
        }
    }

    private void emitAnySchema(DataObject obj, boolean topLevel) {
        if (obj != this._any) {
            throw new RuntimeException("Unexpected object type : " + obj.getQualifiedVmodlType());
        }
        this.emitTypeKindEnum();
        int levels = this.emitDoHeader(obj, "", topLevel);
        this.emitAnyFields(obj);
        this.unindent(levels);
    }

    private void emitTypeKindEnum() {
        this.indent("TypeKind:");
        this.emitLine("type: string");
        this.indent("enum:");
        this.emitLine("- boolean");
        this.emitLine("- byte");
        this.emitLine("- short");
        this.emitLine("- int");
        this.emitLine("- long");
        this.emitLine("- float");
        this.emitLine("- double");
        this.emitLine("- string");
        this.emitLine("- datetime");
        this.emitLine("- typename");
        this.emitLine("- methodname");
        this.emitLine("- proppath");
        this.emitLine("- uri");
        this.emitLine("- binary");
        this.emitLine("- dataobject");
        this.emitLine("- moref");
        this.emitLine("- fault");
        this.emitLine("- array");
        this.unindent();
        this.unindent();
    }

    private void emitAnyFields(DataObject obj) {
        this.indent("properties:");
        this.indent("kind:");
        this.emitLine("$ref: '#/components/schemas/TypeKind'");
        this.unindent();
        this.indent("elementKind:");
        this.emitLine("$ref: '#/components/schemas/TypeKind'");
        this.unindent();
        this.indent("boolean:");
        this.emitLine("type: ", "boolean");
        this.unindent();
        this.indent("integer:");
        this.emitLine("type: ", "integer");
        this.emitLine("format: ", "int64");
        this.unindent();
        this.indent("number:");
        this.emitLine("type: ", "number");
        this.emitLine("format: ", "double");
        this.unindent();
        this.indent("string:");
        this.emitLine("type: ", "string");
        this.unindent();
        this.indent("binary:");
        this.emitLine("type: ", "string");
        this.emitLine("format: ", "byte");
        this.unindent();
        this.indent("moref:");
        this.emitRef(this._managedObjectReference);
        this.unindent();
        this.indent("dataobject:");
        this.emitRefRemap(this._dataObject);
        this.unindent();
        this.indent("fault:");
        this.emitRefRemap(this._methodFault);
        this.unindent();
        this.indent("booleanArray:");
        this.emitLine("type: array");
        this.indent("items:");
        this.emitLine("type: ", "boolean");
        this.unindent();
        this.unindent();
        this.indent("integerArray:");
        this.emitLine("type: array");
        this.indent("items:");
        this.emitLine("type: ", "integer");
        this.emitLine("format: ", "int64");
        this.unindent();
        this.unindent();
        this.indent("numberArray:");
        this.emitLine("type: array");
        this.indent("items:");
        this.emitLine("type: ", "number");
        this.emitLine("format: ", "double");
        this.unindent();
        this.unindent();
        this.indent("stringArray:");
        this.emitLine("type: array");
        this.indent("items:");
        this.emitLine("type: ", "string");
        this.unindent();
        this.unindent();
        this.indent("binaryArray:");
        this.emitLine("type: array");
        this.indent("items:");
        this.emitLine("type: ", "string");
        this.emitLine("format: ", "byte");
        this.unindent();
        this.unindent();
        this.indent("morefArray:");
        this.emitLine("type: array");
        this.indent("items:");
        this.emitRef(this._managedObjectReference);
        this.unindent();
        this.unindent();
        this.indent("dataobjectArray:");
        this.emitLine("type: array");
        this.indent("items:");
        this.emitRefRemap(this._dataObject);
        this.unindent();
        this.unindent();
        this.indent("faultArray:");
        this.emitLine("type: array");
        this.indent("items:");
        this.emitRefRemap(this._methodFault);
        this.unindent();
        this.unindent();
        this.unindent();
    }

    private void emitAnyFieldsExample() {
        this.emitPartial(OpenApi3Emitter.qq("kind"), ":", OpenApi3Emitter.qq("string"), ",");
        this.emitPartial(OpenApi3Emitter.qq("string"), ": ", OpenApi3Emitter.qq("any_string"));
    }

    private String emitSliceProperty(VmodlObject obj) {
        String propName = this.toPropName(obj);
        this.indent(propName + ":");
        this.emitRefRemap(obj, SLICE_SUFFIX);
        this.unindent();
        return propName;
    }

    private void emitSlicePropertyExample(VmodlObject obj) {
        String propName = this.toPropName(obj);
        this.emitPartial(OpenApi3Emitter.qq(propName) + ":");
        this.emitDoSliceExample((DataObject)obj);
    }

    private void emitGroupPropertyExample(VmodlObject obj) {
        String propName = this.toPropName(obj);
        this.emitPartial(OpenApi3Emitter.qq(propName) + ":");
        this.emitDoGroupExample((DataObject)obj);
    }

    private String emitGroupProperty(VmodlObject obj) {
        String propName = this.toPropName(obj);
        this.indent(propName + ":");
        this.emitRefRemap(obj, GROUP_SUFFIX);
        this.unindent();
        return propName;
    }

    private List<String> emitDoBaseSliceFields(DataObject obj) {
        ArrayList<String> required = new ArrayList<String>();
        List<VmodlObject> baseObjs = obj.getBaseObjectList();
        if (!this.isGroupObject(obj)) {
            baseObjs.add(obj);
        }
        for (VmodlObject baseObj : baseObjs) {
            if (baseObj == this._dynamicData || baseObj == this._dataObject) continue;
            required.add(this.emitSliceProperty(baseObj));
        }
        return required;
    }

    private boolean emitDoBaseSliceFieldsExample(DataObject obj) {
        List<VmodlObject> baseObjs = obj.getBaseObjectList();
        if (!this.isGroupObject(obj)) {
            baseObjs.add(obj);
        }
        boolean firstProp = true;
        for (VmodlObject baseObj : baseObjs) {
            if (baseObj == this._dynamicData || baseObj == this._dataObject) continue;
            if (!firstProp) {
                this.emitPartial(", ");
            } else {
                firstProp = false;
            }
            this.emitSlicePropertyExample(baseObj);
        }
        return !firstProp;
    }

    private int emitDoChildSliceFields(DataObject obj) {
        int count = 0;
        List<VmodlObject> desc = obj.getAllDescendents(this._groupObjects);
        for (VmodlObject d : desc) {
            if (!this._filter.shouldEmit(d) || d.getKind() != VmodlObject.Kind.DataObject || this._coreObjects.contains(d) || d == this._dynamicData) continue;
            if (this.isGroupObject(d)) {
                this.emitGroupProperty(d);
            } else {
                this.emitSliceProperty(d);
            }
            ++count;
        }
        return count;
    }

    private void emitDoGroup(DataObject obj, boolean topLevel) {
        int levels = this.emitDoHeader(obj, GROUP_SUFFIX, topLevel);
        this.emitDoGroupFields(obj);
        this.unindent(levels);
    }

    private void emitDoGroupFields(DataObject obj) {
        this.indent("properties:");
        String propName = this.emitSliceProperty(obj);
        this.emitDoChildSliceFields(obj);
        this.unindent();
        this.emitLine("required: [", propName, "]");
    }

    private void emitDecl(VmodlDecl decl) {
        if (decl.isArray()) {
            this.emitLine("type: array");
            this.indent("items:");
        }
        switch (decl.getTypeId()) {
            case BOOLEAN: {
                this.emitLine("type: ", "boolean");
                break;
            }
            case BYTE: {
                this.emitLine("type: ", "integer");
                this.emitLine("format: ", "int32");
                break;
            }
            case SHORT: {
                this.emitLine("type: ", "integer");
                this.emitLine("format: ", "int32");
                break;
            }
            case INT: {
                this.emitLine("type: ", "integer");
                this.emitLine("format: ", "int32");
                break;
            }
            case LONG: {
                this.emitLine("type: ", "integer");
                this.emitLine("format: ", "int64");
                break;
            }
            case FLOAT: {
                this.emitLine("type: ", "number");
                this.emitLine("format: ", "float");
                break;
            }
            case DOUBLE: {
                this.emitLine("type: ", "number");
                this.emitLine("format: ", "double");
                break;
            }
            case STRING: {
                this.emitLine("type: ", "string");
                break;
            }
            case DATETIME: {
                this.emitRef(ObjectRegistry.getObject("vmodl.DateTime"));
                break;
            }
            case TYPENAME: {
                this.emitRef(ObjectRegistry.getObject("vmodl.TypeName"));
                break;
            }
            case METHODNAME: {
                this.emitRef(ObjectRegistry.getObject("vmodl.MethodName"));
                break;
            }
            case PROPPATH: {
                this.emitRef(ObjectRegistry.getObject("vmodl.PropertyPath"));
                break;
            }
            case URI: {
                this.emitRef(ObjectRegistry.getObject("vmodl.URI"));
                break;
            }
            case BINARY: {
                this.emitRef(ObjectRegistry.getObject("vmodl.Binary"));
                break;
            }
            case ANY: {
                this.emitRefRemap(this._any);
                break;
            }
            case VOID: {
                throw new RuntimeException("Unexpected object type : " + (Object)((Object)decl.getTypeId()));
            }
            case ENUM: {
                VmodlObject enumobj = decl.getObject();
                this.emitRef(enumobj);
                break;
            }
            case MANAGED: {
                this.emitRef(this._managedObjectReference);
                break;
            }
            case DATA: {
                VmodlObject obj = decl.getObject();
                if (obj != null) {
                    this.emitRefRemap(obj);
                    break;
                }
                throw new RuntimeException("Decl without object type: " + (Object)((Object)decl.getTypeId()));
            }
            default: {
                throw new RuntimeException("Unexpected object type : " + (Object)((Object)decl.getTypeId()));
            }
        }
        if (decl.isArray()) {
            this.unindent();
        }
    }

    private void emitDeclExample(VmodlDecl decl) {
        if (decl.isArray()) {
            this.emitPartial("[");
        }
        switch (decl.getTypeId()) {
            case BOOLEAN: {
                this.emitPartial("false");
                break;
            }
            case BYTE: 
            case SHORT: 
            case INT: 
            case LONG: {
                this.emitPartial("42");
                break;
            }
            case FLOAT: 
            case DOUBLE: {
                this.emitPartial("3.14");
                break;
            }
            case STRING: {
                this.emitPartial(OpenApi3Emitter.qq("string"));
                break;
            }
            case DATETIME: {
                this.emitPartial(OpenApi3Emitter.qq("1985-04-28T23:20:50.52Z"));
                break;
            }
            case TYPENAME: {
                this.emitPartial(OpenApi3Emitter.qq("typename"));
                break;
            }
            case METHODNAME: {
                this.emitPartial(OpenApi3Emitter.qq("methodname"));
                break;
            }
            case PROPPATH: {
                this.emitPartial(OpenApi3Emitter.qq("propname"));
                break;
            }
            case URI: {
                this.emitPartial(OpenApi3Emitter.qq("http://localhost/api"));
                break;
            }
            case BINARY: {
                this.emitPartial(OpenApi3Emitter.qq("QmluYXJ5REF0YQ=="));
                break;
            }
            case ANY: {
                this.emitDoSchemaExample((DataObject)this._any);
                break;
            }
            case VOID: {
                throw new RuntimeException("Unexpected object type : " + (Object)((Object)decl.getTypeId()));
            }
            case ENUM: {
                VmodlObject enumobj = decl.getObject();
                this.emitEnumExample((Enum)enumobj);
                break;
            }
            case MANAGED: {
                this.emitDoSchemaExample((DataObject)this._managedObjectReference);
                break;
            }
            case DATA: {
                if (decl.isArray()) break;
                VmodlObject obj = decl.getObject();
                if (obj != null) {
                    this.emitDoSchemaExample((DataObject)obj);
                    break;
                }
                throw new RuntimeException("Decl without object type: " + (Object)((Object)decl.getTypeId()));
            }
            default: {
                throw new RuntimeException("Unexpected object type : " + (Object)((Object)decl.getTypeId()));
            }
        }
        if (decl.isArray()) {
            this.emitPartial("]");
        }
    }

    private void emitNestedObjects(VmodlObject obj) {
        TreeSet<VmodlObject> nestedObjects = new TreeSet<VmodlObject>(new VmodlObjectComparator());
        nestedObjects.addAll(obj.getNestedList());
        for (VmodlObject nested : nestedObjects) {
            if (!this._filter.shouldEmit(nested)) continue;
            this.dispatchEmitObject(nested, false);
        }
    }

    private void dispatchEmitObject(VmodlObject obj, boolean topLevel) {
        switch (obj.getKind()) {
            case DataObject: {
                this.emitDo((DataObject)obj, topLevel);
                break;
            }
            case Enum: {
                this.emitEnum((Enum)obj, topLevel);
                break;
            }
            case ManagedObject: {
                this.emitMo((ManagedObject)obj, topLevel);
                break;
            }
            default: {
                throw new RuntimeException("Unexpected VmodlObject Kind");
            }
        }
    }

    private void emitHeader(VmodlObject obj, String decltype) {
        Version version = obj.getVersion();
        String title = obj.getName() + " " + decltype;
        String ver = version != null ? version.getVmodlName() : "None";
        this.emitHeader(title, ver);
    }

    private void emitHeader(String title, String version) {
        this.emitLine("openapi: 3.0.0");
        this.indent("servers:");
        this.indent("- url: http://localhost/sdk");
        this.emitLine("description: Joap server");
        this.unindent();
        this.unindent();
        this.indent("info:");
        this.emitLine("title: ", title);
        this.emitLine("version: ", version);
        this.emitLine("description: ", "Joap API");
        this.indent("contact:");
        this.emitLine("name: ", "Georgi Dimitrov");
        this.unindent();
        this.unindent();
        this.emitGap();
        this._hasCompSchemas = false;
        this._hasPaths = false;
        this._fileTags.clear();
    }

    private int emitCompSchemas() {
        if (!this._hasCompSchemas) {
            this.indent("components:");
            this.indent("schemas:");
            this._hasCompSchemas = true;
            return 2;
        }
        this.indent();
        this.indent();
        return 2;
    }

    private int emitPaths() {
        if (!this._hasPaths) {
            this.indent("paths:");
            this._hasPaths = true;
            return 1;
        }
        this.indent();
        return 1;
    }

    private String getRefFileName(VmodlObject obj) {
        return this.getObjectFileName(obj.getRootContainer());
    }

    private String getRefFileNameRemap(VmodlObject obj) {
        return this.getObjectFileNameRemap(obj.getRootContainer());
    }

    private String makeRef(String fname, String name) {
        String relFname = this.relativePath(this.fullFname(fname), this.getFilename());
        return OpenApi3Emitter.qs(relFname + "#/components/schemas/" + name);
    }

    private String makeRef(VmodlObject obj, String suffix) {
        String fname = this.getRefFileName(obj);
        return this.makeRef(fname, obj.getWsdlName() + suffix);
    }

    private String makeRefRemap(VmodlObject obj, String suffix) {
        String fname = this.getRefFileNameRemap(obj);
        return this.makeRef(fname, obj.getWsdlName() + suffix);
    }

    private void emitRef(VmodlObject obj, String suffix) {
        this.emitLine("$ref: ", this.makeRef(obj, suffix));
    }

    private void emitRef(VmodlObject obj) {
        this.emitRef(obj, "");
    }

    private void emitRefRemap(VmodlObject obj, String suffix) {
        if (this.isExternalNsObj(obj)) {
            this._externalNsObjects.add(obj.getRootContainer());
        }
        this.emitLine("$ref: ", this.makeRefRemap(obj, suffix));
    }

    private void emitRefRemap(VmodlObject obj) {
        this.emitRefRemap(obj, "");
    }

    private boolean isExternalNsObj(VmodlObject obj) {
        return !obj.getVersion().getNamespace().equals(this._namespace);
    }

    private int emitDoHeader(VmodlObject obj, String suffix, boolean topLevel) {
        this.indent(obj.getWsdlName() + suffix + ":");
        this.emitLine("description: ", this.makeDescription(obj, topLevel));
        this.emitPartial("example: ");
        if (suffix.equals(SLICE_SUFFIX)) {
            this.emitDoSliceExample((DataObject)obj);
        } else if (suffix.equals(GROUP_SUFFIX)) {
            this.emitDoGroupExample((DataObject)obj);
        } else {
            this.emitDoSchemaExample((DataObject)obj);
        }
        this.emitGap();
        this.emitLine("type: object");
        return 1;
    }

    private String getMethodInputTypeName(Method meth) {
        return meth.getWsdlName() + METHOD_INPUT_SUFFIX;
    }

    private int emitMethodInputHeader(Method meth) {
        this.indent(this.getMethodInputTypeName(meth) + ":");
        this.emitLine("description: ", this.makeDescription(meth));
        this.emitPartial("example: {");
        this.emitDoSliceFieldsExample(meth.getParameterList());
        this.emitLine("}");
        this.emitLine("type: object");
        return 1;
    }

    private boolean isGroupObject(VmodlObject obj) {
        return this._groupObjects.contains(obj);
    }

    private String makeDescription(VmodlObject obj, boolean topLevel) {
        VmodlObject cont = obj.getContainer();
        String contStr = cont != null ? cont.getName() : "null";
        String desc = obj.getName() + (obj.isFault() ? " FaultClass" : "") + " DataObject" + (topLevel ? "" : " Nested") + " Container: " + contStr;
        return OpenApi3Emitter.qq(desc);
    }

    private String makeDescription(Method meth) {
        String desc = meth.getWsdlName() + "Method Input";
        return OpenApi3Emitter.qq(desc);
    }

    private String toPropName(VmodlObject obj) {
        return obj.getWsdlName();
    }

    private String getObjectFileSuffix(VmodlObject obj) {
        if (obj.getKind() == VmodlObject.Kind.ManagedObject) {
            return "_mo";
        }
        return "_do";
    }

    private String getObjectFileName(VmodlObject obj) {
        return this.getObjectFileName(obj.getQualifiedVmodlType(), this.getObjectFileSuffix(obj));
    }

    private String getObjectFileNameRemap(VmodlObject obj) {
        String fname = this.getObjectFileName(obj);
        if (this.isExternalNsObj(obj)) {
            fname = this._namespace.replace(".", "/") + "/_" + fname;
        }
        return fname;
    }

    private String getObjectFileName(String qtype, String suffix) {
        return qtype.replace('.', '/') + suffix + ".yaml";
    }

    private void beginFileForObject(VmodlObject obj) {
        this.beginFile(this.getObjectFileNameRemap(obj));
    }

    @Override
    protected void beginFile(String filename) {
        super.beginFile(this.fullFname(filename));
    }

    private String fullFname(String fname) {
        return this._folder + '/' + fname;
    }

    private String relativePath(String path, String base) {
        if (path.equals(base) || this._forceLocalRefs) {
            return "";
        }
        Path fname = Paths.get(path, new String[0]).getFileName();
        Path pathAbsolute = Paths.get(path, new String[0]).getParent();
        Path pathBase = Paths.get(base, new String[0]).getParent();
        Path pathRelative = pathBase.relativize(pathAbsolute);
        pathRelative = pathRelative.resolve(fname);
        return pathRelative.toString();
    }

    private void dotEmitLine(String ... strs) {
        for (String s : strs) {
            this._dotBuffer.append(s);
        }
        this._dotBuffer.append("\n");
    }

    private void dotEndFile() {
        this.dotEmitLine("}");
        this.endFile(this.fullFname(this._namespace.replace(".", "/") + "/" + this._namespace + ".gv"), this._dotBuffer);
    }

    private static class MethodComparator
    implements Comparator<Method> {
        private MethodComparator() {
        }

        @Override
        public int compare(Method lhs, Method rhs) {
            return lhs.getWsdlName().compareTo(rhs.getWsdlName());
        }
    }

    private static class VmodlObjectComparator
    implements Comparator<VmodlObject> {
        private VmodlObjectComparator() {
        }

        @Override
        public int compare(VmodlObject lhs, VmodlObject rhs) {
            return lhs.getClassName().compareTo(rhs.getClassName());
        }
    }
}

