/*
 * Decompiled with CFR 0.152.
 */
package emitters.generators.joap;

import emitters.Versions;
import emitters.generators.joap.OpenApiFilter;
import emitters.model.Field;
import emitters.model.MetaVersion;
import emitters.model.ReleaseVersions;
import emitters.model.Version;
import emitters.model.VmodlApi;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

class PreviousReleaseFilter
implements OpenApiFilter {
    private Map<String, Set<Version>> _releasedVersions = new HashMap<String, Set<Version>>();

    @Override
    public boolean shouldEmit(VmodlApi api) {
        return this.shouldEmit(api.getVersion());
    }

    @Override
    public boolean shouldEmit(Field param) {
        return this.shouldEmit(param.getVersion());
    }

    @Override
    public boolean shouldEmit(Version version) {
        String serviceName = version.getService().name();
        Set<Version> prevReleased = this._releasedVersions.get(serviceName);
        if (prevReleased != null) {
            return prevReleased.contains(version);
        }
        Version.Kind kind = version.getKind();
        assert (kind == Version.Kind.LTS);
        return true;
    }

    PreviousReleaseFilter() {
        for (MetaVersion metaVersion2 : Versions.getMetaVersions()) {
            String serviceName = metaVersion2.getService().name();
            HashSet<Version> prevReleased = new HashSet<Version>();
            boolean isLatest = true;
            boolean ltsSet = false;
            boolean tpSet = false;
            for (ReleaseVersions releaseVersions2 : metaVersion2.getReleaseVersions()) {
                if (!ltsSet) {
                    Version ltsVersion = releaseVersions2.ltsVersion();
                    ltsSet = this.addParents(ltsVersion, isLatest, prevReleased);
                }
                if (!tpSet) {
                    Version tpVersion = releaseVersions2.tpVersion();
                    tpSet = this.addParents(tpVersion, isLatest, prevReleased);
                }
                isLatest = false;
                if (!ltsSet || !tpSet) continue;
                break;
            }
            this._releasedVersions.put(serviceName, prevReleased);
        }
    }

    private boolean addParents(Version version, boolean isLatest, Set<Version> set) {
        if (version == null) {
            return false;
        }
        set.addAll(version.getAllParents());
        if (!isLatest) {
            set.add(version);
        }
        return true;
    }
}

