/*
 * Decompiled with CFR 0.152.
 */
package emitters.javac;

import emitters.ObjectRegistry;
import emitters.Utils;
import emitters.Versions;
import emitters.VmodlEmitter;
import emitters.javac.BaseAp;
import emitters.javac.Options;
import emitters.javac.Platform;
import emitters.javac.VersionsLoader;
import emitters.model.DataObject;
import emitters.model.Enum;
import emitters.model.ManagedObject;
import emitters.model.Method;
import emitters.model.Parameter;
import emitters.model.Property;
import emitters.model.Version;
import emitters.model.VmodlDecl;
import emitters.model.VmodlObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.TypeElement;

@SupportedAnnotationTypes(value={"*"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_7)
public class TestApf
extends BaseAp {
    private boolean _doNotTest = false;

    private void verifyVersionsArePresent() {
        HashSet<String> expectedVersions = new HashSet<String>(Arrays.asList("vmodl.version.version0", "vmodl.version.version2", "vmodl.version.version1", "vmodl.query.version.version1", "vmodl.query.version.version2", "vmodl.query.version.version3", "vmodl.query.version.version4", "vmodl.reflect.version.version1", "vmodl.reflect.version.version2", "vim.version.version1", "vim.version.version2", "vim.version.version3", "vim.version.version4", "vim.version.version6", "vim.version.version5", "vim.version.version7", "vim.version.version8", "vim.version.version9", "vim.version.version10", "vim.version.version11", "vim.version.version12", "vim.version.version13", "vim.version.unstable", "vim.version.stable", "vim.version.disabled"));
        for (Version version : Versions.getVersions()) {
            expectedVersions.remove(version.getVmodlName());
        }
        if (expectedVersions.size() != 0) {
            StringBuilder sb = new StringBuilder();
            sb.append("[ ERROR ] Expected versions are not present:");
            for (String str : expectedVersions) {
                sb.append(" \"" + str + "\"");
            }
            throw new RuntimeException(sb.toString());
        }
        System.out.println("[ OK ] Verify Versions Tests passed");
    }

    private void verifyObjectsAreVisible() {
        HashMap<String, VmodlObject.Kind> objTypeMap = new HashMap<String, VmodlObject.Kind>();
        objTypeMap.put("vim.VirtualMachine", VmodlObject.Kind.ManagedObject);
        objTypeMap.put("vim.VirtualMachine.StorageRequirement", VmodlObject.Kind.DataObject);
        objTypeMap.put("vim.VirtualMachine.PowerState", VmodlObject.Kind.Enum);
        objTypeMap.put("vim.DiagnosticManager", VmodlObject.Kind.ManagedObject);
        objTypeMap.put("vim.DiagnosticManager.LogHeader", VmodlObject.Kind.DataObject);
        StringBuilder sb = new StringBuilder();
        for (Map.Entry entry : objTypeMap.entrySet()) {
            VmodlObject obj = ObjectRegistry.getObject((String)entry.getKey());
            if (obj == null) {
                sb.append("Object " + (String)entry.getKey() + " of type " + entry.getValue() + " is missing\n");
                continue;
            }
            if (obj.getKind().equals(entry.getValue())) continue;
            sb.append("Object " + (String)entry.getKey() + " of type " + entry.getValue() + " is present but its type is wrong: " + (Object)((Object)obj.getKind()) + "\n");
        }
        if (sb.length() != 0) {
            throw new RuntimeException(sb.toString());
        }
        System.out.println("[ OK ] Verify Objects Tests passed");
    }

    private void verifyModelCentralObjectsArePresent() {
        List<String> objects = Arrays.asList("vmodl.DynamicArray", "vmodl.DynamicData", "vmodl.DynamicProperty", "vmodl.ManagedObject", "vmodl.DataObject");
        StringBuilder sb = new StringBuilder();
        for (String objName : objects) {
            if (ObjectRegistry.hasObject(objName)) continue;
            sb.append("Object " + objName + " is not present\n");
        }
        if (sb.length() != 0) {
            throw new RuntimeException(sb.toString());
        }
        System.out.println("[ OK ] Verify Model Central Objects Test passed");
    }

    private void verifyContainerCorrectness() {
        StringBuilder sb = new StringBuilder();
        VmodlObject vm = ObjectRegistry.getObject("vim.VirtualMachine");
        if (vm.getContainer() != null) {
            sb.append(vm.getQualifiedVmodlType() + " should not have a container but it has " + vm.getContainer().getQualifiedVmodlType());
        }
        List<String> inVM = Arrays.asList("vim.VirtualMachine.StorageRequirement", "vim.VirtualMachine.PowerState");
        for (String name : inVM) {
            VmodlObject obj = ObjectRegistry.getObject(name);
            VmodlObject container = obj.getContainer();
            if (container == vm) continue;
            sb.append(obj.getQualifiedVmodlType() + " is not contained in  vim.VirtualMachine instead it ");
            if (container == null) {
                sb.append(" is top level\n");
                continue;
            }
            sb.append(" is contained in " + container.getQualifiedVmodlType() + "\n");
        }
        if (sb.length() != 0) {
            throw new RuntimeException(sb.toString());
        }
        System.out.println("[ OK ] Verify Containers Test passed");
    }

    private void verifyHasBase(VmodlObject child, VmodlObject parent, StringBuilder sb) {
        VmodlObject base = child.getBaseObject();
        if (base != parent) {
            String baseName = base == null ? "null" : base.getQualifiedVmodlType();
            sb.append("Object " + child.getQualifiedVmodlType() + " expected to have " + parent.getQualifiedVmodlType() + " as base, but it has " + baseName);
        }
    }

    private void verifyBaseClassRelationship() {
        StringBuilder sb = new StringBuilder();
        VmodlObject dynamicData = ObjectRegistry.getObject(Utils.DynamicDataClassName);
        VmodlObject dynamicArray = ObjectRegistry.getObject(Utils.DynamicArrayClassName);
        VmodlObject dynamicProperty = ObjectRegistry.getObject(Utils.DynamicPropertyClassName);
        VmodlObject dataObject = ObjectRegistry.getObject(Utils.DataObjectClassName);
        VmodlObject managedObject = ObjectRegistry.getObject(Utils.ManagedObjectClassName);
        if (dataObject.getBaseObject() != null) {
            sb.append("DataObject has a non null base object: " + dataObject.getBaseObject().getQualifiedVmodlType() + "\n");
        }
        if (managedObject.getBaseObject() != null) {
            sb.append("ManagedObject has a non null base object: " + managedObject.getBaseObject().getQualifiedVmodlType() + "\n");
        }
        this.verifyHasBase(dynamicData, dataObject, sb);
        this.verifyHasBase(dynamicArray, dataObject, sb);
        this.verifyHasBase(dynamicProperty, dataObject, sb);
        VmodlObject extObj = ObjectRegistry.getObject("vim.ExtensibleManagedObject");
        VmodlObject managedEntity = ObjectRegistry.getObject("vim.ManagedEntity");
        VmodlObject dataCenter = ObjectRegistry.getObject("vim.Datacenter");
        this.verifyHasBase(extObj, managedObject, sb);
        this.verifyHasBase(managedEntity, extObj, sb);
        this.verifyHasBase(dataCenter, managedEntity, sb);
        VmodlObject preflightCheckIssue = ObjectRegistry.getObject("vim.VsanUpgradeSystem.PreflightCheckIssue");
        VmodlObject apiBroken = ObjectRegistry.getObject("vim.VsanUpgradeSystem.APIBrokenIssue");
        this.verifyHasBase(preflightCheckIssue, dataObject, sb);
        this.verifyHasBase(apiBroken, preflightCheckIssue, sb);
        VmodlObject powerState = ObjectRegistry.getObject("vim.VirtualMachine.PowerState");
        this.verifyHasBase(powerState, null, sb);
        System.out.println("[ OK ] Verify Base Class Relationships Test passed");
    }

    private void verifyEnumConstants() {
        Enum powerState = (Enum)ObjectRegistry.getObject("vim.VirtualMachine.NeedSecondaryReason");
        List<String> constants2 = Arrays.asList("initializing", "divergence", "lostConnection", "partialHardwareFailure", "userAction", "checkpointError", "other");
        String checkPointError = "checkpointError";
        List<String> values = powerState.getValueList();
        List<Version> versions = powerState.getValueVersionList();
        StringBuilder sb = new StringBuilder();
        if (values.size() != constants2.size()) {
            sb.append("Expected and actual constants lists have different sizes: " + constants2.size() + " vs " + values.size() + "\n");
        }
        for (int i = 0; i < values.size(); ++i) {
            String expectedValue = constants2.get(i);
            String actualString = values.get(i);
            if (!actualString.equals(expectedValue)) {
                sb.append("At " + i + " expected '" + expectedValue + "' but got " + actualString + "\n");
            }
            if (!values.get(i).equals("checkpointError")) continue;
            Version version = versions.get(i);
            if (Versions.getVersion("vim.version.version10") == version) continue;
            sb.append("Annotated constant 'checkpointError' has bad version ");
            sb.append(versions.get(i) == null ? "null\n" : version.getVmodlName() + "\n");
        }
        if (sb.length() != 0) {
            throw new RuntimeException(sb.toString());
        }
        System.out.println("[ OK ] Verify Enums Test passed");
    }

    private void verifyDataObjects() {
        DataObject summary = (DataObject)ObjectRegistry.getObject("vim.Datastore.Summary");
        StringBuilder sb = new StringBuilder();
        Iterable<Property> properties = summary.getPropertyList();
        List<String> expectedProperties = Arrays.asList("datastore", "name", "url", "capacity", "freeSpace", "uncommitted", "accessible", "multipleHostAccess", "type", "maintenanceMode");
        int i = 0;
        for (Property prop : properties) {
            VmodlDecl decl;
            String expected = expectedProperties.get(i);
            if (!prop.getName().equals(expected)) {
                sb.append("Expected property '" + expected + "' but got '" + prop.getName() + "'\n");
            }
            if (prop.getName().equals("datastore")) {
                decl = prop.getDecl();
                VmodlObject dataStore = decl.getObject();
                if (!decl.isOptional()) {
                    sb.append("'datastore' property should be optional but it is not\n");
                }
                if (!decl.isManaged()) {
                    sb.append("Expected property 'datastore' to be managed but it is " + (Object)((Object)decl.getTypeId()) + "\n");
                }
                if (dataStore == null) {
                    sb.append("Managed propert 'datastore' has null for backing object");
                } else if (dataStore != ObjectRegistry.getObject("vim.Datastore")) {
                    sb.append("Datastore property is not pointing to a vmodl object of type vim.Datastore\n");
                }
            } else if (prop.getName().equals("uncommitted")) {
                decl = prop.getDecl();
                if (!decl.isOptional()) {
                    sb.append("'uncommitted' property should be optional but it is not\n");
                }
                if (!decl.getTypeId().equals((Object)VmodlDecl.TypeId.LONG)) {
                    sb.append("'uncommitted' property should be LONG but it is " + (Object)((Object)decl.getTypeId()));
                }
                if (prop.getVersion() != Versions.getVersion("vim.version.version5")) {
                    sb.append("'uncommitted' property should be in version5 but it is in " + prop.getVersion().getVmodlName());
                }
            }
            ++i;
        }
        if (i != expectedProperties.size()) {
            sb.append("Expected " + expectedProperties.size());
            sb.append(" but got " + i + "\n");
        }
        if (sb.length() != 0) {
            throw new RuntimeException(sb.toString());
        }
        System.out.println("[ OK ] Verify DataObjects Test passed");
    }

    private void verifyManagedObjects() {
        ManagedObject proxyService = (ManagedObject)ObjectRegistry.getObject("vim.ProxyService");
        StringBuilder sb = new StringBuilder();
        List<String> expectedProperties = Arrays.asList("httpsPort", "httpPort", "endpointList");
        int i = 0;
        for (Property prop : proxyService.getPropertyList()) {
            String expected = expectedProperties.get(i);
            if (!prop.getName().equals(expected)) {
                sb.append("Expected property '" + expected + "' but got '" + prop.getName() + "'\n");
            }
            VmodlDecl decl = prop.getDecl();
            if (prop.getName().equals("httpsPort")) {
                if (decl.isOptional()) {
                    sb.append("Property 'httpsPort' is optional\n");
                }
                if (!decl.getTypeId().equals((Object)VmodlDecl.TypeId.INT)) {
                    sb.append("Property 'httpsPort' should be an int but it is " + decl.getTypeId().toString() + "\n");
                }
            } else if (prop.getName().equals("httpPort")) {
                if (decl.isOptional()) {
                    sb.append("Property 'httpPort' is optional\n");
                }
                if (!decl.getTypeId().equals((Object)VmodlDecl.TypeId.INT)) {
                    sb.append("Property 'httpPort' should be an int but it is " + decl.getTypeId().toString() + "\n");
                }
            } else if (prop.getName().equals("endpointList")) {
                if (!decl.isOptional()) {
                    sb.append("Property 'endpointList' should be optional\n");
                }
                if (!decl.getTypeId().equals((Object)VmodlDecl.TypeId.MANAGED)) {
                    sb.append("Property 'endpointList' should be MANAGED  but it is " + decl.getTypeId().toString() + "\n");
                } else {
                    VmodlObject expectedObj = ObjectRegistry.getObject("vim.ProxyService.EndpointSpec");
                    if (expectedObj != decl.getObject()) {
                        sb.append("endpointList is not backed up by ProxySetvice.EndpointSpec");
                        sb.append(" but by " + decl.getObject().getClassName() + "\n");
                    }
                }
            }
            ++i;
        }
        List<Method> methods = proxyService.getMethodList();
        for (Method method : methods) {
            Parameter param;
            VmodlDecl paramDecl;
            List<Parameter> list;
            List<DataObject> faults;
            if (!method.getName().equals("removeEndpoint")) continue;
            VmodlDecl returnDecl = method.getReturnDecl();
            if (!returnDecl.getTypeId().equals((Object)VmodlDecl.TypeId.VOID)) {
                sb.append("removeEndpoint should return void, instead it  returns " + returnDecl.getTypeId().toString() + "\n");
            }
            if ((faults = method.getFaultList()).size() != 1) {
                sb.append("remove faults should have only 1 fault instead");
                sb.append(" it has " + faults.size() + ": ");
                for (DataObject dataObject : faults) {
                    sb.append(" " + dataObject.getClassName());
                }
                sb.append("\n");
            }
            boolean found = false;
            for (Object fault : faults) {
                if (!((VmodlObject)fault).getQualifiedVmodlType().equals("vim.fault.NotFound")) continue;
                found = true;
            }
            if (!found) {
                sb.append("Could not find fault 'NotFound' in fault list for 'removeEndpoint'\n");
            }
            if ((list = method.getParameterList()).size() != 1) {
                Object fault;
                sb.append("removeEndpint should have only 1 paramter instead");
                sb.append(" it has " + list.size() + ": ");
                fault = list.iterator();
                while (fault.hasNext()) {
                    Parameter param2 = (Parameter)fault.next();
                    sb.append(" " + param2.getName());
                }
                sb.append("\n");
            }
            if (!(paramDecl = (param = list.get(0)).getDecl()).isOptional()) {
                sb.append("Parameter 'endpoint' should be optional\n");
            }
            if (!paramDecl.getTypeId().equals((Object)VmodlDecl.TypeId.MANAGED)) {
                sb.append("Parameter 'endpoint' should be MANAGED  but it is " + paramDecl.getTypeId().toString() + "\n");
                continue;
            }
            VmodlObject expectedObj = ObjectRegistry.getObject("vim.ProxyService.EndpointSpec");
            if (expectedObj == paramDecl.getObject()) continue;
            sb.append("endpointList is not backed up by ProxySetvice.EndpointSpec");
            sb.append(" but by " + paramDecl.getObject().getClassName());
            sb.append("\n");
        }
        System.out.println("[ OK ] Verify ManagedObjects Test passed");
    }

    private void verifyObjectWsdlNames() {
        VmodlObject configInfoEx = ObjectRegistry.getObject("vim.cluster.ConfigInfoEx");
        if (!configInfoEx.getWsdlName().equals("ClusterConfigInfoEx")) {
            throw new RuntimeException("Creation of WSDL names for objects without @wsdlName is wrong. Expected 'ClusterConfigInfoEx' vs actual + '" + configInfoEx.getWsdlName() + "'");
        }
        VmodlObject opaqueNet = ObjectRegistry.getObject("vim.OpaqueNetwork");
        if (!opaqueNet.getWsdlName().equals("OpaqueNetwork")) {
            throw new RuntimeException("Creation of WSDL names for objects with @wsdlName is wrong. Expected 'OpaqueNetwork' vs actual + '" + opaqueNet.getWsdlName() + "'");
        }
        System.out.println("[ OK ] Verify Object WsdlNames Test passed");
    }

    private String getTargetVer(String defaultVersion) {
        for (Map.Entry<String, String> entry : Platform.getOptions().entrySet()) {
            if (!entry.getKey().equals("ver.target") || entry.getValue().equals(defaultVersion)) continue;
            this._doNotTest = true;
            return entry.getValue();
        }
        return defaultVersion;
    }

    @Override
    public boolean process(Set<? extends TypeElement> elementSet, RoundEnvironment roundEnv) {
        if (roundEnv.processingOver()) {
            return true;
        }
        this.init();
        Platform.setupRound(roundEnv);
        Versions.setBackend(new VersionsLoader());
        this._options = new Options();
        this._options.Parse(Platform.getOptions());
        Versions.init(new HashMap<String, String>(), this.getTargetVer("vim.version.version10"));
        this.processEmitters(new ArrayList<VmodlEmitter>(), false);
        if (!this._doNotTest) {
            this.verifyVersionsArePresent();
            this.verifyObjectsAreVisible();
            this.verifyModelCentralObjectsArePresent();
            this.verifyContainerCorrectness();
            this.verifyBaseClassRelationship();
            this.verifyEnumConstants();
            this.verifyDataObjects();
            this.verifyManagedObjects();
            this.verifyObjectWsdlNames();
        }
        return true;
    }
}

