/*
 * Decompiled with CFR 0.152.
 */
package emitters.model;

import emitters.Versions;
import emitters.model.Version;
import emitters.model.VmodlDecl;
import java.security.MessageDigest;

public class Field {
    protected final String _name;
    protected final VmodlDecl _decl;
    protected final String _privId;
    protected final Version _version;
    protected final String _comment;

    Field(String name, VmodlDecl decl, String privId, Version version, String comment) {
        this._name = name;
        this._decl = decl;
        this._privId = privId;
        this._version = version;
        this._comment = comment;
    }

    public String getName() {
        return this._name;
    }

    public VmodlDecl getDecl() {
        return this._decl;
    }

    public String getPrivilegeId() {
        return this._privId;
    }

    public Version getVersion() {
        return this._version;
    }

    public String getComment() {
        return this._comment;
    }

    void updateDigest(MessageDigest digest) {
        if (Versions.skipDigesting(this._version)) {
            return;
        }
        Versions.logDigesting("Field %s", this._name);
        digest.update(VmodlDecl.toBytes(this._name));
        Versions.digestLoggerIncreaseNesting();
        this._decl.updateDigest(digest);
        Versions.digestLoggerDecreaseNesting();
    }

    void print(String indent) {
        System.out.print(indent);
        this._decl.print();
        System.out.print(", Name: " + this._name);
        System.out.print(", Version: " + this._version.getVmodlName());
    }
}

