/*
 * Decompiled with CFR 0.152.
 */
package emitters.model;

import emitters.backend.FeatureState;
import emitters.backend.FssConfig;
import emitters.backend.Platform;
import emitters.model.Feature;
import emitters.model.Maturity;
import emitters.model.Release;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import vmodl.featureList;
import vmodl.featureSpec;
import vmodl.release;
import vmodl.releaseList;

public class Product {
    private static final List<Feature> NO_PARENTS = new ArrayList<Feature>(0);
    private final String _name;
    private FssConfig _fssConfig;
    private final Set<Feature> _proposedFeatures = new HashSet<Feature>();
    private final Set<Feature> _changingFeatures = new HashSet<Feature>();
    private final Map<String, Feature> _features = new HashMap<String, Feature>();
    private final Map<String, Release> _releases = new LinkedHashMap<String, Release>();
    private static Map<String, Product> _products = new HashMap<String, Product>();

    Product(String name, releaseList releaseList2, featureList featureList2) {
        this._name = name;
        String configClass = "emitters.config." + name + "FssConfig";
        this._fssConfig = Platform.fetchFssConfig(configClass);
        this.retrieveFeatures(featureList2.value());
        this.retrieveReleases(releaseList2.value());
    }

    private void retrieveFeatures(featureSpec[] featureList2) {
        this.validateFeatureSpec(featureList2);
        this.fillFeatureMap(featureList2, 0);
    }

    private void validateFeatureSpec(featureSpec[] featureList2) {
        if (this._name.contains("Test")) {
            return;
        }
        String previousName = "";
        for (featureSpec feature2 : featureList2) {
            String name = feature2.name();
            int result = name.compareToIgnoreCase(previousName);
            if (result <= 0) {
                throw new RuntimeException("Features in non-alphabetical order in product " + this._name + ": " + previousName + " followed by " + name);
            }
            previousName = name;
        }
    }

    private void fillFeatureMap(featureSpec[] featureSpecs, int index) {
        for (int i = index; i < featureSpecs.length; ++i) {
            String product;
            List<Feature> parents;
            featureSpec fspec = featureSpecs[i];
            String featureName = fspec.name();
            String[] featureDeps = fspec.dependencies();
            if (this._features.containsKey(featureName)) continue;
            if (featureDeps.length == 0) {
                parents = NO_PARENTS;
            } else {
                boolean recurse = false;
                parents = new ArrayList<Feature>();
                int j = 0;
                while (j < featureDeps.length) {
                    if (this._features.containsKey(featureDeps[j])) {
                        parents.add(this._features.get(featureDeps[j]));
                        ++j;
                        continue;
                    }
                    if (recurse) {
                        throw new RuntimeException("Feature '" + featureName + "' depends on '" + featureDeps[j] + "' which is not defined or there is a circular dependency in  product " + this._name);
                    }
                    recurse = true;
                    this.fillFeatureMap(featureSpecs, i + 1);
                }
            }
            FeatureState featureState = this._fssConfig.getState(featureName);
            if (featureState == FeatureState.ENABLED && this._fssConfig.isFrozen() && (product = this._fssConfig.getProduct()) != null && product.equals("vSphere")) {
                String message = "The automatic generation of next release's VMODL version is currently disabled. To ensure VMODL APIs associated with the enabled feature '" + featureName + "' are included in the release, do replace annotations @feature(\"" + featureName + "\") with @released(\"7.0.x.y\"). In addition, the line containing @featureSpec(name = \"" + featureName + "\") has to be removed from bora/vim/vmomi/product/vSphere.java";
                throw new RuntimeException(message);
            }
            Maturity maturity = featureState != FeatureState.DISABLED ? Maturity.TP : Maturity.DEV;
            Feature fd = new Feature(featureName, maturity, parents);
            fd.setTechPreview(featureState == FeatureState.TECH_PREVIEW);
            this._features.put(featureName, fd);
        }
    }

    private void retrieveReleases(release[] releases) {
        HashSet<String> releasedFeatures = new HashSet<String>();
        HashSet<Feature> carryOverFeatures = new HashSet<Feature>();
        for (int i = releases.length - 1; i >= 0; --i) {
            Feature desc;
            release release2 = releases[i];
            HashSet<Feature> ltsFeatures = new HashSet<Feature>();
            HashSet<Feature> tpFeatures = new HashSet<Feature>();
            for (String ltsFeature : release2.ltsFeatures()) {
                desc = this.getFeature(ltsFeature, "LTS feature");
                ltsFeatures.add(desc);
                releasedFeatures.add(ltsFeature);
                carryOverFeatures.remove(desc);
            }
            for (String tpFeature : release2.tpFeatures()) {
                desc = this.getFeature(tpFeature, "TechPreview feature");
                tpFeatures.add(desc);
                releasedFeatures.add(tpFeature);
                carryOverFeatures.add(desc);
            }
            tpFeatures.addAll(carryOverFeatures);
            Release rel = new Release(ltsFeatures, tpFeatures, release2.ltsId(), release2.tpId(), release2.type());
            this._releases.put(release2.id(), rel);
        }
        this.fillLayeredFeatures(releasedFeatures);
    }

    private Feature getFeature(String id, String type) {
        Feature result = this._features.get(id);
        if (result != null) {
            return result;
        }
        throw new RuntimeException("Unknown feature requested '" + id + "' for " + type);
    }

    private void fillLayeredFeatures(Set<String> releasedFeatures) {
        for (Map.Entry<String, Feature> entry : this._features.entrySet()) {
            Feature desc = entry.getValue();
            if (releasedFeatures.contains(entry.getKey())) continue;
            switch (desc.maturity) {
                case TP: {
                    this._proposedFeatures.add(entry.getValue());
                    break;
                }
                case DEV: {
                    this._changingFeatures.add(entry.getValue());
                    break;
                }
            }
        }
    }

    public Feature getFeature(String name) {
        return this._features.get(name);
    }

    public Release getRelease(String id) {
        Release result = this._releases.get(id);
        if (result != null) {
            return result;
        }
        throw new RuntimeException("Unknown release id given '" + id + "'");
    }

    public FssConfig getFssConfig() {
        return this._fssConfig;
    }

    public Set<Feature> getProposedFeatures() {
        return this._proposedFeatures;
    }

    public Set<Feature> getChangingFeatures() {
        return this._changingFeatures;
    }

    public Map<String, Release> getReleases() {
        return this._releases;
    }

    public static Product createProduct(String name, releaseList releases, featureList features) {
        Product product = new Product(name, releases, features);
        if (_products.put(name, product) == null) {
            return product;
        }
        throw new RuntimeException("Product '" + name + "' is already created");
    }

    public static Product getProduct(String name) {
        return _products.get(name);
    }
}

