/*
 * Decompiled with CFR 0.152.
 */
package emitters.model.raw;

import emitters.Versions;
import emitters.core.SyntaxException;
import emitters.model.Maturity;
import emitters.model.MetaVersion;
import emitters.model.Version;
import emitters.model.raw.RawElement;
import emitters.model.raw.ReleaseInNamespace;
import vmodl.feature;

public abstract class RawVersion
extends RawElement {
    protected String _versionTag;

    public Version getVersion() {
        String versionTag = this.getVersionTag();
        ReleaseInNamespace releaseInNs = this.getReleaseInNamespace();
        feature feature2 = this.getFeature();
        boolean isLegacy = this.isLegacy();
        if (versionTag != null || releaseInNs != null) {
            if (feature2 != null || isLegacy) {
                throw SyntaxException.at(this.getSourcePos(), "Mixed release-related annotations", new Object[0]);
            }
            if (releaseInNs != null && versionTag != null) {
                throw SyntaxException.at(this.getSourcePos(), "Mixed @versionX and @released tags", new Object[0]);
            }
            return releaseInNs != null ? releaseInNs.getVersion() : Versions.getVersion(versionTag);
        }
        if (feature2 == null && !isLegacy) {
            return null;
        }
        if (feature2 != null && isLegacy) {
            throw SyntaxException.at(this.getSourcePos(), "Tagged with multiple dev versions", new Object[0]);
        }
        String context = this.getContext();
        MetaVersion metaVersion2 = Versions.getMetaVersion(context);
        if (metaVersion2 == null) {
            throw SyntaxException.at(this.getSourcePos(), "No meta version for %s", context);
        }
        if (isLegacy) {
            return metaVersion2.getDisabledVersion();
        }
        String featureName = feature2.value();
        Maturity maturity = metaVersion2.getFeatureMaturity(featureName);
        if (maturity == null) {
            throw SyntaxException.at(this.getSourcePos(), "Unknown feature: %s", featureName);
        }
        switch (maturity) {
            case TP: 
            case DEV: {
                return metaVersion2.getFeatureVersion(featureName, maturity);
            }
        }
        throw SyntaxException.at(this.getSourcePos(), "Invalid dev version maturity", new Object[0]);
    }

    protected abstract String getVersionTag();

    protected abstract ReleaseInNamespace getReleaseInNamespace();

    protected abstract feature getFeature();

    protected abstract boolean isLegacy();

    protected abstract String getContext();

    protected void processAnnotation(String annotationName) {
        boolean isVmodlAnnotation;
        boolean bl = isVmodlAnnotation = annotationName.startsWith("vmodl.") && annotationName.indexOf(46, 6) == -1;
        if (isVmodlAnnotation || annotationName.startsWith("java.")) {
            return;
        }
        if (annotationName.equals("vmodl.version.version0")) {
            throw SyntaxException.at(this.getSourcePos(), "%s can only be implicit", "vmodl.version.version0");
        }
        if (this._versionTag != null) {
            throw SyntaxException.at(this.getSourcePos(), "Multiple version annotations: %s and %s", this._versionTag, annotationName);
        }
        this._versionTag = annotationName;
    }
}

