/*
 * Decompiled with CFR 0.152.
 */
package emitters.wsdl;

import emitters.backend.Platform;
import emitters.model.ManagedObject;
import emitters.model.VmodlObject;
import emitters.wsdl.BaseWSDLEmitter;
import java.io.File;
import java.io.PrintWriter;
import java.util.List;
import java.util.Map;

public class WSDLGenerator
extends BaseWSDLEmitter {
    public WSDLGenerator(Map<String, String> options) {
        this.parseOptions(options);
    }

    @Override
    public void emitObjects(List<VmodlObject> objects) {
        this.commonSetup();
        if (this._wsdlServiceFilename == null) {
            if (this._xsdFilename != null) {
                this.generateSchema(this._xsdFilename, this._targetNSPrefix, this._targetNamespace);
            }
        } else if (this._wsdlInterfaceFilename == null) {
            if (this._xsdFilename == null) {
                this.generateServiceWSDL(this._wsdlServiceFilename, null, null, this._targetNSPrefix, this._targetNamespace);
            } else {
                this.generateServiceWSDL(this._wsdlServiceFilename, null, this._xsdFilename, this._targetNSPrefix, this._targetNamespace);
                this.generateSchema(this._xsdFilename, this._targetNSPrefix, this._targetNamespace);
            }
        } else if (this._xsdFilename == null) {
            this.generateServiceWSDL(this._wsdlServiceFilename, this._wsdlInterfaceFilename, null, this._targetNSPrefix, this._targetNamespace);
            this.generateInterfaceWSDL(this._wsdlInterfaceFilename, null, this._targetNSPrefix, this._targetNamespace);
        } else {
            this.generateServiceWSDL(this._wsdlServiceFilename, this._wsdlInterfaceFilename, this._xsdFilename, this._targetNSPrefix, this._targetNamespace);
            this.generateInterfaceWSDL(this._wsdlInterfaceFilename, this._xsdFilename, this._targetNSPrefix, this._targetNamespace);
            this.generateSchema(this._xsdFilename, this._targetNSPrefix, this._targetNamespace);
        }
    }

    private void generateServiceWSDL(String serviceWSDLFilename, String interfaceWSDLFilename, String schemaFilename, String targetNSPrefix, String targetNS) {
        this._indentationLevel = 0;
        PrintWriter out = Platform.createTextFile(new File(this._outputDirPath, serviceWSDLFilename));
        this.emitXMLDeclaration(out);
        this.emitCopyrightNotice(out);
        if (interfaceWSDLFilename == null) {
            this.emitDefinitionsStartTag(out, targetNSPrefix, targetNS, null, null, "http://schemas.xmlsoap.org/wsdl/", true, true, true, false);
            this.emitInterfaceSections(out, schemaFilename, targetNSPrefix, targetNS);
            this.emitServiceSection(out, targetNSPrefix);
        } else {
            this.emitDefinitionsStartTag(out, null, targetNS + "Service", "interface", targetNS, "http://schemas.xmlsoap.org/wsdl/", false, true, false, false);
            this.emitIndentedLine(out, "<import location=\"%s\" namespace=\"%s\" />", interfaceWSDLFilename, targetNS);
            this.emitServiceSection(out, "interface");
        }
        this.emitDefinitionsEndTag(out);
        out.close();
        if (this._indentationLevel != 0) {
            throw new IllegalStateException("non-zero indentation level");
        }
    }

    private void generateInterfaceWSDL(String interfaceWSDLFilename, String schemaFilename, String targetNSPrefix, String targetNS) {
        this._indentationLevel = 0;
        PrintWriter out = Platform.createTextFile(new File(this._outputDirPath, interfaceWSDLFilename));
        this.emitXMLDeclaration(out);
        this.emitCopyrightNotice(out);
        this.emitDefinitionsStartTag(out, targetNSPrefix, targetNS, null, null, "http://schemas.xmlsoap.org/wsdl/", true, true, true, false);
        this.emitInterfaceSections(out, schemaFilename, targetNSPrefix, targetNS);
        this.emitDefinitionsEndTag(out);
        out.close();
        if (this._indentationLevel != 0) {
            throw new IllegalStateException("non-zero indentation level");
        }
    }

    private void generateSchema(String schemaFilename, String targetNSPrefix, String targetNS) {
        this._indentationLevel = 0;
        PrintWriter out = Platform.createTextFile(new File(this._outputDirPath, schemaFilename));
        this.emitXMLDeclaration(out);
        this.emitCopyrightNotice(out);
        this.emitTargetSchema(out, targetNSPrefix, targetNS);
        out.close();
        if (this._indentationLevel != 0) {
            throw new IllegalStateException("non-zero indentation level");
        }
    }

    @Override
    void emitTargetSchema(PrintWriter out, String targetNSPrefix, String targetNS) {
        this.emitIndentedLine(out, "<schema", new Object[0]);
        this.indent();
        this.emitIndentedLine(out, "targetNamespace=\"%s\"", targetNS);
        this.emitIndentedLine(out, "xmlns=\"http://www.w3.org/2001/XMLSchema\"", new Object[0]);
        this.emitIndentedLine(out, "xmlns:mime=\"http://schemas.xmlsoap.org/wsdl/mime/\"", new Object[0]);
        this.emitIndentedLine(out, "xmlns:soap=\"http://schemas.xmlsoap.org/wsdl/soap/\"", new Object[0]);
        this.emitIndentedLine(out, "xmlns:wsdl=\"http://schemas.xmlsoap.org/wsdl/\"", new Object[0]);
        this.emitIndentedLine(out, "xmlns:%s=\"%s\"", targetNSPrefix, targetNS);
        this.emitIndentedLine(out, "xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\"", new Object[0]);
        this.emitIndentedLine(out, "elementFormDefault=\"qualified\"", new Object[0]);
        this.unindent();
        this.emitIndentedLine(out, ">", new Object[0]);
        this.indent();
        if (this._importAutoPrepTypes) {
            this.emitIndentedLine(out, "<import namespace=\"urn:sysimage-vmware-com:autoprep1\"", " %sschemaLocation=\"autoprep-types.xsd\" />");
        }
        this.generateTypes(out, out, out, null, targetNSPrefix);
        this.emitCoreArrayPrimitives(out, targetNSPrefix);
        this.unindent();
        this.emitIndentedLine(out, "</schema>", new Object[0]);
    }

    @Override
    String schemaId(VmodlObject obj) {
        return this._targetNSPrefix;
    }

    @Override
    boolean shouldGenerateFor(VmodlObject obj, String service2) {
        return this.shouldGenerateFor(obj);
    }

    @Override
    String schemaArrayPrefix() {
        return this._targetNSPrefix;
    }

    @Override
    boolean shouldGenerateMo(ManagedObject mo) {
        return this.shouldGenerateFor(mo);
    }
}

