/*
 * Decompiled with CFR 0.152.
 */
package emitters.wsdl;

import dochandling.JavadocProcessor;
import dochandling.LinkParser;
import dochandling.MethodComment;
import dochandling.PropertyComment;
import dochandling.StandardProcessor;
import dochandling.TypeComment;
import emitters.ObjectRegistry;
import emitters.Services;
import emitters.Utils;
import emitters.Versions;
import emitters.backend.Platform;
import emitters.core.Options;
import emitters.model.DataObject;
import emitters.model.Enum;
import emitters.model.Locatable;
import emitters.model.ManagedObject;
import emitters.model.Method;
import emitters.model.Parameter;
import emitters.model.Property;
import emitters.model.SourcePos;
import emitters.model.Version;
import emitters.model.VmodlApi;
import emitters.model.VmodlDecl;
import emitters.model.VmodlObject;
import emitters.wsdl.BaseXMLGenerator;
import java.io.File;
import java.io.FileInputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import vmodl.Any;
import vmodl.Binary;
import vmodl.DateTime;
import vmodl.MethodName;
import vmodl.PropertyPath;
import vmodl.TypeName;
import vmodl.URI;

public class XMLGenerator
extends BaseXMLGenerator {
    private String _xmlFilename = null;
    private String _xmlReportFilename = null;
    private PrintWriter _xmlWriter = null;
    private PrintWriter _xmlReport = null;
    private Properties _docTemplates = new Properties();
    private Set<String> _commonFaults = new HashSet<String>();
    private Map<String, List<String>> _undocumented = new HashMap<String, List<String>>();
    private String _namespace = null;
    private boolean _emitDescriptions = true;
    private boolean _emitFaultsFromComments = true;
    private boolean _emitEvents = true;
    private boolean _emitPrivileges = true;
    private boolean _emitIsDeprecated = true;
    private boolean _emitIsLocalizable = true;
    private boolean _emitVersionTypes = true;
    private boolean _emitVersionIdRefs = true;
    private Map<String, VmodlObject> _vmodlRuntimeFaults;
    private Set<DataObject> _dataObjects = new HashSet<DataObject>();
    private Set<ManagedObject> _managedObjects = new HashSet<ManagedObject>();
    private Set<Enum> _enums = new HashSet<Enum>();
    private Map<String, String> _knownTypes;
    private Set<String> _wsdlNames;
    private Set<String> _vmodlNames;
    private static final String ERROR_EXPLANATION = "<html><body><h3>What do the errors mean?</h3><dl><dt>Possible use of vmodl name</dt><dd>In description text a word matched a VMODL name or had a '.' in it.</dd><dt>Possible un-linked wsdl name</dt><dd>In description text a word matched a WSDL name and was not a link.</dd><dt>Item: &lt;package.ClassName&gt; is undocumented</dt><dd>There is no general description for a type</dd><dt>Enum value: &lt;package.EnumName.value&gt; is undocumented</dt><dd>An enum value is not documented</dd><dt>Property: &lt;package.ClassName..property&gt; is undocumented</dt><dd>A property is undocumented</dd><dt>&lt;package.ClassName.method()&gt; @task is undocumented</dt><dd>The method returns a Task and the details about the task are not documented.</dd><dt>Method: &lt;package.ClassName.method()&gt;, Parameter &lt;parameterName&gt; is undocumented</dt><dd>A parameter of the method is not documented</dd><dt>&lt;package.ClassName.method()&gt; return is undocumented</dt><dd>The return value for the method is not documented</dd><dt>&lt;package.ClassName.method()&gt;, Fault: &lt;package.ClassName&gt; is undocumented</dt><dd>A fault that the method throws is not documented</dd><dt>&lt;package.ClassName&gt; Link (@see): &lt;SomeText&gt; not found</dt><dd>A @see link is broken</dd><dt>&lt;package.ClassName&gt; Link {@link}: &lt;SomeText&gt; not found</dt><dd>A @link is broken</dd><dt>Possible unused javadoc tag: '@see'</dt><dd>The text '@see' is output instead of a link</dd><dt>Possible unused javadoc tag: '@link'</dt><dd>The text '@link' is output instead of a link</dd><dt>&lt;package.ClassName.method()&gt;, unused exception \"&lt;ExceptionName&gt;\" documentation</dt><dd>This could mean four things:<br/><ul><li>\"&lt;ExceptionName&gt;\" is NOT derived from an exception declared on the method</li><li>\"&lt;ExceptionName&gt;\" is listed twice and the descriptions need to be combined</li><li>\"&lt;ExceptionName&gt;\" is a base class of an exception declared on the method</li><li>\"&lt;ExceptionName&gt;\" is not a valid type</li></ul></dd></dl>";
    private static final String BUILT_INS = "  <built-ins>\n<built-in name=\"void\" vmodl-name=\"void\" type-id=\"void\" />\n<built-in name=\"xsd:boolean\" vmodl-name=\"BOOLEAN\" type-id=\"BOOLEAN\" />\n<built-in name=\"xsd:byte\" vmodl-name=\"BYTE\" type-id=\"BYTE\" />\n<built-in name=\"xsd:int\" vmodl-name=\"INT\" type-id=\"INT\" />\n<built-in name=\"xsd:long\" vmodl-name=\"LONG\" type-id=\"LONG\" />\n<built-in name=\"xsd:short\" vmodl-name=\"SHORT\" type-id=\"SHORT\" />\n<built-in name=\"xsd:double\" vmodl-name=\"DOUBLE\" type-id=\"DOUBLE\" />\n<built-in name=\"xsd:float\" vmodl-name=\"FLOAT\" type-id=\"FLOAT\" />\n<built-in name=\"xsd:string\" vmodl-name=\"java.lang.String\" type-id=\"java.lang.String\" />\n<built-in name=\"xsd:anyType\" vmodl-name=\"vmodl.Any\" type-id=\"vmodl.Any\" />\n<built-in name=\"xsd:string\" vmodl-name=\"vmodl.TypeName\" type-id=\"vmodl.TypeName\" />\n<built-in name=\"xsd:dateTime\" vmodl-name=\"vmodl.DateTime\" type-id=\"vmodl.DateTime\" />\n<built-in name=\"xsd:string\" vmodl-name=\"vmodl.PropertyPath\" type-id=\"vmodl.PropertyPath\" />\n<built-in name=\"xsd:string\" vmodl-name=\"vmodl.MethodName\" type-id=\"vmodl.MethodName\" />\n<built-in name=\"tns:ManagedObjectReference\" vmodl-name=\"vmodl.ManagedObject\" type-id=\"vmodl.ManagedObject\" />\n<built-in name=\"xsd:anyURI\" vmodl-name=\"vmodl.URI\" type-id=\"vmodl.URI\" />\n<built-in name=\"xsd:base64Binary\" vmodl-name=\"vmodl.Binary\" type-id=\"vmodl.Binary\" />\n</built-ins>\n";
    private static final JavadocProcessor _docProcessor = new StandardProcessor();

    public XMLGenerator(Map<String, String> options) {
        for (Map.Entry<String, String> entry : options.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            if (key.isEmpty()) {
                this._xmlFilename = value;
                continue;
            }
            if (key.equals("output.dir")) {
                this._outputDirPath = value;
                continue;
            }
            if (key.equals("unstable.dir")) {
                this._changingDirPath = value;
                continue;
            }
            if (key.equals("namespace")) {
                this._namespace = value;
                continue;
            }
            if (key.equals("report")) {
                this._xmlReportFilename = value;
                continue;
            }
            if (key.equals("hide.descriptions")) {
                this._emitDescriptions = !Boolean.parseBoolean(value);
                continue;
            }
            if (key.equals("hide.faults.from.comments")) {
                this._emitFaultsFromComments = !Boolean.parseBoolean(value);
                continue;
            }
            if (key.equals("hide.events")) {
                this._emitEvents = !Boolean.parseBoolean(value);
                continue;
            }
            if (key.equals("hide.is.deprecated")) {
                this._emitIsDeprecated = !Boolean.parseBoolean(value);
                continue;
            }
            if (key.equals("hide.is.localizable")) {
                this._emitIsLocalizable = !Boolean.parseBoolean(value);
                continue;
            }
            if (key.equals("hide.privileges")) {
                this._emitPrivileges = !Boolean.parseBoolean(value);
                continue;
            }
            if (key.equals("hide.version.types")) {
                this._emitVersionTypes = !Boolean.parseBoolean(value);
                continue;
            }
            if (key.equals("show.undocumented.features")) {
                this.setHideUndocumentedDecls(!Boolean.parseBoolean(value));
                continue;
            }
            if (key.equals("show.internal.decls")) {
                this.setHideInternalDecls(!Boolean.parseBoolean(value));
                continue;
            }
            if (key.equals("emit.version.id.refs")) {
                this._emitVersionIdRefs = Boolean.parseBoolean(value);
                continue;
            }
            if (!key.equals("doc.templates")) continue;
            try {
                FileInputStream fis = new FileInputStream(value);
                this._docTemplates.loadFromXML(fis);
            }
            catch (Exception x) {
                throw new BaseXMLGenerator.InvalidOptionValueException("doc.templates", value);
            }
        }
        if (this._xmlFilename == null) {
            Platform.printError("XML filename is not specified");
            throw new BaseXMLGenerator.MissingRequiredOptionException("xml");
        }
        this._knownTypes = new HashMap<String, String>();
        this._wsdlNames = new HashSet<String>();
        this._vmodlNames = new HashSet<String>();
        this._vmodlRuntimeFaults = new HashMap<String, VmodlObject>();
    }

    @Override
    void fillPrimitiveTypeMap() {
        EnumMap<VmodlDecl.TypeId, String> vmodlPrimitiveTypeMap = new EnumMap<VmodlDecl.TypeId, String>(VmodlDecl.TypeId.class);
        block11: for (VmodlDecl.TypeId type : VmodlDecl.TypeId.values()) {
            switch (type) {
                case STRING: {
                    vmodlPrimitiveTypeMap.put(type, String.class.getName());
                    continue block11;
                }
                case METHODNAME: {
                    vmodlPrimitiveTypeMap.put(type, MethodName.class.getName());
                    continue block11;
                }
                case PROPPATH: {
                    vmodlPrimitiveTypeMap.put(type, PropertyPath.class.getName());
                    continue block11;
                }
                case TYPENAME: {
                    vmodlPrimitiveTypeMap.put(type, TypeName.class.getName());
                    continue block11;
                }
                case DATETIME: {
                    vmodlPrimitiveTypeMap.put(type, DateTime.class.getName());
                    continue block11;
                }
                case ANY: {
                    vmodlPrimitiveTypeMap.put(type, Any.class.getName());
                    continue block11;
                }
                case MANAGED: {
                    vmodlPrimitiveTypeMap.put(type, vmodl.ManagedObject.class.getName());
                    continue block11;
                }
                case BINARY: {
                    vmodlPrimitiveTypeMap.put(type, Binary.class.getName());
                    continue block11;
                }
                case URI: {
                    vmodlPrimitiveTypeMap.put(type, URI.class.getName());
                    continue block11;
                }
                default: {
                    vmodlPrimitiveTypeMap.put(type, type.toString());
                }
            }
        }
        _vmodlDeclTypeMap = Collections.unmodifiableMap(vmodlPrimitiveTypeMap);
    }

    void partitionObjects(Collection<VmodlObject> objs) {
        for (VmodlObject obj : objs) {
            this._knownTypes.put(obj.getQualifiedVmodlType(), obj.getWsdlName());
            this._wsdlNames.add(obj.getWsdlName());
            this._vmodlNames.add(obj.getQualifiedVmodlType());
            switch (obj.getKind()) {
                case ManagedObject: {
                    this._managedObjects.add((ManagedObject)obj);
                    break;
                }
                case DataObject: {
                    this._dataObjects.add((DataObject)obj);
                    break;
                }
                case Enum: {
                    this._enums.add((Enum)obj);
                }
            }
            if (obj.getNestedList().size() == 0) continue;
            this.partitionObjects(obj.getNestedList());
        }
    }

    private void collectRuntimeFaults() {
        block0: for (VmodlObject obj : this._vmodlObjects) {
            if (!this.shouldGenerateFor(obj) || !obj.isFault()) continue;
            VmodlObject it = obj;
            do {
                if (!it.getQualifiedVmodlType().equals(Utils.RuntimeFaultClassName)) continue;
                int lastDot = it.getQualifiedVmodlType().lastIndexOf(46);
                if (lastDot < 0) {
                    throw new RuntimeException("Object name " + it.getQualifiedVmodlType() + " is not qualified");
                }
                String key = it.getQualifiedVmodlType().substring(lastDot + 1);
                this._vmodlRuntimeFaults.put(key, obj);
                continue block0;
            } while ((it = it.getBaseObject()) != null);
        }
    }

    @Override
    public void emitObjects(List<VmodlObject> objects) {
        this._vmodlObjects = objects;
        this.collectRuntimeFaults();
        this.collectSynthesizedArrayTypes();
        this.partitionObjects(this._vmodlObjects);
        this.generateXml(this._xmlFilename, this._namespace);
    }

    private void generateXml(String schemaFilename, String namespace) {
        this._indentationLevel = 0;
        this._xmlWriter = Platform.createTextFile(new File(this._outputDirPath, schemaFilename));
        this.emitXMLDeclaration();
        this.emitXMLDocument(namespace);
        this._xmlWriter.close();
        if (this._xmlReportFilename != null) {
            this._xmlReport = Platform.createTextFile(new File(this._outputDirPath, this._xmlReportFilename));
        }
        if (this._xmlReport != null) {
            XMLGenerator.emitString(this._xmlReport, ERROR_EXPLANATION);
            for (String key : this._undocumented.keySet()) {
                for (String line : this._undocumented.get(key)) {
                    XMLGenerator.emitString(this._xmlReport, line);
                    XMLGenerator.emitNewline(this._xmlReport);
                }
            }
            XMLGenerator.emitString(this._xmlReport, "</body></html>");
            this._xmlReport.close();
        }
        if (this._indentationLevel != 0) {
            throw new IllegalStateException("non-zero indentation level");
        }
    }

    private void reportUndocumented(String filename, String item, Object ... args) {
        if (this._xmlReport != null) {
            List<String> lines = this._undocumented.get(filename);
            if (lines == null) {
                lines = new ArrayList<String>();
                this._undocumented.put(filename, lines);
            }
            lines.add(String.format(item, args));
        }
    }

    private void checkFinalDoc(String fName, String header, String docText) {
        String[] words = docText.split("\\s");
        ArrayList<String> out = new ArrayList<String>();
        boolean headerOutput = false;
        boolean vmodlOutput = false;
        boolean javadocOutput = false;
        boolean wsdlOutput = false;
        for (String word : words) {
            int dotIndex = word.indexOf(46);
            int hrefIndex = word.indexOf("href");
            if (!vmodlOutput && hrefIndex == -1 && (dotIndex != -1 && dotIndex != word.length() - 1 || this._vmodlNames.contains(word))) {
                if (!headerOutput) {
                    out.add(header);
                    headerOutput = true;
                }
                out.add("----Possible use of vmodl name: '" + word + "'<br/>");
                vmodlOutput = true;
            }
            if (!javadocOutput && word.indexOf(64) != -1) {
                if (!headerOutput) {
                    out.add(header);
                    headerOutput = true;
                }
                out.add("----Possible unused javadoc tag: '" + word + "'<br/>");
                javadocOutput = true;
            }
            if (wsdlOutput || !this._wsdlNames.contains(word)) continue;
            if (!headerOutput) {
                out.add(header);
                headerOutput = true;
            }
            out.add("----Possible un-linked wsdl name: '" + word + "'<br/>");
            wsdlOutput = true;
        }
        if (out.size() > 0) {
            StringBuilder sb = new StringBuilder();
            for (String s : out) {
                sb.append(s).append("\n");
            }
            this.reportUndocumented(fName, sb.toString(), new Object[0]);
        }
    }

    private void emitXMLDeclaration() {
        this.emitIndentedLine(this._xmlWriter, "<?xml version=\"1.0\" encoding=\"UTF-8\" ?>", new Object[0]);
    }

    private void emitXMLDocument(String namespace) {
        this.emitIndentedLine(this._xmlWriter, "<definitions", new Object[0]);
        this.indent();
        if (namespace != null) {
            this.emitIndentedLine(this._xmlWriter, "xmlns=\"%s\"", namespace);
        }
        this.emitIndentedLine(this._xmlWriter, "xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"", new Object[0]);
        this.unindent();
        this.emitIndentedLine(this._xmlWriter, ">", new Object[0]);
        this.indent();
        if (Options.taskTypeName != null) {
            this.emitIndentedLine(this._xmlWriter, "<task-return-type type-id-ref=\"" + Options.taskTypeName + "\"/>", new Object[0]);
        }
        this.emitTemplates();
        this.emitVersions();
        this.emitBuiltins();
        this.emitNeededArrays();
        this.emitEnums();
        this.emitFaults();
        this.emitDataObjects();
        this.emitManagedObjects();
        this.unindent();
        this.emitIndentedLine(this._xmlWriter, "</definitions>", new Object[0]);
    }

    private void emitTemplates() {
        String fType;
        this.emitIndentedLine(this._xmlWriter, "<doc-templates>", new Object[0]);
        this.indent();
        int fNum = 0;
        while ((fType = this._docTemplates.getProperty("commonFaultType" + ++fNum)) != null && fType.length() != 0) {
            if (ObjectRegistry.getObject(fType) == null) {
                throw new IllegalStateException("Unknown common fault type: " + fType);
            }
            this._commonFaults.add(fType);
            this.emitIndentedLine(this._xmlWriter, "<common-fault ", new Object[0]);
            this.emitAttributeLine("type-id-ref", fType);
            this.emitIndentedLine(this._xmlWriter, ">", new Object[0]);
            this.indent();
            LinkParser lp = new LinkParser(this._docTemplates.getProperty(fType));
            SourcePos si = new SourcePos();
            String linkedFrom = "doc-template";
            this.processLinks(lp, si, null, linkedFrom);
            String docs = lp.getFinalDocumentation();
            this.emitDescriptionHtml("fault-description-html", docs);
            this.unindent();
            this.emitIndentedLine(this._xmlWriter, "</common-fault>", new Object[0]);
        }
        this.unindent();
        this.emitIndentedLine(this._xmlWriter, "</doc-templates>", new Object[0]);
    }

    private void emitVersions() {
        if (this._emitVersionTypes) {
            this.emitIndentedLine(this._xmlWriter, "<version-types>", new Object[0]);
            this.indent();
            for (Version version : Versions.getVersions()) {
                String displayName2;
                String qName = version.getVmodlName();
                String name = version.getWireNs();
                if ("".equals(name)) {
                    name = qName;
                }
                this.emitBaseInfo("version-type", name);
                this.indent();
                this.emitAttributeLine("type-id", qName);
                this.emitAttributeLine("vmodl-name", qName);
                String wireId = version.getWireId();
                if (wireId != null) {
                    this.emitAttributeLine("version-id", wireId);
                }
                if ((displayName2 = version.getDisplayName()) != null) {
                    this.emitAttributeLine("display-name", displayName2);
                }
                this.emitAttributeLine("service-namespace", Services.schemaNamespaceId(version));
                this.unindent();
                this.emitIndentedLine(this._xmlWriter, ">", new Object[0]);
                this.indent();
                Set<Version> parentSet = Versions.getSortedDirectParents(version);
                if (parentSet != null) {
                    for (Version parent : parentSet) {
                        this.emitIndentedLine(this._xmlWriter, "<compatible-version-id>%s</compatible-version-id>", parent.getVmodlName());
                    }
                }
                this.unindent();
                this.emitIndentedLine(this._xmlWriter, "</version-type>", new Object[0]);
            }
            this.unindent();
            this.emitIndentedLine(this._xmlWriter, "</version-types>", new Object[0]);
        }
    }

    private void emitBaseInfo(String tag, String name) {
        this.emitIndentedLine(this._xmlWriter, "<" + tag + " name=\"" + name + "\"", new Object[0]);
    }

    private void emitAttributeLine(String key, String value) {
        this.emitIndentedLine(this._xmlWriter, key + "=\"" + value + "\"", new Object[0]);
    }

    private void emitDescriptionHtml(String tagText, String descHtml) {
        if (this._emitDescriptions && descHtml != null && descHtml.length() > 0) {
            this.emitIndentedLine(this._xmlWriter, "<%s>", tagText);
            this.indent();
            this.emitIndentedLine(this._xmlWriter, "<![CDATA[%s]]>", descHtml);
            this.unindent();
            this.emitIndentedLine(this._xmlWriter, "</%s>", tagText);
        }
    }

    private void emitProperties(VmodlObject obj) {
        for (Property prop : obj.getPropertyList()) {
            if (!this.shouldGenerateFor(obj, prop) || prop.getWsdlName().equals("dynamicProperty")) continue;
            this.emitPropertyElementDecl(obj, prop);
        }
        if (obj.getQualifiedVmodlType().equals("vim.Network")) {
            for (Property prop : obj.getPropertyListWithOverrides()) {
                if (!prop.getName().equals("name")) continue;
                this.emitPropertyElementDecl(obj, prop);
                break;
            }
        }
    }

    private void emitMethods(ManagedObject mobj) {
        for (Method method : mobj.getMethodList()) {
            Version internalBeforeVersion;
            Version classVersion;
            if (!this.shouldGenerateFor((VmodlObject)mobj, method)) continue;
            String name = XMLGenerator.getNonTaskWsdlName(method.getWsdlName());
            VmodlDecl returnDecl = method.getReturnDecl();
            String returnTypeSchemaName = returnDecl.getObject() == null ? this.schemaTypeReference(returnDecl.getObject(), returnDecl) : returnDecl.getObject().getQualifiedVmodlType();
            this.emitIndentedLine(this._xmlWriter, "<method name=\"%s\"", name);
            this.indent();
            this.emitAttributeLine("vmodl-name", method.getName());
            Version methodVersion = method.getVersion();
            if (methodVersion != null && methodVersion != (classVersion = mobj.getVersion()) && this._emitVersionIdRefs) {
                this.emitAttributeLine("version-id-ref", methodVersion.getVmodlName());
            }
            if ((internalBeforeVersion = method.getInternalBefore()) != null && this._emitVersionIdRefs) {
                this.emitAttributeLine("internal-before-version-id-ref", internalBeforeVersion.getVmodlName());
            }
            if (this._emitIsDeprecated && method.isDeprecated()) {
                this.emitAttributeLine("is-deprecated", "true");
            }
            this.emitBaseAttributes(returnDecl, method.getPrivilegeId());
            if (returnDecl.getTypeId().equals((Object)VmodlDecl.TypeId.VOID)) {
                this.emitAttributeLine("type-id-ref", "void");
            } else {
                this.emitAttributeLine("type-id-ref", returnTypeSchemaName);
            }
            if (method.isTask()) {
                this.emitAttributeLine("is-task", "true");
            }
            this.emitIndentedLine(this._xmlWriter, ">", new Object[0]);
            MethodComment mComment = new MethodComment();
            _docProcessor.processMethodComment(method.getComment(), mComment);
            LinkParser lp = new LinkParser(mComment.getHtml());
            SourcePos si = Platform.getSourcePos(mobj, method);
            String linkedFrom = String.format("%s.%s()", mobj.getQualifiedVmodlType(), method.getName());
            this.processLinks(lp, si, mobj, linkedFrom);
            String docs = lp.getFinalDocumentation();
            docs = docs + this.processSeeAlsos(mComment.getSeeAlsos(), si, mobj, linkedFrom);
            if (docs == null || docs.length() == 0) {
                this.reportUndocumented(si.fileName, "Method: %s.%s() is undocumented <a href=\"file:///%s\">Open %s(%d,%d)</a><br/>", mobj.getQualifiedVmodlType(), method.getName(), si.absoluteName, si.fileName, si.line, si.column);
            } else {
                this.checkFinalDoc(si.fileName, String.format("Method: %s.%s() <a href=\"file:///%s\">Open %s(%d,%d)</a><br/>", mobj.getQualifiedVmodlType(), method.getName(), si.absoluteName, si.fileName, si.line, si.column), docs);
            }
            this.emitDescriptionHtml("description-html", docs);
            String deprecated = this.processDeprecated(mComment.getDeprecated(), si, method);
            lp = new LinkParser(deprecated);
            this.processLinks(lp, si, mobj, linkedFrom);
            this.emitDescriptionHtml("deprecated-html", lp.getFinalDocumentation());
            if (this._emitPrivileges && method.getSubclassPrivileges() != null) {
                for (Map.Entry entry : method.getSubclassPrivileges().entrySet()) {
                    this.emitIndentedLine(this._xmlWriter, "<sub-privilege target-type-id-ref=\"%s\" privilege=\"%s\"/>", entry.getKey(), entry.getValue());
                }
            }
            for (Parameter parameter : method.getParameterList()) {
                if (!this.shouldGenerateFor(parameter)) continue;
                this.emitParameterDecl(mobj, method, mComment, parameter);
            }
            for (JavadocProcessor.Pair pair : mComment.getUnusedParameters()) {
                this.reportUndocumented(si.fileName, "%s.%s(), unused parameter \"%s\" documentation: <a href=\"file:///%s\">Open %s(%d,%d)</a><br/>", mobj.getQualifiedVmodlType(), method.getName(), pair.first, si.absoluteName, si.fileName, si.line, si.column);
            }
            for (DataObject dataObject : method.getFaultList()) {
                String string = dataObject.getQualifiedVmodlType();
                if (this._commonFaults.contains(string)) continue;
                this.emitMethodFault(mobj, method, mComment, string);
            }
            if (this._emitFaultsFromComments) {
                ArrayList<JavadocProcessor.Pair<String, String>> tList = new ArrayList<JavadocProcessor.Pair<String, String>>(mComment.getUnusedExceptions());
                for (JavadocProcessor.Pair pair : tList) {
                    boolean found;
                    VmodlObject runtimeFault = this._vmodlRuntimeFaults.get(pair.first);
                    if (runtimeFault != null) {
                        String qName = runtimeFault.getQualifiedVmodlType();
                        if (this._commonFaults.contains(qName)) continue;
                        this.emitMethodFault(mobj, method, mComment, qName);
                        continue;
                    }
                    DataObject fault = this.lookupFaultShortName((String)pair.first);
                    boolean bl = found = fault == null;
                    if (fault != null) {
                        for (DataObject parent : method.getFaultList()) {
                            for (VmodlObject it = fault.getBaseObject(); it != null; it = it.getBaseObject()) {
                                if (it != parent) continue;
                                String qName = fault.getQualifiedVmodlType();
                                this.emitMethodFault(mobj, method, mComment, qName);
                                found = true;
                            }
                            if (!found) continue;
                            break;
                        }
                    }
                    if (found) continue;
                    this.reportUndocumented(si.fileName, "%s.%s(), unused exception \"%s\" documentation: <a href=\"file:///%s\">Open %s(%d,%d)</a><br/>", mobj.getQualifiedVmodlType(), method.getName(), pair.first, si.absoluteName, si.fileName, si.line, si.column);
                }
            }
            this.emitEventsForMethod(method);
            lp = new LinkParser(mComment.getReturnHtml());
            linkedFrom = String.format("%s.%s()", mobj.getQualifiedVmodlType(), method.getName());
            this.processLinks(lp, si, mobj, linkedFrom);
            docs = lp.getFinalDocumentation();
            if (!(returnDecl.getTypeId().equals((Object)VmodlDecl.TypeId.VOID) || docs != null && docs.length() != 0)) {
                this.reportUndocumented(si.fileName, "%s.%s() return is undocumented <a href=\"file:///%s\">Open %s(%d,%d)</a><br/>", mobj.getQualifiedVmodlType(), method.getName(), si.absoluteName, si.fileName, si.line, si.column);
            }
            this.emitDescriptionHtml("return-value-description-html", docs);
            if (method.isTask()) {
                lp = new LinkParser(mComment.getTaskHtml());
                linkedFrom = String.format("%s.%s()", mobj.getQualifiedVmodlType(), method.getName());
                this.processLinks(lp, si, mobj, linkedFrom);
                docs = lp.getFinalDocumentation();
                if (docs == null || docs.length() == 0) {
                    this.reportUndocumented(si.fileName, "%s.%s() @task is undocumented <a href=\"file:///%s\">Open %s(%d,%d)</a><br/>", mobj.getQualifiedVmodlType(), method.getName(), si.absoluteName, si.fileName, si.line, si.column);
                }
                this.emitDescriptionHtml("task-description-html", docs);
            }
            this.unindent();
            this.emitIndentedLine(this._xmlWriter, "</method>", new Object[0]);
        }
    }

    private DataObject lookupFaultShortName(String first) {
        for (DataObject obj : this._dataObjects) {
            if (!obj.isFault() || !this.shouldGenerateFor(obj) || !obj.getName().equals(first)) continue;
            return obj;
        }
        return null;
    }

    private void emitEventsForMethod(Method method) {
        if (this._emitEvents && method.getEvents() != null) {
            for (String event2 : method.getEvents()) {
                this.emitIndentedLine(this._xmlWriter, "<event event-id=\"%s\"/>", event2);
            }
        }
    }

    private void emitMethodFault(ManagedObject mobj, Method method, MethodComment mComment, String qName) {
        this.emitIndentedLine(this._xmlWriter, "<fault type-id-ref=\"%s\">", qName);
        LinkParser lp = new LinkParser(mComment.getExceptionDoc(qName));
        SourcePos si = Platform.getSourcePos(mobj, method);
        String linkedFrom = String.format("%s.%s()", mobj.getQualifiedVmodlType(), method.getName());
        this.processLinks(lp, si, mobj, linkedFrom);
        String docs = lp.getFinalDocumentation();
        docs = docs + this.processSeeAlsos(mComment.getSeeAlsos(), si, mobj, linkedFrom);
        if (docs == null || docs.isEmpty()) {
            this.reportUndocumented(si.fileName, "%s.%s(), Fault: %s is undocumented <a href=\"file:///%s\">%s(%d,%d)</a><br/>", mobj.getQualifiedVmodlType(), method.getName(), qName, si.absoluteName, si.fileName, si.line, si.column);
        } else {
            this.checkFinalDoc(si.fileName, String.format("%s.%s(), Fault: %s <a href=\"file:///%s\">%s(%d,%d)</a><br/>", mobj.getQualifiedVmodlType(), method.getName(), qName, si.absoluteName, si.fileName, si.line, si.column), docs);
        }
        this.emitDescriptionHtml("fault-description-html", docs);
        this.emitIndentedLine(this._xmlWriter, "</fault>", new Object[0]);
    }

    private void emitBaseAttributes(VmodlDecl decl, String privilege2) {
        if (decl.isArray()) {
            this.emitAttributeLine("is-array", "true");
        }
        if (decl.isOptional()) {
            this.emitAttributeLine("is-optional", "true");
        }
        if (decl.isLink()) {
            this.emitAttributeLine("is-link", "true");
        }
        if (decl.isLinkable()) {
            this.emitAttributeLine("is-linkable", "true");
        }
        if (this._emitIsLocalizable && decl.isLocalizable()) {
            this.emitAttributeLine("is-localizable", "true");
        }
        if (this._emitPrivileges && privilege2 != null) {
            this.emitAttributeLine("privilege", privilege2);
        }
    }

    private void emitParameterDecl(ManagedObject mobj, Method method, MethodComment mc, Parameter param) {
        VmodlObject paramObj = param.getDecl().getObject();
        String schemaName = paramObj == null ? this.schemaTypeReference(paramObj, param.getDecl()) : paramObj.getQualifiedVmodlType();
        this.emitIndentedLine(this._xmlWriter, "<parameter name=\"%s\" type-id-ref=\"%s\"", param.getName(), schemaName);
        this.emitAttributeLine("vmodl-name", param.getName());
        Version version = method.getVersion();
        if (version != null && this._emitVersionIdRefs) {
            this.emitAttributeLine("version-id-ref", version.getVmodlName());
        }
        this.emitBaseAttributes(param.getDecl(), param.getName());
        this.emitIndentedLine(this._xmlWriter, ">", new Object[0]);
        LinkParser lp = new LinkParser(mc.getParameterDoc(param.getName()));
        SourcePos si = Platform.getSourcePos(mobj, method);
        String linkedFrom = String.format("%s.%s()", mobj.getQualifiedVmodlType(), method.getName());
        this.processLinks(lp, si, mobj, linkedFrom);
        String docs = lp.getFinalDocumentation();
        docs = docs + this.processSeeAlsos(mc.getSeeAlsos(), si, mobj, linkedFrom);
        if (docs == null || docs.isEmpty()) {
            this.reportUndocumented(si.fileName, "Method: %s.%s(), Parameter %s is undocumented <a href=\"file:///%s\">Open %s(%d,%d)</a><br/>", mobj.getQualifiedVmodlType(), method.getName(), param.getName(), si.absoluteName, si.fileName, si.line, si.column);
        } else {
            this.checkFinalDoc(si.fileName, String.format("Method: %s.%s(), Parameter %s <a href=\"file:///%s\">Open %s(%d,%d)</a><br/>", mobj.getQualifiedVmodlType(), method.getName(), param.getName(), si.absoluteName, si.fileName, si.line, si.column), docs);
        }
        this.emitDescriptionHtml("description-html", docs);
        this.emitIndentedLine(this._xmlWriter, "</parameter>", new Object[0]);
    }

    private void emitPropertyElementDecl(VmodlObject obj, Property prop) {
        Version internalBeforeVersion;
        Version classVersion;
        this.emitIndentation(this._xmlWriter);
        VmodlObject propObj = prop.getDecl().getObject();
        String schemaName = propObj == null ? this.schemaTypeReference(propObj, prop.getDecl()) : propObj.getQualifiedVmodlType();
        if (propObj != null && propObj.getKind().equals((Object)VmodlObject.Kind.DataObject)) {
            if (propObj.isFault()) {
                if (propObj.getQualifiedVmodlType().equals(Utils.MethodFaultClassName)) {
                    if (obj.getQualifiedVmodlType().equals("vmodl.LocalizedMethodFault")) {
                        this.emitIndentedLine(this._xmlWriter, "<property name=\"%s\" type-id-ref=\"%s\"", prop.getName(), Utils.MethodFaultClassName);
                    } else {
                        this.emitIndentedLine(this._xmlWriter, "<property name=\"%s\" type-id-ref=\"%s\"", prop.getName(), "vmodl.LocalizedMethodFault");
                    }
                }
            } else {
                this.emitIndentedLine(this._xmlWriter, "<property name=\"%s\" type-id-ref=\"%s\"", prop.getName(), schemaName);
            }
        } else {
            this.emitIndentedLine(this._xmlWriter, "<property name=\"%s\" type-id-ref=\"%s\"", prop.getName(), schemaName);
        }
        this.emitAttributeLine("vmodl-name", prop.getName());
        Version memberVersion = prop.getVersion();
        if (memberVersion != null && memberVersion != (classVersion = obj.getVersion()) && this._emitVersionIdRefs) {
            this.emitAttributeLine("version-id-ref", memberVersion.getVmodlName());
        }
        if ((internalBeforeVersion = prop.getInternalBefore()) != null && this._emitVersionIdRefs) {
            this.emitAttributeLine("internal-before-version-id-ref", internalBeforeVersion.getVmodlName());
        }
        if (this._emitIsDeprecated && prop.getDecl().isDeprecated()) {
            this.emitAttributeLine("is-deprecated", "true");
        }
        this.emitBaseAttributes(prop.getDecl(), prop.getPrivilegeId());
        this.emitIndentedLine(this._xmlWriter, ">", new Object[0]);
        PropertyComment pComment = new PropertyComment();
        _docProcessor.processPropertyComment(prop.getComment(), pComment);
        LinkParser lp = new LinkParser(pComment.getHtml());
        SourcePos si = Platform.getSourcePos(obj, prop);
        String linkedFrom = String.format("%s.%s", obj.getQualifiedVmodlType(), prop.getName());
        this.processLinks(lp, si, obj, linkedFrom);
        String docs = lp.getFinalDocumentation();
        docs = docs + this.processSeeAlsos(pComment.getSeeAlsos(), si, obj, linkedFrom);
        if (docs == null || docs.isEmpty()) {
            this.reportUndocumented(si.fileName, "Property: %s.%s is undocumented <a href=\"file:///%s\">Open %s(%d,%d)</a><br/>", obj.getQualifiedVmodlType(), prop.getName(), si.absoluteName, si.fileName, si.line, si.column);
        } else {
            this.checkFinalDoc(si.fileName, String.format("Property: %s.%s <a href=\"file:///%s\">Open %s(%d,%d)</a><br/>", obj.getQualifiedVmodlType(), prop.getName(), si.absoluteName, si.fileName, si.line, si.column), docs);
        }
        this.emitDescriptionHtml("description-html", docs);
        String deprecated = this.processDeprecated(pComment.getDeprecated(), si, prop);
        lp = new LinkParser(deprecated);
        this.processLinks(lp, si, obj, linkedFrom);
        this.emitDescriptionHtml("deprecated-html", lp.getFinalDocumentation());
        this.emitIndentedLine(this._xmlWriter, "</property>", new Object[0]);
        XMLGenerator.emitNewline(this._xmlWriter);
    }

    private String processDeprecated(Collection<String> deprecated, SourcePos si, VmodlApi decl) {
        if (deprecated.size() > 1) {
            String srcPos = "";
            if (si != null) {
                srcPos = si.toString();
            }
            if (decl instanceof Locatable) {
                srcPos = srcPos + " " + ((Locatable)((Object)decl)).getName();
            }
            Platform.printWarning(srcPos + " has more than one @deprecated JavaDoc tag");
        }
        String ret = "";
        for (String html : deprecated) {
            ret = ret + html;
        }
        return ret;
    }

    private void emitBuiltins() {
        this.emitIndentedLine(this._xmlWriter, "%s", BUILT_INS);
    }

    private <T extends VmodlObject> void emitNeededArraysForObjects(Collection<T> objs) {
        for (VmodlObject obj : objs) {
            if (!this.needArrayOf(obj) || !this.shouldGenerateFor(obj)) continue;
            String name = obj.getWsdlName();
            this.emitIndentedLine(this._xmlWriter, "<needed-array-type arrayNameBase=\"%s\" name=\"%s\" type=\"tns:%s\" type-id-ref=\"%s\"/>", name, name, name, obj.getQualifiedVmodlType());
        }
    }

    private void emitNeededArrays() {
        this.emitIndentedLine(this._xmlWriter, "<needed-array-types>", new Object[0]);
        this.indent();
        this.emitNeededArraysForObjects(this._managedObjects);
        this.emitNeededArraysForObjects(this._dataObjects);
        this.emitNeededArraysForObjects(this._enums);
        for (VmodlDecl.TypeId type : this._vmodlDeclPrimitivesNeedingArrayType) {
            if (type == VmodlDecl.TypeId.ANY || type == VmodlDecl.TypeId.DATETIME || type == VmodlDecl.TypeId.URI || type == VmodlDecl.TypeId.MANAGED || type == VmodlDecl.TypeId.STRING || type == VmodlDecl.TypeId.TYPENAME || type == VmodlDecl.TypeId.METHODNAME || type == VmodlDecl.TypeId.BINARY || type == VmodlDecl.TypeId.PROPPATH) continue;
            String name = type.toString().toLowerCase();
            this.emitIndentedLine(this._xmlWriter, "<needed-array-type arrayNameBase=\"%s\" name=\"%s\" type=\"xsd:%s\"/>", Utils.capitalizeB(name), name, name);
        }
        if (this.needAnyArray()) {
            this.emitIndentedLine(this._xmlWriter, "<needed-array-type arrayNameBase=\"AnyType\" name=\"anytype\" type=\"xsd:anyType\"/>", new Object[0]);
        }
        if (this.needDateTimeArray()) {
            this.emitIndentedLine(this._xmlWriter, "<needed-array-type arrayNameBase=\"DateTime\" name=\"dateTime\" type=\"xsd:dateType\"/>", new Object[0]);
        }
        if (this.needURIArray()) {
            this.emitIndentedLine(this._xmlWriter, "<needed-array-type arrayNameBase=\"AnyURI\" name=\"anyURI\" type=\"xsd:anyURI\"/>", new Object[0]);
        }
        if (this.needBinaryArray()) {
            this.emitIndentedLine(this._xmlWriter, "<needed-array-type arrayNameBase=\"Base64Binary\" name=\"base64Binary\" type=\"xsd:base64Binary\"/>", new Object[0]);
        }
        if (this.needMoRefArray()) {
            this.emitIndentedLine(this._xmlWriter, "<needed-array-type arrayNameBase=\"ManagedObjectReference\" name=\"ManagedObjectReference\" type=\"tns:ManagedObjectReference\"/>", new Object[0]);
        }
        if (this.needStringArray()) {
            this.emitIndentedLine(this._xmlWriter, "<needed-array-type arrayNameBase=\"String\" name=\"string\" type=\"xsd:string\"/>", new Object[0]);
        }
        this.unindent();
        this.emitIndentedLine(this._xmlWriter, "</needed-array-types>", new Object[0]);
    }

    private void emitEnums() {
        this.emitIndentedLine(this._xmlWriter, "<enums>", new Object[0]);
        for (VmodlObject vmodlObject : this._enums) {
            if (!this.shouldGenerateFor(vmodlObject)) continue;
            this.emitDataObjectContent("enum", vmodlObject.getWsdlName(), vmodlObject);
            Enum en = (Enum)vmodlObject;
            List<String> values = en.getValueList();
            List<Version> versions = en.getValueVersionList();
            for (int i = 0; i < values.size(); ++i) {
                Version version = versions.get(i);
                String value = values.get(i);
                if (versions.get(i) != null && !Versions.isTargetNewerThan(versions.get(i))) continue;
                if (version != null) {
                    if (this._emitVersionIdRefs) {
                        this.emitIndentedLine(this._xmlWriter, "<value name=\"" + value + "\" vmodl-name=\"" + value + "\" version-id-ref=\"" + value + "\">", new Object[0]);
                    } else {
                        this.emitIndentedLine(this._xmlWriter, "<value name=\"" + value + "\" vmodl-name=\"" + value + "\">", new Object[0]);
                    }
                } else {
                    this.emitIndentedLine(this._xmlWriter, "<value name=\"" + value + "\" vmodl-name=\"" + value + "\">", new Object[0]);
                }
                this.emitIndentedLine(this._xmlWriter, "</value>", new Object[0]);
            }
            this.emitIndentedLine(this._xmlWriter, "</enum>", new Object[0]);
        }
        this.emitIndentedLine(this._xmlWriter, "</enums>", new Object[0]);
    }

    private void emitFaults() {
        this.emitIndentedLine(this._xmlWriter, "<faults>", new Object[0]);
        for (VmodlObject obj : this._vmodlObjects) {
            if (!this.shouldGenerateFor(obj) || !obj.isFault()) continue;
            this.emitDataObjectContent("fault", obj.getWsdlName(), obj);
            this.emitIndentedLine(this._xmlWriter, "</fault>", new Object[0]);
        }
        this.emitIndentedLine(this._xmlWriter, "</faults>", new Object[0]);
    }

    private boolean queryEmitDataObject(VmodlObject obj) {
        return !obj.getQualifiedVmodlType().equals(Utils.DataObjectClassName);
    }

    private void emitDataObjects() {
        this.emitIndentedLine(this._xmlWriter, "<data-objects>", new Object[0]);
        for (DataObject obj : this._dataObjects) {
            if (!this.shouldGenerateFor(obj) || obj.isFault() || !this.queryEmitDataObject(obj)) continue;
            this.emitDataObjectContent("data-object", obj.getWsdlName(), obj);
            this.emitIndentedLine(this._xmlWriter, "</data-object>", new Object[0]);
        }
        this.emitIndentedLine(this._xmlWriter, "</data-objects>", new Object[0]);
    }

    private boolean queryEmitManagedObject(VmodlObject obj) {
        return !obj.getQualifiedVmodlType().equals(Utils.ManagedObjectClassName);
    }

    private boolean queryExtendDynamicData(VmodlObject td) {
        return !td.getKind().equals((Object)VmodlObject.Kind.Enum) && !"vmodl.ManagedObjectReference".equals(td.getQualifiedVmodlType()) && !td.getQualifiedVmodlType().equals(Utils.DynamicDataClassName) && !td.getQualifiedVmodlType().equals(Utils.DynamicArrayClassName) && !td.getQualifiedVmodlType().equals(Utils.DynamicPropertyClassName) && !td.getQualifiedVmodlType().equals(Utils.MethodFaultClassName);
    }

    private Pair<String, String> getLinkTargetAndLabelImpl(VmodlObject obj, String fieldOrMethod, String target) {
        for (Property prop : obj.getPropertyList()) {
            if (!prop.getName().equals(fieldOrMethod)) continue;
            return new Pair<String, String>(String.format("%s.html%s", obj.getQualifiedVmodlType(), target), prop.getWsdlName());
        }
        if (obj.getKind().equals((Object)VmodlObject.Kind.ManagedObject)) {
            ManagedObject mobj = (ManagedObject)obj;
            for (Method method : mobj.getMethodList()) {
                if (!method.getName().equals(fieldOrMethod)) continue;
                return new Pair<String, String>(String.format("%s.html%s", obj.getQualifiedVmodlType(), target), method.getWsdlName());
            }
        }
        if (obj.getContainer() != null) {
            return this.getLinkTargetAndLabelImpl(obj.getContainer(), fieldOrMethod, target);
        }
        return null;
    }

    private Pair<String, String> getLinkTargetAndLabel(String target, String label, SourcePos si, VmodlObject decl) {
        VmodlObject docdObj = decl;
        int pound = target.indexOf(35);
        if (pound == 0) {
            String fieldOrMethod = target.substring(1);
            if (label == null) {
                label = fieldOrMethod;
            }
            return this.getLinkTargetAndLabelImpl(docdObj, fieldOrMethod, target);
        }
        if (pound > 0) {
            String className = target.substring(0, pound);
            String anchor2 = target.substring(pound);
            String wsdlName2 = this._knownTypes.get(className);
            if (wsdlName2 == null) {
                className = docdObj.getPackage() + "." + className;
                wsdlName2 = this._knownTypes.get(className);
            }
            if (wsdlName2 != null) {
                if (label == null) {
                    label = target.substring(pound + 1);
                }
                VmodlObject targetObj = ObjectRegistry.getObject(className);
                return this.getLinkTargetAndLabelImpl(targetObj, anchor2.substring(1), anchor2);
            }
            return null;
        }
        String wsdlName3 = this._knownTypes.get(target);
        if (wsdlName3 == null) {
            target = docdObj.getPackage() + "." + target;
            wsdlName3 = this._knownTypes.get(target);
        }
        if (wsdlName3 != null) {
            if (label == null) {
                label = wsdlName3;
            }
            return new Pair<String, String>(String.format("%s.html", target), label);
        }
        return null;
    }

    private String processSeeAlsos(Collection<String> seeAlsos, SourcePos si, VmodlObject decl, String linkedFrom) {
        String ret = seeAlsos.size() > 0 ? "<br>" : "";
        for (String target : seeAlsos) {
            Pair<String, String> targetAndLabel;
            int indexSpace = target.indexOf(32);
            if (indexSpace != -1) {
                target = target.substring(0, indexSpace).trim();
            }
            if ((targetAndLabel = this.getLinkTargetAndLabel(target, null, si, decl)) != null) {
                ret = ret + String.format("See <a href=\"%s\">%s</a><br>", targetAndLabel.first, targetAndLabel.second);
                continue;
            }
            ret = ret + "See " + target;
            this.reportUndocumented(si.fileName, "%s Link (@see): %s not found <a href=\"file:///%s\">Open %s(%d,%d)</a><br/>", linkedFrom, target, si.absoluteName, si.fileName, si.line, si.column);
        }
        return ret;
    }

    private void processLinks(LinkParser lp, SourcePos si, VmodlObject decl, String linkedFrom) {
        for (LinkParser.Link link2 : lp.getLinks()) {
            String label;
            String target = link2.getTarget();
            Pair<String, String> targetAndLabel = this.getLinkTargetAndLabel(target, label = link2.getLabel(), si, decl);
            if (targetAndLabel != null) {
                link2.setLinkHtml(String.format("<a href=\"%s\">%s</a>", targetAndLabel.first, targetAndLabel.second));
            } else {
                this.reportUndocumented(si.fileName, "%s Link {@link}: %s not found <a href=\"file:///%s\">Open %s(%d,%d)</a><br/>", linkedFrom, link2.getTarget(), si.absoluteName, si.fileName, si.line, si.column);
                link2.setLinkHtml(label == null ? target : label);
            }
            lp.updateDocumentation(link2);
        }
    }

    private void emitDataObjectContent(String tagText, String name, VmodlObject obj) {
        Version internalBeforeVersion;
        String qName = obj.getQualifiedVmodlType();
        this.emitBaseInfo(tagText, name);
        this.indent();
        this.emitAttributeLine("type-id", qName);
        this.emitAttributeLine("vmodl-name", qName);
        VmodlObject container = obj.getContainer();
        if (container != null) {
            this.emitAttributeLine("enclosing-type-id-ref", container.getQualifiedVmodlType());
        }
        Version version = obj.getVersion();
        if (this._emitVersionIdRefs) {
            this.emitAttributeLine("version-id-ref", version.getVmodlName());
        }
        if ((internalBeforeVersion = obj.getInternalBefore()) != null && this._emitVersionIdRefs) {
            this.emitAttributeLine("internal-before-version-id-ref", internalBeforeVersion.getVmodlName());
        }
        if (this._emitIsDeprecated && obj.isDeprecated()) {
            this.emitAttributeLine("is-deprecated", "true");
        }
        if (obj.getKind().equals((Object)VmodlObject.Kind.DataObject) && !obj.getQualifiedVmodlType().startsWith("vmodl.Dynamic")) {
            VmodlObject base = obj.getBaseObject();
            String lQName = base == null ? "java.lang.Object" : base.getQualifiedVmodlType();
            if (!lQName.startsWith("java.")) {
                this.emitAttributeLine("base-type-id", lQName);
            } else if (this.queryExtendDynamicData(obj)) {
                this.emitAttributeLine("base-type-id", Utils.DynamicDataClassName);
            }
        } else if (obj.getKind().equals((Object)VmodlObject.Kind.ManagedObject) && !obj.getBaseObject().getQualifiedVmodlType().equals(Utils.ManagedObjectClassName)) {
            this.emitAttributeLine("base-type-id", obj.getBaseObject().getQualifiedVmodlType());
        }
        this.emitIndentedLine(this._xmlWriter, ">", new Object[0]);
        TypeComment tComment = new TypeComment();
        _docProcessor.processTypeComment(obj.getComment(), tComment);
        LinkParser lp = new LinkParser(tComment.getHtml());
        SourcePos si = Platform.getSourcePos(obj);
        String linkedFrom = obj.getQualifiedVmodlType();
        this.processLinks(lp, si, obj, linkedFrom);
        String docs = lp.getFinalDocumentation();
        docs = docs + this.processSeeAlsos(tComment.getSeeAlsos(), si, obj, linkedFrom);
        if (docs == null || docs.length() == 0) {
            this.reportUndocumented(si.fileName, "Item: %s is undocumented <a href=\"file:///%s\">Open %s(%d,%d)</a><br/>", obj.getQualifiedVmodlType(), si.absoluteName, si.fileName, si.line, si.column);
        } else {
            this.checkFinalDoc(si.fileName, String.format("Item: %s <a href=\"file:///%s\">Open %s(%d,%d)</a><br/>", obj.getQualifiedVmodlType(), si.absoluteName, si.fileName, si.line, si.column), docs);
        }
        this.emitDescriptionHtml("description-html", docs);
        String deprecated = this.processDeprecated(tComment.getDeprecated(), si, obj);
        lp = new LinkParser(deprecated);
        this.processLinks(lp, si, obj, linkedFrom);
        this.emitDescriptionHtml("deprecated-html", lp.getFinalDocumentation());
        if (!obj.getKind().equals((Object)VmodlObject.Kind.Enum)) {
            this.emitProperties(obj);
        }
        for (VmodlObject nobj : obj.getNestedList()) {
            if (!this.shouldGenerateFor(nobj)) continue;
            this.emitIndentedLine(this._xmlWriter, "<nested-type-id-ref>" + nobj.getQualifiedVmodlType() + "</nested-type-id-ref>", new Object[0]);
        }
        this.unindent();
    }

    private void emitManagedObjects() {
        this.emitIndentedLine(this._xmlWriter, "<managed-objects>", new Object[0]);
        for (ManagedObject obj : this._managedObjects) {
            if (!this.shouldGenerateFor(obj) || !this.queryEmitManagedObject(obj)) continue;
            this.emitDataObjectContent("managed-object", obj.getWsdlName(), obj);
            this.emitMethods(obj);
            this.emitIndentedLine(this._xmlWriter, "</managed-object>", new Object[0]);
        }
        this.emitIndentedLine(this._xmlWriter, "</managed-objects>", new Object[0]);
    }

    @Override
    String schemaDefaultNS() {
        return "xml:";
    }

    @Override
    String schemaId(VmodlObject obj) {
        return "schemaId";
    }

    @Override
    String schemaArrayPrefix() {
        return "arrayPrefix";
    }

    private class Pair<T1, T2> {
        T1 first;
        T2 second;

        Pair(T1 first, T2 second) {
            this.first = first;
            this.second = second;
        }
    }
}

