/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.dr.ui.tools.utilities;

import com.vmware.dr.ui.tools.utilities.ThreadContext;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.commons.lang.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecutorUtils {
    private static final int EXEC_CORE_SIZE = 64;
    private static final int SCHED_EXEC_CORE_SIZE = 16;
    private static final Logger LOGGER = LoggerFactory.getLogger(ExecutorUtils.class);
    private static final ExecutorService EXEC;
    private static final ScheduledExecutorService SCHED_EXEC;

    private static <T> Callable<T> wrap(Callable<T> task) {
        Validate.notNull(task, (String)"task");
        ThreadContext current = ThreadContext.get();
        return () -> ThreadContext.setupContext(task, current);
    }

    private static Runnable wrap(Runnable task) {
        Validate.notNull((Object)task, (String)"task");
        ThreadContext current = ThreadContext.get();
        return () -> ThreadContext.setupContext(task, current);
    }

    private static <T> Collection<Callable<T>> wrap(Collection<? extends Callable<T>> tasks) {
        Validate.notNull(tasks, (String)"tasks");
        ThreadContext current = ThreadContext.get();
        return tasks.stream().map(task -> () -> ThreadContext.setupContext(task, current)).collect(Collectors.toList());
    }

    public static ExecutorService createThreadContextExecutor(ExecutorService es) {
        return new ThreadContextExecutor(es);
    }

    public static ScheduledExecutorService createThreadContextScheduledExecutor(ScheduledExecutorService ses) {
        return new ThreadContextScheduledExecutor(ses);
    }

    public static Executor getExecutor() {
        return EXEC;
    }

    public static ScheduledExecutorService getScheduledExecutor() {
        return SCHED_EXEC;
    }

    static {
        ThreadPoolExecutor tes = new ThreadPoolExecutor(64, 64, 60L, TimeUnit.SECONDS, (BlockingQueue)new LinkedBlockingQueue(), (ThreadFactory)new ThreadFactoryImpl("srm-utilities-thread")){

            @Override
            protected void afterExecute(Runnable r, Throwable t) {
                super.afterExecute(r, t);
                if (t != null) {
                    LOGGER.warn("Topology task finished with error: ", t);
                }
            }
        };
        tes.allowCoreThreadTimeOut(true);
        EXEC = ExecutorUtils.createThreadContextExecutor(tes);
        ScheduledThreadPoolExecutor ses = new ScheduledThreadPoolExecutor(16, new ThreadFactoryImpl("srm-utilities-sched-thread")){

            @Override
            protected void afterExecute(Runnable r, Throwable t) {
                super.afterExecute(r, t);
                if (t != null) {
                    LOGGER.warn("Scheduled task finished with error: ", t);
                }
            }
        };
        ses.setRemoveOnCancelPolicy(true);
        SCHED_EXEC = ses;
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                EXEC.shutdown();
                SCHED_EXEC.shutdown();
            }
        });
    }

    public static class ThreadFactoryImpl
    implements ThreadFactory {
        final AtomicInteger nextThread = new AtomicInteger(1);
        final String threadPrefix;

        public ThreadFactoryImpl(String prefix) {
            this.threadPrefix = prefix + "-%s";
        }

        @Override
        public Thread newThread(Runnable r) {
            String name = String.format(this.threadPrefix, this.nextThread.getAndIncrement());
            Thread t = new Thread(r, name);
            if (t.isDaemon()) {
                t.setDaemon(false);
            }
            if (t.getPriority() != 5) {
                t.setPriority(5);
            }
            return t;
        }
    }

    private static final class ThreadContextScheduledExecutor
    extends ThreadContextExecutor
    implements ScheduledExecutorService {
        private final ScheduledExecutorService _delegate;

        ThreadContextScheduledExecutor(ScheduledExecutorService delegate) {
            super(delegate);
            this._delegate = delegate;
        }

        @Override
        public ScheduledFuture<?> schedule(Runnable command, long delay, TimeUnit unit) {
            return this._delegate.schedule(ExecutorUtils.wrap(command), delay, unit);
        }

        @Override
        public <V> ScheduledFuture<V> schedule(Callable<V> callable, long delay, TimeUnit unit) {
            return this._delegate.schedule(ExecutorUtils.wrap(callable), delay, unit);
        }

        @Override
        public ScheduledFuture<?> scheduleAtFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit) {
            return this._delegate.scheduleAtFixedRate(ExecutorUtils.wrap(command), initialDelay, period, unit);
        }

        @Override
        public ScheduledFuture<?> scheduleWithFixedDelay(Runnable command, long initialDelay, long delay, TimeUnit unit) {
            return this._delegate.scheduleWithFixedDelay(ExecutorUtils.wrap(command), initialDelay, delay, unit);
        }
    }

    private static class ThreadContextExecutor
    implements ExecutorService {
        private final ExecutorService _delegate;

        ThreadContextExecutor(ExecutorService delegate) {
            Validate.notNull((Object)delegate, (String)"delegate");
            this._delegate = delegate;
        }

        @Override
        public final void execute(Runnable command) {
            this._delegate.execute(ExecutorUtils.wrap(command));
        }

        @Override
        public final void shutdown() {
            this._delegate.shutdown();
        }

        @Override
        public final List<Runnable> shutdownNow() {
            return this._delegate.shutdownNow();
        }

        @Override
        public final boolean isShutdown() {
            return this._delegate.isShutdown();
        }

        @Override
        public final boolean isTerminated() {
            return this._delegate.isTerminated();
        }

        @Override
        public final boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
            return this._delegate.awaitTermination(timeout, unit);
        }

        @Override
        public final <T> Future<T> submit(Callable<T> task) {
            return this._delegate.submit(ExecutorUtils.wrap(task));
        }

        @Override
        public final <T> Future<T> submit(Runnable task, T result) {
            return this._delegate.submit(ExecutorUtils.wrap(task), result);
        }

        @Override
        public final Future<?> submit(Runnable task) {
            return this._delegate.submit(ExecutorUtils.wrap(task));
        }

        @Override
        public final <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
            return this._delegate.invokeAll(ExecutorUtils.wrap(tasks));
        }

        @Override
        public final <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
            return this._delegate.invokeAll(ExecutorUtils.wrap(tasks), timeout, unit);
        }

        @Override
        public final <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
            return this._delegate.invokeAny(ExecutorUtils.wrap(tasks));
        }

        @Override
        public final <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            return this._delegate.invokeAny(ExecutorUtils.wrap(tasks), timeout, unit);
        }
    }
}

