/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.dr.ui.tools.utilities;

import com.vmware.dr.ui.tools.utilities.ContextApplier;
import com.vmware.dr.ui.tools.utilities.Exceptions;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import org.apache.commons.lang.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ThreadContext {
    private static final Logger LOGGER = LoggerFactory.getLogger(ThreadContext.class);
    private static final ContextApplier EMPTY_APPLIER = new ContextApplier(){

        @Override
        public Object apply() {
            return null;
        }

        @Override
        public void undo(Object prev) {
        }

        @Override
        public boolean isApplied() {
            return true;
        }
    };
    private static final ThreadContext EMPTY = new ThreadContext(null, EMPTY_APPLIER);
    private static final ThreadLocal<ThreadContext> CURRENT = ThreadLocal.withInitial(() -> EMPTY);
    private final ContextApplier _applier;
    private final ThreadContext _parent;
    private ThreadContext _child;

    private static <T> Callable<T> wrap(Runnable run) {
        return () -> {
            run.run();
            return null;
        };
    }

    public static ThreadContext get() {
        return CURRENT.get().clone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T setupContext(Callable<T> task, ThreadContext root) throws Exception {
        ThreadContext current = CURRENT.get();
        CURRENT.set(root);
        try {
            T t = root.execute(task);
            return t;
        }
        finally {
            CURRENT.set(current);
        }
    }

    public static <T> T setupContext(Callable<T> task, ContextApplier applier) throws Exception {
        return ThreadContext.setupContext(task, new ThreadContext(null, applier));
    }

    public static void setupContext(Runnable task, ContextApplier applier) {
        try {
            ThreadContext.setupContext(ThreadContext.wrap(task), applier);
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception exc) {
            throw Exceptions.getRuntimeException(exc);
        }
    }

    public static void setupContext(Runnable task, ThreadContext root) {
        try {
            ThreadContext.setupContext(ThreadContext.wrap(task), root);
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception exc) {
            throw Exceptions.getRuntimeException(exc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T extendContext(Callable<T> task, ContextApplier applier) throws Exception {
        ThreadContext child = CURRENT.get().addChild(applier);
        try {
            T t = child.execute(task);
            return t;
        }
        finally {
            child.remove();
        }
    }

    public static void extendContext(Runnable task, ContextApplier applier) {
        try {
            ThreadContext.extendContext(ThreadContext.wrap(task), applier);
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception exc) {
            throw Exceptions.getRuntimeException(exc);
        }
    }

    private ThreadContext(ThreadContext parent, ContextApplier applier) {
        Validate.notNull((Object)applier, (String)"applier");
        this._parent = parent;
        this._applier = applier;
    }

    private ThreadContext addChild(ContextApplier applier) {
        if (this._child == null) {
            ThreadContext child;
            this._child = child = new ThreadContext(this, applier);
            return child;
        }
        return this._child.addChild(applier);
    }

    private void remove() {
        if (this._parent != null) {
            if (this._parent._child != this) {
                LOGGER.error("Already removed", (Throwable)new IllegalStateException());
                return;
            }
            this._parent._child = null;
        }
    }

    private <T> T execute(Callable<T> task) throws Exception {
        return ThreadContext.execute(task, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> T execute(Callable<T> task, ThreadContext tc) throws Exception {
        ArrayList<Invoker> stack = new ArrayList<Invoker>();
        ThreadContext local = tc;
        while (local != null) {
            block15: {
                block14: {
                    try {
                        if (local.isApplied()) {
                        }
                        break block14;
                    }
                    catch (Exception exc) {
                        LOGGER.warn("Failed to apply context '{}'", (Object)local, (Object)exc);
                    }
                    break block15;
                }
                try {
                    stack.add(new Invoker(local));
                }
                catch (Exception exc) {
                    LOGGER.warn("Failed to apply context '{}'", (Object)local, (Object)exc);
                }
            }
            local = local._child;
        }
        try {
            T t = task.call();
            return t;
        }
        finally {
            for (int i = stack.size() - 1; i >= 0; --i) {
                Invoker inv = (Invoker)stack.get(i);
                try {
                    inv.doUnset();
                    continue;
                }
                catch (Exception exc) {
                    LOGGER.warn("Failed to unset context '{}'", (Object)inv._th, (Object)exc);
                }
            }
            stack.clear();
        }
    }

    private boolean isApplied() {
        return this._applier.isApplied();
    }

    private Object set() {
        return this._applier.apply();
    }

    private void unset(Object prev) {
        this._applier.undo(prev);
    }

    protected ThreadContext clone() {
        if (this._parent != null) {
            throw new IllegalStateException("Cloning supported on root only.");
        }
        return this.clone(null);
    }

    private ThreadContext clone(ThreadContext parent) {
        ThreadContext result = new ThreadContext(parent, this._applier);
        if (this._child != null) {
            result._child = this._child.clone(result);
        }
        return result;
    }

    public String toString() {
        return "ThreadContext{_applier=" + this._applier + '}';
    }

    private static final class Invoker {
        private final Object _toUnset;
        private final ThreadContext _th;

        Invoker(ThreadContext th) {
            this._toUnset = th.set();
            this._th = th;
        }

        void doUnset() {
            this._th.unset(this._toUnset);
        }
    }
}

