/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.binding.vim.host;

import com.vmware.vim.binding.impl.vmodl.DynamicDataImpl;
import com.vmware.vim.binding.vim.fault.AlreadyExists;
import com.vmware.vim.binding.vim.fault.InvalidLogin;
import com.vmware.vim.binding.vim.fault.UserNotFound;
import com.vmware.vim.binding.vim.version.version1;
import com.vmware.vim.binding.vim.version.version14;
import com.vmware.vim.binding.vmodl.ManagedObject;
import com.vmware.vim.binding.vmodl.data;
import com.vmware.vim.binding.vmodl.faults;
import com.vmware.vim.binding.vmodl.managed;
import com.vmware.vim.binding.vmodl.name;
import com.vmware.vim.binding.vmodl.optional;
import com.vmware.vim.binding.vmodl.privilege;
import com.vmware.vim.binding.vmodl.propertyOrder;
import com.vmware.vim.binding.vmodl.secret;
import com.vmware.vim.binding.vmodl.versionClass;
import com.vmware.vim.binding.vmodl.wsdlName;
import com.vmware.vim.vmomi.core.Future;
import com.vmware.vim.vmomi.core.util.StringUtil;

@managed
@versionClass(value=version1.class)
@wsdlName(value="HostLocalAccountManager")
public interface LocalAccountManager
extends ManagedObject {
    @versionClass(value=version1.class)
    @wsdlName(value="AssignUserToGroup")
    @privilege(value="Host.Local.ManageUserGroups")
    @faults(value={"UserNotFound", "AlreadyExists"})
    @Deprecated
    public void assignUserToGroup(@name(value="user") @versionClass(value=version1.class) String var1, @name(value="group") @versionClass(value=version1.class) String var2, Future<Void> var3);

    @wsdlName(value="AssignUserToGroup")
    @Deprecated
    public void assignUserToGroup(String var1, String var2) throws UserNotFound, AlreadyExists;

    @versionClass(value=version14.class)
    @wsdlName(value="ChangePassword")
    @privilege(value="System.Anonymous")
    @faults(value={"InvalidLogin"})
    public void changePassword(@name(value="user") @versionClass(value=version14.class) String var1, @name(value="oldPassword") @versionClass(value=version14.class) @secret String var2, @name(value="newPassword") @versionClass(value=version14.class) @secret String var3, Future<Void> var4);

    @wsdlName(value="ChangePassword")
    public void changePassword(String var1, String var2, String var3) throws InvalidLogin;

    @versionClass(value=version1.class)
    @wsdlName(value="CreateGroup")
    @privilege(value="Host.Local.ManageUserGroups")
    @faults(value={"AlreadyExists"})
    @Deprecated
    public void createGroup(@name(value="group") @versionClass(value=version1.class) AccountSpecification var1, Future<Void> var2);

    @wsdlName(value="CreateGroup")
    @Deprecated
    public void createGroup(AccountSpecification var1) throws AlreadyExists;

    @versionClass(value=version1.class)
    @wsdlName(value="CreateUser")
    @privilege(value="Host.Local.ManageUserGroups")
    @faults(value={"AlreadyExists"})
    public void createUser(@name(value="user") @versionClass(value=version1.class) AccountSpecification var1, Future<Void> var2);

    @wsdlName(value="CreateUser")
    public void createUser(AccountSpecification var1) throws AlreadyExists;

    @versionClass(value=version1.class)
    @wsdlName(value="RemoveGroup")
    @privilege(value="Host.Local.ManageUserGroups")
    @faults(value={"UserNotFound"})
    @Deprecated
    public void removeGroup(@name(value="groupName") @versionClass(value=version1.class) String var1, Future<Void> var2);

    @wsdlName(value="RemoveGroup")
    @Deprecated
    public void removeGroup(String var1) throws UserNotFound;

    @versionClass(value=version1.class)
    @wsdlName(value="RemoveUser")
    @privilege(value="Host.Local.ManageUserGroups")
    @faults(value={"UserNotFound"})
    public void removeUser(@name(value="userName") @versionClass(value=version1.class) String var1, Future<Void> var2);

    @wsdlName(value="RemoveUser")
    public void removeUser(String var1) throws UserNotFound;

    @versionClass(value=version1.class)
    @wsdlName(value="UnassignUserFromGroup")
    @privilege(value="Host.Local.ManageUserGroups")
    @faults(value={"UserNotFound"})
    @Deprecated
    public void unassignUserFromGroup(@name(value="user") @versionClass(value=version1.class) String var1, @name(value="group") @versionClass(value=version1.class) String var2, Future<Void> var3);

    @wsdlName(value="UnassignUserFromGroup")
    @Deprecated
    public void unassignUserFromGroup(String var1, String var2) throws UserNotFound;

    @versionClass(value=version1.class)
    @wsdlName(value="UpdateUser")
    @privilege(value="Host.Local.ManageUserGroups")
    @faults(value={"UserNotFound", "AlreadyExists"})
    public void updateUser(@name(value="user") @versionClass(value=version1.class) AccountSpecification var1, Future<Void> var2);

    @wsdlName(value="UpdateUser")
    public void updateUser(AccountSpecification var1) throws UserNotFound, AlreadyExists;

    @versionClass(value=version1.class)
    @wsdlName(value="HostPosixAccountSpec")
    @data
    @propertyOrder(value={"posixId", "shellAccess"})
    public static class PosixAccountSpecification
    extends AccountSpecification {
        private static final long serialVersionUID = 1L;
        public Integer posixId;
        public Boolean shellAccess;

        public PosixAccountSpecification() {
        }

        public PosixAccountSpecification(String id, String password, String description, Integer posixId, Boolean shellAccess) {
            super(id, password, description);
            this.posixId = posixId;
            this.shellAccess = shellAccess;
        }

        @optional
        @versionClass(value=version1.class)
        public Integer getPosixId() {
            return this.posixId;
        }

        @optional
        @versionClass(value=version1.class)
        public void setPosixId(Integer posixId) {
            this.posixId = posixId;
        }

        @optional
        @versionClass(value=version1.class)
        @Deprecated
        public Boolean isShellAccess() {
            return this.shellAccess;
        }

        @optional
        @versionClass(value=version1.class)
        public Boolean getShellAccess() {
            return this.shellAccess;
        }

        @optional
        @versionClass(value=version1.class)
        public void setShellAccess(Boolean shellAccess) {
            this.shellAccess = shellAccess;
        }

        @Override
        public String toString() {
            StringBuilder objString = new StringBuilder(280);
            objString.append("(vim.host.PosixAccountSpecification) {\n");
            objString.append("   ");
            objString.append("dynamicType = ");
            objString.append(this.getDynamicType());
            objString.append(",\n");
            objString.append("   ");
            objString.append("dynamicProperty = ");
            if (this.getDynamicProperty() == null) {
                objString.append("null");
            } else {
                objString.append("(vmodl.DynamicProperty) [\n");
                for (int i = 0; i < this.getDynamicProperty().length; ++i) {
                    objString.append("      ");
                    objString.append(StringUtil.indent((String)("" + this.getDynamicProperty()[i]), (boolean)true));
                    if (i < this.getDynamicProperty().length - 1) {
                        objString.append(",");
                    }
                    objString.append("\n");
                }
                objString.append("   ");
                objString.append("]");
            }
            objString.append(",\n");
            objString.append("   ");
            objString.append("id = ");
            objString.append(this.getId());
            objString.append(",\n");
            objString.append("   ");
            objString.append("password = ");
            if (this.getPassword() == null) {
                objString.append("null");
            } else {
                objString.append("(not shown)");
            }
            objString.append(",\n");
            objString.append("   ");
            objString.append("description = ");
            objString.append(this.getDescription());
            objString.append(",\n");
            objString.append("   ");
            objString.append("posixId = ");
            objString.append(this.getPosixId());
            objString.append(",\n");
            objString.append("   ");
            objString.append("shellAccess = ");
            objString.append(this.isShellAccess());
            objString.append("\n}");
            return objString.toString();
        }
    }

    @versionClass(value=version1.class)
    @wsdlName(value="HostAccountSpec")
    @data
    @propertyOrder(value={"id", "password", "description"})
    public static class AccountSpecification
    extends DynamicDataImpl {
        private static final long serialVersionUID = 1L;
        public String id;
        public String password;
        public String description;

        public AccountSpecification() {
        }

        public AccountSpecification(String id, String password, String description) {
            this.id = id;
            this.password = password;
            this.description = description;
        }

        @versionClass(value=version1.class)
        public String getId() {
            return this.id;
        }

        @versionClass(value=version1.class)
        public void setId(String id) {
            this.id = id;
        }

        @secret
        @optional
        @versionClass(value=version1.class)
        public String getPassword() {
            return this.password;
        }

        @secret
        @optional
        @versionClass(value=version1.class)
        public void setPassword(String password) {
            this.password = password;
        }

        @optional
        @versionClass(value=version1.class)
        public String getDescription() {
            return this.description;
        }

        @optional
        @versionClass(value=version1.class)
        public void setDescription(String description) {
            this.description = description;
        }

        public String toString() {
            StringBuilder objString = new StringBuilder(200);
            objString.append("(vim.host.AccountSpecification) {\n");
            objString.append("   ");
            objString.append("dynamicType = ");
            objString.append(this.getDynamicType());
            objString.append(",\n");
            objString.append("   ");
            objString.append("dynamicProperty = ");
            if (this.getDynamicProperty() == null) {
                objString.append("null");
            } else {
                objString.append("(vmodl.DynamicProperty) [\n");
                for (int i = 0; i < this.getDynamicProperty().length; ++i) {
                    objString.append("      ");
                    objString.append(StringUtil.indent((String)("" + this.getDynamicProperty()[i]), (boolean)true));
                    if (i < this.getDynamicProperty().length - 1) {
                        objString.append(",");
                    }
                    objString.append("\n");
                }
                objString.append("   ");
                objString.append("]");
            }
            objString.append(",\n");
            objString.append("   ");
            objString.append("id = ");
            objString.append(this.getId());
            objString.append(",\n");
            objString.append("   ");
            objString.append("password = ");
            if (this.getPassword() == null) {
                objString.append("null");
            } else {
                objString.append("(not shown)");
            }
            objString.append(",\n");
            objString.append("   ");
            objString.append("description = ");
            objString.append(this.getDescription());
            objString.append("\n}");
            return objString.toString();
        }
    }
}

