/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.binding.vim.host;

import com.vmware.vim.binding.impl.vmodl.DynamicDataImpl;
import com.vmware.vim.binding.vim.fault.AlreadyExists;
import com.vmware.vim.binding.vim.fault.HostConfigFault;
import com.vmware.vim.binding.vim.fault.InvalidHostState;
import com.vmware.vim.binding.vim.fault.NotFound;
import com.vmware.vim.binding.vim.version.version12;
import com.vmware.vim.binding.vim.version.version13;
import com.vmware.vim.binding.vmodl.ManagedObject;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.binding.vmodl.data;
import com.vmware.vim.binding.vmodl.faults;
import com.vmware.vim.binding.vmodl.list;
import com.vmware.vim.binding.vmodl.localizable;
import com.vmware.vim.binding.vmodl.managed;
import com.vmware.vim.binding.vmodl.managedObjectType;
import com.vmware.vim.binding.vmodl.map;
import com.vmware.vim.binding.vmodl.name;
import com.vmware.vim.binding.vmodl.optional;
import com.vmware.vim.binding.vmodl.privilege;
import com.vmware.vim.binding.vmodl.propertyOrder;
import com.vmware.vim.binding.vmodl.readonly;
import com.vmware.vim.binding.vmodl.task;
import com.vmware.vim.binding.vmodl.versionClass;
import com.vmware.vim.binding.vmodl.wsdlName;
import com.vmware.vim.vmomi.core.Future;
import com.vmware.vim.vmomi.core.util.StringUtil;

@managed
@versionClass(value=version12.class)
@wsdlName(value="HostNvdimmSystem")
public interface NvdimmSystem
extends ManagedObject {
    @readonly
    @name(value="nvdimmSystemInfo")
    @privilege(value="Host.Config.Nvdimm")
    @versionClass(value=version12.class)
    public void getNvdimmSystemInfo(Future<NvdimmSystemInfo> var1);

    @name(value="nvdimmSystemInfo")
    public NvdimmSystemInfo getNvdimmSystemInfo();

    @versionClass(value=version12.class)
    @wsdlName(value="CreateNvdimmNamespace_Task")
    @privilege(value="Host.Config.Nvdimm")
    @task
    @faults(value={"InvalidHostState", "AlreadyExists", "HostConfigFault"})
    @Deprecated
    public void createNamespace(@name(value="createSpec") @versionClass(value=version12.class) NamespaceCreateSpec var1, @managedObjectType(value="com.vmware.vim.binding.vim.Task") Future<ManagedObjectReference> var2);

    @wsdlName(value="CreateNvdimmNamespace_Task")
    @Deprecated
    @managedObjectType(value="com.vmware.vim.binding.vim.Task")
    public ManagedObjectReference createNamespace(NamespaceCreateSpec var1) throws InvalidHostState, AlreadyExists, HostConfigFault;

    @versionClass(value=version13.class)
    @wsdlName(value="CreateNvdimmPMemNamespace_Task")
    @privilege(value="Host.Config.Nvdimm")
    @task
    @faults(value={"InvalidHostState", "AlreadyExists", "HostConfigFault"})
    public void createPMemNamespace(@name(value="createSpec") @versionClass(value=version13.class) PMemNamespaceCreateSpec var1, @managedObjectType(value="com.vmware.vim.binding.vim.Task") Future<ManagedObjectReference> var2);

    @wsdlName(value="CreateNvdimmPMemNamespace_Task")
    @managedObjectType(value="com.vmware.vim.binding.vim.Task")
    public ManagedObjectReference createPMemNamespace(PMemNamespaceCreateSpec var1) throws InvalidHostState, AlreadyExists, HostConfigFault;

    @versionClass(value=version12.class)
    @wsdlName(value="DeleteNvdimmBlockNamespaces_Task")
    @privilege(value="Host.Config.Nvdimm")
    @task
    @faults(value={"NotFound", "InvalidHostState", "HostConfigFault"})
    public void deleteBlockNamespaces(@managedObjectType(value="com.vmware.vim.binding.vim.Task") Future<ManagedObjectReference> var1);

    @wsdlName(value="DeleteNvdimmBlockNamespaces_Task")
    @managedObjectType(value="com.vmware.vim.binding.vim.Task")
    public ManagedObjectReference deleteBlockNamespaces() throws NotFound, InvalidHostState, HostConfigFault;

    @versionClass(value=version12.class)
    @wsdlName(value="DeleteNvdimmNamespace_Task")
    @privilege(value="Host.Config.Nvdimm")
    @task
    @faults(value={"NotFound", "InvalidHostState", "HostConfigFault"})
    public void deleteNamespace(@name(value="deleteSpec") @versionClass(value=version12.class) NamespaceDeleteSpec var1, @managedObjectType(value="com.vmware.vim.binding.vim.Task") Future<ManagedObjectReference> var2);

    @wsdlName(value="DeleteNvdimmNamespace_Task")
    @managedObjectType(value="com.vmware.vim.binding.vim.Task")
    public ManagedObjectReference deleteNamespace(NamespaceDeleteSpec var1) throws NotFound, InvalidHostState, HostConfigFault;

    @versionClass(value=version12.class)
    @wsdlName(value="NvdimmSummary")
    @data
    @propertyOrder(value={"numDimms", "healthStatus", "totalCapacity", "persistentCapacity", "blockCapacity", "availableCapacity", "numInterleavesets", "numNamespaces"})
    public static class Summary
    extends DynamicDataImpl {
        private static final long serialVersionUID = 1L;
        public int numDimms;
        public String healthStatus;
        public long totalCapacity;
        public long persistentCapacity;
        public long blockCapacity;
        public long availableCapacity;
        public int numInterleavesets;
        public int numNamespaces;

        public Summary() {
        }

        public Summary(int numDimms, String healthStatus, long totalCapacity, long persistentCapacity, long blockCapacity, long availableCapacity, int numInterleavesets, int numNamespaces) {
            this.numDimms = numDimms;
            this.healthStatus = healthStatus;
            this.totalCapacity = totalCapacity;
            this.persistentCapacity = persistentCapacity;
            this.blockCapacity = blockCapacity;
            this.availableCapacity = availableCapacity;
            this.numInterleavesets = numInterleavesets;
            this.numNamespaces = numNamespaces;
        }

        @versionClass(value=version12.class)
        public int getNumDimms() {
            return this.numDimms;
        }

        @versionClass(value=version12.class)
        public void setNumDimms(int numDimms) {
            this.numDimms = numDimms;
        }

        @versionClass(value=version12.class)
        @localizable
        public String getHealthStatus() {
            return this.healthStatus;
        }

        @versionClass(value=version12.class)
        @localizable
        public void setHealthStatus(String healthStatus) {
            this.healthStatus = healthStatus;
        }

        @versionClass(value=version12.class)
        public long getTotalCapacity() {
            return this.totalCapacity;
        }

        @versionClass(value=version12.class)
        public void setTotalCapacity(long totalCapacity) {
            this.totalCapacity = totalCapacity;
        }

        @versionClass(value=version12.class)
        public long getPersistentCapacity() {
            return this.persistentCapacity;
        }

        @versionClass(value=version12.class)
        public void setPersistentCapacity(long persistentCapacity) {
            this.persistentCapacity = persistentCapacity;
        }

        @versionClass(value=version12.class)
        public long getBlockCapacity() {
            return this.blockCapacity;
        }

        @versionClass(value=version12.class)
        public void setBlockCapacity(long blockCapacity) {
            this.blockCapacity = blockCapacity;
        }

        @versionClass(value=version12.class)
        public long getAvailableCapacity() {
            return this.availableCapacity;
        }

        @versionClass(value=version12.class)
        public void setAvailableCapacity(long availableCapacity) {
            this.availableCapacity = availableCapacity;
        }

        @versionClass(value=version12.class)
        public int getNumInterleavesets() {
            return this.numInterleavesets;
        }

        @versionClass(value=version12.class)
        public void setNumInterleavesets(int numInterleavesets) {
            this.numInterleavesets = numInterleavesets;
        }

        @versionClass(value=version12.class)
        public int getNumNamespaces() {
            return this.numNamespaces;
        }

        @versionClass(value=version12.class)
        public void setNumNamespaces(int numNamespaces) {
            this.numNamespaces = numNamespaces;
        }

        public String toString() {
            StringBuilder objString = new StringBuilder(400);
            objString.append("(vim.host.Summary) {\n");
            objString.append("   ");
            objString.append("dynamicType = ");
            objString.append(this.getDynamicType());
            objString.append(",\n");
            objString.append("   ");
            objString.append("dynamicProperty = ");
            if (this.getDynamicProperty() == null) {
                objString.append("null");
            } else {
                objString.append("(vmodl.DynamicProperty) [\n");
                for (int i = 0; i < this.getDynamicProperty().length; ++i) {
                    objString.append("      ");
                    objString.append(StringUtil.indent((String)("" + this.getDynamicProperty()[i]), (boolean)true));
                    if (i < this.getDynamicProperty().length - 1) {
                        objString.append(",");
                    }
                    objString.append("\n");
                }
                objString.append("   ");
                objString.append("]");
            }
            objString.append(",\n");
            objString.append("   ");
            objString.append("numDimms = ");
            objString.append(this.getNumDimms());
            objString.append(",\n");
            objString.append("   ");
            objString.append("healthStatus = ");
            objString.append(this.getHealthStatus());
            objString.append(",\n");
            objString.append("   ");
            objString.append("totalCapacity = ");
            objString.append(this.getTotalCapacity());
            objString.append(",\n");
            objString.append("   ");
            objString.append("persistentCapacity = ");
            objString.append(this.getPersistentCapacity());
            objString.append(",\n");
            objString.append("   ");
            objString.append("blockCapacity = ");
            objString.append(this.getBlockCapacity());
            objString.append(",\n");
            objString.append("   ");
            objString.append("availableCapacity = ");
            objString.append(this.getAvailableCapacity());
            objString.append(",\n");
            objString.append("   ");
            objString.append("numInterleavesets = ");
            objString.append(this.getNumInterleavesets());
            objString.append(",\n");
            objString.append("   ");
            objString.append("numNamespaces = ");
            objString.append(this.getNumNamespaces());
            objString.append("\n}");
            return objString.toString();
        }
    }

    @versionClass(value=version12.class)
    @wsdlName(value="NvdimmRegionInfo")
    @data
    @propertyOrder(value={"regionId", "setId", "rangeType", "startAddr", "size", "offset"})
    public static class RegionInfo
    extends DynamicDataImpl {
        private static final long serialVersionUID = 1L;
        public int regionId;
        public int setId;
        public String rangeType;
        public long startAddr;
        public long size;
        public long offset;

        public RegionInfo() {
        }

        public RegionInfo(int regionId, int setId, String rangeType, long startAddr, long size, long offset) {
            this.regionId = regionId;
            this.setId = setId;
            this.rangeType = rangeType;
            this.startAddr = startAddr;
            this.size = size;
            this.offset = offset;
        }

        @versionClass(value=version12.class)
        public int getRegionId() {
            return this.regionId;
        }

        @versionClass(value=version12.class)
        public void setRegionId(int regionId) {
            this.regionId = regionId;
        }

        @versionClass(value=version12.class)
        public int getSetId() {
            return this.setId;
        }

        @versionClass(value=version12.class)
        public void setSetId(int setId) {
            this.setId = setId;
        }

        @versionClass(value=version12.class)
        public String getRangeType() {
            return this.rangeType;
        }

        @versionClass(value=version12.class)
        public void setRangeType(String rangeType) {
            this.rangeType = rangeType;
        }

        @versionClass(value=version12.class)
        public long getStartAddr() {
            return this.startAddr;
        }

        @versionClass(value=version12.class)
        public void setStartAddr(long startAddr) {
            this.startAddr = startAddr;
        }

        @versionClass(value=version12.class)
        public long getSize() {
            return this.size;
        }

        @versionClass(value=version12.class)
        public void setSize(long size) {
            this.size = size;
        }

        @versionClass(value=version12.class)
        public long getOffset() {
            return this.offset;
        }

        @versionClass(value=version12.class)
        public void setOffset(long offset) {
            this.offset = offset;
        }

        public String toString() {
            StringBuilder objString = new StringBuilder(320);
            objString.append("(vim.host.RegionInfo) {\n");
            objString.append("   ");
            objString.append("dynamicType = ");
            objString.append(this.getDynamicType());
            objString.append(",\n");
            objString.append("   ");
            objString.append("dynamicProperty = ");
            if (this.getDynamicProperty() == null) {
                objString.append("null");
            } else {
                objString.append("(vmodl.DynamicProperty) [\n");
                for (int i = 0; i < this.getDynamicProperty().length; ++i) {
                    objString.append("      ");
                    objString.append(StringUtil.indent((String)("" + this.getDynamicProperty()[i]), (boolean)true));
                    if (i < this.getDynamicProperty().length - 1) {
                        objString.append(",");
                    }
                    objString.append("\n");
                }
                objString.append("   ");
                objString.append("]");
            }
            objString.append(",\n");
            objString.append("   ");
            objString.append("regionId = ");
            objString.append(this.getRegionId());
            objString.append(",\n");
            objString.append("   ");
            objString.append("setId = ");
            objString.append(this.getSetId());
            objString.append(",\n");
            objString.append("   ");
            objString.append("rangeType = ");
            objString.append(this.getRangeType());
            objString.append(",\n");
            objString.append("   ");
            objString.append("startAddr = ");
            objString.append(this.getStartAddr());
            objString.append(",\n");
            objString.append("   ");
            objString.append("size = ");
            objString.append(this.getSize());
            objString.append(",\n");
            objString.append("   ");
            objString.append("offset = ");
            objString.append(this.getOffset());
            objString.append("\n}");
            return objString.toString();
        }
    }

    @versionClass(value=version12.class)
    @wsdlName(value="NvdimmRangeType")
    public static enum RangeType {
        volatileRange,
        persistentRange,
        controlRange,
        blockRange,
        volatileVirtualDiskRange,
        volatileVirtualCDRange,
        persistentVirtualDiskRange,
        persistentVirtualCDRange;

    }

    @versionClass(value=version13.class)
    @wsdlName(value="NvdimmPMemNamespaceCreateSpec")
    @data
    @propertyOrder(value={"friendlyName", "size", "interleavesetID"})
    public static class PMemNamespaceCreateSpec
    extends DynamicDataImpl {
        private static final long serialVersionUID = 1L;
        public String friendlyName;
        public long size;
        public int interleavesetID;

        public PMemNamespaceCreateSpec() {
        }

        public PMemNamespaceCreateSpec(String friendlyName, long size, int interleavesetID) {
            this.friendlyName = friendlyName;
            this.size = size;
            this.interleavesetID = interleavesetID;
        }

        @optional
        @versionClass(value=version13.class)
        public String getFriendlyName() {
            return this.friendlyName;
        }

        @optional
        @versionClass(value=version13.class)
        public void setFriendlyName(String friendlyName) {
            this.friendlyName = friendlyName;
        }

        @versionClass(value=version13.class)
        public long getSize() {
            return this.size;
        }

        @versionClass(value=version13.class)
        public void setSize(long size) {
            this.size = size;
        }

        @versionClass(value=version13.class)
        public int getInterleavesetID() {
            return this.interleavesetID;
        }

        @versionClass(value=version13.class)
        public void setInterleavesetID(int interleavesetID) {
            this.interleavesetID = interleavesetID;
        }

        public String toString() {
            StringBuilder objString = new StringBuilder(200);
            objString.append("(vim.host.PMemNamespaceCreateSpec) {\n");
            objString.append("   ");
            objString.append("dynamicType = ");
            objString.append(this.getDynamicType());
            objString.append(",\n");
            objString.append("   ");
            objString.append("dynamicProperty = ");
            if (this.getDynamicProperty() == null) {
                objString.append("null");
            } else {
                objString.append("(vmodl.DynamicProperty) [\n");
                for (int i = 0; i < this.getDynamicProperty().length; ++i) {
                    objString.append("      ");
                    objString.append(StringUtil.indent((String)("" + this.getDynamicProperty()[i]), (boolean)true));
                    if (i < this.getDynamicProperty().length - 1) {
                        objString.append(",");
                    }
                    objString.append("\n");
                }
                objString.append("   ");
                objString.append("]");
            }
            objString.append(",\n");
            objString.append("   ");
            objString.append("friendlyName = ");
            objString.append(this.getFriendlyName());
            objString.append(",\n");
            objString.append("   ");
            objString.append("size = ");
            objString.append(this.getSize());
            objString.append(",\n");
            objString.append("   ");
            objString.append("interleavesetID = ");
            objString.append(this.getInterleavesetID());
            objString.append("\n}");
            return objString.toString();
        }
    }

    @versionClass(value=version12.class)
    @wsdlName(value="NvdimmSystemInfo")
    @data
    @propertyOrder(value={"summary", "dimms", "dimmInfo", "interleaveSet", "iSetInfo", "namespace", "nsInfo", "nsDetails"})
    public static class NvdimmSystemInfo
    extends DynamicDataImpl {
        private static final long serialVersionUID = 1L;
        public Summary summary;
        public int[] dimms;
        public DimmInfo[] dimmInfo;
        public int[] interleaveSet;
        public InterleaveSetInfo[] iSetInfo;
        public Guid[] namespace;
        public NamespaceInfo[] nsInfo;
        public NamespaceDetails[] nsDetails;

        public NvdimmSystemInfo() {
        }

        public NvdimmSystemInfo(Summary summary, int[] dimms, DimmInfo[] dimmInfo, int[] interleaveSet, InterleaveSetInfo[] iSetInfo, Guid[] namespace, NamespaceInfo[] nsInfo, NamespaceDetails[] nsDetails) {
            this.summary = summary;
            this.dimms = dimms;
            this.dimmInfo = dimmInfo;
            this.interleaveSet = interleaveSet;
            this.iSetInfo = iSetInfo;
            this.namespace = namespace;
            this.nsInfo = nsInfo;
            this.nsDetails = nsDetails;
        }

        @optional
        @versionClass(value=version12.class)
        public Summary getSummary() {
            return this.summary;
        }

        @optional
        @versionClass(value=version12.class)
        public void setSummary(Summary summary) {
            this.summary = summary;
        }

        @map
        @optional
        @versionClass(value=version12.class)
        public int[] getDimms() {
            return this.dimms;
        }

        @map
        @optional
        @versionClass(value=version12.class)
        public void setDimms(int[] dimms) {
            this.dimms = dimms;
        }

        @list
        @optional
        @versionClass(value=version12.class)
        public DimmInfo[] getDimmInfo() {
            return this.dimmInfo;
        }

        @list
        @optional
        @versionClass(value=version12.class)
        public void setDimmInfo(DimmInfo[] dimmInfo) {
            this.dimmInfo = dimmInfo;
        }

        @map
        @optional
        @versionClass(value=version12.class)
        public int[] getInterleaveSet() {
            return this.interleaveSet;
        }

        @map
        @optional
        @versionClass(value=version12.class)
        public void setInterleaveSet(int[] interleaveSet) {
            this.interleaveSet = interleaveSet;
        }

        @list
        @optional
        @versionClass(value=version12.class)
        public InterleaveSetInfo[] getISetInfo() {
            return this.iSetInfo;
        }

        @list
        @optional
        @versionClass(value=version12.class)
        public void setISetInfo(InterleaveSetInfo[] iSetInfo) {
            this.iSetInfo = iSetInfo;
        }

        @list
        @optional
        @versionClass(value=version12.class)
        public Guid[] getNamespace() {
            return this.namespace;
        }

        @list
        @optional
        @versionClass(value=version12.class)
        public void setNamespace(Guid[] namespace) {
            this.namespace = namespace;
        }

        @list
        @optional
        @versionClass(value=version12.class)
        public NamespaceInfo[] getNsInfo() {
            return this.nsInfo;
        }

        @list
        @optional
        @versionClass(value=version12.class)
        public void setNsInfo(NamespaceInfo[] nsInfo) {
            this.nsInfo = nsInfo;
        }

        @list
        @optional
        @versionClass(value=version13.class)
        public NamespaceDetails[] getNsDetails() {
            return this.nsDetails;
        }

        @list
        @optional
        @versionClass(value=version13.class)
        public void setNsDetails(NamespaceDetails[] nsDetails) {
            this.nsDetails = nsDetails;
        }

        public String toString() {
            int i;
            StringBuilder objString = new StringBuilder(400);
            objString.append("(vim.host.NvdimmSystemInfo) {\n");
            objString.append("   ");
            objString.append("dynamicType = ");
            objString.append(this.getDynamicType());
            objString.append(",\n");
            objString.append("   ");
            objString.append("dynamicProperty = ");
            if (this.getDynamicProperty() == null) {
                objString.append("null");
            } else {
                objString.append("(vmodl.DynamicProperty) [\n");
                for (i = 0; i < this.getDynamicProperty().length; ++i) {
                    objString.append("      ");
                    objString.append(StringUtil.indent((String)("" + this.getDynamicProperty()[i]), (boolean)true));
                    if (i < this.getDynamicProperty().length - 1) {
                        objString.append(",");
                    }
                    objString.append("\n");
                }
                objString.append("   ");
                objString.append("]");
            }
            objString.append(",\n");
            objString.append("   ");
            objString.append("summary = ");
            if (this.getSummary() == null) {
                objString.append("null");
            } else {
                objString.append(StringUtil.indent((String)("" + (Object)((Object)this.getSummary())), (boolean)false));
            }
            objString.append(",\n");
            objString.append("   ");
            objString.append("dimms = ");
            if (this.getDimms() == null) {
                objString.append("null");
            } else {
                objString.append("(INT) [\n");
                for (i = 0; i < this.getDimms().length; ++i) {
                    objString.append("      ");
                    objString.append(this.getDimms()[i]);
                    if (i < this.getDimms().length - 1) {
                        objString.append(",");
                    }
                    objString.append("\n");
                }
                objString.append("   ");
                objString.append("]");
            }
            objString.append(",\n");
            objString.append("   ");
            objString.append("dimmInfo = ");
            if (this.getDimmInfo() == null) {
                objString.append("null");
            } else {
                objString.append("(vim.host.DimmInfo) [\n");
                for (i = 0; i < this.getDimmInfo().length; ++i) {
                    objString.append("      ");
                    objString.append(StringUtil.indent((String)("" + (Object)((Object)this.getDimmInfo()[i])), (boolean)true));
                    if (i < this.getDimmInfo().length - 1) {
                        objString.append(",");
                    }
                    objString.append("\n");
                }
                objString.append("   ");
                objString.append("]");
            }
            objString.append(",\n");
            objString.append("   ");
            objString.append("interleaveSet = ");
            if (this.getInterleaveSet() == null) {
                objString.append("null");
            } else {
                objString.append("(INT) [\n");
                for (i = 0; i < this.getInterleaveSet().length; ++i) {
                    objString.append("      ");
                    objString.append(this.getInterleaveSet()[i]);
                    if (i < this.getInterleaveSet().length - 1) {
                        objString.append(",");
                    }
                    objString.append("\n");
                }
                objString.append("   ");
                objString.append("]");
            }
            objString.append(",\n");
            objString.append("   ");
            objString.append("iSetInfo = ");
            if (this.getISetInfo() == null) {
                objString.append("null");
            } else {
                objString.append("(vim.host.InterleaveSetInfo) [\n");
                for (i = 0; i < this.getISetInfo().length; ++i) {
                    objString.append("      ");
                    objString.append(StringUtil.indent((String)("" + (Object)((Object)this.getISetInfo()[i])), (boolean)true));
                    if (i < this.getISetInfo().length - 1) {
                        objString.append(",");
                    }
                    objString.append("\n");
                }
                objString.append("   ");
                objString.append("]");
            }
            objString.append(",\n");
            objString.append("   ");
            objString.append("namespace = ");
            if (this.getNamespace() == null) {
                objString.append("null");
            } else {
                objString.append("(vim.host.Guid) [\n");
                for (i = 0; i < this.getNamespace().length; ++i) {
                    objString.append("      ");
                    objString.append(StringUtil.indent((String)("" + (Object)((Object)this.getNamespace()[i])), (boolean)true));
                    if (i < this.getNamespace().length - 1) {
                        objString.append(",");
                    }
                    objString.append("\n");
                }
                objString.append("   ");
                objString.append("]");
            }
            objString.append(",\n");
            objString.append("   ");
            objString.append("nsInfo = ");
            if (this.getNsInfo() == null) {
                objString.append("null");
            } else {
                objString.append("(vim.host.NamespaceInfo) [\n");
                for (i = 0; i < this.getNsInfo().length; ++i) {
                    objString.append("      ");
                    objString.append(StringUtil.indent((String)("" + (Object)((Object)this.getNsInfo()[i])), (boolean)true));
                    if (i < this.getNsInfo().length - 1) {
                        objString.append(",");
                    }
                    objString.append("\n");
                }
                objString.append("   ");
                objString.append("]");
            }
            objString.append(",\n");
            objString.append("   ");
            objString.append("nsDetails = ");
            if (this.getNsDetails() == null) {
                objString.append("null");
            } else {
                objString.append("(vim.host.NamespaceDetails) [\n");
                for (i = 0; i < this.getNsDetails().length; ++i) {
                    objString.append("      ");
                    objString.append(StringUtil.indent((String)("" + (Object)((Object)this.getNsDetails()[i])), (boolean)true));
                    if (i < this.getNsDetails().length - 1) {
                        objString.append(",");
                    }
                    objString.append("\n");
                }
                objString.append("   ");
                objString.append("]");
            }
            objString.append("\n}");
            return objString.toString();
        }
    }

    @versionClass(value=version12.class)
    @wsdlName(value="NvdimmNamespaceType")
    public static enum NamespaceType {
        blockNamespace,
        persistentNamespace;

    }

    @versionClass(value=version12.class)
    @wsdlName(value="NvdimmNamespaceInfo")
    @data
    @propertyOrder(value={"uuid", "friendlyName", "blockSize", "blockCount", "type", "namespaceHealthStatus", "locationID", "state"})
    public static class NamespaceInfo
    extends DynamicDataImpl {
        private static final long serialVersionUID = 1L;
        public String uuid;
        public String friendlyName;
        public long blockSize;
        public long blockCount;
        public String type;
        public String namespaceHealthStatus;
        public int locationID;
        public String state;

        public NamespaceInfo() {
        }

        public NamespaceInfo(String uuid, String friendlyName, long blockSize, long blockCount, String type, String namespaceHealthStatus, int locationID, String state) {
            this.uuid = uuid;
            this.friendlyName = friendlyName;
            this.blockSize = blockSize;
            this.blockCount = blockCount;
            this.type = type;
            this.namespaceHealthStatus = namespaceHealthStatus;
            this.locationID = locationID;
            this.state = state;
        }

        @versionClass(value=version12.class)
        public String getUuid() {
            return this.uuid;
        }

        @versionClass(value=version12.class)
        public void setUuid(String uuid) {
            this.uuid = uuid;
        }

        @versionClass(value=version12.class)
        public String getFriendlyName() {
            return this.friendlyName;
        }

        @versionClass(value=version12.class)
        public void setFriendlyName(String friendlyName) {
            this.friendlyName = friendlyName;
        }

        @versionClass(value=version12.class)
        public long getBlockSize() {
            return this.blockSize;
        }

        @versionClass(value=version12.class)
        public void setBlockSize(long blockSize) {
            this.blockSize = blockSize;
        }

        @versionClass(value=version12.class)
        public long getBlockCount() {
            return this.blockCount;
        }

        @versionClass(value=version12.class)
        public void setBlockCount(long blockCount) {
            this.blockCount = blockCount;
        }

        @versionClass(value=version12.class)
        public String getType() {
            return this.type;
        }

        @versionClass(value=version12.class)
        public void setType(String type) {
            this.type = type;
        }

        @versionClass(value=version12.class)
        public String getNamespaceHealthStatus() {
            return this.namespaceHealthStatus;
        }

        @versionClass(value=version12.class)
        public void setNamespaceHealthStatus(String namespaceHealthStatus) {
            this.namespaceHealthStatus = namespaceHealthStatus;
        }

        @versionClass(value=version12.class)
        public int getLocationID() {
            return this.locationID;
        }

        @versionClass(value=version12.class)
        public void setLocationID(int locationID) {
            this.locationID = locationID;
        }

        @versionClass(value=version12.class)
        public String getState() {
            return this.state;
        }

        @versionClass(value=version12.class)
        public void setState(String state) {
            this.state = state;
        }

        public String toString() {
            StringBuilder objString = new StringBuilder(400);
            objString.append("(vim.host.NamespaceInfo) {\n");
            objString.append("   ");
            objString.append("dynamicType = ");
            objString.append(this.getDynamicType());
            objString.append(",\n");
            objString.append("   ");
            objString.append("dynamicProperty = ");
            if (this.getDynamicProperty() == null) {
                objString.append("null");
            } else {
                objString.append("(vmodl.DynamicProperty) [\n");
                for (int i = 0; i < this.getDynamicProperty().length; ++i) {
                    objString.append("      ");
                    objString.append(StringUtil.indent((String)("" + this.getDynamicProperty()[i]), (boolean)true));
                    if (i < this.getDynamicProperty().length - 1) {
                        objString.append(",");
                    }
                    objString.append("\n");
                }
                objString.append("   ");
                objString.append("]");
            }
            objString.append(",\n");
            objString.append("   ");
            objString.append("uuid = ");
            objString.append(this.getUuid());
            objString.append(",\n");
            objString.append("   ");
            objString.append("friendlyName = ");
            objString.append(this.getFriendlyName());
            objString.append(",\n");
            objString.append("   ");
            objString.append("blockSize = ");
            objString.append(this.getBlockSize());
            objString.append(",\n");
            objString.append("   ");
            objString.append("blockCount = ");
            objString.append(this.getBlockCount());
            objString.append(",\n");
            objString.append("   ");
            objString.append("type = ");
            objString.append(this.getType());
            objString.append(",\n");
            objString.append("   ");
            objString.append("namespaceHealthStatus = ");
            objString.append(this.getNamespaceHealthStatus());
            objString.append(",\n");
            objString.append("   ");
            objString.append("locationID = ");
            objString.append(this.getLocationID());
            objString.append(",\n");
            objString.append("   ");
            objString.append("state = ");
            objString.append(this.getState());
            objString.append("\n}");
            return objString.toString();
        }

        @versionClass(value=version12.class)
        @wsdlName(value="NvdimmNamespaceState")
        public static enum NamespaceState {
            invalid,
            notInUse,
            inUse;

        }

        @versionClass(value=version12.class)
        @wsdlName(value="NvdimmNamespaceHealthStatus")
        public static enum NamespaceHealthStatus {
            normal,
            missing,
            labelMissing,
            interleaveBroken,
            labelInconsistent,
            bttCorrupt,
            badBlockSize;

        }
    }

    @versionClass(value=version13.class)
    @wsdlName(value="NvdimmNamespaceDetails")
    @data
    @propertyOrder(value={"uuid", "friendlyName", "size", "type", "namespaceHealthStatus", "interleavesetID", "state"})
    public static class NamespaceDetails
    extends DynamicDataImpl {
        private static final long serialVersionUID = 1L;
        public String uuid;
        public String friendlyName;
        public long size;
        public String type;
        public String namespaceHealthStatus;
        public int interleavesetID;
        public String state;

        public NamespaceDetails() {
        }

        public NamespaceDetails(String uuid, String friendlyName, long size, String type, String namespaceHealthStatus, int interleavesetID, String state) {
            this.uuid = uuid;
            this.friendlyName = friendlyName;
            this.size = size;
            this.type = type;
            this.namespaceHealthStatus = namespaceHealthStatus;
            this.interleavesetID = interleavesetID;
            this.state = state;
        }

        @versionClass(value=version13.class)
        public String getUuid() {
            return this.uuid;
        }

        @versionClass(value=version13.class)
        public void setUuid(String uuid) {
            this.uuid = uuid;
        }

        @versionClass(value=version13.class)
        public String getFriendlyName() {
            return this.friendlyName;
        }

        @versionClass(value=version13.class)
        public void setFriendlyName(String friendlyName) {
            this.friendlyName = friendlyName;
        }

        @versionClass(value=version13.class)
        public long getSize() {
            return this.size;
        }

        @versionClass(value=version13.class)
        public void setSize(long size) {
            this.size = size;
        }

        @versionClass(value=version13.class)
        public String getType() {
            return this.type;
        }

        @versionClass(value=version13.class)
        public void setType(String type) {
            this.type = type;
        }

        @versionClass(value=version13.class)
        public String getNamespaceHealthStatus() {
            return this.namespaceHealthStatus;
        }

        @versionClass(value=version13.class)
        public void setNamespaceHealthStatus(String namespaceHealthStatus) {
            this.namespaceHealthStatus = namespaceHealthStatus;
        }

        @versionClass(value=version13.class)
        public int getInterleavesetID() {
            return this.interleavesetID;
        }

        @versionClass(value=version13.class)
        public void setInterleavesetID(int interleavesetID) {
            this.interleavesetID = interleavesetID;
        }

        @versionClass(value=version13.class)
        public String getState() {
            return this.state;
        }

        @versionClass(value=version13.class)
        public void setState(String state) {
            this.state = state;
        }

        public String toString() {
            StringBuilder objString = new StringBuilder(360);
            objString.append("(vim.host.NamespaceDetails) {\n");
            objString.append("   ");
            objString.append("dynamicType = ");
            objString.append(this.getDynamicType());
            objString.append(",\n");
            objString.append("   ");
            objString.append("dynamicProperty = ");
            if (this.getDynamicProperty() == null) {
                objString.append("null");
            } else {
                objString.append("(vmodl.DynamicProperty) [\n");
                for (int i = 0; i < this.getDynamicProperty().length; ++i) {
                    objString.append("      ");
                    objString.append(StringUtil.indent((String)("" + this.getDynamicProperty()[i]), (boolean)true));
                    if (i < this.getDynamicProperty().length - 1) {
                        objString.append(",");
                    }
                    objString.append("\n");
                }
                objString.append("   ");
                objString.append("]");
            }
            objString.append(",\n");
            objString.append("   ");
            objString.append("uuid = ");
            objString.append(this.getUuid());
            objString.append(",\n");
            objString.append("   ");
            objString.append("friendlyName = ");
            objString.append(this.getFriendlyName());
            objString.append(",\n");
            objString.append("   ");
            objString.append("size = ");
            objString.append(this.getSize());
            objString.append(",\n");
            objString.append("   ");
            objString.append("type = ");
            objString.append(this.getType());
            objString.append(",\n");
            objString.append("   ");
            objString.append("namespaceHealthStatus = ");
            objString.append(this.getNamespaceHealthStatus());
            objString.append(",\n");
            objString.append("   ");
            objString.append("interleavesetID = ");
            objString.append(this.getInterleavesetID());
            objString.append(",\n");
            objString.append("   ");
            objString.append("state = ");
            objString.append(this.getState());
            objString.append("\n}");
            return objString.toString();
        }

        @versionClass(value=version13.class)
        @wsdlName(value="NvdimmNamespaceDetailsState")
        public static enum NamespaceState {
            invalid,
            notInUse,
            inUse;

        }

        @versionClass(value=version13.class)
        @wsdlName(value="NvdimmNamespaceDetailsHealthStatus")
        public static enum NamespaceHealthStatus {
            normal,
            missing,
            labelMissing,
            interleaveBroken,
            labelInconsistent;

        }
    }

    @versionClass(value=version12.class)
    @wsdlName(value="NvdimmNamespaceDeleteSpec")
    @data
    @propertyOrder(value={"uuid"})
    public static class NamespaceDeleteSpec
    extends DynamicDataImpl {
        private static final long serialVersionUID = 1L;
        public String uuid;

        public NamespaceDeleteSpec() {
        }

        public NamespaceDeleteSpec(String uuid) {
            this.uuid = uuid;
        }

        @versionClass(value=version12.class)
        public String getUuid() {
            return this.uuid;
        }

        @versionClass(value=version12.class)
        public void setUuid(String uuid) {
            this.uuid = uuid;
        }

        public String toString() {
            StringBuilder objString = new StringBuilder(120);
            objString.append("(vim.host.NamespaceDeleteSpec) {\n");
            objString.append("   ");
            objString.append("dynamicType = ");
            objString.append(this.getDynamicType());
            objString.append(",\n");
            objString.append("   ");
            objString.append("dynamicProperty = ");
            if (this.getDynamicProperty() == null) {
                objString.append("null");
            } else {
                objString.append("(vmodl.DynamicProperty) [\n");
                for (int i = 0; i < this.getDynamicProperty().length; ++i) {
                    objString.append("      ");
                    objString.append(StringUtil.indent((String)("" + this.getDynamicProperty()[i]), (boolean)true));
                    if (i < this.getDynamicProperty().length - 1) {
                        objString.append(",");
                    }
                    objString.append("\n");
                }
                objString.append("   ");
                objString.append("]");
            }
            objString.append(",\n");
            objString.append("   ");
            objString.append("uuid = ");
            objString.append(this.getUuid());
            objString.append("\n}");
            return objString.toString();
        }
    }

    @versionClass(value=version12.class)
    @wsdlName(value="NvdimmNamespaceCreateSpec")
    @data
    @propertyOrder(value={"friendlyName", "blockSize", "blockCount", "type", "locationID"})
    public static class NamespaceCreateSpec
    extends DynamicDataImpl {
        private static final long serialVersionUID = 1L;
        public String friendlyName;
        public long blockSize;
        public long blockCount;
        public String type;
        public int locationID;

        public NamespaceCreateSpec() {
        }

        public NamespaceCreateSpec(String friendlyName, long blockSize, long blockCount, String type, int locationID) {
            this.friendlyName = friendlyName;
            this.blockSize = blockSize;
            this.blockCount = blockCount;
            this.type = type;
            this.locationID = locationID;
        }

        @optional
        @versionClass(value=version12.class)
        public String getFriendlyName() {
            return this.friendlyName;
        }

        @optional
        @versionClass(value=version12.class)
        public void setFriendlyName(String friendlyName) {
            this.friendlyName = friendlyName;
        }

        @versionClass(value=version12.class)
        public long getBlockSize() {
            return this.blockSize;
        }

        @versionClass(value=version12.class)
        public void setBlockSize(long blockSize) {
            this.blockSize = blockSize;
        }

        @versionClass(value=version12.class)
        public long getBlockCount() {
            return this.blockCount;
        }

        @versionClass(value=version12.class)
        public void setBlockCount(long blockCount) {
            this.blockCount = blockCount;
        }

        @versionClass(value=version12.class)
        public String getType() {
            return this.type;
        }

        @versionClass(value=version12.class)
        public void setType(String type) {
            this.type = type;
        }

        @versionClass(value=version12.class)
        public int getLocationID() {
            return this.locationID;
        }

        @versionClass(value=version12.class)
        public void setLocationID(int locationID) {
            this.locationID = locationID;
        }

        public String toString() {
            StringBuilder objString = new StringBuilder(280);
            objString.append("(vim.host.NamespaceCreateSpec) {\n");
            objString.append("   ");
            objString.append("dynamicType = ");
            objString.append(this.getDynamicType());
            objString.append(",\n");
            objString.append("   ");
            objString.append("dynamicProperty = ");
            if (this.getDynamicProperty() == null) {
                objString.append("null");
            } else {
                objString.append("(vmodl.DynamicProperty) [\n");
                for (int i = 0; i < this.getDynamicProperty().length; ++i) {
                    objString.append("      ");
                    objString.append(StringUtil.indent((String)("" + this.getDynamicProperty()[i]), (boolean)true));
                    if (i < this.getDynamicProperty().length - 1) {
                        objString.append(",");
                    }
                    objString.append("\n");
                }
                objString.append("   ");
                objString.append("]");
            }
            objString.append(",\n");
            objString.append("   ");
            objString.append("friendlyName = ");
            objString.append(this.getFriendlyName());
            objString.append(",\n");
            objString.append("   ");
            objString.append("blockSize = ");
            objString.append(this.getBlockSize());
            objString.append(",\n");
            objString.append("   ");
            objString.append("blockCount = ");
            objString.append(this.getBlockCount());
            objString.append(",\n");
            objString.append("   ");
            objString.append("type = ");
            objString.append(this.getType());
            objString.append(",\n");
            objString.append("   ");
            objString.append("locationID = ");
            objString.append(this.getLocationID());
            objString.append("\n}");
            return objString.toString();
        }
    }

    @versionClass(value=version12.class)
    @wsdlName(value="NvdimmInterleaveSetInfo")
    @data
    @propertyOrder(value={"setId", "rangeType", "baseAddress", "size", "availableSize", "deviceList", "state"})
    public static class InterleaveSetInfo
    extends DynamicDataImpl {
        private static final long serialVersionUID = 1L;
        public int setId;
        public String rangeType;
        public long baseAddress;
        public long size;
        public long availableSize;
        public int[] deviceList;
        public String state;

        public InterleaveSetInfo() {
        }

        public InterleaveSetInfo(int setId, String rangeType, long baseAddress, long size, long availableSize, int[] deviceList, String state) {
            this.setId = setId;
            this.rangeType = rangeType;
            this.baseAddress = baseAddress;
            this.size = size;
            this.availableSize = availableSize;
            this.deviceList = deviceList;
            this.state = state;
        }

        @versionClass(value=version12.class)
        public int getSetId() {
            return this.setId;
        }

        @versionClass(value=version12.class)
        public void setSetId(int setId) {
            this.setId = setId;
        }

        @versionClass(value=version12.class)
        public String getRangeType() {
            return this.rangeType;
        }

        @versionClass(value=version12.class)
        public void setRangeType(String rangeType) {
            this.rangeType = rangeType;
        }

        @versionClass(value=version12.class)
        public long getBaseAddress() {
            return this.baseAddress;
        }

        @versionClass(value=version12.class)
        public void setBaseAddress(long baseAddress) {
            this.baseAddress = baseAddress;
        }

        @versionClass(value=version12.class)
        public long getSize() {
            return this.size;
        }

        @versionClass(value=version12.class)
        public void setSize(long size) {
            this.size = size;
        }

        @versionClass(value=version12.class)
        public long getAvailableSize() {
            return this.availableSize;
        }

        @versionClass(value=version12.class)
        public void setAvailableSize(long availableSize) {
            this.availableSize = availableSize;
        }

        @map
        @optional
        @versionClass(value=version12.class)
        public int[] getDeviceList() {
            return this.deviceList;
        }

        @map
        @optional
        @versionClass(value=version12.class)
        public void setDeviceList(int[] deviceList) {
            this.deviceList = deviceList;
        }

        @versionClass(value=version12.class)
        public String getState() {
            return this.state;
        }

        @versionClass(value=version12.class)
        public void setState(String state) {
            this.state = state;
        }

        public String toString() {
            int i;
            StringBuilder objString = new StringBuilder(360);
            objString.append("(vim.host.InterleaveSetInfo) {\n");
            objString.append("   ");
            objString.append("dynamicType = ");
            objString.append(this.getDynamicType());
            objString.append(",\n");
            objString.append("   ");
            objString.append("dynamicProperty = ");
            if (this.getDynamicProperty() == null) {
                objString.append("null");
            } else {
                objString.append("(vmodl.DynamicProperty) [\n");
                for (i = 0; i < this.getDynamicProperty().length; ++i) {
                    objString.append("      ");
                    objString.append(StringUtil.indent((String)("" + this.getDynamicProperty()[i]), (boolean)true));
                    if (i < this.getDynamicProperty().length - 1) {
                        objString.append(",");
                    }
                    objString.append("\n");
                }
                objString.append("   ");
                objString.append("]");
            }
            objString.append(",\n");
            objString.append("   ");
            objString.append("setId = ");
            objString.append(this.getSetId());
            objString.append(",\n");
            objString.append("   ");
            objString.append("rangeType = ");
            objString.append(this.getRangeType());
            objString.append(",\n");
            objString.append("   ");
            objString.append("baseAddress = ");
            objString.append(this.getBaseAddress());
            objString.append(",\n");
            objString.append("   ");
            objString.append("size = ");
            objString.append(this.getSize());
            objString.append(",\n");
            objString.append("   ");
            objString.append("availableSize = ");
            objString.append(this.getAvailableSize());
            objString.append(",\n");
            objString.append("   ");
            objString.append("deviceList = ");
            if (this.getDeviceList() == null) {
                objString.append("null");
            } else {
                objString.append("(INT) [\n");
                for (i = 0; i < this.getDeviceList().length; ++i) {
                    objString.append("      ");
                    objString.append(this.getDeviceList()[i]);
                    if (i < this.getDeviceList().length - 1) {
                        objString.append(",");
                    }
                    objString.append("\n");
                }
                objString.append("   ");
                objString.append("]");
            }
            objString.append(",\n");
            objString.append("   ");
            objString.append("state = ");
            objString.append(this.getState());
            objString.append("\n}");
            return objString.toString();
        }

        @versionClass(value=version12.class)
        @wsdlName(value="NvdimmInterleaveSetState")
        public static enum InterleaveSetState {
            invalid,
            active;

        }
    }

    @versionClass(value=version12.class)
    @wsdlName(value="NvdimmHealthInfo")
    @data
    @propertyOrder(value={"healthStatus", "healthInformation", "stateFlagInfo", "dimmTemperature", "dimmTemperatureThreshold", "spareBlocksPercentage", "spareBlockThreshold", "dimmLifespanPercentage", "esTemperature", "esTemperatureThreshold", "esLifespanPercentage"})
    public static class HealthInfo
    extends DynamicDataImpl {
        private static final long serialVersionUID = 1L;
        public String healthStatus;
        public String healthInformation;
        public String[] stateFlagInfo;
        public int dimmTemperature;
        public int dimmTemperatureThreshold;
        public int spareBlocksPercentage;
        public int spareBlockThreshold;
        public int dimmLifespanPercentage;
        public Integer esTemperature;
        public Integer esTemperatureThreshold;
        public Integer esLifespanPercentage;

        public HealthInfo() {
        }

        public HealthInfo(String healthStatus, String healthInformation, String[] stateFlagInfo, int dimmTemperature, int dimmTemperatureThreshold, int spareBlocksPercentage, int spareBlockThreshold, int dimmLifespanPercentage, Integer esTemperature, Integer esTemperatureThreshold, Integer esLifespanPercentage) {
            this.healthStatus = healthStatus;
            this.healthInformation = healthInformation;
            this.stateFlagInfo = stateFlagInfo;
            this.dimmTemperature = dimmTemperature;
            this.dimmTemperatureThreshold = dimmTemperatureThreshold;
            this.spareBlocksPercentage = spareBlocksPercentage;
            this.spareBlockThreshold = spareBlockThreshold;
            this.dimmLifespanPercentage = dimmLifespanPercentage;
            this.esTemperature = esTemperature;
            this.esTemperatureThreshold = esTemperatureThreshold;
            this.esLifespanPercentage = esLifespanPercentage;
        }

        @versionClass(value=version12.class)
        @localizable
        public String getHealthStatus() {
            return this.healthStatus;
        }

        @versionClass(value=version12.class)
        @localizable
        public void setHealthStatus(String healthStatus) {
            this.healthStatus = healthStatus;
        }

        @versionClass(value=version12.class)
        @localizable
        public String getHealthInformation() {
            return this.healthInformation;
        }

        @versionClass(value=version12.class)
        @localizable
        public void setHealthInformation(String healthInformation) {
            this.healthInformation = healthInformation;
        }

        @map
        @optional
        @versionClass(value=version12.class)
        public String[] getStateFlagInfo() {
            return this.stateFlagInfo;
        }

        @map
        @optional
        @versionClass(value=version12.class)
        public void setStateFlagInfo(String[] stateFlagInfo) {
            this.stateFlagInfo = stateFlagInfo;
        }

        @versionClass(value=version12.class)
        public int getDimmTemperature() {
            return this.dimmTemperature;
        }

        @versionClass(value=version12.class)
        public void setDimmTemperature(int dimmTemperature) {
            this.dimmTemperature = dimmTemperature;
        }

        @versionClass(value=version12.class)
        public int getDimmTemperatureThreshold() {
            return this.dimmTemperatureThreshold;
        }

        @versionClass(value=version12.class)
        public void setDimmTemperatureThreshold(int dimmTemperatureThreshold) {
            this.dimmTemperatureThreshold = dimmTemperatureThreshold;
        }

        @versionClass(value=version12.class)
        public int getSpareBlocksPercentage() {
            return this.spareBlocksPercentage;
        }

        @versionClass(value=version12.class)
        public void setSpareBlocksPercentage(int spareBlocksPercentage) {
            this.spareBlocksPercentage = spareBlocksPercentage;
        }

        @versionClass(value=version12.class)
        public int getSpareBlockThreshold() {
            return this.spareBlockThreshold;
        }

        @versionClass(value=version12.class)
        public void setSpareBlockThreshold(int spareBlockThreshold) {
            this.spareBlockThreshold = spareBlockThreshold;
        }

        @versionClass(value=version12.class)
        public int getDimmLifespanPercentage() {
            return this.dimmLifespanPercentage;
        }

        @versionClass(value=version12.class)
        public void setDimmLifespanPercentage(int dimmLifespanPercentage) {
            this.dimmLifespanPercentage = dimmLifespanPercentage;
        }

        @optional
        @versionClass(value=version12.class)
        public Integer getEsTemperature() {
            return this.esTemperature;
        }

        @optional
        @versionClass(value=version12.class)
        public void setEsTemperature(Integer esTemperature) {
            this.esTemperature = esTemperature;
        }

        @optional
        @versionClass(value=version12.class)
        public Integer getEsTemperatureThreshold() {
            return this.esTemperatureThreshold;
        }

        @optional
        @versionClass(value=version12.class)
        public void setEsTemperatureThreshold(Integer esTemperatureThreshold) {
            this.esTemperatureThreshold = esTemperatureThreshold;
        }

        @optional
        @versionClass(value=version12.class)
        public Integer getEsLifespanPercentage() {
            return this.esLifespanPercentage;
        }

        @optional
        @versionClass(value=version12.class)
        public void setEsLifespanPercentage(Integer esLifespanPercentage) {
            this.esLifespanPercentage = esLifespanPercentage;
        }

        public String toString() {
            int i;
            StringBuilder objString = new StringBuilder(520);
            objString.append("(vim.host.HealthInfo) {\n");
            objString.append("   ");
            objString.append("dynamicType = ");
            objString.append(this.getDynamicType());
            objString.append(",\n");
            objString.append("   ");
            objString.append("dynamicProperty = ");
            if (this.getDynamicProperty() == null) {
                objString.append("null");
            } else {
                objString.append("(vmodl.DynamicProperty) [\n");
                for (i = 0; i < this.getDynamicProperty().length; ++i) {
                    objString.append("      ");
                    objString.append(StringUtil.indent((String)("" + this.getDynamicProperty()[i]), (boolean)true));
                    if (i < this.getDynamicProperty().length - 1) {
                        objString.append(",");
                    }
                    objString.append("\n");
                }
                objString.append("   ");
                objString.append("]");
            }
            objString.append(",\n");
            objString.append("   ");
            objString.append("healthStatus = ");
            objString.append(this.getHealthStatus());
            objString.append(",\n");
            objString.append("   ");
            objString.append("healthInformation = ");
            objString.append(this.getHealthInformation());
            objString.append(",\n");
            objString.append("   ");
            objString.append("stateFlagInfo = ");
            if (this.getStateFlagInfo() == null) {
                objString.append("null");
            } else {
                objString.append("(STRING) [\n");
                for (i = 0; i < this.getStateFlagInfo().length; ++i) {
                    objString.append("      ");
                    objString.append(this.getStateFlagInfo()[i]);
                    if (i < this.getStateFlagInfo().length - 1) {
                        objString.append(",");
                    }
                    objString.append("\n");
                }
                objString.append("   ");
                objString.append("]");
            }
            objString.append(",\n");
            objString.append("   ");
            objString.append("dimmTemperature = ");
            objString.append(this.getDimmTemperature());
            objString.append(",\n");
            objString.append("   ");
            objString.append("dimmTemperatureThreshold = ");
            objString.append(this.getDimmTemperatureThreshold());
            objString.append(",\n");
            objString.append("   ");
            objString.append("spareBlocksPercentage = ");
            objString.append(this.getSpareBlocksPercentage());
            objString.append(",\n");
            objString.append("   ");
            objString.append("spareBlockThreshold = ");
            objString.append(this.getSpareBlockThreshold());
            objString.append(",\n");
            objString.append("   ");
            objString.append("dimmLifespanPercentage = ");
            objString.append(this.getDimmLifespanPercentage());
            objString.append(",\n");
            objString.append("   ");
            objString.append("esTemperature = ");
            objString.append(this.getEsTemperature());
            objString.append(",\n");
            objString.append("   ");
            objString.append("esTemperatureThreshold = ");
            objString.append(this.getEsTemperatureThreshold());
            objString.append(",\n");
            objString.append("   ");
            objString.append("esLifespanPercentage = ");
            objString.append(this.getEsLifespanPercentage());
            objString.append("\n}");
            return objString.toString();
        }

        @versionClass(value=version12.class)
        @wsdlName(value="NvdimmNvdimmHealthInfoState")
        public static enum StateFlag {
            normal,
            error;

        }
    }

    @versionClass(value=version12.class)
    @wsdlName(value="NvdimmGuid")
    @data
    @propertyOrder(value={"uuid"})
    public static class Guid
    extends DynamicDataImpl {
        private static final long serialVersionUID = 1L;
        public String uuid;

        public Guid() {
        }

        public Guid(String uuid) {
            this.uuid = uuid;
        }

        @versionClass(value=version12.class)
        public String getUuid() {
            return this.uuid;
        }

        @versionClass(value=version12.class)
        public void setUuid(String uuid) {
            this.uuid = uuid;
        }

        public String toString() {
            StringBuilder objString = new StringBuilder(120);
            objString.append("(vim.host.Guid) {\n");
            objString.append("   ");
            objString.append("dynamicType = ");
            objString.append(this.getDynamicType());
            objString.append(",\n");
            objString.append("   ");
            objString.append("dynamicProperty = ");
            if (this.getDynamicProperty() == null) {
                objString.append("null");
            } else {
                objString.append("(vmodl.DynamicProperty) [\n");
                for (int i = 0; i < this.getDynamicProperty().length; ++i) {
                    objString.append("      ");
                    objString.append(StringUtil.indent((String)("" + this.getDynamicProperty()[i]), (boolean)true));
                    if (i < this.getDynamicProperty().length - 1) {
                        objString.append(",");
                    }
                    objString.append("\n");
                }
                objString.append("   ");
                objString.append("]");
            }
            objString.append(",\n");
            objString.append("   ");
            objString.append("uuid = ");
            objString.append(this.getUuid());
            objString.append("\n}");
            return objString.toString();
        }
    }

    @versionClass(value=version12.class)
    @wsdlName(value="NvdimmDimmInfo")
    @data
    @propertyOrder(value={"dimmHandle", "healthInfo", "totalCapacity", "persistentCapacity", "availablePersistentCapacity", "volatileCapacity", "availableVolatileCapacity", "blockCapacity", "regionInfo", "representationString"})
    public static class DimmInfo
    extends DynamicDataImpl {
        private static final long serialVersionUID = 1L;
        public int dimmHandle;
        public HealthInfo healthInfo;
        public long totalCapacity;
        public long persistentCapacity;
        public long availablePersistentCapacity;
        public long volatileCapacity;
        public long availableVolatileCapacity;
        public long blockCapacity;
        public RegionInfo[] regionInfo;
        public String representationString;

        public DimmInfo() {
        }

        public DimmInfo(int dimmHandle, HealthInfo healthInfo, long totalCapacity, long persistentCapacity, long availablePersistentCapacity, long volatileCapacity, long availableVolatileCapacity, long blockCapacity, RegionInfo[] regionInfo, String representationString) {
            this.dimmHandle = dimmHandle;
            this.healthInfo = healthInfo;
            this.totalCapacity = totalCapacity;
            this.persistentCapacity = persistentCapacity;
            this.availablePersistentCapacity = availablePersistentCapacity;
            this.volatileCapacity = volatileCapacity;
            this.availableVolatileCapacity = availableVolatileCapacity;
            this.blockCapacity = blockCapacity;
            this.regionInfo = regionInfo;
            this.representationString = representationString;
        }

        @versionClass(value=version12.class)
        public int getDimmHandle() {
            return this.dimmHandle;
        }

        @versionClass(value=version12.class)
        public void setDimmHandle(int dimmHandle) {
            this.dimmHandle = dimmHandle;
        }

        @versionClass(value=version12.class)
        public HealthInfo getHealthInfo() {
            return this.healthInfo;
        }

        @versionClass(value=version12.class)
        public void setHealthInfo(HealthInfo healthInfo) {
            this.healthInfo = healthInfo;
        }

        @versionClass(value=version12.class)
        public long getTotalCapacity() {
            return this.totalCapacity;
        }

        @versionClass(value=version12.class)
        public void setTotalCapacity(long totalCapacity) {
            this.totalCapacity = totalCapacity;
        }

        @versionClass(value=version12.class)
        public long getPersistentCapacity() {
            return this.persistentCapacity;
        }

        @versionClass(value=version12.class)
        public void setPersistentCapacity(long persistentCapacity) {
            this.persistentCapacity = persistentCapacity;
        }

        @versionClass(value=version12.class)
        public long getAvailablePersistentCapacity() {
            return this.availablePersistentCapacity;
        }

        @versionClass(value=version12.class)
        public void setAvailablePersistentCapacity(long availablePersistentCapacity) {
            this.availablePersistentCapacity = availablePersistentCapacity;
        }

        @versionClass(value=version12.class)
        public long getVolatileCapacity() {
            return this.volatileCapacity;
        }

        @versionClass(value=version12.class)
        public void setVolatileCapacity(long volatileCapacity) {
            this.volatileCapacity = volatileCapacity;
        }

        @versionClass(value=version12.class)
        public long getAvailableVolatileCapacity() {
            return this.availableVolatileCapacity;
        }

        @versionClass(value=version12.class)
        public void setAvailableVolatileCapacity(long availableVolatileCapacity) {
            this.availableVolatileCapacity = availableVolatileCapacity;
        }

        @versionClass(value=version12.class)
        public long getBlockCapacity() {
            return this.blockCapacity;
        }

        @versionClass(value=version12.class)
        public void setBlockCapacity(long blockCapacity) {
            this.blockCapacity = blockCapacity;
        }

        @list
        @optional
        @versionClass(value=version12.class)
        public RegionInfo[] getRegionInfo() {
            return this.regionInfo;
        }

        @list
        @optional
        @versionClass(value=version12.class)
        public void setRegionInfo(RegionInfo[] regionInfo) {
            this.regionInfo = regionInfo;
        }

        @versionClass(value=version12.class)
        public String getRepresentationString() {
            return this.representationString;
        }

        @versionClass(value=version12.class)
        public void setRepresentationString(String representationString) {
            this.representationString = representationString;
        }

        public String toString() {
            int i;
            StringBuilder objString = new StringBuilder(480);
            objString.append("(vim.host.DimmInfo) {\n");
            objString.append("   ");
            objString.append("dynamicType = ");
            objString.append(this.getDynamicType());
            objString.append(",\n");
            objString.append("   ");
            objString.append("dynamicProperty = ");
            if (this.getDynamicProperty() == null) {
                objString.append("null");
            } else {
                objString.append("(vmodl.DynamicProperty) [\n");
                for (i = 0; i < this.getDynamicProperty().length; ++i) {
                    objString.append("      ");
                    objString.append(StringUtil.indent((String)("" + this.getDynamicProperty()[i]), (boolean)true));
                    if (i < this.getDynamicProperty().length - 1) {
                        objString.append(",");
                    }
                    objString.append("\n");
                }
                objString.append("   ");
                objString.append("]");
            }
            objString.append(",\n");
            objString.append("   ");
            objString.append("dimmHandle = ");
            objString.append(this.getDimmHandle());
            objString.append(",\n");
            objString.append("   ");
            objString.append("healthInfo = ");
            if (this.getHealthInfo() == null) {
                objString.append("null");
            } else {
                objString.append(StringUtil.indent((String)("" + (Object)((Object)this.getHealthInfo())), (boolean)false));
            }
            objString.append(",\n");
            objString.append("   ");
            objString.append("totalCapacity = ");
            objString.append(this.getTotalCapacity());
            objString.append(",\n");
            objString.append("   ");
            objString.append("persistentCapacity = ");
            objString.append(this.getPersistentCapacity());
            objString.append(",\n");
            objString.append("   ");
            objString.append("availablePersistentCapacity = ");
            objString.append(this.getAvailablePersistentCapacity());
            objString.append(",\n");
            objString.append("   ");
            objString.append("volatileCapacity = ");
            objString.append(this.getVolatileCapacity());
            objString.append(",\n");
            objString.append("   ");
            objString.append("availableVolatileCapacity = ");
            objString.append(this.getAvailableVolatileCapacity());
            objString.append(",\n");
            objString.append("   ");
            objString.append("blockCapacity = ");
            objString.append(this.getBlockCapacity());
            objString.append(",\n");
            objString.append("   ");
            objString.append("regionInfo = ");
            if (this.getRegionInfo() == null) {
                objString.append("null");
            } else {
                objString.append("(vim.host.RegionInfo) [\n");
                for (i = 0; i < this.getRegionInfo().length; ++i) {
                    objString.append("      ");
                    objString.append(StringUtil.indent((String)("" + (Object)((Object)this.getRegionInfo()[i])), (boolean)true));
                    if (i < this.getRegionInfo().length - 1) {
                        objString.append(",");
                    }
                    objString.append("\n");
                }
                objString.append("   ");
                objString.append("]");
            }
            objString.append(",\n");
            objString.append("   ");
            objString.append("representationString = ");
            objString.append(this.getRepresentationString());
            objString.append("\n}");
            return objString.toString();
        }
    }
}

