/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.binding.vim.host;

import com.vmware.vim.binding.impl.vmodl.DynamicDataImpl;
import com.vmware.vim.binding.vim.KeyValue;
import com.vmware.vim.binding.vim.fault.InsufficientResourcesFault;
import com.vmware.vim.binding.vim.fault.NotFound;
import com.vmware.vim.binding.vim.version.version1;
import com.vmware.vim.binding.vim.version.version2;
import com.vmware.vim.binding.vim.version.version5;
import com.vmware.vim.binding.vim.version.version7;
import com.vmware.vim.binding.vmodl.ManagedObject;
import com.vmware.vim.binding.vmodl.data;
import com.vmware.vim.binding.vmodl.faults;
import com.vmware.vim.binding.vmodl.list;
import com.vmware.vim.binding.vmodl.managed;
import com.vmware.vim.binding.vmodl.map;
import com.vmware.vim.binding.vmodl.name;
import com.vmware.vim.binding.vmodl.optional;
import com.vmware.vim.binding.vmodl.privilege;
import com.vmware.vim.binding.vmodl.propertyOrder;
import com.vmware.vim.binding.vmodl.readonly;
import com.vmware.vim.binding.vmodl.versionClass;
import com.vmware.vim.binding.vmodl.wsdlName;
import com.vmware.vim.vmomi.core.Future;
import com.vmware.vim.vmomi.core.util.StringUtil;

@managed
@versionClass(value=version1.class)
@wsdlName(value="HostSnmpSystem")
public interface SnmpSystem
extends ManagedObject {
    @readonly
    @name(value="configuration")
    @privilege(value="Global.Settings")
    @versionClass(value=version2.class)
    public void getConfiguration(Future<SnmpConfigSpec> var1);

    @name(value="configuration")
    public SnmpConfigSpec getConfiguration();

    @readonly
    @name(value="limits")
    @privilege(value="Global.Settings")
    @versionClass(value=version2.class)
    public void getLimits(Future<AgentLimits> var1);

    @name(value="limits")
    public AgentLimits getLimits();

    @versionClass(value=version2.class)
    @wsdlName(value="ReconfigureSnmpAgent")
    @privilege(value="Global.Settings")
    @faults(value={"NotFound", "InsufficientResourcesFault"})
    public void reconfigureSnmpAgent(@name(value="spec") @versionClass(value=version2.class) SnmpConfigSpec var1, Future<Void> var2);

    @wsdlName(value="ReconfigureSnmpAgent")
    public void reconfigureSnmpAgent(SnmpConfigSpec var1) throws NotFound, InsufficientResourcesFault;

    @versionClass(value=version2.class)
    @wsdlName(value="SendTestNotification")
    @privilege(value="Global.Settings")
    @faults(value={"NotFound", "InsufficientResourcesFault"})
    public void sendTestNotification(Future<Void> var1);

    @wsdlName(value="SendTestNotification")
    public void sendTestNotification() throws NotFound, InsufficientResourcesFault;

    @versionClass(value=version2.class)
    @wsdlName(value="HostSnmpConfigSpec")
    @data
    @propertyOrder(value={"enabled", "port", "readOnlyCommunities", "trapTargets", "option"})
    public static class SnmpConfigSpec
    extends DynamicDataImpl {
        private static final long serialVersionUID = 1L;
        public Boolean enabled;
        public Integer port;
        public String[] readOnlyCommunities;
        public Destination[] trapTargets;
        public KeyValue[] option;

        public SnmpConfigSpec() {
        }

        public SnmpConfigSpec(Boolean enabled, Integer port, String[] readOnlyCommunities, Destination[] trapTargets, KeyValue[] option) {
            this.enabled = enabled;
            this.port = port;
            this.readOnlyCommunities = readOnlyCommunities;
            this.trapTargets = trapTargets;
            this.option = option;
        }

        @optional
        @versionClass(value=version2.class)
        @Deprecated
        public Boolean isEnabled() {
            return this.enabled;
        }

        @optional
        @versionClass(value=version2.class)
        public Boolean getEnabled() {
            return this.enabled;
        }

        @optional
        @versionClass(value=version2.class)
        public void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        @optional
        @versionClass(value=version2.class)
        public Integer getPort() {
            return this.port;
        }

        @optional
        @versionClass(value=version2.class)
        public void setPort(Integer port) {
            this.port = port;
        }

        @map
        @optional
        @versionClass(value=version2.class)
        public String[] getReadOnlyCommunities() {
            return this.readOnlyCommunities;
        }

        @map
        @optional
        @versionClass(value=version2.class)
        public void setReadOnlyCommunities(String[] readOnlyCommunities) {
            this.readOnlyCommunities = readOnlyCommunities;
        }

        @list
        @optional
        @versionClass(value=version2.class)
        public Destination[] getTrapTargets() {
            return this.trapTargets;
        }

        @list
        @optional
        @versionClass(value=version2.class)
        public void setTrapTargets(Destination[] trapTargets) {
            this.trapTargets = trapTargets;
        }

        @map
        @optional
        @versionClass(value=version7.class)
        public KeyValue[] getOption() {
            return this.option;
        }

        @map
        @optional
        @versionClass(value=version7.class)
        public void setOption(KeyValue[] option) {
            this.option = option;
        }

        public String toString() {
            int i;
            StringBuilder objString = new StringBuilder(280);
            objString.append("(vim.host.SnmpConfigSpec) {\n");
            objString.append("   ");
            objString.append("dynamicType = ");
            objString.append(this.getDynamicType());
            objString.append(",\n");
            objString.append("   ");
            objString.append("dynamicProperty = ");
            if (this.getDynamicProperty() == null) {
                objString.append("null");
            } else {
                objString.append("(vmodl.DynamicProperty) [\n");
                for (i = 0; i < this.getDynamicProperty().length; ++i) {
                    objString.append("      ");
                    objString.append(StringUtil.indent((String)("" + this.getDynamicProperty()[i]), (boolean)true));
                    if (i < this.getDynamicProperty().length - 1) {
                        objString.append(",");
                    }
                    objString.append("\n");
                }
                objString.append("   ");
                objString.append("]");
            }
            objString.append(",\n");
            objString.append("   ");
            objString.append("enabled = ");
            objString.append(this.isEnabled());
            objString.append(",\n");
            objString.append("   ");
            objString.append("port = ");
            objString.append(this.getPort());
            objString.append(",\n");
            objString.append("   ");
            objString.append("readOnlyCommunities = ");
            if (this.getReadOnlyCommunities() == null) {
                objString.append("null");
            } else {
                objString.append("(STRING) [\n");
                for (i = 0; i < this.getReadOnlyCommunities().length; ++i) {
                    objString.append("      ");
                    objString.append(this.getReadOnlyCommunities()[i]);
                    if (i < this.getReadOnlyCommunities().length - 1) {
                        objString.append(",");
                    }
                    objString.append("\n");
                }
                objString.append("   ");
                objString.append("]");
            }
            objString.append(",\n");
            objString.append("   ");
            objString.append("trapTargets = ");
            if (this.getTrapTargets() == null) {
                objString.append("null");
            } else {
                objString.append("(vim.host.Destination) [\n");
                for (i = 0; i < this.getTrapTargets().length; ++i) {
                    objString.append("      ");
                    objString.append(StringUtil.indent((String)("" + (Object)((Object)this.getTrapTargets()[i])), (boolean)true));
                    if (i < this.getTrapTargets().length - 1) {
                        objString.append(",");
                    }
                    objString.append("\n");
                }
                objString.append("   ");
                objString.append("]");
            }
            objString.append(",\n");
            objString.append("   ");
            objString.append("option = ");
            if (this.getOption() == null) {
                objString.append("null");
            } else {
                objString.append("(vim.KeyValue) [\n");
                for (i = 0; i < this.getOption().length; ++i) {
                    objString.append("      ");
                    objString.append(StringUtil.indent((String)("" + (Object)((Object)this.getOption()[i])), (boolean)true));
                    if (i < this.getOption().length - 1) {
                        objString.append(",");
                    }
                    objString.append("\n");
                }
                objString.append("   ");
                objString.append("]");
            }
            objString.append("\n}");
            return objString.toString();
        }

        @versionClass(value=version1.class)
        @wsdlName(value="HostSnmpDestination")
        @data
        @propertyOrder(value={"hostName", "port", "community"})
        public static class Destination
        extends DynamicDataImpl {
            private static final long serialVersionUID = 1L;
            public String hostName;
            public int port;
            public String community;

            public Destination() {
            }

            public Destination(String hostName, int port, String community) {
                this.hostName = hostName;
                this.port = port;
                this.community = community;
            }

            @versionClass(value=version1.class)
            public String getHostName() {
                return this.hostName;
            }

            @versionClass(value=version1.class)
            public void setHostName(String hostName) {
                this.hostName = hostName;
            }

            @versionClass(value=version1.class)
            public int getPort() {
                return this.port;
            }

            @versionClass(value=version1.class)
            public void setPort(int port) {
                this.port = port;
            }

            @versionClass(value=version1.class)
            public String getCommunity() {
                return this.community;
            }

            @versionClass(value=version1.class)
            public void setCommunity(String community) {
                this.community = community;
            }

            public String toString() {
                StringBuilder objString = new StringBuilder(200);
                objString.append("(vim.host.Destination) {\n");
                objString.append("   ");
                objString.append("dynamicType = ");
                objString.append(this.getDynamicType());
                objString.append(",\n");
                objString.append("   ");
                objString.append("dynamicProperty = ");
                if (this.getDynamicProperty() == null) {
                    objString.append("null");
                } else {
                    objString.append("(vmodl.DynamicProperty) [\n");
                    for (int i = 0; i < this.getDynamicProperty().length; ++i) {
                        objString.append("      ");
                        objString.append(StringUtil.indent((String)("" + this.getDynamicProperty()[i]), (boolean)true));
                        if (i < this.getDynamicProperty().length - 1) {
                            objString.append(",");
                        }
                        objString.append("\n");
                    }
                    objString.append("   ");
                    objString.append("]");
                }
                objString.append(",\n");
                objString.append("   ");
                objString.append("hostName = ");
                objString.append(this.getHostName());
                objString.append(",\n");
                objString.append("   ");
                objString.append("port = ");
                objString.append(this.getPort());
                objString.append(",\n");
                objString.append("   ");
                objString.append("community = ");
                objString.append(this.getCommunity());
                objString.append("\n}");
                return objString.toString();
            }
        }
    }

    @versionClass(value=version2.class)
    @wsdlName(value="HostSnmpSystemAgentLimits")
    @data
    @propertyOrder(value={"maxReadOnlyCommunities", "maxTrapDestinations", "maxCommunityLength", "maxBufferSize", "capability"})
    public static class AgentLimits
    extends DynamicDataImpl {
        private static final long serialVersionUID = 1L;
        public int maxReadOnlyCommunities;
        public int maxTrapDestinations;
        public int maxCommunityLength;
        public int maxBufferSize;
        public Capability capability;

        public AgentLimits() {
        }

        public AgentLimits(int maxReadOnlyCommunities, int maxTrapDestinations, int maxCommunityLength, int maxBufferSize, Capability capability) {
            this.maxReadOnlyCommunities = maxReadOnlyCommunities;
            this.maxTrapDestinations = maxTrapDestinations;
            this.maxCommunityLength = maxCommunityLength;
            this.maxBufferSize = maxBufferSize;
            this.capability = capability;
        }

        @versionClass(value=version2.class)
        public int getMaxReadOnlyCommunities() {
            return this.maxReadOnlyCommunities;
        }

        @versionClass(value=version2.class)
        public void setMaxReadOnlyCommunities(int maxReadOnlyCommunities) {
            this.maxReadOnlyCommunities = maxReadOnlyCommunities;
        }

        @versionClass(value=version2.class)
        public int getMaxTrapDestinations() {
            return this.maxTrapDestinations;
        }

        @versionClass(value=version2.class)
        public void setMaxTrapDestinations(int maxTrapDestinations) {
            this.maxTrapDestinations = maxTrapDestinations;
        }

        @versionClass(value=version2.class)
        public int getMaxCommunityLength() {
            return this.maxCommunityLength;
        }

        @versionClass(value=version2.class)
        public void setMaxCommunityLength(int maxCommunityLength) {
            this.maxCommunityLength = maxCommunityLength;
        }

        @versionClass(value=version2.class)
        public int getMaxBufferSize() {
            return this.maxBufferSize;
        }

        @versionClass(value=version2.class)
        public void setMaxBufferSize(int maxBufferSize) {
            this.maxBufferSize = maxBufferSize;
        }

        @optional
        @versionClass(value=version5.class)
        public Capability getCapability() {
            return this.capability;
        }

        @optional
        @versionClass(value=version5.class)
        public void setCapability(Capability capability) {
            this.capability = capability;
        }

        public String toString() {
            StringBuilder objString = new StringBuilder(280);
            objString.append("(vim.host.AgentLimits) {\n");
            objString.append("   ");
            objString.append("dynamicType = ");
            objString.append(this.getDynamicType());
            objString.append(",\n");
            objString.append("   ");
            objString.append("dynamicProperty = ");
            if (this.getDynamicProperty() == null) {
                objString.append("null");
            } else {
                objString.append("(vmodl.DynamicProperty) [\n");
                for (int i = 0; i < this.getDynamicProperty().length; ++i) {
                    objString.append("      ");
                    objString.append(StringUtil.indent((String)("" + this.getDynamicProperty()[i]), (boolean)true));
                    if (i < this.getDynamicProperty().length - 1) {
                        objString.append(",");
                    }
                    objString.append("\n");
                }
                objString.append("   ");
                objString.append("]");
            }
            objString.append(",\n");
            objString.append("   ");
            objString.append("maxReadOnlyCommunities = ");
            objString.append(this.getMaxReadOnlyCommunities());
            objString.append(",\n");
            objString.append("   ");
            objString.append("maxTrapDestinations = ");
            objString.append(this.getMaxTrapDestinations());
            objString.append(",\n");
            objString.append("   ");
            objString.append("maxCommunityLength = ");
            objString.append(this.getMaxCommunityLength());
            objString.append(",\n");
            objString.append("   ");
            objString.append("maxBufferSize = ");
            objString.append(this.getMaxBufferSize());
            objString.append(",\n");
            objString.append("   ");
            objString.append("capability = ");
            objString.append((Object)this.getCapability());
            objString.append("\n}");
            return objString.toString();
        }

        @versionClass(value=version5.class)
        @wsdlName(value="HostSnmpAgentCapability")
        public static enum Capability {
            COMPLETE,
            DIAGNOSTICS,
            CONFIGURATION;

        }
    }
}

