#

# Script module for module 'VMware.VimAutomation.Security'

#

Set-StrictMode -Version Latest



$binaryModuleFileName = 'VMware.VimAutomation.Security.psd1'



# Set up some helper variables to make it easier to work with the module

$PSModule = $ExecutionContext.SessionState.Module

$PSModuleRoot = $PSModule.ModuleBase



# Import the appropriate nested binary module based on the current PowerShell version

$binaryModuleRoot = $PSModuleRoot



if (($PSVersionTable.Keys -contains "PSEdition") -and ($PSVersionTable.PSEdition -ne 'Desktop')) {

   $binaryModuleRoot = Join-Path -Path $PSModuleRoot -ChildPath 'netcoreapp2.0'

} else {

   $binaryModuleRoot = Join-Path -Path $PSModuleRoot -ChildPath 'net45'

}



$binaryModulePath = Join-Path -Path $binaryModuleRoot -ChildPath $binaryModuleFileName

$binaryModule = Import-Module -Name $binaryModulePath -PassThru



# When the module is unloaded, remove the nested binary module that was loaded with it

$PSModule.OnRemove = {

   Remove-Module -ModuleInfo $binaryModule

}


# SIG # Begin signature block
# MIID0gYJKoZIhvcNAQcCoIIDwzCCA78CAQExCzAJBgUrDgMCGgUAMGkGCisGAQQB
# gjcCAQSgWzBZMDQGCisGAQQBgjcCAR4wJgIDAQAABBAfzDtgWUsITrck0sYpfvNR
# AgEAAgEAAgEAAgEAAgEAMCEwCQYFKw4DAhoFAAQUw4WOJWfOZt2sbRWtKqOb7FNO
# NXugggH/MIIB+zCCAWSgAwIBAgIQ18907PngVoVDxSbOLQ8BUzANBgkqhkiG9w0B
# AQQFADAVMRMwEQYDVQQDEwpWTXdhcmVUZXN0MCAXDTA2MDEwMTA3MDAwMFoYDzIw
# OTkwMTAxMDcwMDAwWjAVMRMwEQYDVQQDEwpWTXdhcmVUZXN0MIGfMA0GCSqGSIb3
# DQEBAQUAA4GNADCBiQKBgQDmacgVpuOBXRDeqygplNoCKFw8/pnraVAWvTQIANfb
# wt54jsZyX8wC2xv9Olgh6723Xg9s7qMBaJwQ4MCtUB18cx4grDcGeyigsmToBxFA
# zs3lqCP6RfZQzFcLIFdI9XeXvGOebP7rMFh0F5nUuvHIOtPF6I5tEhtxcGIR1gO+
# 5wIDAQABo0owSDBGBgNVHQEEPzA9gBA5XdDY7iSoQWy8DWL2BWjboRcwFTETMBEG
# A1UEAxMKVk13YXJlVGVzdIIQ18907PngVoVDxSbOLQ8BUzANBgkqhkiG9w0BAQQF
# AAOBgQCL864AWy1uUq69aswJAGcTBc7nGzM+3HCJT3tPLiiC76GYcnkxSQYHU8ER
# BdOwSKfPWKgjvdAvZR0/pLU6bIvQxEguFqgHVhbufx1njj7eH4dRWiDq672+OKJN
# IrcBnlMopCu75ryHAOH7j+dTUa2ykyt8FOk/OKVpnBfMfygrczGCAT0wggE5AgEB
# MCkwFTETMBEGA1UEAxMKVk13YXJlVGVzdAIQ18907PngVoVDxSbOLQ8BUzAJBgUr
# DgMCGgUAoGwwGQYJKoZIhvcNAQkDMQwGCisGAQQBgjcCAQQwIwYJKoZIhvcNAQkE
# MRYEFOA2ZQaohAK50cPzamf2iZ2xGR3GMCoGCisGAQQBgjcCAQwxHDAaoRiAFmh0
# dHA6Ly93d3cudm13YXJlLmNvbS8wDQYJKoZIhvcNAQEBBQAEgYDBmTSzBWoLNdMf
# Xq1Vk9MwADAcn0Nb5hilx5/Oo9B8xVIb1CGX7OMLuXnA3TiHLJ6kHznYz+R9fd88
# mJiHw2S/NDmmTM31EiJisblteCTDl8WqZ2zjj9NRwNSZY8lmTJFWLRzp9pzUK39d
# QsSYao82+yYndYhdxYZvCt4IWY1IEg==
# SIG # End signature block
