/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.cis.authn;

import com.vmware.vapi.cis.authn.SamlAuthenticationData;
import com.vmware.vapi.cis.authn.SamlTokenSecurityContext;
import com.vmware.vapi.core.ExecutionContext;
import com.vmware.vapi.security.OAuthSecurityContext;
import com.vmware.vapi.security.SessionSecurityContext;
import com.vmware.vapi.security.UserPassSecurityContext;
import com.vmware.vim.sso.client.SamlToken;
import java.security.PrivateKey;
import java.util.Collections;
import java.util.Map;

public final class SecurityContextFactory {
    public static ExecutionContext.SecurityContext createSamlSecurityContext(SamlToken token, PrivateKey privateKey) {
        return new SamlTokenSecurityContext(token, privateKey);
    }

    public static ExecutionContext.SecurityContext createSamlSecurityCtx(String token, PrivateKey privateKey) {
        return new SamlTokenSecurityContext(token, privateKey);
    }

    public static ExecutionContext.SecurityContext createSessionSecurityContext(char[] sessionId) {
        return new SessionSecurityContext(sessionId);
    }

    public static ExecutionContext.SecurityContext createOAuthSecurityContext(char[] accessToken) {
        return new OAuthSecurityContext(accessToken);
    }

    public static ExecutionContext.SecurityContext createUserPassSecurityContext(String user, char[] password) {
        return new UserPassSecurityContext(user, password);
    }

    public static UserPassSecurityContext parseUserPassSecurityContext(ExecutionContext.SecurityContext ctx) {
        return UserPassSecurityContext.getInstance((ExecutionContext.SecurityContext)ctx);
    }

    public static SamlAuthenticationData parseSamlSecurityContext(ExecutionContext.SecurityContext ctx) {
        return SamlAuthenticationData.createInstance(ctx);
    }

    public static SessionSecurityContext parseSessionSecurityContext(ExecutionContext.SecurityContext ctx) {
        return SessionSecurityContext.newInstance((ExecutionContext.SecurityContext)ctx);
    }

    public static OAuthSecurityContext parseOAuthSecurityContext(ExecutionContext.SecurityContext ctx) {
        return OAuthSecurityContext.newInstance((ExecutionContext.SecurityContext)ctx);
    }

    public static ExecutionContext.SecurityContext createDefaultSecurityContext(Map<String, Object> props) {
        final Map<Object, Object> scProps = props != null ? Collections.unmodifiableMap(props) : Collections.emptyMap();
        return new ExecutionContext.SecurityContext(){

            public Object getProperty(String key) {
                return scProps.get(key);
            }

            public Map<String, Object> getAllProperties() {
                return scProps;
            }
        };
    }
}

