/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.impex.configurables.inventory.datacenter.resPool;

import com.vmware.srm.client.impex.configurables.ConfigurableConverter;
import com.vmware.srm.client.impex.configurables.inventory.IeInventory;
import com.vmware.srm.client.impex.configurables.inventory.datacenter.IeVirtualMachine;
import com.vmware.srm.client.impex.configurables.inventory.datacenter.VirtualMachineConverterBase;
import com.vmware.srm.client.impex.configurables.inventory.datacenter.resPool.IeResourcePool;
import com.vmware.srm.client.impex.tool.IdBuilder;
import com.vmware.srm.client.infrastructure.pc.utils.PcResult;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang.ArrayUtils;

public abstract class ResourcePoolConverter<V extends IeVirtualMachine, C extends VirtualMachineConverterBase<V>, P extends IeResourcePool<V, P>>
implements ConfigurableConverter {
    public final P fromVmodl(IdBuilder idBuilder, PcResult pcResult, ManagedObjectReference entity, C vmConverter) {
        if (!"ResourcePool".equals(entity.getType()) && !"VirtualApp".equals(entity.getType())) {
            throw new IllegalStateException("ResourcePool conversion");
        }
        boolean isVirtualApp = "VirtualApp".equals(entity.getType());
        P resPool = isVirtualApp ? this.createVirtualApp() : this.createResourcePool();
        this.setResourcePoolInfo(idBuilder, pcResult, entity, vmConverter, resPool);
        this.setResourcePoolVms(idBuilder, pcResult, entity, vmConverter, resPool);
        if (isVirtualApp) {
            this.convertVirtualAppInt(idBuilder, pcResult, entity, vmConverter, resPool);
        } else {
            this.convertResourcePoolInt(idBuilder, pcResult, entity, vmConverter, resPool);
        }
        return resPool;
    }

    protected abstract P createResourcePool();

    protected abstract P createVirtualApp();

    protected void convertResourcePoolInt(IdBuilder idBuilder, PcResult pcResult, ManagedObjectReference entity, C vmConverter, P resPool) {
    }

    protected void convertVirtualAppInt(IdBuilder idBuilder, PcResult pcResult, ManagedObjectReference entity, C vmConverter, P virtualApp) {
    }

    private void setResourcePoolInfo(IdBuilder idBuilder, PcResult pcResult, ManagedObjectReference entity, C vmConverter, P ieResourcePool) {
        ((IeInventory)ieResourcePool).setId(idBuilder.buildId(entity));
        String name = (String)pcResult.getProperty(entity, "name");
        ((IeInventory)ieResourcePool).setName(name);
        Object[] children = (ManagedObjectReference[])pcResult.getProperty(entity, "resourcePool");
        List ieChildren = ArrayUtils.isEmpty((Object[])children) ? Collections.emptyList() : Arrays.stream(children).map(child -> this.fromVmodl(idBuilder, pcResult, (ManagedObjectReference)child, vmConverter)).collect(Collectors.toList());
        ((IeResourcePool)ieResourcePool).setChildren(ieChildren);
    }

    private void setResourcePoolVms(IdBuilder idBuilder, PcResult pcResult, ManagedObjectReference entity, C vmConverter, P resPool) {
        Object[] vms = (ManagedObjectReference[])pcResult.getProperty(entity, "vm");
        List ieVms = ArrayUtils.isEmpty((Object[])vms) ? Collections.emptyList() : Arrays.stream(vms).map(vm -> vmConverter.fromVmodl(idBuilder, pcResult, (ManagedObjectReference)vm)).collect(Collectors.toList());
        ((IeResourcePool)resPool).setVirtualMachines(ieVms);
    }
}

