/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.impex.tool;

import com.vmware.dr.ui.tools.utilities.ContextApplier;
import com.vmware.dr.ui.tools.utilities.ContextApplierImpl;
import com.vmware.dr.ui.tools.utilities.ThreadContext;
import com.vmware.srm.client.impex.tool.IdBuilder;
import com.vmware.srm.client.impex.tool.SrmServersDataWrapper;
import com.vmware.srm.client.topology.client.view.availability.srm.SrmServer;
import java.util.concurrent.Callable;
import org.apache.commons.lang.Validate;

public class ImpexExportSrmContext {
    private static final ThreadLocal<ImpexExportSrmContext> IMPEX_CONTEXT = new ThreadLocal();
    private final SrmServersDataWrapper _serversDataWrapper;
    private final IdBuilder _idBuilder;

    public static <T> T executeWith(Callable<T> task, SrmServersDataWrapper serversWrapper) throws Exception {
        ImpexExportSrmContext context = new ImpexExportSrmContext(serversWrapper);
        return (T)ThreadContext.extendContext(task, (ContextApplier)new ContextApplierImpl(IMPEX_CONTEXT, (Object)context));
    }

    public static SrmServersDataWrapper getServersDataWrapper() {
        return ImpexExportSrmContext.get()._serversDataWrapper;
    }

    public static IdBuilder getIdBuilder() {
        return ImpexExportSrmContext.get()._idBuilder;
    }

    private static ImpexExportSrmContext get() {
        ImpexExportSrmContext impexContext = IMPEX_CONTEXT.get();
        Validate.notNull((Object)impexContext, (String)"impexContext");
        return impexContext;
    }

    public static boolean isAvailable() {
        return IMPEX_CONTEXT.get() != null;
    }

    private ImpexExportSrmContext(SrmServersDataWrapper serversDataWrapper) {
        this._serversDataWrapper = serversDataWrapper;
        this._idBuilder = new IdBuilder(((SrmServer)serversDataWrapper.getLocalPair().server()).vc().guid(), ((SrmServer)serversDataWrapper.getRemotePair().server()).vc().guid());
    }
}

