/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.topology.impl.vmomi.is;

import com.vmware.dr.ui.tools.reactive.Promise;
import com.vmware.dr.ui.tools.reactive.impl.Promises;
import com.vmware.srm.client.reactive.impl.FuturePromise;
import com.vmware.srm.client.topology.client.vmomi.is.InventoryService;
import com.vmware.srm.client.topology.impl.vmomi.ClientUtils;
import com.vmware.srm.client.topology.impl.vmomi.TokenProvider;
import com.vmware.srm.client.topology.impl.vmomi.osgi.VmodlContextInitializer;
import com.vmware.srm.client.topology.impl.vmomi.vlsi.FixedVersionServiceImpl;
import com.vmware.srm.client.topology.impl.vmomi.vlsi.HttpConfigManagerUtils;
import com.vmware.vim.binding.dataservice.Service;
import com.vmware.vim.binding.dataservice.ServiceInformation;
import com.vmware.vim.binding.dataservice.authentication.SessionManager;
import com.vmware.vim.binding.dataservice.fault.NotAuthenticatedFault;
import com.vmware.vim.binding.dataservice.version.internal.version3;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.binding.vmodl.fault.SecurityError;
import com.vmware.vim.vmomi.core.Future;
import com.vmware.vim.vmomi.core.types.VmodlContext;
import java.lang.annotation.Annotation;
import java.net.URI;
import java.security.KeyStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InventoryServiceImpl
extends FixedVersionServiceImpl<Service, ServiceInformation>
implements InventoryService {
    private static final Logger LOGGER = LoggerFactory.getLogger(InventoryServiceImpl.class);
    public static final Class<? extends Annotation> VERSION = version3.class;
    public static final ManagedObjectReference SERVICE_INSTANCE;
    public static final ManagedObjectReference SESSION_MANAGER;
    public static final VmodlContextInitializer VMODL_INIT;

    public InventoryServiceImpl(URI server, KeyStore store, TokenProvider tokenProvider) {
        super(server, HttpConfigManagerUtils.COMMON_MANAGER.getConfiguration(), VMODL_INIT, tokenProvider, SERVICE_INSTANCE, "Inventory Service", VERSION);
        HttpConfigManagerUtils.COMMON_MANAGER.addThumbprints(store);
    }

    @Override
    protected String getServerGuid(ServiceInformation content) {
        if (content == null) {
            return null;
        }
        return content.getInstanceUuid();
    }

    @Override
    protected Promise<ServiceInformation> retrieveContent(Service serviceInstance) {
        SessionManager sm = (SessionManager)this.createStub(SESSION_MANAGER);
        FuturePromise fpLogin = new FuturePromise();
        sm.loginBySamlToken((Future)fpLogin);
        return fpLogin.materialize().thenCompose(result -> {
            if (result.isSuccessful() || result.getError() instanceof SecurityError) {
                if (result.isSuccessful()) {
                    LOGGER.warn("SessionManager::loginBySamlToken should have failed but didn't.");
                }
                return Promises.resolve(null);
            }
            if (InventoryServiceImpl.shouldDoBackOff(result.getError())) {
                return Promises.reject((Exception)result.getError());
            }
            LOGGER.warn("Unexpected fault:", (Throwable)result.getError());
            return Promises.resolve(null);
        });
    }

    @Override
    protected Promise<Void> login(ServiceInformation content, String locale) {
        return this.createLoginStub(SESSION_MANAGER).thenCompose(sm -> {
            SessionManager sessionManager = (SessionManager)sm;
            FuturePromise result = new FuturePromise();
            sessionManager.loginBySamlToken((Future)result);
            return result;
        }).thenApply(unused -> null);
    }

    @Override
    protected Promise<Void> logout(ServiceInformation content) {
        return this.createFreeStub(SESSION_MANAGER).thenCompose(sm -> {
            FuturePromise result = new FuturePromise();
            sm.logout((Future)result);
            return result;
        }).thenApply(unused -> null);
    }

    @Override
    protected boolean retryOnError(Exception err) {
        return err instanceof NotAuthenticatedFault || super.retryOnError(err);
    }

    static {
        VmodlContext context = VmodlContext.initContext((String[])new String[0], (boolean)false);
        VMODL_INIT = new VmodlContextInitializer(context, VERSION);
        SERVICE_INSTANCE = ClientUtils.createMoRef("InventoryService", "service", null);
        SESSION_MANAGER = ClientUtils.createMoRef("InventoryServiceSessionManager", "sessionManager", null);
    }
}

