/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.topology.impl.vmomi.ssl;

import com.vmware.srm.client.topology.impl.vmomi.vlsi.VlsiClientUtils;
import com.vmware.vim.vmomi.client.http.ThumbprintVerifier;
import com.vmware.vim.vmomi.core.impl.SslUtil;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;
import javax.net.ssl.SSLException;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamicVerifier
implements ThumbprintVerifier {
    private static final Logger LOGGER = LoggerFactory.getLogger(DynamicVerifier.class);
    private static final ThreadLocal<Boolean> VERIFIED = new ThreadLocal();
    private static final String SHA256 = "SHA-256";
    private static final String[] EMPTY_ARR = new String[0];
    private static final Pattern SHA256_PATTERN = Pattern.compile("[A-F0-9]{2}(?::[A-F0-9]{2}){31}");
    private final AtomicReference<String[]> _thumbprintsRef = new AtomicReference<String[]>(EMPTY_ARR);
    private final AtomicBoolean _containsSHA256 = new AtomicBoolean(false);

    private static boolean isSHA256(String thumbprint) {
        Validate.notNull((Object)thumbprint, (String)"thumbprint");
        return thumbprint.length() == 95 && SHA256_PATTERN.matcher(thumbprint).matches();
    }

    public ThumbprintVerifier.Result verify(String thumbprint) {
        boolean verified = Arrays.binarySearch(this._thumbprintsRef.get(), thumbprint) >= 0;
        VERIFIED.set(verified);
        if (!verified && !this._containsSHA256.get()) {
            return ThumbprintVerifier.Result.MISMATCH;
        }
        return ThumbprintVerifier.Result.MATCH;
    }

    public void onSuccess(X509Certificate[] chain, String thumbprint, ThumbprintVerifier.Result verifyResult, boolean trustedChain, boolean verifiedAssertions) throws SSLException {
        String computed;
        Boolean verified = VERIFIED.get();
        VERIFIED.remove();
        if (verified == null) {
            throw new IllegalStateException("Not verified.");
        }
        if (verified.booleanValue() || trustedChain && verifiedAssertions) {
            return;
        }
        if (ArrayUtils.isEmpty((Object[])chain)) {
            throw new IllegalArgumentException("chain");
        }
        try {
            computed = SslUtil.computeCertificateThumbprint((X509Certificate)chain[0], (String)SHA256);
        }
        catch (NoSuchAlgorithmException | CertificateEncodingException e) {
            throw new SSLException(e);
        }
        if (Arrays.binarySearch(this._thumbprintsRef.get(), computed) < 0) {
            throw new SSLException("Certificate thumbprint mismatch.");
        }
        this.addThumbprint(thumbprint);
    }

    public void addThumbprint(String thumbprint) {
        String[] myThumbprints;
        Object[] thumbprints;
        Validate.notEmpty((String)thumbprint, (String)"thumbprint");
        if (DynamicVerifier.isSHA256(thumbprint)) {
            this._containsSHA256.set(true);
        }
        do {
            int i;
            if ((i = Arrays.binarySearch(thumbprints = this._thumbprintsRef.get(), thumbprint)) >= 0) {
                return;
            }
            i = Math.abs(i) - 1;
            myThumbprints = new String[thumbprints.length + 1];
            System.arraycopy(thumbprints, 0, myThumbprints, 0, i);
            myThumbprints[i] = thumbprint;
            System.arraycopy(thumbprints, i, myThumbprints, i + 1, thumbprints.length - i);
        } while (!this._thumbprintsRef.compareAndSet((String[])thumbprints, myThumbprints));
        LOGGER.info("Added thumbprint '{}'.", (Object)thumbprint);
    }

    public void addThumbprints(KeyStore store) {
        String[] thumbprints;
        Validate.notNull((Object)store, (String)"store");
        try {
            thumbprints = VlsiClientUtils.computeThumbprints(store);
        }
        catch (GeneralSecurityException e) {
            throw new RuntimeException("Unable to compute certificate thumbprints.", e);
        }
        for (String tp : thumbprints) {
            this.addThumbprint(tp);
        }
    }
}

