/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml2.binding.decoding.impl;

import javax.servlet.http.HttpServletRequest;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.decoder.MessageDecodingException;
import org.opensaml.messaging.decoder.servlet.BaseHttpServletRequestXMLMessageDecoder;
import org.opensaml.saml.common.SAMLObject;
import org.opensaml.saml.common.binding.SAMLBindingSupport;
import org.opensaml.saml.common.binding.decoding.SAMLMessageDecoder;
import org.opensaml.saml.common.messaging.context.SAMLBindingContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HTTPArtifactDecoder
extends BaseHttpServletRequestXMLMessageDecoder<SAMLObject>
implements SAMLMessageDecoder {
    private final Logger log = LoggerFactory.getLogger(HTTPArtifactDecoder.class);

    public String getBindingURI() {
        return "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact";
    }

    protected void doDecode() throws MessageDecodingException {
        MessageContext messageContext = new MessageContext();
        HttpServletRequest request = this.getHttpServletRequest();
        String relayState = StringSupport.trim((String)request.getParameter("RelayState"));
        this.log.debug("Decoded SAML relay state of: {}", (Object)relayState);
        SAMLBindingSupport.setRelayState((MessageContext)messageContext, (String)relayState);
        this.processArtifact(messageContext, request);
        this.populateBindingContext((MessageContext<SAMLObject>)messageContext);
        this.setMessageContext(messageContext);
    }

    protected void processArtifact(MessageContext messageContext, HttpServletRequest request) throws MessageDecodingException {
        String encodedArtifact = StringSupport.trimOrNull((String)request.getParameter("SAMLart"));
        if (encodedArtifact == null) {
            this.log.error("URL SAMLart parameter was missing or did not contain a value.");
            throw new MessageDecodingException("URL TARGET parameter was missing or did not contain a value.");
        }
    }

    protected void populateBindingContext(MessageContext<SAMLObject> messageContext) {
        SAMLBindingContext bindingContext = (SAMLBindingContext)messageContext.getSubcontext(SAMLBindingContext.class, true);
        bindingContext.setBindingUri(this.getBindingURI());
        bindingContext.setHasBindingSignature(false);
        bindingContext.setIntendedDestinationEndpointURIRequired(false);
    }
}

