/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.core;

import com.vmware.vapi.core.InterfaceIdentifier;
import com.vmware.vapi.core.MethodIdentifier;
import com.vmware.vapi.internal.util.Validate;
import java.util.Set;

public class InterfaceDefinition {
    private InterfaceIdentifier id;
    private Set<MethodIdentifier> methodIds;

    public InterfaceDefinition(InterfaceIdentifier id, Set<MethodIdentifier> methodIds) {
        Validate.notNull(id, "Interface identifier is required.");
        Validate.notNull(methodIds, "'methodIds' is required");
        Validate.noNullElements(methodIds, "'methodIds' must not contain null elements");
        this.id = id;
        this.methodIds = methodIds;
    }

    public InterfaceIdentifier getIdentifier() {
        return this.id;
    }

    public Set<MethodIdentifier> getMethodIdentifiers() {
        return this.methodIds;
    }

    public String toString() {
        return "Interface id: " + this.id + "\n  methods: " + this.methodIds;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof InterfaceDefinition)) {
            return false;
        }
        InterfaceDefinition other = (InterfaceDefinition)obj;
        return this.getIdentifier().equals(other.getIdentifier()) && this.getMethodIdentifiers().equals(other.getMethodIdentifiers());
    }

    public int hashCode() {
        int hash = 1;
        hash = hash * 31 + this.getIdentifier().hashCode();
        hash = hash * 31 + this.getMethodIdentifiers().hashCode();
        return hash;
    }
}

