/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.internal.bindings;

import com.vmware.vapi.bindings.Task;
import com.vmware.vapi.bindings.client.AsyncCallback;
import com.vmware.vapi.bindings.type.Type;
import com.vmware.vapi.std.Progress;
import java.util.concurrent.CompletableFuture;

public class AsyncCallbackFactory<T> {
    public static <T> AsyncCallback<T> getCallback(final CompletableFuture<T> future) {
        return new AsyncCallback<T>(){

            @Override
            public void onProgress(Progress progress) {
            }

            @Override
            public void onResult(T result) {
                future.complete(result);
            }

            @Override
            public void onError(RuntimeException error) {
                future.completeExceptionally(error);
            }
        };
    }

    public static <T> AsyncCallback<String> getTaskCallback(final CompletableFuture<Task<T>> future, final Type outputType) {
        return new AsyncCallback<String>(){

            @Override
            public void onProgress(Progress progress) {
            }

            @Override
            public void onResult(String result) {
                Task taskResult = new Task(result, outputType);
                future.complete(taskResult);
            }

            @Override
            public void onError(RuntimeException error) {
                future.completeExceptionally(error);
            }
        };
    }
}

