/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.internal.util.time;

public class Chronometer {
    private State runningState = State.UNSTARTED;
    private long startTime;
    private long stopTime;

    public void start() {
        if (this.runningState == State.STOPPED) {
            throw new IllegalStateException("Stopwatch must be reset before being restarted. ");
        }
        if (this.runningState != State.UNSTARTED) {
            throw new IllegalStateException("Stopwatch already started. ");
        }
        this.stopTime = 0L;
        this.startTime = System.nanoTime();
        this.runningState = State.RUNNING;
    }

    public void stop() {
        if (this.runningState != State.RUNNING) {
            throw new IllegalStateException("Stopwatch is not running. ");
        }
        this.stopTime = System.nanoTime();
        this.runningState = State.STOPPED;
    }

    public void reset() {
        this.runningState = State.UNSTARTED;
    }

    public long getTime() {
        if (this.runningState == State.UNSTARTED) {
            return 0L;
        }
        if (this.runningState == State.STOPPED) {
            return this.stopTime - this.startTime;
        }
        if (this.runningState == State.RUNNING) {
            return System.nanoTime() - this.startTime;
        }
        throw new RuntimeException("Illegal running state has occured. ");
    }

    static enum State {
        UNSTARTED,
        RUNNING,
        STOPPED;

    }
}

