"""
Copyright (c) 2021 VMware, Inc.  All rights reserved. -- VMware Confidential

Some util functions for DataSets in-guest APIs.
"""

import json
import logging
import shlex
import subprocess

# run a command line through the shell and return the result
def run_cmd(cmdline):
    logging.debug("Running cmdline %s", cmdline)
    ret = subprocess.run(args=cmdline, text=True, capture_output=True,
                         shell=True)
    if ret.returncode != 0:
        logging.debug("Command failed: %s returned %s (%d)",
                      cmdline, ret.stderr, ret.returncode)
        return ret.stderr
    output = ret.stdout
    logging.debug("Command returned: '%s'", output)
    return output

# takes a full datasets RPC as a string, executes it and returns the result
def run_rpc(cmd):
    cmdline = "vmtoolsd --cmd '" + cmd + "'"
    return run_cmd(cmdline)

# takes a datasets RPC and combines json object, executes and returns
def run_rpc_json(cmd, json_obj):
    # shlex.quote() does the magic to make sure any embedded quotes
    # in the json values are properly quoted
    cmdline = "vmtoolsd --cmd " + shlex.quote(cmd + " " + json.dumps(json_obj))
    return run_cmd(cmdline)

# parses json string and returns requested object
def json_str_to_obj(rep, dictname):
    dcode = json.JSONDecoder()
    p = dcode.decode(rep)
    return p[dictname]

# finds the 'result' field and checks against desired value
def check_result(rep, wanted):
    result = json_str_to_obj(rep, 'result')
    logging.debug("check_result(): Result is %s", result)
    if result == wanted:
        logging.debug("check_result() passed")
        return True
    logging.debug("check_result() failed")
    return False

