/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.automatic.plugin.registration;

import com.vmware.automatic.plugin.registration.actions.Action;
import com.vmware.automatic.plugin.registration.commands.IsPluginRegisteredCmd;
import com.vmware.automatic.plugin.registration.commands.PluginCmd;
import com.vmware.automatic.plugin.registration.commands.RegisterPluginCmd;
import com.vmware.automatic.plugin.registration.commands.UnregisterPluginCmd;
import com.vmware.automatic.plugin.registration.commands.UpdatePluginCmd;
import com.vmware.automatic.plugin.registration.services.ConnectionService;
import com.vmware.automatic.plugin.registration.services.PluginExtensionRegistryService;
import com.vmware.automatic.plugin.registration.services.SslTrustStrategy;
import com.vmware.vim25.VimService;
import org.apache.commons.cli.DefaultParser;

public class PluginCmdInstanceCreator {
    public PluginCmd getInstance(String actionValue) {
        Action action = Action.fromValue(actionValue);
        ConnectionService connectionService = new ConnectionService(new VimService(), new SslTrustStrategy());
        PluginExtensionRegistryService registryService = new PluginExtensionRegistryService();
        DefaultParser cmdLineParser = new DefaultParser();
        switch (action) {
            case REGISTER_PLUGIN: {
                return new RegisterPluginCmd(connectionService, registryService, cmdLineParser);
            }
            case UPDATE_PLUGIN: {
                return new UpdatePluginCmd(connectionService, registryService, cmdLineParser);
            }
            case UNREGISTER_PLUGIN: {
                return new UnregisterPluginCmd(connectionService, registryService, cmdLineParser);
            }
            case IS_PLUGIN_REGISTERED: {
                return new IsPluginRegisteredCmd(connectionService, registryService, cmdLineParser);
            }
        }
        return null;
    }
}

