/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.automatic.plugin.registration.commands;

import com.vmware.automatic.plugin.registration.commands.PluginCmd;
import com.vmware.automatic.plugin.registration.services.ConnectionService;
import com.vmware.automatic.plugin.registration.services.PluginExtensionRegistryService;
import com.vmware.vim25.NotFoundFaultMsg;
import org.apache.commons.cli.CommandLineParser;

public class UnregisterPluginCmd
extends PluginCmd {
    public UnregisterPluginCmd(ConnectionService connectionService, PluginExtensionRegistryService registryService, CommandLineParser parser) {
        super(connectionService, registryService, parser);
    }

    @Override
    protected void doExecute() throws Exception {
        String key = this._commandLine.getOptionValue("k");
        String url = this._commandLine.getOptionValue("url");
        try {
            this.connectionService.getVimPort().unregisterExtension(this.connectionService.getExtensionManager(), key);
        }
        catch (NotFoundFaultMsg ex) {
            System.out.println(String.format("Plugin with key '%s' is not registered to vCenter Server <%s>.", key, url));
            throw ex;
        }
        System.out.println(String.format("Plugin '%s' has been successfully un-registered from vCenter Server <%s>.", key, url));
    }
}

