/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.provisioning.impl;

import com.vmware.vcenter.inventory.Network;
import com.vmware.vcenter.inventory.NetworkTypes;
import com.vmware.vcenter.ovf.CertificateParams;
import com.vmware.vcenter.ovf.DeploymentOptionParams;
import com.vmware.vcenter.ovf.EulaParams;
import com.vmware.vcenter.ovf.ExtraConfigParams;
import com.vmware.vcenter.ovf.IpAllocationParams;
import com.vmware.vcenter.ovf.NameAndProductParams;
import com.vmware.vcenter.ovf.NetworkMappingParams;
import com.vmware.vcenter.ovf.PropertyParams;
import com.vmware.vcenter.ovf.SizeParams;
import com.vmware.vcenter.ovf.SourceNetwork;
import com.vmware.vcenter.ovf.TargetNetwork;
import com.vmware.vcenter.ovf.VServiceParams;
import com.vmware.vim.vmomi.cis.CisIdConverter;
import com.vmware.vise.data.query.internal.PropertyProviderBean;
import com.vmware.vise.data.query.type;
import com.vmware.vsphere.client.provisioning.VServiceInfoFactory;
import com.vmware.vsphere.client.provisioning.spec.EulaInfo;
import com.vmware.vsphere.client.provisioning.spec.NetworkMapping;
import com.vmware.vsphere.client.provisioning.spec.NetworkMappingsSpec;
import com.vmware.vsphere.client.provisioning.spec.ProductDetailsData;
import com.vmware.vsphere.client.provisioning.spec.UserDefinedPropertiesData;
import com.vmware.vsphere.client.provisioning.spec.VServiceInfo;
import com.vmware.vsphere.client.util.collection.CollectionUtil;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.StringUtils;

public class ProvisioningPropertyProvider
implements PropertyProviderBean {
    private final Network _network;

    public ProvisioningPropertyProvider(Network network) {
        this._network = network;
    }

    @type(value="com.vmware.vsphere.client.provisioning.Context")
    public EulaInfo getEulaInfo(URI objRef, List<Object> commonContext) {
        EulaParams eulaParams = (EulaParams)CollectionUtil.getObjectByType(commonContext, EulaParams.class);
        List eulas = eulaParams != null ? eulaParams.getEulas() : null;
        EulaInfo nfo = new EulaInfo();
        if (eulas != null) {
            nfo.eula = eulas.toArray(new String[eulas.size()]);
            nfo.checkSum = DigestUtils.md5Hex((byte[])StringUtils.join((Collection)eulas, (String)"").getBytes());
        }
        return nfo;
    }

    @type(value="com.vmware.vsphere.client.provisioning.Context")
    public DeploymentOptionParams getDeploymentOption(URI objRef, List<Object> commonContext) {
        DeploymentOptionParams deploymentOptionParams = (DeploymentOptionParams)CollectionUtil.getObjectByType(commonContext, DeploymentOptionParams.class);
        return deploymentOptionParams;
    }

    @type(value="com.vmware.vsphere.client.provisioning.Context")
    public NetworkMappingsSpec getNetworkMappings(URI objRef, List<Object> commonContext) {
        List sourceNetworks;
        NetworkMappingsSpec result = null;
        NetworkMappingParams networkParams = (NetworkMappingParams)CollectionUtil.getObjectByType(commonContext, NetworkMappingParams.class);
        List list = sourceNetworks = networkParams != null ? networkParams.getSourceNetworks() : null;
        if (sourceNetworks != null) {
            Map idToNetInfo = this._network.find(this.getUniqueNetworkIds(sourceNetworks));
            result = new NetworkMappingsSpec();
            result.networkMappings = new NetworkMapping[sourceNetworks.size()];
            ArrayList<NetworkMapping> mappings = new ArrayList<NetworkMapping>();
            for (SourceNetwork source : networkParams.getSourceNetworks()) {
                String networkType;
                NetworkTypes.Info networkInfo;
                NetworkMapping mapping = new NetworkMapping();
                mapping.sourceNetworkName = source.getName();
                mapping.sourceNetworkDescription = source.getDescription();
                String target = source.getTarget();
                if (target != null && idToNetInfo != null && (networkInfo = (NetworkTypes.Info)idToNetInfo.get(target)) != null && (networkType = networkInfo.getType()) != null) {
                    mapping.targetNetworkRef = CisIdConverter.fromGlobalCisId((String)target, (String)networkType);
                }
                mappings.add(mapping);
            }
            mappings.toArray(result.networkMappings);
        }
        return result;
    }

    private List<String> getUniqueNetworkIds(List<SourceNetwork> sourceNetworks) {
        HashSet<String> networkIds = new HashSet<String>();
        if (sourceNetworks != null) {
            for (SourceNetwork source : sourceNetworks) {
                if (source == null || source.getTarget() == null) continue;
                networkIds.add(source.getTarget());
            }
        }
        ArrayList<String> result = new ArrayList<String>();
        result.addAll(networkIds);
        return result;
    }

    private List<String> getUniqueTargetNetworkIds(List<TargetNetwork> targetNetworks) {
        HashSet<String> networkIds = new HashSet<String>();
        if (targetNetworks != null) {
            for (TargetNetwork target : targetNetworks) {
                if (target == null || target.getId() == null) continue;
                networkIds.add(target.getId());
            }
        }
        ArrayList<String> result = new ArrayList<String>();
        result.addAll(networkIds);
        return result;
    }

    @type(value="com.vmware.vsphere.client.provisioning.Context")
    public IpAllocationParams getOvfIpAllocationData(Object target, List<Object> commonContext) {
        IpAllocationParams ipAllocationParams = (IpAllocationParams)CollectionUtil.getObjectByType(commonContext, IpAllocationParams.class);
        return ipAllocationParams;
    }

    @type(value="com.vmware.vsphere.client.provisioning.Context")
    public ProductDetailsData getProductDetails(URI objRef, List<Object> commonContext) {
        ProductDetailsData result = new ProductDetailsData();
        result.certificateParam = (CertificateParams)CollectionUtil.getObjectByType(commonContext, CertificateParams.class);
        result.nameAndProductParams = (NameAndProductParams)CollectionUtil.getObjectByType(commonContext, NameAndProductParams.class);
        result.sizeParams = (SizeParams)CollectionUtil.getObjectByType(commonContext, SizeParams.class);
        result.extraConfigParams = (ExtraConfigParams)CollectionUtil.getObjectByType(commonContext, ExtraConfigParams.class);
        return result;
    }

    @type(value="com.vmware.vsphere.client.provisioning.Context")
    public UserDefinedPropertiesData getUserDefinedProperties(URI objRef, List<Object> commonContext) {
        UserDefinedPropertiesData result = new UserDefinedPropertiesData();
        result.propertyParams = (PropertyParams)CollectionUtil.getObjectByType(commonContext, PropertyParams.class);
        result.ipAllocationParams = (IpAllocationParams)CollectionUtil.getObjectByType(commonContext, IpAllocationParams.class);
        return result;
    }

    @type(value="com.vmware.vcenter.VirtualDatacenter,ResourcePool")
    public VServiceInfo getVServiceInfo(Object objRef, Object[] commonContext) {
        VServiceParams params = (VServiceParams)CollectionUtil.getObjectByType((Object[])commonContext, VServiceParams.class);
        VServiceInfoFactory factory = new VServiceInfoFactory();
        VServiceInfo vserviceInfo = factory.createVServiceInfo(params);
        return vserviceInfo;
    }
}

