/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.libraryItem.impl;

import com.vmware.cis.data.api.PropertyPredicate;
import com.vmware.cis.data.api.QueryService;
import com.vmware.cis.data.api.ResourceItem;
import com.vmware.cis.data.api.ResultSet;
import com.vmware.cis.data.query.util.QueryServiceFactory;
import com.vmware.content.library.Item;
import com.vmware.vise.data.PropertySpec;
import com.vmware.vise.data.query.DataServiceExtensionRegistry;
import com.vmware.vise.data.query.PropertyProviderAdapter;
import com.vmware.vise.data.query.PropertyRequestSpec;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.TypeInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LibraryItemPropertyAdapter
implements PropertyProviderAdapter {
    private static final Log _logger = LogFactory.getLog(LibraryItemPropertyAdapter.class);
    private static final String GUEST_OS_FOR_LIBRARY_ITEM_PROP = "guestOSForLibraryItem";
    private QueryServiceFactory _queryServiceFactory;
    private final DataServiceExtensionRegistry _dsExtensionRegistry;

    public LibraryItemPropertyAdapter(DataServiceExtensionRegistry registry, QueryServiceFactory queryServiceFactory) {
        _logger.info((Object)"instantiated");
        this._dsExtensionRegistry = registry;
        this._queryServiceFactory = queryServiceFactory;
    }

    public void initialize() {
        _logger.info((Object)"initializing...");
        TypeInfo tiLibraryItem = new TypeInfo();
        tiLibraryItem.type = Item.class.getCanonicalName();
        tiLibraryItem.properties = new String[]{GUEST_OS_FOR_LIBRARY_ITEM_PROP};
        this._dsExtensionRegistry.registerDataAdapter((PropertyProviderAdapter)this, new TypeInfo[]{tiLibraryItem});
    }

    public com.vmware.vise.data.query.ResultSet getProperties(PropertyRequestSpec propertyRequest) {
        com.vmware.vise.data.query.ResultSet result = new com.vmware.vise.data.query.ResultSet();
        HashSet<String> requestedPropertyNames = new HashSet<String>();
        for (PropertySpec ps : propertyRequest.properties) {
            requestedPropertyNames.addAll(Arrays.asList(ps.propertyNames));
        }
        result.items = this.getResultItems(propertyRequest.objects, requestedPropertyNames);
        result.totalMatchedObjectCount = propertyRequest.objects.length;
        return result;
    }

    private ResultItem[] getResultItems(Object[] objects, Set<String> requestedPropertyNames) {
        HashMap<Object, List> resultsByObject = new HashMap<Object, List>();
        for (String propertyName : requestedPropertyNames) {
            if (!propertyName.equals(GUEST_OS_FOR_LIBRARY_ITEM_PROP)) continue;
            for (Map.Entry<Object, Object> entry : this.getGuestOSForLibraryItem(new HashSet<Object>(Arrays.asList(objects))).entrySet()) {
                List propValues = resultsByObject.getOrDefault(entry.getKey(), new ArrayList());
                propValues.add(this.newPropertyValue(GUEST_OS_FOR_LIBRARY_ITEM_PROP, entry.getValue()));
                resultsByObject.put(entry.getKey(), propValues);
            }
        }
        ResultItem[] resultItems = new ResultItem[objects.length];
        for (int i = 0; i < objects.length; ++i) {
            Object object = objects[i];
            ResultItem result = new ResultItem();
            result.resourceObject = object;
            result.properties = resultsByObject.get(object) != null ? ((List)resultsByObject.get(object)).toArray(new PropertyValue[0]) : new PropertyValue[]{};
            resultItems[i] = result;
        }
        return resultItems;
    }

    private Map<Object, Object> getGuestOSForLibraryItem(Set<Object> objects) {
        HashMap<Object, Object> result = new HashMap<Object, Object>();
        QueryService qsOvf = this._queryServiceFactory.getQueryService();
        ResultSet libraryItemsResultOvf = qsOvf.select(new String[]{"vmTemplate/osDescription"}).from(new String[]{"com.vmware.content.library.ItemModel", "com.vmware.content.type.ovf.OvfTemplate"}).where(new PropertyPredicate[]{new PropertyPredicate("id", PropertyPredicate.ComparisonOperator.IN, objects)}).fetch();
        for (ResourceItem libraryItem : libraryItemsResultOvf.getItems()) {
            if (libraryItem.get("vmTemplate/osDescription") == null) continue;
            result.put(libraryItem.getKey(), libraryItem.get("vmTemplate/osDescription"));
        }
        if (result.size() == objects.size()) {
            return result;
        }
        objects.removeAll(result.keySet());
        QueryService qsVmtx = this._queryServiceFactory.getQueryService();
        ResultSet libraryItemsResultVmtx = qsVmtx.select(new String[]{"com.vmware.vcenter.vm_template.LibraryItems.Info/guestOsDescription"}).from(new String[]{"com.vmware.content.library.ItemModel", "com.vmware.vcenter.vm_template.LibraryItems.Info"}).where(new PropertyPredicate[]{new PropertyPredicate("id", PropertyPredicate.ComparisonOperator.IN, objects)}).fetch();
        for (ResourceItem libraryItem : libraryItemsResultVmtx.getItems()) {
            if (libraryItem.get("com.vmware.vcenter.vm_template.LibraryItems.Info/guestOsDescription") == null) continue;
            result.put(libraryItem.getKey(), libraryItem.get("com.vmware.vcenter.vm_template.LibraryItems.Info/guestOsDescription"));
        }
        return result;
    }

    private PropertyValue newPropertyValue(String name, Object value) {
        PropertyValue result = new PropertyValue();
        result.propertyName = name;
        result.value = value;
        return result;
    }
}

