/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.subscriptions.impl;

import com.vmware.content.Library;
import com.vmware.content.library.Item;
import com.vmware.content.library.Subscriptions;
import com.vmware.vapi.bindings.client.InvocationConfig;
import com.vmware.vapi.std.errors.OperationNotFound;
import com.vmware.vapi.std.errors.ServiceUnavailable;
import com.vmware.vcenter.vm_template.library_items.Versions;
import com.vmware.vim.binding.vim.Folder;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.PropertySpec;
import com.vmware.vise.data.query.DataServiceExtensionRegistry;
import com.vmware.vise.data.query.PropertyProviderAdapter;
import com.vmware.vise.data.query.PropertyRequestSpec;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.query.TypeInfo;
import com.vmware.vise.data.uri.resolve.VapiUriSchemeUtil;
import com.vmware.vise.vim.vapi.util.VapiUtil;
import java.net.URI;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ContentLibrarySpecificCapabilitiesPropertyProviderAdapter
implements PropertyProviderAdapter {
    private static final Log _logger = LogFactory.getLog(ContentLibrarySpecificCapabilitiesPropertyProviderAdapter.class);
    private static final String IS_SUBSCRIPTIONS_CAPABILITY_SUPPORTED_PROP = "isSubscriptionsCapabilitySupported";
    private static final String IS_VERSIONING_CAPABILITY_SUPPORTED_PROP = "isVersioningCapabilitySupported";
    private static final String DUMMY_SUBSCRIPTION_ID = "DummySubscription";
    private static final String DUMMY_LIBRARY_ID = "DummyLibraryID";
    private static final String DUMMY_LIBRARY_ITEM_ID = "DummyLibraryItemID";
    private final Subscriptions _subscriptionsService;
    private final Versions _versionsService;
    private final DataServiceExtensionRegistry _dsExtensionRegistry;

    public ContentLibrarySpecificCapabilitiesPropertyProviderAdapter(Subscriptions subscriptionsService, Versions versionsService, DataServiceExtensionRegistry registry) {
        this._subscriptionsService = subscriptionsService;
        this._versionsService = versionsService;
        this._dsExtensionRegistry = registry;
    }

    public void initialize() {
        TypeInfo tiLibrary = new TypeInfo();
        tiLibrary.type = Library.class.getCanonicalName();
        tiLibrary.properties = new String[]{IS_SUBSCRIPTIONS_CAPABILITY_SUPPORTED_PROP, IS_VERSIONING_CAPABILITY_SUPPORTED_PROP};
        TypeInfo tiFolder = new TypeInfo();
        tiFolder.type = Folder.class.getSimpleName();
        tiFolder.properties = new String[]{IS_SUBSCRIPTIONS_CAPABILITY_SUPPORTED_PROP};
        TypeInfo tiLibraryItem = new TypeInfo();
        tiLibraryItem.type = Item.class.getCanonicalName();
        tiLibraryItem.properties = new String[]{IS_SUBSCRIPTIONS_CAPABILITY_SUPPORTED_PROP};
        this._dsExtensionRegistry.registerDataAdapter((PropertyProviderAdapter)this, new TypeInfo[]{tiLibrary, tiFolder, tiLibraryItem});
    }

    public ResultSet getProperties(PropertyRequestSpec propertyRequest) {
        ResultSet result = new ResultSet();
        Object[] objects = propertyRequest.objects;
        PropertySpec[] propertySpecs = propertyRequest.properties;
        HashSet<String> requestedPropertyNames = new HashSet<String>();
        for (PropertySpec ps : propertySpecs) {
            requestedPropertyNames.addAll(Arrays.asList(ps.propertyNames));
        }
        result.items = this.getResultItems(objects, requestedPropertyNames);
        result.totalMatchedObjectCount = objects.length;
        return result;
    }

    private ResultItem[] getResultItems(Object[] objects, Set<String> requestedPropertyNames) {
        ResultItem[] resultItems = new ResultItem[objects.length];
        HashMap<String, Boolean> subscriptionsCapabilityPerServerGuid = new HashMap<String, Boolean>();
        HashMap<String, Boolean> versioningCapabilityPerServerGuid = new HashMap<String, Boolean>();
        for (int i = 0; i < objects.length; ++i) {
            Object object = objects[i];
            if (!(object instanceof URI) && !(object instanceof ManagedObjectReference)) {
                _logger.warn((Object)("Non-managed object or uri passed." + object));
                continue;
            }
            ResultItem result = new ResultItem();
            result.resourceObject = object;
            PropertyValue[] propertyValues = new PropertyValue[requestedPropertyNames.size()];
            int j = 0;
            for (String propertyName : requestedPropertyNames) {
                if (propertyName.equals(IS_SUBSCRIPTIONS_CAPABILITY_SUPPORTED_PROP)) {
                    propertyValues[j++] = this.getIsSubscriptionCapabilityAvailable(object, subscriptionsCapabilityPerServerGuid);
                    continue;
                }
                if (propertyName.equals(IS_VERSIONING_CAPABILITY_SUPPORTED_PROP)) {
                    propertyValues[j++] = this.getIsVersioningCapabilityAvailable(object, versioningCapabilityPerServerGuid);
                    continue;
                }
                _logger.debug((Object)("Non-provided property requested: " + propertyName));
                ++j;
            }
            result.properties = propertyValues;
            resultItems[i] = result;
        }
        return resultItems;
    }

    private PropertyValue getIsSubscriptionCapabilityAvailable(Object object, HashMap<String, Boolean> subscriptionsCapabilityPerServerGuid) {
        String libraryId = "";
        String libraryNodeUuid = "";
        if (object instanceof URI) {
            libraryId = VapiUriSchemeUtil.getId((URI)((URI)object));
            libraryNodeUuid = VapiUriSchemeUtil.getNodeUuid((URI)((URI)object));
        }
        if (object instanceof ManagedObjectReference) {
            libraryId = DUMMY_LIBRARY_ID;
            libraryNodeUuid = ((ManagedObjectReference)object).getServerGuid();
        }
        PropertyValue pv = new PropertyValue();
        pv.propertyName = IS_SUBSCRIPTIONS_CAPABILITY_SUPPORTED_PROP;
        pv.resourceObject = object;
        if (subscriptionsCapabilityPerServerGuid.containsKey(libraryNodeUuid)) {
            pv.value = subscriptionsCapabilityPerServerGuid.get(libraryNodeUuid);
            return pv;
        }
        InvocationConfig invConfig = VapiUtil.newInvocationConfig((String)libraryNodeUuid);
        try {
            this._subscriptionsService.get(libraryId, DUMMY_SUBSCRIPTION_ID, invConfig);
            subscriptionsCapabilityPerServerGuid.put(libraryNodeUuid, true);
            pv.value = true;
        }
        catch (OperationNotFound | ServiceUnavailable ex) {
            subscriptionsCapabilityPerServerGuid.put(libraryNodeUuid, false);
            pv.value = false;
        }
        catch (Exception ex) {
            subscriptionsCapabilityPerServerGuid.put(libraryNodeUuid, true);
            pv.value = true;
        }
        return pv;
    }

    private PropertyValue getIsVersioningCapabilityAvailable(Object object, Map<String, Boolean> versioningCapabilityPerServerGuid) {
        String libraryNodeUuid = "";
        if (object instanceof URI) {
            libraryNodeUuid = VapiUriSchemeUtil.getNodeUuid((URI)((URI)object));
        }
        if (object instanceof ManagedObjectReference) {
            libraryNodeUuid = ((ManagedObjectReference)object).getServerGuid();
        }
        PropertyValue pv = new PropertyValue();
        pv.propertyName = IS_VERSIONING_CAPABILITY_SUPPORTED_PROP;
        pv.resourceObject = object;
        if (versioningCapabilityPerServerGuid.containsKey(libraryNodeUuid)) {
            pv.value = versioningCapabilityPerServerGuid.get(libraryNodeUuid);
            return pv;
        }
        InvocationConfig invConfig = VapiUtil.newInvocationConfig((String)libraryNodeUuid);
        try {
            this._versionsService.get(DUMMY_LIBRARY_ITEM_ID, "1", invConfig);
            versioningCapabilityPerServerGuid.put(libraryNodeUuid, true);
            pv.value = true;
        }
        catch (OperationNotFound | ServiceUnavailable ex) {
            versioningCapabilityPerServerGuid.put(libraryNodeUuid, false);
            pv.value = false;
        }
        catch (Exception ex) {
            versioningCapabilityPerServerGuid.put(libraryNodeUuid, true);
            pv.value = true;
        }
        return pv;
    }
}

