/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.vmtx.libraryItem.impl;

import com.vmware.cis.data.api.PropertyPredicate;
import com.vmware.cis.data.api.QueryService;
import com.vmware.cis.data.api.ResourceItem;
import com.vmware.cis.data.api.ResultSet;
import com.vmware.cis.data.query.util.QueryServiceFactory;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.internal.PropertyProviderBean;
import com.vmware.vise.data.query.type;
import java.net.URI;
import org.apache.commons.lang.Validate;

public class VmtxLibraryItemPropertyProvider
implements PropertyProviderBean {
    private final DataService _dataService;
    private QueryService _queryService;
    private static final String VM_TYPE = "VirtualMachine";

    public VmtxLibraryItemPropertyProvider(DataService dataService, QueryServiceFactory queryServiceFactory) {
        Validate.notNull((Object)dataService, (String)"dataService is null");
        this._dataService = dataService;
        this._queryService = queryServiceFactory.getQueryService();
    }

    @type(value="com.vmware.content.library.Item")
    public ManagedObjectReference getMorIdOfVmtx(URI objRef) {
        ResultSet libraryItemsResult = this._queryService.select(new String[]{"com.vmware.vcenter.vm_template.LibraryItems.Info/vmTemplate"}).from(new String[]{"com.vmware.content.library.ItemModel", "com.vmware.vcenter.vm_template.LibraryItems.Info"}).where(new PropertyPredicate[]{new PropertyPredicate("id", PropertyPredicate.ComparisonOperator.EQUAL, (Object)objRef)}).fetch();
        if (libraryItemsResult != null && !libraryItemsResult.getItems().isEmpty()) {
            ResourceItem item = (ResourceItem)libraryItemsResult.getItems().get(0);
            return this.convertVmIdToManagedObject(item);
        }
        return null;
    }

    private ManagedObjectReference convertVmIdToManagedObject(ResourceItem item) {
        String[] parts;
        Object firstItem;
        if (!item.getPropertyValues().isEmpty() && (firstItem = item.getPropertyValues().get(0)) != null && !firstItem.toString().isEmpty() && (parts = firstItem.toString().split(":")).length == 2) {
            return new ManagedObjectReference(VM_TYPE, parts[0], parts[1]);
        }
        return null;
    }
}

