/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.hostprofile.impl;

import com.vmware.vim.binding.vim.ClusterComputeResource;
import com.vmware.vim.binding.vim.HostSystem;
import com.vmware.vim.binding.vim.TaskInfo;
import com.vmware.vim.binding.vim.profile.host.AnswerFileStatusResult;
import com.vmware.vim.binding.vim.profile.host.HostProfile;
import com.vmware.vim.binding.vim.profile.host.ProfileManager;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.core.model.exception.CompositeException;
import com.vmware.vise.data.PropertySpec;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.DataServiceExtensionRegistry;
import com.vmware.vise.data.query.PropertyProviderAdapter;
import com.vmware.vise.data.query.PropertyRequestSpec;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.query.TypeInfo;
import com.vmware.vise.data.query.util.QueryUtil;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vise.vim.commons.MixedUtil;
import com.vmware.vise.vim.tasks.TaskMonitor;
import com.vmware.vsphere.client.hostprofile.data.AssociatedHostProfileSummaryData;
import com.vmware.vsphere.client.hostprofile.util.HostProfileUtils;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.Validate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AssociationHostSystemAdapter
implements PropertyProviderAdapter {
    private static final Log _logger = LogFactory.getLog(AssociationHostSystemAdapter.class);
    private static final int MINIMUM_ENTITIES_FOR_BATCH_QUERY = 10;
    private DataService _dataService;
    private final TaskMonitor _taskMonitor;

    public AssociationHostSystemAdapter(DataServiceExtensionRegistry registry, DataService dataService, TaskMonitor taskMonitor) {
        registry.registerDataAdapter((PropertyProviderAdapter)this, this.getProvidedTypeInfos());
        this._dataService = dataService;
        this._taskMonitor = taskMonitor;
    }

    public ResultSet getProperties(PropertyRequestSpec propertyRequest) {
        Validate.notNull((Object)propertyRequest);
        Object[] objects = propertyRequest.objects;
        PropertySpec[] propertySpecs = propertyRequest.properties;
        Map<ManagedObjectReference, Collection<PropertyValue>> properties = AssociationHostSystemAdapter.filterSystemObjects(objects);
        Map entitiesPerVC = HostProfileUtils.groupEntitiesByVc(properties.keySet());
        ArrayList<Exception> faults = new ArrayList<Exception>();
        if (HostProfileUtils.isPropertyRequested((String)"hostCustomizationsStatus", (PropertySpec[])propertySpecs)) {
            this.buildAnswerFileStatusResults(properties, entitiesPerVC, faults);
        }
        if (HostProfileUtils.isPropertyRequested((String)"associatedHostProfile", (PropertySpec[])propertySpecs) || HostProfileUtils.isPropertyRequested((String)"associatedHostProfileName", (PropertySpec[])propertySpecs) || HostProfileUtils.isPropertyRequested((String)"associatedHostProfileSummary", (PropertySpec[])propertySpecs)) {
            this.buildPropertyResults(properties, entitiesPerVC, faults, propertySpecs);
        }
        ResultSet result = new ResultSet();
        if (faults.size() > 0) {
            result.error = new CompositeException(faults);
        }
        result.items = AssociationHostSystemAdapter.mergeResults(properties);
        return result;
    }

    private void buildAnswerFileStatusResults(Map<ManagedObjectReference, Collection<PropertyValue>> properties, Map<String, Collection<ManagedObjectReference>> entitiesPerVC, List<Exception> faults) {
        for (Map.Entry<String, Collection<ManagedObjectReference>> groupedEntitiesPerVC : entitiesPerVC.entrySet()) {
            Collection<ManagedObjectReference> entities = groupedEntitiesPerVC.getValue();
            List<ManagedObjectReference> hosts = this.extractHosts(entities);
            if (hosts.isEmpty()) continue;
            try {
                ProfileManager profileManager = HostProfileUtils.getProfileManager((String)groupedEntitiesPerVC.getKey());
                ManagedObjectReference taskRef = profileManager.checkAnswerFileStatus(hosts.toArray(new ManagedObjectReference[hosts.size()]));
                TaskInfo taskInfo = this._taskMonitor.monitorTask(taskRef);
                if (taskInfo.error != null) {
                    throw taskInfo.error;
                }
                AnswerFileStatusResult[] answerFileStatus = (AnswerFileStatusResult[])taskInfo.result;
                for (AnswerFileStatusResult statusResult : answerFileStatus) {
                    AssociationHostSystemAdapter.addPropertyValue(properties, statusResult.host, "hostCustomizationsStatus", statusResult.status);
                    hosts.remove(statusResult.host);
                }
                for (ManagedObjectReference host : hosts) {
                    AssociationHostSystemAdapter.addPropertyValue(properties, host, "hostCustomizationsStatus", ProfileManager.AnswerFileStatus.unknown);
                }
            }
            catch (Exception ex) {
                _logger.warn((Object)"Exception occurs during extraction of the answer file statuses", (Throwable)ex);
                faults.add((Exception)MixedUtil.getMethodFault((Throwable)ex));
            }
        }
    }

    private TypeInfo[] getProvidedTypeInfos() {
        TypeInfo hostTypeInfo = new TypeInfo();
        hostTypeInfo.type = HostSystem.class.getSimpleName();
        hostTypeInfo.properties = new String[]{"associatedHostProfile", "associatedHostProfileName", "associatedHostProfileSummary", "hostCustomizationsStatus"};
        TypeInfo clusterTypeInfo = new TypeInfo();
        clusterTypeInfo.type = ClusterComputeResource.class.getSimpleName();
        clusterTypeInfo.properties = new String[]{"associatedHostProfile", "associatedHostProfileName", "associatedHostProfileSummary"};
        return new TypeInfo[]{hostTypeInfo, clusterTypeInfo};
    }

    private static Map<ManagedObjectReference, Collection<PropertyValue>> filterSystemObjects(Object[] objects) {
        HashMap<ManagedObjectReference, Collection<PropertyValue>> hostsAndClusters = new HashMap<ManagedObjectReference, Collection<PropertyValue>>();
        for (Object object : objects) {
            ManagedObjectReference reference;
            if (!(object instanceof ManagedObjectReference) || !(reference = (ManagedObjectReference)object).getType().equals(ClusterComputeResource.class.getSimpleName()) && !reference.getType().equals(HostSystem.class.getSimpleName())) continue;
            hostsAndClusters.put(reference, new ArrayList());
        }
        return hostsAndClusters;
    }

    private List<ManagedObjectReference> extractHosts(Collection<ManagedObjectReference> entities) {
        ArrayList<ManagedObjectReference> hosts = new ArrayList<ManagedObjectReference>();
        for (ManagedObjectReference entity : entities) {
            if (!entity.getType().equals(HostSystem.class.getSimpleName())) continue;
            hosts.add(entity);
        }
        return hosts;
    }

    private static void addPropertyValue(Map<ManagedObjectReference, Collection<PropertyValue>> properties, ManagedObjectReference object, String propertyName, Object propertyValue) {
        PropertyValue result = new PropertyValue();
        result.resourceObject = object;
        result.propertyName = propertyName;
        result.value = propertyValue;
        properties.get(object).add(result);
    }

    private static Object findProfileValue(PropertyValue[] profileValues, ManagedObjectReference profile, String propertyName) {
        if (profile == null || profileValues == null) {
            return null;
        }
        for (PropertyValue profileValue : profileValues) {
            ManagedObjectReference profileObjectRef = (ManagedObjectReference)profileValue.resourceObject;
            if (!ManagedObjectUtil.areEqual((ManagedObjectReference)profileObjectRef, (ManagedObjectReference)profile).booleanValue() || !propertyName.equals(profileValue.propertyName)) continue;
            return profileValue.value;
        }
        return null;
    }

    private void assignServerResults(Map<ManagedObjectReference, ManagedObjectReference> profileAssociations, Map<ManagedObjectReference, Collection<PropertyValue>> properties, PropertySpec[] propertySpecs) throws Exception {
        String[] profileProperties = null;
        boolean isProfileNameRequested = HostProfileUtils.isPropertyRequested((String)"associatedHostProfileName", (PropertySpec[])propertySpecs);
        boolean isProfileSummaryRequested = HostProfileUtils.isPropertyRequested((String)"associatedHostProfileSummary", (PropertySpec[])propertySpecs);
        if (isProfileSummaryRequested) {
            profileProperties = new String[]{"name", "createdTime", "modifiedTime"};
        } else if (isProfileNameRequested) {
            profileProperties = new String[]{"name"};
        }
        PropertyValue[] profileValues = null;
        if (profileProperties != null) {
            HashSet<ManagedObjectReference> uniqueProfiles = new HashSet<ManagedObjectReference>();
            for (ManagedObjectReference profile : profileAssociations.values()) {
                uniqueProfiles.add(profile);
            }
            profileValues = uniqueProfiles.size() > 0 ? QueryUtil.getProperties((DataService)this._dataService, (Object[])uniqueProfiles.toArray(), (String[])profileProperties) : new PropertyValue[]{};
        }
        for (Map.Entry<ManagedObjectReference, Collection<PropertyValue>> entry : properties.entrySet()) {
            ManagedObjectReference entity = entry.getKey();
            ManagedObjectReference associatedProfile = profileAssociations.get(entity);
            if (HostProfileUtils.isPropertyRequested((String)"associatedHostProfile", (PropertySpec[])propertySpecs)) {
                AssociationHostSystemAdapter.addPropertyValue(properties, entity, "associatedHostProfile", associatedProfile);
            }
            if (isProfileNameRequested) {
                Object proflieName = AssociationHostSystemAdapter.findProfileValue(profileValues, associatedProfile, "name");
                AssociationHostSystemAdapter.addPropertyValue(properties, entity, "associatedHostProfileName", proflieName);
            }
            if (!isProfileSummaryRequested) continue;
            AssociatedHostProfileSummaryData summaryData = null;
            if (associatedProfile != null) {
                summaryData = new AssociatedHostProfileSummaryData();
                summaryData.profile = associatedProfile;
                summaryData.name = (String)AssociationHostSystemAdapter.findProfileValue(profileValues, associatedProfile, "name");
                summaryData.creationTime = (Calendar)AssociationHostSystemAdapter.findProfileValue(profileValues, associatedProfile, "createdTime");
                summaryData.lastUpdateTime = (Calendar)AssociationHostSystemAdapter.findProfileValue(profileValues, associatedProfile, "modifiedTime");
            }
            AssociationHostSystemAdapter.addPropertyValue(properties, entity, "associatedHostProfileSummary", summaryData);
        }
    }

    private static ManagedObjectReference getAssociatedHostProfile(ProfileManager profileManager, ManagedObjectReference entity) throws Exception {
        ManagedObjectReference result = null;
        ManagedObjectReference[] profiles = profileManager.findAssociatedProfile(entity);
        if (profiles != null) {
            for (ManagedObjectReference profile : profiles) {
                if (!profile.getType().equals(HostProfile.class.getSimpleName())) continue;
                result = profile;
                break;
            }
        }
        return result;
    }

    private void doSingleQuery(String serverGuid, Collection<ManagedObjectReference> entities, Map<ManagedObjectReference, ManagedObjectReference> associatedProfiles) throws Exception {
        ProfileManager profileManager = HostProfileUtils.getProfileManager((String)serverGuid);
        for (ManagedObjectReference entity : entities) {
            ManagedObjectReference profileRef = AssociationHostSystemAdapter.getAssociatedHostProfile(profileManager, entity);
            if (profileRef == null) continue;
            associatedProfiles.put(entity, profileRef);
        }
    }

    private void doBatchQuery(String serverGuid, Collection<ManagedObjectReference> entities, Map<ManagedObjectReference, ManagedObjectReference> associatedProfiles) throws Exception {
        ProfileManager profileManager = HostProfileUtils.getProfileManager((String)serverGuid);
        ManagedObjectReference[] profiles = profileManager.getProfile();
        HashMap<ManagedObjectReference, ManagedObjectReference> allAssociations = new HashMap<ManagedObjectReference, ManagedObjectReference>();
        for (ManagedObjectReference profile : profiles) {
            ManagedObjectReference[] attachedEntities = (ManagedObjectReference[])QueryUtil.getProperty((DataService)this._dataService, (Object)profile, (String)"entity");
            if (attachedEntities == null) continue;
            for (ManagedObjectReference entity : attachedEntities) {
                allAssociations.put(entity, profile);
            }
        }
        for (ManagedObjectReference entity : entities) {
            ManagedObjectReference profileRef = (ManagedObjectReference)allAssociations.get(entity);
            if (profileRef == null) continue;
            associatedProfiles.put(entity, profileRef);
        }
    }

    private Map<ManagedObjectReference, ManagedObjectReference> getAssociatedProfiles(String serverGuid, Collection<ManagedObjectReference> entities) throws Exception {
        HashMap<ManagedObjectReference, ManagedObjectReference> result = new HashMap<ManagedObjectReference, ManagedObjectReference>();
        if (entities.size() < 10) {
            this.doSingleQuery(serverGuid, entities, result);
        } else {
            this.doBatchQuery(serverGuid, entities, result);
        }
        return result;
    }

    private void buildPropertyResults(Map<ManagedObjectReference, Collection<PropertyValue>> propertiesResult, Map<String, Collection<ManagedObjectReference>> entitiesPerVC, List<Exception> faults, PropertySpec[] propertySpecs) {
        for (Map.Entry<String, Collection<ManagedObjectReference>> groupedEntitiesPerVC : entitiesPerVC.entrySet()) {
            String serverGuid = groupedEntitiesPerVC.getKey();
            Collection<ManagedObjectReference> entities = groupedEntitiesPerVC.getValue();
            try {
                Map<ManagedObjectReference, ManagedObjectReference> profileAssociations = this.getAssociatedProfiles(serverGuid, entities);
                this.assignServerResults(profileAssociations, propertiesResult, propertySpecs);
            }
            catch (Exception ex) {
                _logger.warn((Object)"Exception occurs while extraction of associated host profile", (Throwable)ex);
                faults.add((Exception)MixedUtil.getMethodFault((Throwable)ex));
            }
        }
    }

    private static ResultItem[] mergeResults(Map<ManagedObjectReference, Collection<PropertyValue>> properties) {
        ResultItem[] result = new ResultItem[properties.size()];
        int index = 0;
        for (Map.Entry<ManagedObjectReference, Collection<PropertyValue>> entityItem : properties.entrySet()) {
            ResultItem resultItem = new ResultItem();
            resultItem.resourceObject = entityItem.getKey();
            resultItem.properties = entityItem.getValue().toArray(new PropertyValue[0]);
            result[index++] = resultItem;
        }
        return result;
    }
}

