/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.hostprofile.impl;

import com.vmware.vim.binding.vim.ClusterComputeResource;
import com.vmware.vim.binding.vim.HostSystem;
import com.vmware.vim.binding.vim.profile.ComplianceLocator;
import com.vmware.vim.binding.vim.profile.ComplianceManager;
import com.vmware.vim.binding.vim.profile.ComplianceResult;
import com.vmware.vim.binding.vim.profile.ParameterMetadata;
import com.vmware.vim.binding.vim.profile.PolicyMetadata;
import com.vmware.vim.binding.vim.profile.PolicyOptionMetadata;
import com.vmware.vim.binding.vim.profile.ProfileCategoryMetadata;
import com.vmware.vim.binding.vim.profile.ProfileComponentMetadata;
import com.vmware.vim.binding.vim.profile.ProfileMetadata;
import com.vmware.vim.binding.vim.profile.host.HostProfile;
import com.vmware.vim.binding.vim.profile.host.ProfileManager;
import com.vmware.vim.binding.vmodl.KeyAnyValue;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.internal.PropertyProviderBean;
import com.vmware.vise.data.query.type;
import com.vmware.vise.data.query.util.QueryUtil;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vise.vim.commons.VimSessionUtil;
import com.vmware.vise.vim.commons.i18n.LocalizationUtil;
import com.vmware.vise.vim.commons.vcservice.VcService;
import com.vmware.vsphere.client.hostprofile.data.ComplianceFailureValue;
import com.vmware.vsphere.client.hostprofile.data.ComplianceFailuresByCategory;
import com.vmware.vsphere.client.hostprofile.data.ProfileWrapper;
import com.vmware.vsphere.client.hostprofile.impl.I18nUtil;
import com.vmware.vsphere.client.hostprofile.util.HostProfileUtils;
import com.vmware.vsphere.client.hostprofile.util.ProfileNameUtil;
import com.vmware.vsphere.client.hostprofile.util.ProfilePathUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ComplianceFailuresPropertyProvider
implements PropertyProviderBean {
    private static final String KEY_PREFIX = "Key-[";
    private static final String VALUE_PREFIX = "Value-[";
    private static final String PARAM_NAME_PREFIX = "ParamName-[";
    private static final String POLICY_NAME = "PolicyName-[";
    private static final Log _logger = LogFactory.getLog(ComplianceFailuresPropertyProvider.class);
    private final DataService _dataService;

    public ComplianceFailuresPropertyProvider(DataService dataService) {
        this._dataService = dataService;
    }

    @type(value="HostSystem,ClusterComputeResource")
    public ComplianceFailuresByCategory[] getComplianceFailures(ManagedObjectReference moRef, ManagedObjectReference profileRef) throws Exception {
        ComplianceResult[] results;
        if (profileRef == null) {
            if (moRef.getType().equals(HostSystem.class.getSimpleName())) {
                profileRef = (ManagedObjectReference)QueryUtil.getProperty((DataService)this._dataService, (Object)moRef, (String)"associatedHostProfile");
            } else if (moRef.getType().equals(ClusterComputeResource.class.getSimpleName())) {
                profileRef = (ManagedObjectReference)QueryUtil.getProperty((DataService)this._dataService, (Object)moRef, (String)"associatedClusterProfile");
            }
        }
        if (profileRef == null) {
            return null;
        }
        VcService vc = VimSessionUtil.getService((String)moRef.getServerGuid());
        try {
            ManagedObjectReference managerRef = vc.getServiceInstanceContent().getComplianceManager();
            ComplianceManager manager = (ComplianceManager)ManagedObjectUtil.getManagedObject((ManagedObjectReference)managerRef);
            results = manager.queryComplianceStatus(new ManagedObjectReference[]{profileRef}, new ManagedObjectReference[]{moRef});
        }
        catch (Exception e) {
            _logger.error((Object)e);
            return null;
        }
        if (results == null) {
            return null;
        }
        PolicyMetadata[] policyMeta = new PolicyMetadata[]{};
        ProfileComponentMetadata[] componentMeta = new ProfileComponentMetadata[]{};
        ProfileWrapper pw = null;
        if (profileRef.getType().equals(HostProfile.class.getSimpleName())) {
            ProfileManager.HostProfileMetadata hostProfileMeta = HostProfileUtils.getHostProfileMetadata((ManagedObjectReference)profileRef, (ProfileManager.MetadataTypes[])new ProfileManager.MetadataTypes[]{ProfileManager.MetadataTypes.profile, ProfileManager.MetadataTypes.policy, ProfileManager.MetadataTypes.category, ProfileManager.MetadataTypes.component});
            pw = ProfilePathUtil.buildProfileWrapper((ManagedObjectReference)profileRef, (ProfileMetadata[])hostProfileMeta.profileMetadata, (PolicyMetadata[])hostProfileMeta.policyMetadata, (ProfileCategoryMetadata[])hostProfileMeta.profileCategoryMetadata, (ProfileComponentMetadata[])hostProfileMeta.profileComponentMetadata);
            policyMeta = hostProfileMeta.policyMetadata;
            componentMeta = hostProfileMeta.profileComponentMetadata;
        }
        ComplianceFailuresByCategory[] retVal = null;
        HashMap<String, ArrayList<String>> expresionParamNameKeyMap = new HashMap<String, ArrayList<String>>();
        HashMap<String, List<ComplianceFailureValue>> paramNameKeyComplianceFailureMap = new HashMap<String, List<ComplianceFailureValue>>();
        HashMap<String, ArrayList<ComplianceFailureValue>> policyNameKeyComplianceFailureMap = new HashMap<String, ArrayList<ComplianceFailureValue>>();
        HashMap<String, String> relevantProfilePaths = new HashMap<String, String>();
        ProfilePathUtil.extractProfileParamsPaths(pw, relevantProfilePaths);
        HostProfile hostProfile = (HostProfile)ManagedObjectUtil.getManagedObject((ManagedObjectReference)profileRef);
        HostProfile.ConfigInfo configInfo = (HostProfile.ConfigInfo)hostProfile.getConfig();
        ComplianceLocator[] complianceLocators = configInfo.defaultComplyLocator;
        for (ComplianceResult result : results) {
            if (result.failure == null) continue;
            HashMap<String, ComplianceFailuresByCategory> failuresByCategory = new HashMap<String, ComplianceFailuresByCategory>();
            for (ComplianceResult.ComplianceFailure failure : result.failure) {
                String category = ComplianceFailuresPropertyProvider.getFailureCategory(failure, componentMeta, profileRef);
                if (!failuresByCategory.containsKey(category)) {
                    ComplianceFailuresByCategory complianceFailure = new ComplianceFailuresByCategory();
                    complianceFailure.complianceFailures = new ArrayList();
                    complianceFailure.category = category;
                    failuresByCategory.put(category, complianceFailure);
                }
                this.initComplianceFailures(paramNameKeyComplianceFailureMap, policyNameKeyComplianceFailureMap, expresionParamNameKeyMap, failuresByCategory, failure, category, complianceLocators, relevantProfilePaths);
            }
            if (paramNameKeyComplianceFailureMap.size() > 0 || policyNameKeyComplianceFailureMap.size() > 0) {
                Map<String, String> paramNameKeyPolicyIdMap = this.createParameterNameKeyPolicyIdMap(complianceLocators, expresionParamNameKeyMap);
                this.initParameterNamesOfComplianceFailureValue(policyMeta, paramNameKeyComplianceFailureMap, policyNameKeyComplianceFailureMap, paramNameKeyPolicyIdMap);
            }
            retVal = new ComplianceFailuresByCategory[failuresByCategory.values().size()];
            failuresByCategory.values().toArray(retVal);
        }
        return retVal;
    }

    private void initComplianceFailures(Map<String, List<ComplianceFailureValue>> paramNameKeyComplianceFailureMap, Map<String, ArrayList<ComplianceFailureValue>> policyNameKeyComplianceFailureMap, Map<String, ArrayList<String>> expresionParamNameKeyMap, Map<String, ComplianceFailuresByCategory> failuresByCategory, ComplianceResult.ComplianceFailure failure, String category, ComplianceLocator[] complianceLocators, Map<String, String> relevantProfilePaths) {
        String humanReadableProfilePath = "";
        for (ComplianceLocator complianceLocator : complianceLocators) {
            if (failure.expressionName == null || !failure.expressionName.equals(complianceLocator.getExpressionName())) continue;
            String profilePath = complianceLocator.getApplyPath().getProfilePath();
            humanReadableProfilePath = relevantProfilePaths.get(profilePath);
            break;
        }
        String failureMessage = LocalizationUtil.getLocalizedMessage((String)failure.message.getKey(), (KeyAnyValue[])failure.message.getArg());
        if (failure.failureValues == null || failure.failureValues.length == 0) {
            ComplianceFailureValue complianceValue = new ComplianceFailureValue(failureMessage, null);
            complianceValue.profilePath = humanReadableProfilePath;
            failuresByCategory.get((Object)category).complianceFailures.add(complianceValue);
            return;
        }
        for (ComplianceResult.ComplianceFailure.ComplianceFailureValues value : failure.failureValues) {
            String paramNameKey;
            ComplianceFailureValue complianceValue = new ComplianceFailureValue(failureMessage, value);
            complianceValue.profilePath = humanReadableProfilePath;
            failuresByCategory.get((Object)category).complianceFailures.add(complianceValue);
            if (value.comparisonIdentifier == null) continue;
            String comparisonIdentifier = value.comparisonIdentifier;
            if (comparisonIdentifier.startsWith(PARAM_NAME_PREFIX)) {
                complianceValue.parameterName = paramNameKey = comparisonIdentifier.substring(PARAM_NAME_PREFIX.length(), comparisonIdentifier.length() - 1);
                this.addComplianceValue(paramNameKeyComplianceFailureMap, complianceValue);
                ArrayList<String> expresionParamNameKey = expresionParamNameKeyMap.get(failure.expressionName);
                if (expresionParamNameKey == null) {
                    expresionParamNameKey = new ArrayList();
                    expresionParamNameKey.add(paramNameKey);
                    expresionParamNameKeyMap.put(failure.expressionName, expresionParamNameKey);
                    continue;
                }
                expresionParamNameKey.add(paramNameKey);
                continue;
            }
            if (comparisonIdentifier.startsWith(VALUE_PREFIX)) {
                complianceValue.parameterName = comparisonIdentifier.substring(VALUE_PREFIX.length(), comparisonIdentifier.length() - 1);
                continue;
            }
            if (comparisonIdentifier.startsWith(KEY_PREFIX)) {
                String identifierKey = comparisonIdentifier.substring(KEY_PREFIX.length(), comparisonIdentifier.length() - 1);
                String comparisonIdentifierValue = LocalizationUtil.getLocalizedMessage((String)identifierKey);
                complianceValue.parameterName = comparisonIdentifierValue = ProfileNameUtil.trimPlaceholders((String)comparisonIdentifierValue);
                continue;
            }
            if (comparisonIdentifier.startsWith(POLICY_NAME)) {
                complianceValue.parameterName = paramNameKey = comparisonIdentifier.substring(POLICY_NAME.length(), comparisonIdentifier.length() - 1);
                ArrayList<Object> complianceValues = policyNameKeyComplianceFailureMap.get(paramNameKey);
                if (complianceValues == null) {
                    complianceValues = new ArrayList();
                    policyNameKeyComplianceFailureMap.put(paramNameKey, complianceValues);
                }
                complianceValues.add(complianceValue);
                continue;
            }
            complianceValue.parameterName = LocalizationUtil.getLocalizedMessage((String)comparisonIdentifier);
        }
    }

    private void addComplianceValue(Map<String, List<ComplianceFailureValue>> paramNameKeyComplianceFailureMap, ComplianceFailureValue complianceValue) {
        List<ComplianceFailureValue> complianceFailureValues = paramNameKeyComplianceFailureMap.get(complianceValue.parameterName);
        if (complianceFailureValues == null) {
            complianceFailureValues = new ArrayList<ComplianceFailureValue>();
            paramNameKeyComplianceFailureMap.put(complianceValue.parameterName, complianceFailureValues);
        }
        complianceFailureValues.add(complianceValue);
    }

    private Map<String, String> createParameterNameKeyPolicyIdMap(ComplianceLocator[] complianceLocators, Map<String, ArrayList<String>> expresionParamNameKeyMap) {
        HashMap<String, String> parameterNameIdentifierPolicyIdMap = new HashMap<String, String>();
        if (expresionParamNameKeyMap.isEmpty()) {
            return parameterNameIdentifierPolicyIdMap;
        }
        for (ComplianceLocator complianceLocator : complianceLocators) {
            ArrayList<String> paramNameKeys = expresionParamNameKeyMap.remove(complianceLocator.getExpressionName());
            if (paramNameKeys == null) continue;
            String policyId = complianceLocator.getApplyPath().getPolicyId();
            for (String paramValiue : paramNameKeys) {
                parameterNameIdentifierPolicyIdMap.put(paramValiue, policyId);
            }
            if (expresionParamNameKeyMap.isEmpty()) break;
        }
        return parameterNameIdentifierPolicyIdMap;
    }

    private void initParameterNamesOfComplianceFailureValue(PolicyMetadata[] policyMeta, Map<String, List<ComplianceFailureValue>> paramNameKeyComplianceFailureMap, Map<String, ArrayList<ComplianceFailureValue>> policyNameKeyComplianceFailureMap, Map<String, String> paramNameKeyPolicyIdMap) {
        if (policyMeta == null) {
            return;
        }
        for (PolicyMetadata meta : policyMeta) {
            if (paramNameKeyComplianceFailureMap.isEmpty() && policyNameKeyComplianceFailureMap.isEmpty()) {
                return;
            }
            if (policyNameKeyComplianceFailureMap.containsKey(meta.getId().key)) {
                ArrayList<ComplianceFailureValue> complianceFailureValues = policyNameKeyComplianceFailureMap.get(meta.id.key);
                this.localizePolicyNameComplianceFailure(meta, complianceFailureValues);
                policyNameKeyComplianceFailureMap.remove(meta.getId().key);
                continue;
            }
            this.localizeParameterComplianceFailure(paramNameKeyComplianceFailureMap, paramNameKeyPolicyIdMap, meta);
        }
    }

    private void localizeParameterComplianceFailure(Map<String, List<ComplianceFailureValue>> paramNameKeyComplianceFailureMap, Map<String, String> paramNameKeyPolicyIdMap, PolicyMetadata meta) {
        if (paramNameKeyComplianceFailureMap.isEmpty()) {
            return;
        }
        for (PolicyOptionMetadata possibleOption : meta.getPossibleOption()) {
            if (possibleOption.parameter == null) continue;
            for (ParameterMetadata parameterMetadata : possibleOption.parameter) {
                String policyId;
                List<ComplianceFailureValue> complianceFailureValues = paramNameKeyComplianceFailureMap.get(parameterMetadata.id.key);
                if (complianceFailureValues == null || complianceFailureValues.size() <= 0 || (policyId = paramNameKeyPolicyIdMap.get(parameterMetadata.id.key)) != null && !meta.getId().key.endsWith(policyId)) continue;
                String parameterLabelKey = parameterMetadata.id.messageCatalogKeyPrefix + ".label";
                this.updateParameterName(parameterMetadata, complianceFailureValues, parameterLabelKey);
                paramNameKeyComplianceFailureMap.remove(parameterMetadata.id.key);
                if (!paramNameKeyComplianceFailureMap.isEmpty()) continue;
                return;
            }
        }
    }

    private void updateParameterName(ParameterMetadata parameterMetadata, List<ComplianceFailureValue> complianceFailureValues, String parameterLabelKey) {
        String parameterName = null;
        for (ComplianceFailureValue complianceFailureValue : complianceFailureValues) {
            if (parameterName == null) {
                parameterName = LocalizationUtil.getLocalizedMessage((String)parameterLabelKey);
            }
            complianceFailureValue.parameterName = parameterName;
            if (!complianceFailureValue.parameterName.equals(parameterLabelKey)) continue;
            complianceFailureValue.parameterName = parameterMetadata.id.key;
        }
    }

    private void localizePolicyNameComplianceFailure(PolicyMetadata meta, ArrayList<ComplianceFailureValue> complianceFailureValues) {
        String parameterName = LocalizationUtil.getLocalizedMessage((String)(meta.getId().getMessageCatalogKeyPrefix() + ".label"));
        for (ComplianceFailureValue complianceFailureValue : complianceFailureValues) {
            complianceFailureValue.parameterName = parameterName;
            this.localizePolicyNameComplianceFailureValues(meta, complianceFailureValue);
        }
    }

    private void localizePolicyNameComplianceFailureValues(PolicyMetadata meta, ComplianceFailureValue complianceFailureValue) {
        String hostValueKey = complianceFailureValue.hostValue;
        String profileValueKey = complianceFailureValue.profileValue;
        for (PolicyOptionMetadata possibleOption : meta.getPossibleOption()) {
            if (possibleOption.id == null || possibleOption.id.key == null) continue;
            if (hostValueKey != null && possibleOption.id.key.contains(hostValueKey)) {
                complianceFailureValue.hostValue = LocalizationUtil.getLocalizedMessage((String)(possibleOption.id.messageCatalogKeyPrefix + ".label"));
                hostValueKey = null;
            }
            if (profileValueKey != null && possibleOption.id.key.contains(profileValueKey)) {
                complianceFailureValue.profileValue = LocalizationUtil.getLocalizedMessage((String)(possibleOption.id.messageCatalogKeyPrefix + ".label"));
                profileValueKey = null;
            }
            if (hostValueKey == null && profileValueKey == null) break;
        }
    }

    private static String getFailureCategory(ComplianceResult.ComplianceFailure failure, ProfileComponentMetadata[] componentMeta, ManagedObjectReference profileRef) {
        String result = null;
        if (failure.expressionName != null) {
            block0: for (ProfileComponentMetadata meta : componentMeta) {
                for (String path : meta.profilePaths) {
                    String label;
                    if (failure.expressionName.indexOf(path) <= -1) continue;
                    result = label = LocalizationUtil.getLocalizedMessage((String)(meta.id.messageCatalogKeyPrefix + ".label"), (KeyAnyValue[])meta.id.messageArg);
                    break block0;
                }
            }
            if (result == null) {
                int[] separators = new int[]{failure.expressionName.indexOf(46), failure.expressionName.indexOf(45), failure.expressionName.indexOf(91)};
                int categorySeparatorIndex = -1;
                for (int i = 0; i < separators.length; ++i) {
                    if (categorySeparatorIndex != -1 && (categorySeparatorIndex <= separators[i] || separators[i] == -1)) continue;
                    categorySeparatorIndex = separators[i];
                }
                result = categorySeparatorIndex != -1 ? failure.expressionName.substring(0, categorySeparatorIndex) : failure.expressionName;
            }
        }
        if (result == null) {
            result = I18nUtil.getLocalizedString("complianceFailure.common");
        }
        return result;
    }
}

