/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.hostprofile.impl;

import com.vmware.vim.binding.vim.ClusterComputeResource;
import com.vmware.vim.binding.vim.TaskInfo;
import com.vmware.vim.binding.vim.profile.DeferredPolicyOptionParameter;
import com.vmware.vim.binding.vim.profile.host.ProfileManager;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.core.model.exception.CompositeException;
import com.vmware.vise.core.model.mutation.OperationResult;
import com.vmware.vise.core.model.mutation.ValidationResult;
import com.vmware.vise.data.common.PropertyValidationNode;
import com.vmware.vise.data.mutation.MutationMapping;
import com.vmware.vise.data.mutation.MutationProvider;
import com.vmware.vise.vim.commons.MixedUtil;
import com.vmware.vise.vim.tasks.TaskMonitor;
import com.vmware.vsphere.client.hostprofile.cluster.impl.Util;
import com.vmware.vsphere.client.hostprofile.data.DeferredHostSettingsSpec;
import com.vmware.vsphere.client.hostprofile.data.DeferredSettingsValidationResult;
import com.vmware.vsphere.client.hostprofile.data.ExecuteResultWrapper;
import com.vmware.vsphere.client.hostprofile.data.HostCustomizationsValidationError;
import com.vmware.vsphere.client.hostprofile.data.h5.HostCustomizationIntermediateValidationResult;
import com.vmware.vsphere.client.hostprofile.data.h5.UpdateHostCustomizationsSpec;
import com.vmware.vsphere.client.hostprofile.data.h5.ValidateHostCustomizationsSpec;
import com.vmware.vsphere.client.hostprofile.impl.I18nUtil;
import com.vmware.vsphere.client.hostprofile.impl.hostcustomizations.HostApplyConfigService;
import com.vmware.vsphere.client.hostprofile.impl.hostcustomizations.HostCustomizationsBatchService;
import com.vmware.vsphere.client.hostprofile.impl.hostcustomizations.HostCustomizationsSequenceService;
import com.vmware.vsphere.client.hostprofile.impl.hostcustomizations.HostCustomizationsService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DeferredHostSettingsMutationProvider
implements MutationProvider {
    private static final Log logger = LogFactory.getLog(DeferredHostSettingsMutationProvider.class);
    private static final String CLUSTER_TYPE = ClusterComputeResource.class.getSimpleName();
    private final TaskMonitor taskMonitor;
    private final HostCustomizationsSequenceService hostCustomizationSequenceService;
    private final HostCustomizationsBatchService hostCustomizationBatchService;
    private final HostApplyConfigService hostApplyConfigService;
    private final HostCustomizationsService service;

    public DeferredHostSettingsMutationProvider(TaskMonitor taskMonitor, HostCustomizationsService service, HostCustomizationsSequenceService hostCustomizationSequenceService, HostCustomizationsBatchService hostCustomizationBatchService, HostApplyConfigService hostApplyConfigService) {
        this.taskMonitor = taskMonitor;
        this.service = service;
        this.hostCustomizationSequenceService = hostCustomizationSequenceService;
        this.hostCustomizationBatchService = hostCustomizationBatchService;
        this.hostApplyConfigService = hostApplyConfigService;
    }

    @MutationMapping(type="HostProfile", property="deferredHostSettings")
    public ValidationResult validateDeferredHostSettings(ManagedObjectReference profileRef, DeferredHostSettingsSpec spec, Object[] rows) throws Exception {
        ValidationResult result;
        try {
            ManagedObjectReference[] hosts = DeferredHostSettingsMutationProvider.getHostsForValidation(spec);
            Map<ManagedObjectReference, String> hostEntityNameMap = this.service.createHostEntityNameMap(hosts);
            Map<ManagedObjectReference, DeferredPolicyOptionParameter[]> deferredPolicyOptionParameterMap = this.service.createDeferredPolicyOptionParameterMap(rows, hostEntityNameMap);
            HostCustomizationIntermediateValidationResult intermediateResult = this.validateHostCustomizations(profileRef, spec, hosts, deferredPolicyOptionParameterMap);
            result = this.getPropertyValidationNodesValidationResult(intermediateResult, hostEntityNameMap, deferredPolicyOptionParameterMap);
        }
        catch (Exception e) {
            result = DeferredHostSettingsMutationProvider.handleValidationError(e);
        }
        return result;
    }

    public ValidationResult validate(ManagedObjectReference profileRef, ValidateHostCustomizationsSpec spec) throws Exception {
        ValidationResult result;
        try {
            ManagedObjectReference[] hosts = DeferredHostSettingsMutationProvider.getHostsForValidation((DeferredHostSettingsSpec)spec);
            Map<ManagedObjectReference, String> hostEntityNameMap = this.service.createHostEntityNameMap(hosts);
            Map<ManagedObjectReference, DeferredPolicyOptionParameter[]> deferredPolicyOptionParameterMap = this.service.createDeferredPolicyOptionParameterMap(spec.currentHostCustomizations, hostEntityNameMap);
            HostCustomizationIntermediateValidationResult intermediateResult = this.validateHostCustomizations(profileRef, (DeferredHostSettingsSpec)spec, hosts, deferredPolicyOptionParameterMap);
            result = this.populateValidationResult(intermediateResult, hostEntityNameMap);
            ConcurrentHashMap<String, ExecuteResultWrapper> cachedResultsMap = new ConcurrentHashMap<String, ExecuteResultWrapper>();
            if (intermediateResult != null && intermediateResult.cachedResults instanceof Map) {
                Map cachedResults = (Map)intermediateResult.cachedResults;
                for (Object key : cachedResults.keySet()) {
                    if (!(key instanceof String) || !(cachedResults.get(key) instanceof ExecuteResultWrapper)) continue;
                    ExecuteResultWrapper executeResult = (ExecuteResultWrapper)cachedResults.get(key);
                    cachedResultsMap.put((String)key, executeResult);
                }
            }
            result.parameter = cachedResultsMap;
        }
        catch (Exception e) {
            result = DeferredHostSettingsMutationProvider.handleValidationError(e);
        }
        return result;
    }

    private HostCustomizationIntermediateValidationResult validateHostCustomizations(ManagedObjectReference profileRef, DeferredHostSettingsSpec spec, ManagedObjectReference[] hosts, Map<ManagedObjectReference, DeferredPolicyOptionParameter[]> deferredPolicyOptionParameterMap) throws Exception {
        ProfileManager.HostProfileMetadata hostProfileMeta = this.service.getHostProfilePolicyMetadata(profileRef);
        HostCustomizationIntermediateValidationResult result = !spec.executeProfile && this.service.isBulkAnswerFileEnabled(profileRef) ? this.hostCustomizationBatchService.validateHostCustomizations(profileRef, spec, deferredPolicyOptionParameterMap, hostProfileMeta.policyMetadata) : (spec.executeProfile && this.service.isParallelOperationsEnabled(profileRef) ? this.hostApplyConfigService.validateHostApplyConfigData(hosts, deferredPolicyOptionParameterMap) : this.hostCustomizationSequenceService.validateHostCustomizations(profileRef, spec, hosts, deferredPolicyOptionParameterMap, hostProfileMeta.policyMetadata));
        return result;
    }

    private ValidationResult populateValidationResult(HostCustomizationIntermediateValidationResult intermediateResult, Map<ManagedObjectReference, String> hostEntityNameMap) {
        ValidationResult validationResult = new ValidationResult();
        if (validationResult.error != null) {
            validationResult.error = new CompositeException((Collection)intermediateResult.genericErrors);
        }
        HashMap<String, DeferredSettingsValidationResult> hostNamesToValidationResult = new HashMap<String, DeferredSettingsValidationResult>();
        if (intermediateResult.hostToValidationResult != null) {
            for (Map.Entry entry : intermediateResult.hostToValidationResult.entrySet()) {
                hostNamesToValidationResult.put(hostEntityNameMap.get(entry.getKey()), (DeferredSettingsValidationResult)entry.getValue());
            }
        }
        validationResult.result = hostNamesToValidationResult;
        return validationResult;
    }

    private ValidationResult getPropertyValidationNodesValidationResult(HostCustomizationIntermediateValidationResult intermediateResult, Map<ManagedObjectReference, String> hostEntityNameMap, Map<ManagedObjectReference, DeferredPolicyOptionParameter[]> deferredPolicyOptionParameterMap) throws Exception {
        ValidationResult validationResult = new ValidationResult();
        if (intermediateResult.genericErrors != null) {
            validationResult.error = new CompositeException((Collection)intermediateResult.genericErrors);
        }
        if (intermediateResult.cachedResults != null) {
            validationResult.result = intermediateResult.cachedResults;
        } else {
            HashMap<String, PropertyValidationNode> validationMessages = new HashMap<String, PropertyValidationNode>();
            if (intermediateResult.hostToValidationResult != null) {
                for (Map.Entry hostValidationResult : intermediateResult.hostToValidationResult.entrySet()) {
                    ManagedObjectReference host = (ManagedObjectReference)hostValidationResult.getKey();
                    DeferredPolicyOptionParameter[] policyOptions = deferredPolicyOptionParameterMap.get(host);
                    validationMessages.putAll(this.service.processValidationResults((DeferredSettingsValidationResult)hostValidationResult.getValue(), hostEntityNameMap.get(host), policyOptions));
                }
            }
            validationResult.result = validationMessages.values().toArray(new PropertyValidationNode[0]);
        }
        return validationResult;
    }

    @MutationMapping(type="HostProfile", property="deferredHostSettings")
    public OperationResult[] applyDeferredHostSettings(ManagedObjectReference profileRef, DeferredHostSettingsSpec spec, Object[] rows) {
        OperationResult[] result;
        try {
            result = this.service.isBulkAnswerFileEnabled(profileRef) ? this.hostCustomizationBatchService.applyHostCustomizations(profileRef, spec.forceValidationOnHosts, spec.skipValidationOnHosts, rows) : this.hostCustomizationSequenceService.applyHostCustomizations(profileRef, spec.forceValidationOnHosts, spec.skipValidationOnHosts, rows);
        }
        catch (Exception e) {
            logger.error((Object)"Update host customizations not started: ", (Throwable)e);
            OperationResult operation = new OperationResult();
            operation.error = new CompositeException(new Exception[]{new Exception(I18nUtil.getLocalizedString("error.updateHostCustomizationsNotStarted")), MixedUtil.getMethodFault((Throwable)e)});
            result = new OperationResult[]{operation};
        }
        return result;
    }

    public OperationResult[] applyOnMultiEntity(ManagedObjectReference[] profiles, DeferredHostSettingsSpec spec) throws Exception {
        ManagedObjectReference profileRef = profiles[0];
        Object[] operationResults = this.applyDeferredHostSettings(profileRef, spec, spec.currentHostCustomizations);
        if (ArrayUtils.isEmpty((Object[])operationResults)) {
            return operationResults;
        }
        Object operationResult = operationResults[0];
        if (((OperationResult)operationResult).error != null || ((OperationResult)operationResult).task == null) {
            return operationResults;
        }
        TaskInfo taskInfo = this.taskMonitor.monitorTask((ManagedObjectReference)((OperationResult)operationResult).task);
        if (taskInfo == null || !(taskInfo.result instanceof ProfileManager.AnswerFileValidationResultMap[])) {
            return operationResults;
        }
        ValidationResult validationResult = this.extractValidationResult((ProfileManager.AnswerFileValidationResultMap[])taskInfo.result, spec.currentHostCustomizations, spec.forceValidationOnHosts);
        if (validationResult != null && (validationResult.result instanceof PropertyValidationNode[] || validationResult.error != null)) {
            OperationResult validationFailedResult = new OperationResult();
            validationFailedResult.error = new HostCustomizationsValidationError(I18nUtil.getLocalizedString("error.deferredSettingsValidationFailed"));
            validationFailedResult.result = validationResult;
            return new OperationResult[]{validationFailedResult};
        }
        return operationResults;
    }

    public OperationResult[] applyOnMultiEntity(ManagedObjectReference[] entities, UpdateHostCustomizationsSpec spec) throws Exception {
        OperationResult[] result;
        if (spec.hostProfile == null && ArrayUtils.isEmpty((Object[])entities)) {
            throw new IllegalArgumentException("Supply a host profile in the spec!");
        }
        ManagedObjectReference[] hosts = entities[0].getType().equals(CLUSTER_TYPE) ? Util.getHostsForCluster(entities[0]) : entities;
        try {
            result = this.service.isBulkAnswerFileEnabled(spec.hostProfile) ? this.hostCustomizationBatchService.applyHostCustomizations(spec.hostProfile, hosts, null, spec.currentHostCustomizations) : this.hostCustomizationSequenceService.applyHostCustomizations(spec.hostProfile, hosts, null, spec.currentHostCustomizations);
        }
        catch (Exception e) {
            logger.error((Object)"Update host customizations not started: ", (Throwable)e);
            OperationResult operation = new OperationResult();
            operation.error = new CompositeException(new Exception[]{new Exception(I18nUtil.getLocalizedString("error.updateHostCustomizationsNotStarted")), MixedUtil.getMethodFault((Throwable)e)});
            result = new OperationResult[]{operation};
        }
        OperationResult operation = result != null && result.length > 0 ? result[0] : new OperationResult();
        return new OperationResult[]{operation};
    }

    private ValidationResult extractValidationResult(ProfileManager.AnswerFileValidationResultMap[] answerFileValidationResult, Object[] currentHostCustomizations, ManagedObjectReference[] hosts) throws Exception {
        Map<ManagedObjectReference, String> hostEntityNameMap = this.service.createHostEntityNameMap(hosts);
        Map<ManagedObjectReference, DeferredPolicyOptionParameter[]> deferredPolicyOptionParameterMap = this.service.createDeferredPolicyOptionParameterMap(currentHostCustomizations, hostEntityNameMap);
        HostCustomizationIntermediateValidationResult intermediateResult = this.service.createValidationResult(answerFileValidationResult);
        return this.getPropertyValidationNodesValidationResult(intermediateResult, hostEntityNameMap, deferredPolicyOptionParameterMap);
    }

    private static ValidationResult handleValidationError(Exception e) {
        ArrayList<Exception> errors = new ArrayList<Exception>();
        errors.add(new Exception(I18nUtil.getLocalizedString("error.validateHostCustomizations")));
        errors.add((Exception)MixedUtil.getMethodFault((Throwable)e));
        ValidationResult result = new ValidationResult();
        result.error = new CompositeException(errors);
        return result;
    }

    private static ManagedObjectReference[] getHostsForValidation(DeferredHostSettingsSpec spec) {
        return spec.forceValidationOnHosts == null ? new ManagedObjectReference[]{} : spec.forceValidationOnHosts;
    }
}

