/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.hostprofile.impl;

import com.vmware.vim.binding.vim.ClusterComputeResource;
import com.vmware.vim.binding.vim.profile.DeferredPolicyOptionParameter;
import com.vmware.vim.binding.vim.profile.PolicyMetadata;
import com.vmware.vim.binding.vim.profile.host.HostProfile;
import com.vmware.vim.binding.vim.profile.host.ProfileManager;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.core.model.exception.CompositeException;
import com.vmware.vise.core.model.mutation.OperationResult;
import com.vmware.vise.data.ParameterSpec;
import com.vmware.vise.data.PropertySpec;
import com.vmware.vise.data.common.DynamicObject;
import com.vmware.vise.data.mutation.MutationProvider;
import com.vmware.vise.data.query.DataServiceExtensionRegistry;
import com.vmware.vise.data.query.PropertyProviderAdapter;
import com.vmware.vise.data.query.PropertyRequestSpec;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.query.TypeInfo;
import com.vmware.vise.metadata.PropertyNodeDescriptor;
import com.vmware.vise.metadata.TypeNodeDescriptor;
import com.vmware.vise.vim.commons.MixedUtil;
import com.vmware.vsphere.client.hostprofile.cluster.impl.Util;
import com.vmware.vsphere.client.hostprofile.data.DeferredHostSettingsSpec;
import com.vmware.vsphere.client.hostprofile.data.ProfileWrapper;
import com.vmware.vsphere.client.hostprofile.data.h5.HostCustomizationSetting;
import com.vmware.vsphere.client.hostprofile.data.h5.ReadHostCustomizationsSpec;
import com.vmware.vsphere.client.hostprofile.impl.I18nUtil;
import com.vmware.vsphere.client.hostprofile.impl.hostcustomizations.HostCustomizationsBatchService;
import com.vmware.vsphere.client.hostprofile.impl.hostcustomizations.HostCustomizationsImportService;
import com.vmware.vsphere.client.hostprofile.impl.hostcustomizations.HostCustomizationsSequenceService;
import com.vmware.vsphere.client.hostprofile.impl.hostcustomizations.HostCustomizationsService;
import com.vmware.vsphere.client.hostprofile.impl.hostcustomizations.data.DeferredPolicyOptionData;
import com.vmware.vsphere.client.hostprofile.impl.hostcustomizations.data.HostCustomizationData;
import com.vmware.vsphere.client.hostprofile.util.HostProfileUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DeferredHostSettingsPropertyAdapter
implements PropertyProviderAdapter,
MutationProvider {
    private static final Log logger = LogFactory.getLog(DeferredHostSettingsPropertyAdapter.class);
    private static final String CLUSTER_TYPE = ClusterComputeResource.class.getSimpleName();
    private static final String DEFERRED_HOST_SETTINGS_PROPERTY = "deferredHostSettings";
    private static final String DEFERRED_HOST_SETTINGS_PROPERTY_METADATA = "deferredHostSettings.@info";
    private final HostCustomizationsImportService importService;
    private final HostCustomizationsSequenceService hostCustomizationSequenceService;
    private final HostCustomizationsBatchService hostCustomizationBatchService;
    private final HostCustomizationsService hostCustomizationsService;

    public DeferredHostSettingsPropertyAdapter(DataServiceExtensionRegistry registry, HostCustomizationsService hostCustomizationsService, HostCustomizationsImportService importService, HostCustomizationsSequenceService hostCustomizationSequenceService, HostCustomizationsBatchService hostCustomizationBatchService) {
        registry.registerDataAdapter((PropertyProviderAdapter)this, this.getProvidedTypeInfos());
        this.hostCustomizationsService = hostCustomizationsService;
        this.importService = importService;
        this.hostCustomizationSequenceService = hostCustomizationSequenceService;
        this.hostCustomizationBatchService = hostCustomizationBatchService;
    }

    private TypeInfo[] getProvidedTypeInfos() {
        TypeInfo hostProfileInfo = new TypeInfo();
        hostProfileInfo.type = HostProfile.class.getSimpleName();
        hostProfileInfo.properties = new String[]{DEFERRED_HOST_SETTINGS_PROPERTY, DEFERRED_HOST_SETTINGS_PROPERTY_METADATA};
        return new TypeInfo[]{hostProfileInfo};
    }

    private static DeferredHostSettingsSpec getDeferredHostSettingsSpecParameter(PropertySpec[] specs, String requestedProperty) {
        for (PropertySpec propertySpec : specs) {
            for (ParameterSpec parameterSpec : propertySpec.parameters) {
                Object parameter;
                String propertyName = parameterSpec.propertyName;
                if (!requestedProperty.equals(propertyName) || !((parameter = parameterSpec.parameter) instanceof DeferredHostSettingsSpec)) continue;
                return (DeferredHostSettingsSpec)parameter;
            }
        }
        return null;
    }

    private static PropertyValue buildPropertyValue(Object provider, String propertyName, Object propertyValue) {
        PropertyValue property = new PropertyValue();
        property.resourceObject = provider;
        property.propertyName = propertyName;
        property.value = propertyValue;
        return property;
    }

    private static ResultItem buildResultItem(ManagedObjectReference host, PropertyValue[] properties) {
        ResultItem resultItem = new ResultItem();
        resultItem.resourceObject = host;
        resultItem.properties = properties;
        return resultItem;
    }

    public ResultSet getProperties(PropertyRequestSpec propertyRequest) {
        Validate.notNull((Object)propertyRequest);
        Object[] objectsRefs = propertyRequest.objects;
        PropertySpec[] properties = propertyRequest.properties;
        ResultSet result = new ResultSet();
        boolean isProviderApplicable = this.isProviderApplicable(properties);
        if (isProviderApplicable) {
            ManagedObjectReference[] profileRefs = DeferredHostSettingsPropertyAdapter.getManagedObjectReferences(objectsRefs, HostProfile.class.getSimpleName());
            DeferredHostSettingsSpec deferredHostSettingsSpec = DeferredHostSettingsPropertyAdapter.getDeferredHostSettingsSpecParameter(properties, DEFERRED_HOST_SETTINGS_PROPERTY);
            result = !this.isProvidedSpecValid(deferredHostSettingsSpec) ? this.getEmptyResultSet(profileRefs) : this.extractHostCustomizationsData(profileRefs, deferredHostSettingsSpec);
        }
        return result;
    }

    private boolean isProviderApplicable(PropertySpec[] properties) {
        boolean isDeferredHostSettingsMetadataRequested = HostProfileUtils.isPropertyRequested((String)DEFERRED_HOST_SETTINGS_PROPERTY_METADATA, (PropertySpec[])properties);
        boolean isDeferredHostSettingsRequested = HostProfileUtils.isPropertyRequested((String)DEFERRED_HOST_SETTINGS_PROPERTY, (PropertySpec[])properties);
        return isDeferredHostSettingsRequested || isDeferredHostSettingsMetadataRequested;
    }

    private ResultSet extractHostCustomizationsData(ManagedObjectReference[] profileRefs, DeferredHostSettingsSpec spec) {
        Map<ManagedObjectReference, ProfileManager.HostProfileMetadata> hostProfilesMeta;
        ArrayList<ResultItem> profileResults = new ArrayList<ResultItem>();
        ArrayList<Exception> faults = new ArrayList<Exception>();
        ResultSet result = new ResultSet();
        try {
            hostProfilesMeta = this.hostCustomizationsService.getHostProfilesMetadata(profileRefs, spec.hostApplyProfileWrapper);
        }
        catch (Exception e) {
            logger.error((Object)"Could not retrieve HostProfileMetadata for the target profiles", (Throwable)e);
            faults.add(new Exception(I18nUtil.getLocalizedString("error.readDeferredHostSettingsMetadata")));
            faults.add((Exception)MixedUtil.getMethodFault((Throwable)e));
            result.error = new CompositeException(faults);
            return result;
        }
        for (ManagedObjectReference profileRef : profileRefs) {
            ProfileManager.HostProfileMetadata hostProfileMeta = hostProfilesMeta.get(profileRef);
            Map<String, String> relevantProfilePaths = this.hostCustomizationsService.buildRelevantProfilePaths(profileRef, hostProfileMeta, spec.hostApplyProfileWrapper);
            HostCustomizationData hostCustomizationsData = this.getHostCustomizationData(profileRef, hostProfileMeta, spec, relevantProfilePaths);
            TypeNodeDescriptor rootDescriptor = this.getDeferredHostSettingsMetadata(hostProfileMeta.policyMetadata, spec.forceValidationOnHosts, relevantProfilePaths, hostCustomizationsData.getUserInputMap());
            faults.addAll(hostCustomizationsData.getFaults());
            ResultItem profileResult = this.createResultItem(profileRef, hostCustomizationsData.getDeferredHostSettings(), rootDescriptor);
            profileResults.add(profileResult);
        }
        if (faults.size() > 0) {
            result.error = new CompositeException(faults);
        }
        result.items = profileResults.toArray(new ResultItem[profileResults.size()]);
        return result;
    }

    private ResultSet getEmptyResultSet(ManagedObjectReference[] profileRefs) {
        ArrayList<ResultItem> profileResults = new ArrayList<ResultItem>();
        ResultSet result = new ResultSet();
        for (ManagedObjectReference profileRef : profileRefs) {
            ResultItem profileResult = this.createResultItem(profileRef, null, null);
            profileResults.add(profileResult);
        }
        result.items = profileResults.toArray(new ResultItem[profileResults.size()]);
        return result;
    }

    private ResultItem createResultItem(ManagedObjectReference profileRef, DynamicObject[] deferredSettings, TypeNodeDescriptor rootDescriptor) {
        PropertyValue propertyData = DeferredHostSettingsPropertyAdapter.buildPropertyValue(profileRef, DEFERRED_HOST_SETTINGS_PROPERTY, deferredSettings);
        PropertyValue propertyMetadata = DeferredHostSettingsPropertyAdapter.buildPropertyValue(profileRef, DEFERRED_HOST_SETTINGS_PROPERTY_METADATA, rootDescriptor);
        return DeferredHostSettingsPropertyAdapter.buildResultItem(profileRef, new PropertyValue[]{propertyData, propertyMetadata});
    }

    private HostCustomizationData getHostCustomizationData(ManagedObjectReference profileRef, ProfileManager.HostProfileMetadata hostProfileMeta, DeferredHostSettingsSpec spec, Map<String, String> relevantProfilePaths) {
        HostCustomizationData hostCustomizationsData;
        try {
            if (spec.formattedCustomizations != null) {
                hostCustomizationsData = this.importService.importHostCustomizations(profileRef, spec, relevantProfilePaths, hostProfileMeta.policyMetadata);
            } else {
                DeferredPolicyOptionData hostDeferredSettings = this.getDeferredHostSettingsFromTheServer(profileRef, spec.forceValidationOnHosts, spec.isNewlyAssociatedProfile, spec.hostApplyProfileWrapper, hostProfileMeta.policyMetadata);
                hostCustomizationsData = this.createExtractHostCustomizationsResult(spec.forceValidationOnHosts, hostDeferredSettings, relevantProfilePaths, hostProfileMeta.policyMetadata);
            }
        }
        catch (Exception e) {
            logger.warn((Object)"Cannot retrieve deferred settings.", (Throwable)e);
            ArrayList<Exception> faults = new ArrayList<Exception>();
            faults.add((Exception)MixedUtil.getMethodFault((Throwable)e));
            hostCustomizationsData = new ExtractHostCustomizationsResult(faults);
        }
        return hostCustomizationsData;
    }

    private boolean isProvidedSpecValid(DeferredHostSettingsSpec spec) {
        return spec != null && !ArrayUtils.isEmpty((Object[])spec.forceValidationOnHosts);
    }

    private HostCustomizationData createExtractHostCustomizationsResult(ManagedObjectReference[] hosts, DeferredPolicyOptionData hostDeferredSettings, Map<String, String> relevantProfilePaths, PolicyMetadata[] policiesMetadata) throws Exception {
        ExtractHostCustomizationsResult hostCustomizationsData;
        if (!hostDeferredSettings.getUserInputMap().isEmpty()) {
            Map<ManagedObjectReference, String> hostEntityNameMap = this.hostCustomizationsService.createHostEntityNameMap(hosts);
            ArrayList<DynamicObject> resultList = this.extractHostSettings(hosts, policiesMetadata, relevantProfilePaths, hostDeferredSettings.getUserInputMap(), hostEntityNameMap);
            hostCustomizationsData = new ExtractHostCustomizationsResult(resultList, hostDeferredSettings);
        } else {
            hostCustomizationsData = new ExtractHostCustomizationsResult(hostDeferredSettings.getFaults());
        }
        return hostCustomizationsData;
    }

    private DeferredPolicyOptionData getDeferredHostSettingsFromTheServer(ManagedObjectReference hostProfileRef, ManagedObjectReference[] hosts, boolean isNewlyAssociatedProfile, ProfileWrapper hostApplyProfileWrapper, PolicyMetadata[] policiesMetadata) throws Exception {
        if (this.hostCustomizationsService.isBulkAnswerFileEnabled(hostProfileRef)) {
            return this.hostCustomizationBatchService.getDeferredHostSettings(hostProfileRef, hosts, isNewlyAssociatedProfile, hostApplyProfileWrapper, policiesMetadata);
        }
        return this.hostCustomizationSequenceService.getDeferredHostSettings(hostProfileRef, hosts, isNewlyAssociatedProfile, hostApplyProfileWrapper, policiesMetadata);
    }

    private TypeNodeDescriptor getDeferredHostSettingsMetadata(PolicyMetadata[] policiesMetadata, ManagedObjectReference[] hosts, Map<String, String> relevantProfilePaths, Map<ManagedObjectReference, DeferredPolicyOptionParameter[]> cachedResults) {
        if (cachedResults.isEmpty()) {
            return null;
        }
        ArrayList<PropertyNodeDescriptor> resultList = new ArrayList<PropertyNodeDescriptor>();
        for (ManagedObjectReference host : hosts) {
            DeferredPolicyOptionParameter[] deferredSettings = cachedResults.get(host);
            if (deferredSettings == null) continue;
            this.hostCustomizationsService.extractDeferredSettingsMetadata(resultList, policiesMetadata, relevantProfilePaths, deferredSettings);
        }
        TypeNodeDescriptor arrayDescriptor = new TypeNodeDescriptor();
        arrayDescriptor.name = "array";
        arrayDescriptor.properties = resultList.toArray(new PropertyNodeDescriptor[0]);
        return arrayDescriptor;
    }

    public OperationResult[] applyOnMultiEntity(ManagedObjectReference[] entities, ReadHostCustomizationsSpec spec) {
        if (spec.hostProfile == null && ArrayUtils.isEmpty((Object[])entities)) {
            throw new IllegalArgumentException("ReadHostCustomizations spec doesn't have host profile.");
        }
        ManagedObjectReference[] targetHosts = entities[0].getType().equals(CLUSTER_TYPE) ? Util.getHostsForCluster(entities[0]) : entities;
        OperationResult operationResult = new OperationResult();
        operationResult.entity = spec.hostProfile;
        try {
            List<HostCustomizationSetting> settings;
            DeferredPolicyOptionData newDeferredPolicyOptionsData;
            Map<ManagedObjectReference, String> hostEntityNameMap = this.hostCustomizationsService.createHostEntityNameMap(targetHosts);
            ProfileManager.HostProfileMetadata hostProfileMeta = this.getHostProfileMetadata(spec.hostProfile);
            Map<String, String> relevantProfilePaths = this.hostCustomizationsService.buildRelevantProfilePaths(spec.hostProfile, hostProfileMeta, null);
            Map<ManagedObjectReference, DeferredPolicyOptionParameter[]> deferredPolicyOptionsBeforeImport = null;
            if (StringUtils.isNotEmpty((String)spec.formattedHostCustomizations)) {
                deferredPolicyOptionsBeforeImport = this.hostCustomizationsService.createDeferredPolicyOptionParameterMap(spec.currentHostCustomizations, hostEntityNameMap);
                newDeferredPolicyOptionsData = this.importService.importH5HostCustomizations(spec.hostProfile, targetHosts, spec.formattedHostCustomizations);
            } else {
                newDeferredPolicyOptionsData = this.getDeferredHostSettingsFromTheServer(spec.hostProfile, targetHosts, spec.isNewlyAssociatedProfile, null, hostProfileMeta.policyMetadata);
            }
            if (newDeferredPolicyOptionsData.getFaults().size() > 0) {
                operationResult.error = new CompositeException(newDeferredPolicyOptionsData.getFaults());
            }
            operationResult.result = settings = this.hostCustomizationsService.createHostCustomizationSettingsData(hostProfileMeta.policyMetadata, relevantProfilePaths, newDeferredPolicyOptionsData.getUserInputMap(), deferredPolicyOptionsBeforeImport, hostEntityNameMap);
        }
        catch (Exception e) {
            logger.error((Object)"Could not read host customization setting.", (Throwable)e);
            operationResult.error = e;
        }
        return new OperationResult[]{operationResult};
    }

    private ProfileManager.HostProfileMetadata getHostProfileMetadata(ManagedObjectReference profileRef) throws Exception {
        ManagedObjectReference[] profileRefs = new ManagedObjectReference[]{profileRef};
        Map<ManagedObjectReference, ProfileManager.HostProfileMetadata> hostProfilesMeta = this.hostCustomizationsService.getHostProfilesMetadata(profileRefs, null);
        return hostProfilesMeta.get(profileRef);
    }

    private ArrayList<DynamicObject> extractHostSettings(ManagedObjectReference[] hosts, PolicyMetadata[] policiesMetadata, Map<String, String> relevantProfilePaths, Map<ManagedObjectReference, DeferredPolicyOptionParameter[]> cachedResults, Map<ManagedObjectReference, String> hostEntityNameMap) throws Exception {
        ArrayList<DynamicObject> resultList = new ArrayList<DynamicObject>();
        for (ManagedObjectReference host : hosts) {
            DeferredPolicyOptionParameter[] deferredParameters = cachedResults.get(host);
            String hostName = hostEntityNameMap.get(host);
            if (deferredParameters != null) {
                Collection<DynamicObject> result = this.hostCustomizationsService.extractDeferredHostSettings(hostName, policiesMetadata, relevantProfilePaths, deferredParameters, null);
                resultList.addAll(result);
                continue;
            }
            logger.warn((Object)("Execute result is null for host: " + hostName));
        }
        return resultList;
    }

    private static ManagedObjectReference[] getManagedObjectReferences(Object[] objects, String simpleClassName) {
        ArrayList<ManagedObjectReference> entityList = new ArrayList<ManagedObjectReference>();
        for (Object object : objects) {
            if (!(object instanceof ManagedObjectReference)) continue;
            ManagedObjectReference reference = (ManagedObjectReference)object;
            if (simpleClassName != null && !simpleClassName.equals(reference.getType())) continue;
            entityList.add(reference);
        }
        return entityList.toArray(new ManagedObjectReference[entityList.size()]);
    }

    private class ExtractHostCustomizationsResult
    implements HostCustomizationData {
        private final DynamicObject[] deferredHostSettings;
        private final Map<ManagedObjectReference, DeferredPolicyOptionParameter[]> userInputMap;
        private final List<Exception> faults;

        ExtractHostCustomizationsResult(ArrayList<DynamicObject> resultList, DeferredPolicyOptionData deferredPolicyOptionData) {
            DynamicObject[] result = new DynamicObject[resultList.size()];
            this.deferredHostSettings = resultList.toArray(result);
            this.userInputMap = deferredPolicyOptionData.getUserInputMap() == null ? Collections.emptyMap() : deferredPolicyOptionData.getUserInputMap();
            this.faults = deferredPolicyOptionData.getFaults() == null ? Collections.emptyList() : deferredPolicyOptionData.getFaults();
        }

        ExtractHostCustomizationsResult(List<Exception> faults) {
            this.deferredHostSettings = new DynamicObject[0];
            this.userInputMap = Collections.emptyMap();
            this.faults = faults == null ? Collections.emptyList() : faults;
        }

        @Override
        public DynamicObject[] getDeferredHostSettings() {
            return this.deferredHostSettings;
        }

        @Override
        public Map<ManagedObjectReference, DeferredPolicyOptionParameter[]> getUserInputMap() {
            return this.userInputMap;
        }

        @Override
        public List<Exception> getFaults() {
            return this.faults;
        }
    }
}

