/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.hostprofile.impl;

import com.vmware.vim.binding.vim.ClusterComputeResource;
import com.vmware.vim.binding.vim.HostSystem;
import com.vmware.vim.binding.vim.profile.ComplianceManager;
import com.vmware.vim.binding.vim.profile.ComplianceResult;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.core.model.exception.CompositeException;
import com.vmware.vise.data.PropertySpec;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.DataServiceExtensionRegistry;
import com.vmware.vise.data.query.PropertyProviderAdapter;
import com.vmware.vise.data.query.PropertyRequestSpec;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.query.TypeInfo;
import com.vmware.vise.data.query.util.QueryUtil;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vise.vim.commons.MixedUtil;
import com.vmware.vsphere.client.hostprofile.util.HostProfileUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.Validate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HostCompliancePropertyAdapter
implements PropertyProviderAdapter {
    private static final Log _logger = LogFactory.getLog(HostCompliancePropertyAdapter.class);
    private final DataService _dataService;

    public HostCompliancePropertyAdapter(DataServiceExtensionRegistry registry, DataService dataService) {
        registry.registerDataAdapter((PropertyProviderAdapter)this, this.getProvidedTypeInfos());
        this._dataService = dataService;
    }

    private TypeInfo[] getProvidedTypeInfos() {
        TypeInfo hostTypeInfo = new TypeInfo();
        hostTypeInfo.type = HostSystem.class.getSimpleName();
        hostTypeInfo.properties = new String[]{"hostProfileCompliance", "clusterProfileCompliance"};
        TypeInfo clusterTypeInfo = new TypeInfo();
        clusterTypeInfo.type = ClusterComputeResource.class.getSimpleName();
        clusterTypeInfo.properties = new String[]{"hostProfileCompliance", "clusterProfileCompliance"};
        return new TypeInfo[]{hostTypeInfo, clusterTypeInfo};
    }

    public ResultSet getProperties(PropertyRequestSpec propertyRequest) {
        Validate.notNull((Object)propertyRequest);
        Object[] objects = propertyRequest.objects;
        PropertySpec[] propertySpecs = propertyRequest.properties;
        Map<ManagedObjectReference, Collection<PropertyValue>> properties = HostCompliancePropertyAdapter.filterSystemObjects(objects);
        ArrayList<Exception> faults = new ArrayList<Exception>();
        this.extractProfileCompliance(properties, faults, propertySpecs, true);
        this.extractProfileCompliance(properties, faults, propertySpecs, false);
        ResultSet result = new ResultSet();
        if (faults.size() > 0) {
            result.error = new CompositeException(faults);
        }
        result.items = HostCompliancePropertyAdapter.mergeResults(properties);
        return result;
    }

    private void extractProfileCompliance(Map<ManagedObjectReference, Collection<PropertyValue>> propertiesResult, List<Exception> faults, PropertySpec[] propertySpecs, boolean extractHostProfile) {
        if (extractHostProfile && !HostProfileUtils.isPropertyRequested((String)"hostProfileCompliance", (PropertySpec[])propertySpecs)) {
            return;
        }
        if (!extractHostProfile && !HostProfileUtils.isPropertyRequested((String)"clusterProfileCompliance", (PropertySpec[])propertySpecs)) {
            return;
        }
        Map<String, Map<ManagedObjectReference, Collection<ManagedObjectReference>>> entitiesPerVC = this.groupEntitiesByGuid(propertiesResult.keySet(), extractHostProfile);
        for (Map.Entry<String, Map<ManagedObjectReference, Collection<ManagedObjectReference>>> groupedEntitiesPerVC : entitiesPerVC.entrySet()) {
            Map<ManagedObjectReference, Collection<ManagedObjectReference>> entitiesPerProfile = groupedEntitiesPerVC.getValue();
            for (Map.Entry<ManagedObjectReference, Collection<ManagedObjectReference>> groupedEntitiesPerProfile : entitiesPerProfile.entrySet()) {
                try {
                    ManagedObjectReference[] entities = groupedEntitiesPerProfile.getValue().toArray(new ManagedObjectReference[0]);
                    ManagedObjectReference profileRef = groupedEntitiesPerProfile.getKey();
                    ComplianceResult[] complianceResults = HostCompliancePropertyAdapter.getComplianceResultProperty(groupedEntitiesPerVC.getKey(), profileRef, entities);
                    this.assignComplianceResultProperty(complianceResults, propertiesResult, profileRef, entities, extractHostProfile);
                }
                catch (Exception ex) {
                    faults.add((Exception)MixedUtil.getMethodFault((Throwable)ex));
                }
            }
        }
    }

    private static Map<ManagedObjectReference, Collection<PropertyValue>> filterSystemObjects(Object[] objects) {
        HashMap<ManagedObjectReference, Collection<PropertyValue>> hostsAndClusters = new HashMap<ManagedObjectReference, Collection<PropertyValue>>();
        for (Object object : objects) {
            ManagedObjectReference reference;
            if (!(object instanceof ManagedObjectReference) || !(reference = (ManagedObjectReference)object).getType().equals(ClusterComputeResource.class.getSimpleName()) && !reference.getType().equals(HostSystem.class.getSimpleName())) continue;
            hostsAndClusters.put(reference, new ArrayList());
        }
        return hostsAndClusters;
    }

    private Map<String, Map<ManagedObjectReference, Collection<ManagedObjectReference>>> groupEntitiesByGuid(Collection<ManagedObjectReference> hostsAndClusters, boolean groupByHostProfile) {
        HashMap<String, Map<ManagedObjectReference, Collection<ManagedObjectReference>>> result = new HashMap<String, Map<ManagedObjectReference, Collection<ManagedObjectReference>>>();
        String profilePropertyName = groupByHostProfile ? "associatedHostProfile" : "associatedClusterProfile";
        try {
            PropertyValue[] profileValues;
            for (PropertyValue profileValue : profileValues = QueryUtil.getProperties((DataService)this._dataService, (Object[])hostsAndClusters.toArray(), (String[])new String[]{profilePropertyName})) {
                LinkedList<ManagedObjectReference> groupedByProfile;
                ManagedObjectReference entity = (ManagedObjectReference)profileValue.resourceObject;
                ManagedObjectReference profileRef = (ManagedObjectReference)profileValue.value;
                if (profileRef == null) continue;
                String serverGuid = entity.getServerGuid();
                HashMap<ManagedObjectReference, LinkedList<ManagedObjectReference>> groupedByVC = (HashMap<ManagedObjectReference, LinkedList<ManagedObjectReference>>)result.get(serverGuid);
                if (groupedByVC == null) {
                    groupedByVC = new HashMap<ManagedObjectReference, LinkedList<ManagedObjectReference>>();
                    result.put(serverGuid, groupedByVC);
                }
                if ((groupedByProfile = (LinkedList<ManagedObjectReference>)groupedByVC.get(profileRef)) == null) {
                    groupedByProfile = new LinkedList<ManagedObjectReference>();
                    groupedByVC.put(profileRef, groupedByProfile);
                }
                groupedByProfile.add(entity);
            }
        }
        catch (Exception e) {
            _logger.warn((Object)"Cannot extract associated profiles.", (Throwable)e);
        }
        return result;
    }

    private static ComplianceResult[] getComplianceResultProperty(String serverGuid, ManagedObjectReference profile, ManagedObjectReference[] entities) throws Exception {
        ComplianceManager complianceManager = HostProfileUtils.getComplianceManager((String)serverGuid);
        return complianceManager.queryComplianceStatus(new ManagedObjectReference[]{profile}, entities);
    }

    private void assignComplianceResultProperty(ComplianceResult[] complianceResults, Map<ManagedObjectReference, Collection<PropertyValue>> properties, ManagedObjectReference profileRef, ManagedObjectReference[] entities, boolean extractHostProfile) throws Exception {
        SlotHolder slots = new SlotHolder();
        int resultIndex = 0;
        for (ManagedObjectReference reference : entities) {
            resultIndex = slots.getNextFreeSlot(resultIndex);
            ComplianceResult complianceResult = null;
            if (complianceResults != null && resultIndex < complianceResults.length) {
                complianceResult = complianceResults[resultIndex];
            }
            if (complianceResult == null || !ManagedObjectUtil.areEqual((ManagedObjectReference)reference, (ManagedObjectReference)complianceResult.entity).booleanValue()) {
                int foundResultIndex = HostCompliancePropertyAdapter.getResultIndex(complianceResults, resultIndex, reference);
                if (foundResultIndex == -1) {
                    complianceResult = this.getUnknownComplianceResult(reference, profileRef);
                } else {
                    complianceResult = complianceResults[foundResultIndex];
                    slots.reserveSlot(foundResultIndex);
                }
            } else {
                ++resultIndex;
            }
            PropertyValue value = new PropertyValue();
            value.resourceObject = complianceResult.entity;
            value.propertyName = extractHostProfile ? "hostProfileCompliance" : "clusterProfileCompliance";
            value.value = complianceResult;
            properties.get(reference).add(value);
        }
    }

    private static int getResultIndex(ComplianceResult[] complianceResults, int offsetResultPosition, ManagedObjectReference reference) {
        if (complianceResults != null) {
            for (int index = offsetResultPosition; index < complianceResults.length; ++index) {
                if (!ManagedObjectUtil.areEqual((ManagedObjectReference)reference, (ManagedObjectReference)complianceResults[index].entity).booleanValue()) continue;
                return index;
            }
        }
        return -1;
    }

    private ComplianceResult getUnknownComplianceResult(ManagedObjectReference hostRef, ManagedObjectReference profileRef) throws Exception {
        ComplianceResult result = new ComplianceResult();
        result.entity = hostRef;
        result.complianceStatus = ComplianceResult.Status.unknown.name();
        result.profile = profileRef;
        return result;
    }

    private static ResultItem[] mergeResults(Map<ManagedObjectReference, Collection<PropertyValue>> properties) {
        ResultItem[] result = new ResultItem[properties.size()];
        int index = 0;
        for (Map.Entry<ManagedObjectReference, Collection<PropertyValue>> entityItem : properties.entrySet()) {
            ResultItem resultItem = new ResultItem();
            resultItem.resourceObject = entityItem.getKey();
            resultItem.properties = entityItem.getValue().toArray(new PropertyValue[0]);
            result[index++] = resultItem;
        }
        return result;
    }

    private static final class SlotHolder {
        private final Set<Integer> _usedSlots = new HashSet<Integer>();

        private SlotHolder() {
        }

        public void reserveSlot(int slotIndex) {
            this._usedSlots.add(slotIndex);
        }

        public int getNextFreeSlot(int startIndex) {
            while (this._usedSlots.remove(startIndex)) {
                ++startIndex;
            }
            return startIndex;
        }
    }
}

