/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.hostprofile.impl.hostcustomizations;

import com.vmware.vim.binding.vim.profile.DeferredPolicyOptionParameter;
import com.vmware.vim.binding.vim.profile.PolicyMetadata;
import com.vmware.vim.binding.vim.profile.host.AnswerFile;
import com.vmware.vim.binding.vim.profile.host.ExecuteResult;
import com.vmware.vim.binding.vim.profile.host.HostApplyProfile;
import com.vmware.vim.binding.vim.profile.host.HostProfile;
import com.vmware.vim.binding.vim.profile.host.ProfileManager;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.binding.vmodl.MethodFault;
import com.vmware.vise.core.model.mutation.OperationResult;
import com.vmware.vise.data.common.DynamicObject;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.util.session.SessionUtil;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vise.vim.commons.MixedUtil;
import com.vmware.vsphere.client.hostprofile.data.DeferredHostSettingsSpec;
import com.vmware.vsphere.client.hostprofile.data.DeferredSettingsValidationResult;
import com.vmware.vsphere.client.hostprofile.data.ExecuteResultWrapper;
import com.vmware.vsphere.client.hostprofile.data.ProfileWrapper;
import com.vmware.vsphere.client.hostprofile.data.h5.HostCustomizationIntermediateValidationResult;
import com.vmware.vsphere.client.hostprofile.impl.hostcustomizations.HostCustomizationsService;
import com.vmware.vsphere.client.hostprofile.impl.hostcustomizations.data.DeferredPolicyOptionData;
import com.vmware.vsphere.client.hostprofile.impl.hostcustomizations.data.DeferredPolicyOptionDataImpl;
import com.vmware.vsphere.client.hostprofile.util.HostProfileUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HostCustomizationsSequenceService {
    private static final Log logger = LogFactory.getLog(HostCustomizationsSequenceService.class);
    private final HostCustomizationsService service;
    private final ThreadPoolExecutor threadPool;

    public HostCustomizationsSequenceService(HostCustomizationsService service, ThreadPoolExecutor threadPool) {
        this.threadPool = threadPool;
        this.service = service;
    }

    public HostCustomizationIntermediateValidationResult validateHostCustomizations(final ManagedObjectReference profileRef, final DeferredHostSettingsSpec spec, ManagedObjectReference[] hosts, Map<ManagedObjectReference, DeferredPolicyOptionParameter[]> deferredPolicyOptionParameterMap, final PolicyMetadata[] policyMetadata) throws Exception {
        final ConcurrentHashMap cachedResults = new ConcurrentHashMap();
        final ArrayList errors = new ArrayList();
        ArrayList<1> validationTasks = new ArrayList<1>(hosts.length);
        final HttpServletRequest threadContext = SessionUtil.getHttpRequest();
        final ConcurrentHashMap<ManagedObjectReference, DeferredSettingsValidationResult> allValidationResults = new ConcurrentHashMap<ManagedObjectReference, DeferredSettingsValidationResult>();
        final ConcurrentHashMap<ManagedObjectReference, DeferredPolicyOptionParameter[]> deferredPolicyOptionMap = new ConcurrentHashMap<ManagedObjectReference, DeferredPolicyOptionParameter[]>(deferredPolicyOptionParameterMap);
        for (final ManagedObjectReference host : hosts) {
            Callable<Void> validationTask = new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    Object[] deferredSettings = (DeferredPolicyOptionParameter[])deferredPolicyOptionMap.get(host);
                    if (ArrayUtils.isEmpty((Object[])deferredSettings) && !spec.executeProfile) {
                        return null;
                    }
                    SessionUtil.setHttpRequest((HttpServletRequest)threadContext);
                    try {
                        DeferredSettingsValidationResult validationResult = HostCustomizationsSequenceService.this.runValidationOnServer(profileRef, spec, host, (DeferredPolicyOptionParameter[])deferredSettings, cachedResults, policyMetadata);
                        allValidationResults.put(host, validationResult);
                    }
                    catch (Exception e) {
                        logger.warn((Object)("Could not validate host: " + host), (Throwable)e);
                        errors.add(e);
                    }
                    finally {
                        SessionUtil.setHttpRequest(null);
                    }
                    return null;
                }
            };
            validationTasks.add(validationTask);
        }
        try {
            this.threadPool.invokeAll(validationTasks, 1L, TimeUnit.HOURS);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        HostCustomizationIntermediateValidationResult result = new HostCustomizationIntermediateValidationResult();
        if (!errors.isEmpty()) {
            result.genericErrors = errors;
        }
        boolean hasValidationErrors = this.hasValidationErrors(allValidationResults);
        result.hostToValidationResult = allValidationResults;
        if (!hasValidationErrors && errors.isEmpty()) {
            result.cachedResults = cachedResults;
        }
        return result;
    }

    private boolean hasValidationErrors(Map<ManagedObjectReference, DeferredSettingsValidationResult> allValidationResults) {
        boolean hasValidationErrors = false;
        for (DeferredSettingsValidationResult validationResult : allValidationResults.values()) {
            if (ExecuteResult.Status.success.toString().equals(validationResult.status)) continue;
            hasValidationErrors = true;
        }
        return hasValidationErrors;
    }

    private DeferredSettingsValidationResult runValidationOnServer(ManagedObjectReference profileRef, DeferredHostSettingsSpec spec, ManagedObjectReference hostRef, DeferredPolicyOptionParameter[] deferredSettings, Map<String, ExecuteResultWrapper> cachedResults, PolicyMetadata[] policyMetadata) throws Exception {
        DeferredSettingsValidationResult validationResult = null;
        if (!spec.executeProfile && HostProfileUtils.isVc51OrLater((ManagedObjectReference)profileRef)) {
            ProfileManager profileManager = HostProfileUtils.getProfileManager((String)profileRef.getServerGuid());
            HostApplyProfile applyProfile = this.service.getHostApplyProfile(profileRef, spec.isNewlyAssociatedProfile, spec.hostApplyProfileWrapper, policyMetadata);
            ProfileManager.AnswerFileOptionsCreateSpec answerFileSpec = new ProfileManager.AnswerFileOptionsCreateSpec();
            answerFileSpec.userInput = deferredSettings;
            answerFileSpec.validating = true;
            ProfileManager.AnswerFileValidationResult answerFileResult = profileManager.validateAnswerFile(hostRef, (ProfileManager.AnswerFileCreateSpec)answerFileSpec, applyProfile);
            if (answerFileResult != null) {
                validationResult = new DeferredSettingsValidationResult(answerFileResult);
            }
        } else {
            HostProfile profile = (HostProfile)ManagedObjectUtil.getManagedObject((ManagedObjectReference)profileRef);
            ExecuteResult executeResult = profile.execute(hostRef, deferredSettings);
            if (executeResult != null) {
                validationResult = new DeferredSettingsValidationResult(executeResult);
                ExecuteResultWrapper resultWrapper = new ExecuteResultWrapper(executeResult);
                cachedResults.put(ManagedObjectUtil.morefToString((ManagedObjectReference)hostRef), resultWrapper);
            }
        }
        return validationResult;
    }

    public OperationResult[] applyHostCustomizations(ManagedObjectReference profileRef, ManagedObjectReference[] forceValidationOnHosts, ManagedObjectReference[] skipValidationOnHosts, Object[] rows) throws Exception {
        ProfileManager profileManager = HostProfileUtils.getProfileManager((String)profileRef.getServerGuid());
        ArrayList<OperationResult> results = new ArrayList<OperationResult>();
        if (!ArrayUtils.isEmpty((Object[])forceValidationOnHosts)) {
            Collection<OperationResult> validatingHostsResult = this.applyDeferredSettings(rows, profileManager, forceValidationOnHosts, true);
            results.addAll(validatingHostsResult);
        }
        if (!ArrayUtils.isEmpty((Object[])skipValidationOnHosts)) {
            Collection<OperationResult> skipValidationHostsResult = this.applyDeferredSettings(rows, profileManager, skipValidationOnHosts, false);
            results.addAll(skipValidationHostsResult);
        }
        return results.toArray(new OperationResult[results.size()]);
    }

    private Collection<OperationResult> applyDeferredSettings(Object[] rows, ProfileManager profileManager, ManagedObjectReference[] hosts, Boolean validating) throws Exception {
        ArrayList<OperationResult> results = new ArrayList<OperationResult>(hosts.length);
        Map<ManagedObjectReference, String> hostEntityNameMap = this.service.createHostEntityNameMap(hosts);
        Map<ManagedObjectReference, DeferredPolicyOptionParameter[]> deferredPolicyOptionParameterMap = this.service.createDeferredPolicyOptionParameterMap(rows, hostEntityNameMap);
        for (ManagedObjectReference host : hosts) {
            OperationResult hostResult = new OperationResult();
            hostResult.entity = host;
            try {
                ProfileManager.AnswerFileOptionsCreateSpec createSpec = new ProfileManager.AnswerFileOptionsCreateSpec();
                createSpec.userInput = deferredPolicyOptionParameterMap.get(host);
                if (!ArrayUtils.isEmpty((Object[])createSpec.userInput)) {
                    createSpec.validating = validating;
                    hostResult.task = profileManager.updateAnswerFile(host, (ProfileManager.AnswerFileCreateSpec)createSpec);
                }
            }
            catch (Exception e) {
                logger.warn((Object)"Exception occurred during persistence of deferred host settings ", (Throwable)e);
                hostResult.error = MixedUtil.getMethodFault((Throwable)e);
            }
            results.add(hostResult);
        }
        return results;
    }

    public DeferredPolicyOptionData getDeferredHostSettings(ManagedObjectReference hostProfileRef, ManagedObjectReference[] hosts, boolean isNewlyAssociatedProfile, ProfileWrapper hostApplyProfileWrapper, PolicyMetadata[] policiesMetadata) throws Exception {
        final CopyOnWriteArrayList<Exception> faults = new CopyOnWriteArrayList<Exception>();
        final ConcurrentHashMap<ManagedObjectReference, DeferredPolicyOptionParameter[]> cachedResults = new ConcurrentHashMap<ManagedObjectReference, DeferredPolicyOptionParameter[]>();
        ArrayList<2> taskRequests = new ArrayList<2>(hosts.length);
        final HttpServletRequest threadContext = SessionUtil.getHttpRequest();
        final ProfileManager profileManager = HostProfileUtils.getProfileManager((String)hostProfileRef.getServerGuid());
        final HostApplyProfile applyProfile = this.service.getHostApplyProfile(hostProfileRef, isNewlyAssociatedProfile, hostApplyProfileWrapper, policiesMetadata);
        final PropertyValue[] hostsNames = this.service.getEntitiesName(hosts);
        for (final ManagedObjectReference hostRef : hosts) {
            Callable<Collection<DynamicObject>> callable = new Callable<Collection<DynamicObject>>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Collection<DynamicObject> call() throws Exception {
                    try {
                        SessionUtil.setHttpRequest((HttpServletRequest)threadContext);
                        DeferredPolicyOptionParameter[] deferredSettings = HostCustomizationsSequenceService.this.extractDeferredHostSettingsFromServer(profileManager, hostRef, applyProfile);
                        if (deferredSettings != null) {
                            cachedResults.put(hostRef, deferredSettings);
                        }
                    }
                    catch (Exception e) {
                        String hostName = HostCustomizationsSequenceService.this.service.getEntityName(hostsNames, hostRef);
                        logger.warn((Object)("Cannot extract deferred host settings on " + hostName), (Throwable)e);
                        MethodFault detailedException = MixedUtil.getMethodFault((Throwable)new Exception(hostName + " - " + e.getCause().getLocalizedMessage()));
                        faults.add(detailedException);
                    }
                    finally {
                        SessionUtil.setHttpRequest(null);
                    }
                    return null;
                }
            };
            taskRequests.add(callable);
        }
        try {
            this.threadPool.invokeAll(taskRequests, 1L, TimeUnit.HOURS);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        return new DeferredPolicyOptionDataImpl(cachedResults, faults);
    }

    private DeferredPolicyOptionParameter[] extractDeferredHostSettingsFromServer(ProfileManager profileManager, ManagedObjectReference hostRef, HostApplyProfile applyProfile) throws Exception {
        AnswerFile answerFile = applyProfile != null ? profileManager.retrieveAnswerFileForProfile(hostRef, applyProfile) : profileManager.retrieveAnswerFile(hostRef);
        DeferredPolicyOptionParameter[] deferredParameters = null;
        if (answerFile != null) {
            deferredParameters = answerFile.userInput;
        } else {
            logger.warn((Object)("Execute result is null for host: " + hostRef));
        }
        if (deferredParameters == null) {
            deferredParameters = new DeferredPolicyOptionParameter[]{};
        }
        return deferredParameters;
    }
}

