/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.dvs.hostmembers;

import com.vmware.vim.binding.vim.DistributedVirtualSwitch;
import com.vmware.vim.binding.vim.HostSystem;
import com.vmware.vim.binding.vim.dvs.DistributedVirtualPortgroup;
import com.vmware.vim.binding.vim.dvs.HostMember;
import com.vmware.vim.binding.vim.dvs.VmwareDistributedVirtualSwitch;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.Constraint;
import com.vmware.vise.data.PropertySpec;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.DataServiceExtensionRegistry;
import com.vmware.vise.data.query.ObjectIdentityConstraint;
import com.vmware.vise.data.query.PropertyProviderAdapter;
import com.vmware.vise.data.query.PropertyRequestSpec;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.query.TypeInfo;
import com.vmware.vise.data.query.util.QueryUtil;
import com.vmware.vsphere.client.dvs.hostmembers.DistributedVirtualSwitchHostMemberSpec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;

public class DistributedVirtualSwitchHostMemberProviderAdapter
implements PropertyProviderAdapter {
    private DataService _dataService;
    private static final String DVS_HOST_MEMBER = "distributedVirtualSwitchHostMember";

    public DistributedVirtualSwitchHostMemberProviderAdapter(DataServiceExtensionRegistry registry, DataService dataService) {
        registry.registerDataAdapter((PropertyProviderAdapter)this, this.getProvidedTypeInfos());
        this._dataService = dataService;
    }

    private TypeInfo[] getProvidedTypeInfos() {
        TypeInfo supported = new TypeInfo();
        supported.type = HostSystem.class.getSimpleName();
        supported.properties = new String[]{DVS_HOST_MEMBER};
        return new TypeInfo[]{supported};
    }

    public ResultSet getProperties(PropertyRequestSpec propertyRequest) {
        Validate.notNull((Object)propertyRequest);
        Object[] objects = propertyRequest.objects;
        PropertySpec[] properties = propertyRequest.properties;
        ResultSet rs = new ResultSet();
        try {
            ManagedObjectReference context = (ManagedObjectReference)properties[0].parameters[0].parameter;
            ObjectIdentityConstraint constraint = null;
            if (context == null || StringUtils.isEmpty((CharSequence)context.getType())) {
                throw new IllegalArgumentException("Empty context provided.");
            }
            if (DistributedVirtualSwitch.class.getSimpleName().equals(context.getType()) || VmwareDistributedVirtualSwitch.class.getSimpleName().equals(context.getType())) {
                constraint = QueryUtil.createObjectIdentityConstraint((Object)context);
            } else if (DistributedVirtualPortgroup.class.getSimpleName().equals(context.getType())) {
                constraint = QueryUtil.createRelationalConstraint((String)"dvs", (Constraint)QueryUtil.createObjectIdentityConstraint((Object)context), (Boolean)true, (String)DistributedVirtualSwitch.class.getSimpleName());
            } else {
                throw new IllegalArgumentException("Unsupported context provided.");
            }
            ResultSet dvsData = QueryUtil.getData((DataService)this._dataService, (QuerySpec)QueryUtil.buildQuerySpec((Constraint)constraint, (String[])new String[]{"config.host"}));
            ArrayList<HostMember> members = new ArrayList<HostMember>(Arrays.asList((HostMember[])dvsData.items[0].properties[0].value));
            ArrayList<ResultItem> results = new ArrayList<ResultItem>(objects.length);
            for (Object obj : objects) {
                ManagedObjectReference hostMor = (ManagedObjectReference)obj;
                Iterator it = members.iterator();
                while (it.hasNext()) {
                    HostMember hostMember = (HostMember)it.next();
                    if (!hostMember.config.host.equals((Object)hostMor)) continue;
                    it.remove();
                    DistributedVirtualSwitchHostMemberSpec dvshmSpec = new DistributedVirtualSwitchHostMemberSpec();
                    dvshmSpec.status = hostMember.status;
                    dvshmSpec.statusDetail = hostMember.statusDetail;
                    results.add(DistributedVirtualSwitchHostMemberProviderAdapter.getResultItem(hostMor, dvshmSpec));
                }
            }
            rs.items = results.toArray(new ResultItem[results.size()]);
        }
        catch (Exception e) {
            rs.error = e;
        }
        return rs;
    }

    private static ResultItem getResultItem(Object obj, Object value) {
        ResultItem ri = new ResultItem();
        ri.resourceObject = obj;
        ri.properties = DistributedVirtualSwitchHostMemberProviderAdapter.getValue(value);
        return ri;
    }

    private static PropertyValue[] getValue(Object value) {
        PropertyValue pv = new PropertyValue();
        pv.propertyName = DVS_HOST_MEMBER;
        pv.value = value;
        return new PropertyValue[]{pv};
    }
}

