/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.dvs.impl;

import com.vmware.vim.binding.vim.DistributedVirtualSwitch;
import com.vmware.vim.binding.vim.dvs.VmwareDistributedVirtualSwitch;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.PropertySpec;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.DataServiceExtensionRegistry;
import com.vmware.vise.data.query.PropertyProviderAdapter;
import com.vmware.vise.data.query.PropertyRequestSpec;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.query.TypeInfo;
import com.vmware.vise.data.query.util.QueryUtil;
import com.vmware.vise.data.query.util.ResultUtil;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vsphere.client.networking.util.Util;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.Validate;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DvsListPropertyProviderAdapter
implements PropertyProviderAdapter {
    private static final String LACP_VERSION_LABEL = "lacpVersionColumnLabel";
    private static final String LACP_API_VERSION = "config[@type='VMwareDVSConfigInfo'].lacpApiVersion";
    private static final String LACP_CAPABILITY = "capability.featuresSupported[@type='VMwareDVSFeatureCapability'].lacpCapability.lacpSupported";
    private static final String VMWARE_DVS_TYPE = VmwareDistributedVirtualSwitch.class.getSimpleName();
    private static final String DVS_TYPE = DistributedVirtualSwitch.class.getSimpleName();
    private static Log _logger = LogFactory.getLog(DvsListPropertyProviderAdapter.class);
    private final DataService _dataService;

    public DvsListPropertyProviderAdapter(DataServiceExtensionRegistry registry, DataService dataService) {
        registry.registerDataAdapter((PropertyProviderAdapter)this, this.getProvidedTypeInfos());
        this._dataService = dataService;
    }

    private TypeInfo[] getProvidedTypeInfos() {
        TypeInfo dvsTypeInfo = new TypeInfo();
        dvsTypeInfo.type = DVS_TYPE;
        dvsTypeInfo.properties = new String[]{LACP_VERSION_LABEL};
        TypeInfo vmwDvsTypeInfo = new TypeInfo();
        vmwDvsTypeInfo.type = VMWARE_DVS_TYPE;
        vmwDvsTypeInfo.properties = new String[]{LACP_VERSION_LABEL};
        return new TypeInfo[]{dvsTypeInfo, vmwDvsTypeInfo};
    }

    public ResultSet getProperties(PropertyRequestSpec propertyRequest) {
        Validate.notNull((Object)propertyRequest);
        Object[] objects = propertyRequest.objects;
        Object[] properties = propertyRequest.properties;
        if (ArrayUtils.isEmpty((Object[])objects) || ArrayUtils.isEmpty((Object[])properties)) {
            return null;
        }
        Map<String, ManagedObjectReference[]> switchesByType = this.getSwitchesByType(objects);
        HashSet<String> reqPropSet = new HashSet<String>();
        for (Object propSpec : properties) {
            if (((PropertySpec)propSpec).propertyNames == null) continue;
            for (String propName : ((PropertySpec)propSpec).propertyNames) {
                reqPropSet.add(propName);
            }
        }
        Object[] queryProps = this.getRequestedQueryProps(reqPropSet);
        ResultSet resultSet = null;
        if (!ArrayUtils.isEmpty((Object[])queryProps)) {
            try {
                ResultSet dvsPropValues = null;
                Object[] vmwSwitches = switchesByType.get(VMWARE_DVS_TYPE);
                if (vmwSwitches.length > 0) {
                    QuerySpec query = QueryUtil.buildQuerySpec((Object[])vmwSwitches, (String[])queryProps);
                    dvsPropValues = QueryUtil.getData((DataService)this._dataService, (QuerySpec)query);
                }
                resultSet = this.createResultSet(reqPropSet, dvsPropValues, switchesByType.get(DVS_TYPE));
            }
            catch (Exception e) {
                resultSet = new ResultSet();
                resultSet.error = e;
            }
        }
        return resultSet;
    }

    private String[] getRequestedQueryProps(Set<String> reqProps) {
        HashSet<String> queryProps = new HashSet<String>();
        if (reqProps.contains(LACP_VERSION_LABEL)) {
            queryProps.add(LACP_API_VERSION);
            queryProps.add(LACP_CAPABILITY);
        }
        return queryProps.toArray(new String[queryProps.size()]);
    }

    private ResultSet createResultSet(Set<String> reqPropSet, ResultSet propValues, ManagedObjectReference[] nonVmwSwitches) {
        ResultItem ri;
        int i;
        ResultSet resultSet = new ResultSet();
        LinkedList<ResultItem> items = new LinkedList<ResultItem>();
        if (propValues != null && !ArrayUtils.isEmpty((Object[])propValues.items)) {
            for (i = 0; i < propValues.items.length; ++i) {
                ri = propValues.items[i];
                ResultItem processedRes = new ResultItem();
                processedRes.resourceObject = ri.resourceObject;
                processedRes.properties = this.processResultSet(reqPropSet, ri);
                items.add(processedRes);
            }
        }
        if (!ArrayUtils.isEmpty((Object[])nonVmwSwitches)) {
            for (i = 0; i < nonVmwSwitches.length; ++i) {
                ri = new ResultItem();
                ri.resourceObject = nonVmwSwitches[i];
                ri.properties = new PropertyValue[1];
                ri.properties[0] = ResultUtil.newProperty((String)LACP_VERSION_LABEL, (Object)Util.getLocalizedString("noData"), (Object)ri.resourceObject);
                items.add(ri);
            }
        }
        resultSet.items = items.toArray(new ResultItem[items.size()]);
        return resultSet;
    }

    private PropertyValue[] processResultSet(Set<String> reqProps, ResultItem ri) {
        ArrayList<PropertyValue> results = new ArrayList<PropertyValue>();
        if (reqProps.contains(LACP_VERSION_LABEL)) {
            this.processLacpVersion(ri, results);
        }
        return results.toArray(new PropertyValue[results.size()]);
    }

    private void processLacpVersion(ResultItem ri, ArrayList<PropertyValue> propValues) {
        String lacpApiVersion = (String)Util.getPropertyValue(ri, LACP_API_VERSION);
        Boolean lacpCapability = (Boolean)Util.getPropertyValue(ri, LACP_CAPABILITY);
        propValues.add(ResultUtil.newProperty((String)LACP_VERSION_LABEL, (Object)Util.formatLacpVersion(lacpApiVersion, lacpCapability), (Object)ri.resourceObject));
    }

    private Map<String, ManagedObjectReference[]> getSwitchesByType(Object[] switches) {
        Validate.notNull((Object)switches);
        HashMap<String, ManagedObjectReference[]> switchesByType = new HashMap<String, ManagedObjectReference[]>();
        LinkedList<ManagedObjectReference> vmwDvsList = new LinkedList<ManagedObjectReference>();
        LinkedList<ManagedObjectReference> nonVmwDvsList = new LinkedList<ManagedObjectReference>();
        for (int i = 0; i < switches.length; ++i) {
            if (!(switches[i] instanceof ManagedObjectReference)) continue;
            ManagedObjectReference dvsRef = (ManagedObjectReference)switches[i];
            if (ManagedObjectUtil.isOfType((ManagedObjectReference)dvsRef, (String)VMWARE_DVS_TYPE)) {
                vmwDvsList.add(dvsRef);
                continue;
            }
            if (!ManagedObjectUtil.isOfType((ManagedObjectReference)dvsRef, (String)DVS_TYPE)) continue;
            nonVmwDvsList.add(dvsRef);
        }
        switchesByType.put(VMWARE_DVS_TYPE, vmwDvsList.toArray(new ManagedObjectReference[vmwDvsList.size()]));
        switchesByType.put(DVS_TYPE, nonVmwDvsList.toArray(new ManagedObjectReference[nonVmwDvsList.size()]));
        return switchesByType;
    }
}

