/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.dvs.impl;

import com.vmware.vim.binding.vim.HostSystem;
import com.vmware.vim.binding.vim.dvs.NetworkResourcePool;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.Constraint;
import com.vmware.vise.data.query.Comparator;
import com.vmware.vise.data.query.Conjoiner;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.PropertyConstraint;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.query.util.QueryUtil;
import com.vmware.vise.vim.security.LegacyAuthorizationService;
import com.vmware.vsphere.client.dvs.api.common.ValidationResultType;
import com.vmware.vsphere.client.dvs.api.featureupgrade.ValidationCheckResult;
import com.vmware.vsphere.client.dvs.impl.DvsUtil;
import com.vmware.vsphere.client.dvs.lacp.LacpUpgradePrerequisitesValidator;
import com.vmware.vsphere.client.networking.util.I18nUtil;
import com.vmware.vsphere.client.networking.util.Util;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DvsResControlUpgradePrerequisitesValidator {
    private static final Log _logger = LogFactory.getLog(LacpUpgradePrerequisitesValidator.class);
    private static final String PRIVILEGE_PORT_GROUP_MODIFY = "DVPortgroup.Modify";
    private static final String[] REQUIRED_PRIVILEGES_FOR_PORT_GROUP = new String[]{"DVPortgroup.Modify"};
    private static final String PROP_PORT_GROUP_NAME = "name";
    private static final String PROP_NETIORM_POLICY_OVERRIDE = "config.policy.networkResourcePoolOverrideAllowed";
    private static final String RELATION_HOST = "summary.hostMember";
    private static final String PROP_HOST_CONNECTION_STATE = "connectionState";
    private static final String PROP_HOST_NAME = "name";
    private final DataService _dataService;
    private final LegacyAuthorizationService _authorizationService;

    public ValidationCheckResult[] validatePrerequisites(ManagedObjectReference dvsRef) throws Exception {
        if (dvsRef == null) {
            return null;
        }
        ArrayList<ValidationCheckResult> results = new ArrayList<ValidationCheckResult>();
        ValidationCheckResult pgAccessCheckResult = this.validatePortGroupAccessibility(dvsRef);
        results.add(pgAccessCheckResult);
        boolean markValidationAsFailed = false;
        NetworkResourcePool[] pools = null;
        String[] disconnectedHosts = null;
        try {
            pools = (NetworkResourcePool[])QueryUtil.getProperty((DataService)this._dataService, (Object)dvsRef, (String)"networkResourcePool");
            disconnectedHosts = this.retrieveDisconnectedHosts(dvsRef);
        }
        catch (Exception ex) {
            _logger.error((Object)ex);
            markValidationAsFailed = true;
        }
        results.add(this.validateHostConnectionState(disconnectedHosts, markValidationAsFailed));
        results.add(this.validateCosTags(pools, markValidationAsFailed));
        ValidationCheckResult userDefinedPoolsCheckResult = this.validateUserDefinedPools(pools, markValidationAsFailed);
        results.add(userDefinedPoolsCheckResult);
        if (userDefinedPoolsCheckResult.type != ValidationResultType.pass) {
            ValidationCheckResult pgOverrideCheckResult = this.validatePortGroupOverrides(dvsRef, markValidationAsFailed);
            results.add(pgOverrideCheckResult);
            if (pgOverrideCheckResult.type != ValidationResultType.fail) {
                PropertyValue[] pgNames = this.retrievePoolAssociatedPortGroups(dvsRef);
                ValidationCheckResult pgPrivCheckResult = this.validatePortGroupPrivileges(pgNames, markValidationAsFailed);
                if (pgPrivCheckResult.type == ValidationResultType.fail) {
                    results.set(results.indexOf(pgAccessCheckResult), pgPrivCheckResult);
                }
            }
        }
        return DvsResControlUpgradePrerequisitesValidator.toArray(results);
    }

    private DvsResControlUpgradePrerequisitesValidator(DataService dataService, LegacyAuthorizationService authorizationService) {
        if (dataService == null) {
            throw new IllegalArgumentException("Parameter 'dataService' is required.");
        }
        if (authorizationService == null) {
            throw new IllegalArgumentException("Parameter 'authorizationService' is required.");
        }
        this._dataService = dataService;
        this._authorizationService = authorizationService;
    }

    private static ValidationCheckResult[] toArray(List<ValidationCheckResult> results) {
        return results.toArray(new ValidationCheckResult[results.size()]);
    }

    private static ValidationCheckResult createGeneralErrorValidationResult(String checkName) {
        return DvsResControlUpgradePrerequisitesValidator.createCheckResult(ValidationResultType.fail, checkName, I18nUtil.text("resControl.upgrade.check.genericError", new String[0]), null);
    }

    private static ValidationCheckResult createCheckResult(ValidationResultType type2, String checkName, String message, String[] affectedEntities) {
        ValidationCheckResult result = new ValidationCheckResult();
        result.type = type2;
        result.checkName = checkName;
        result.message = message;
        result.affectedEntities = affectedEntities;
        return result;
    }

    private ValidationCheckResult validatePortGroupAccessibility(ManagedObjectReference dvsRef) throws Exception {
        String checkName = I18nUtil.text("resControl.upgrade.check.pgAccess.name", new String[0]);
        try {
            boolean allAccessible = DvsUtil.areAllPortGroupsAccessible(dvsRef, this._dataService);
            if (allAccessible) {
                return DvsResControlUpgradePrerequisitesValidator.createCheckResult(ValidationResultType.pass, checkName, I18nUtil.text("resControl.upgrade.check.pgAccess.pass", new String[0]), null);
            }
            return DvsResControlUpgradePrerequisitesValidator.createCheckResult(ValidationResultType.fail, checkName, I18nUtil.text("resControl.upgrade.check.pgAccess.fail.noAccess", new String[0]), null);
        }
        catch (Exception ex) {
            _logger.error((Object)ex);
            return DvsResControlUpgradePrerequisitesValidator.createGeneralErrorValidationResult(checkName);
        }
    }

    private ValidationCheckResult validatePortGroupPrivileges(PropertyValue[] pgNames, boolean markAsFailed) throws Exception {
        String checkName = I18nUtil.text("resControl.upgrade.check.pgAccess.name", new String[0]);
        if (markAsFailed) {
            return DvsResControlUpgradePrerequisitesValidator.createGeneralErrorValidationResult(checkName);
        }
        try {
            List<String> noPrivList = Util.checkEntitiesWithMissingPrivileges(pgNames, REQUIRED_PRIVILEGES_FOR_PORT_GROUP, this._authorizationService);
            if (noPrivList.isEmpty()) {
                return DvsResControlUpgradePrerequisitesValidator.createCheckResult(ValidationResultType.pass, checkName, I18nUtil.text("resControl.upgrade.check.pgAccess.pass", new String[0]), null);
            }
            return DvsResControlUpgradePrerequisitesValidator.createCheckResult(ValidationResultType.fail, checkName, I18nUtil.text("resControl.upgrade.check.pgAccess.fail.noPrivileges", new String[0]), noPrivList.toArray(new String[noPrivList.size()]));
        }
        catch (Exception ex) {
            _logger.error((Object)ex);
            return DvsResControlUpgradePrerequisitesValidator.createGeneralErrorValidationResult(checkName);
        }
    }

    private ValidationCheckResult validatePortGroupOverrides(ManagedObjectReference dvsRef, boolean markAsFailed) throws Exception {
        String checkName = I18nUtil.text("resControl.upgrade.check.pgOverrides.name", new String[0]);
        if (markAsFailed) {
            return DvsResControlUpgradePrerequisitesValidator.createGeneralErrorValidationResult(checkName);
        }
        try {
            ValidationCheckResult result;
            ResultSet rs = DvsUtil.retrievePortGroupsByOverridablePolicy(this._dataService, dvsRef, PROP_NETIORM_POLICY_OVERRIDE, new String[]{"name"});
            if (rs == null) {
                result = DvsResControlUpgradePrerequisitesValidator.createGeneralErrorValidationResult(checkName);
            } else if (rs.error != null) {
                _logger.error((Object)"Could not retrieve port groups that allow network I/O control override", (Throwable)rs.error);
                result = DvsResControlUpgradePrerequisitesValidator.createGeneralErrorValidationResult(checkName);
            } else if (ArrayUtils.isEmpty((Object[])rs.items)) {
                String[] portKeys = DvsUtil.retrieveStandaloneAndConflictPortKeys(dvsRef);
                result = portKeys == null || portKeys.length == 0 ? DvsResControlUpgradePrerequisitesValidator.createCheckResult(ValidationResultType.pass, checkName, I18nUtil.text("resControl.upgrade.check.pgOverrides.pass", new String[0]), null) : DvsResControlUpgradePrerequisitesValidator.createCheckResult(ValidationResultType.warning, checkName, I18nUtil.text("resControl.upgrade.check.pgOverrides.warn.standalonePorts", new String[0]), null);
            } else {
                Map<Object, Map<String, Object>> results = Util.resultSetToMap(rs);
                ArrayList<String> overrideAllowedPgList = new ArrayList<String>();
                for (Map<String, Object> pgProps : results.values()) {
                    String name = (String)pgProps.get("name");
                    overrideAllowedPgList.add(name);
                }
                assert (!overrideAllowedPgList.isEmpty());
                String[] affectedEntities = overrideAllowedPgList.toArray(new String[overrideAllowedPgList.size()]);
                result = DvsResControlUpgradePrerequisitesValidator.createCheckResult(ValidationResultType.warning, checkName, I18nUtil.text("resControl.upgrade.check.pgOverrides.warn.overrideAllowed", new String[0]), affectedEntities);
            }
            return result;
        }
        catch (Exception ex) {
            _logger.error((Object)ex);
            return DvsResControlUpgradePrerequisitesValidator.createGeneralErrorValidationResult(checkName);
        }
    }

    private ValidationCheckResult validateUserDefinedPools(NetworkResourcePool[] pools, boolean markAsFailed) {
        String checkName = I18nUtil.text("resControl.upgrade.check.userDefinedNrps.name", new String[0]);
        if (markAsFailed) {
            return DvsResControlUpgradePrerequisitesValidator.createGeneralErrorValidationResult(checkName);
        }
        if (pools != null) {
            for (NetworkResourcePool pool : pools) {
                if (DvsUtil.isSystemNetworkResourcePool(pool.key)) continue;
                return DvsResControlUpgradePrerequisitesValidator.createCheckResult(ValidationResultType.warning, checkName, I18nUtil.text("resControl.upgrade.check.userDefinedNrps.warn", new String[0]), null);
            }
        }
        return DvsResControlUpgradePrerequisitesValidator.createCheckResult(ValidationResultType.pass, checkName, I18nUtil.text("resControl.upgrade.check.userDefinedNrps.pass", new String[0]), null);
    }

    private ValidationCheckResult validateHostConnectionState(String[] disconnectedHosts, boolean markAsFailed) {
        String checkName = I18nUtil.text("resControl.upgrade.check.hostState.name", new String[0]);
        if (markAsFailed) {
            return DvsResControlUpgradePrerequisitesValidator.createGeneralErrorValidationResult(checkName);
        }
        if (ArrayUtils.isEmpty((Object[])disconnectedHosts)) {
            return DvsResControlUpgradePrerequisitesValidator.createCheckResult(ValidationResultType.pass, checkName, I18nUtil.text("resControl.upgrade.check.hostState.pass", new String[0]), null);
        }
        return DvsResControlUpgradePrerequisitesValidator.createCheckResult(ValidationResultType.fail, checkName, I18nUtil.text("resControl.upgrade.check.hostState.error", new String[0]), disconnectedHosts);
    }

    private ValidationCheckResult validateCosTags(NetworkResourcePool[] pools, boolean markAsFailed) {
        String checkName = I18nUtil.text("resControl.upgrade.check.cosTag.name", new String[0]);
        if (markAsFailed) {
            return DvsResControlUpgradePrerequisitesValidator.createGeneralErrorValidationResult(checkName);
        }
        if (pools != null) {
            ArrayList<String> cosTagResourcePoolList = new ArrayList<String>();
            for (NetworkResourcePool pool : pools) {
                if (!DvsUtil.isSystemNetworkResourcePool(pool.key) || !DvsUtil.isCosTagSpecified(pool)) continue;
                cosTagResourcePoolList.add(pool.name);
            }
            if (!cosTagResourcePoolList.isEmpty()) {
                String[] affectedEntities = cosTagResourcePoolList.toArray(new String[cosTagResourcePoolList.size()]);
                return DvsResControlUpgradePrerequisitesValidator.createCheckResult(ValidationResultType.warning, checkName, I18nUtil.text("resControl.upgrade.check.cosTag.warn", new String[0]), affectedEntities);
            }
        }
        return DvsResControlUpgradePrerequisitesValidator.createCheckResult(ValidationResultType.pass, checkName, I18nUtil.text("resControl.upgrade.check.cosTag.pass", new String[0]), null);
    }

    private PropertyValue[] retrievePoolAssociatedPortGroups(ManagedObjectReference dvsRef) throws Exception {
        Constraint constraint = DvsUtil.createPortGroupsWithNrpConstraint(dvsRef);
        QuerySpec query = QueryUtil.buildQuerySpec((Constraint)constraint, (String[])new String[]{"name"});
        ResultSet rs = QueryUtil.getData((DataService)this._dataService, (QuerySpec)query);
        if (rs == null || rs.items == null) {
            throw new Exception("Could not retrieve port groups that have associated NRPs");
        }
        PropertyValue[] pvs = new PropertyValue[rs.items.length];
        for (int i = 0; i < rs.items.length; ++i) {
            if (rs.items[i].properties == null || rs.items[i].properties.length != 1) {
                throw new Exception("Could not retrieve port groups that have associated NRPs");
            }
            pvs[i] = rs.items[i].properties[0];
        }
        return pvs;
    }

    private String[] retrieveDisconnectedHosts(ManagedObjectReference dvsRef) throws Exception {
        Constraint dvsHostConstraint = QueryUtil.createConstraintForRelationship((Object)dvsRef, (String)RELATION_HOST, (String)HostSystem.class.getSimpleName());
        PropertyConstraint hostConnectionPropConstraint = QueryUtil.createPropertyConstraint((String)HostSystem.class.getSimpleName(), (String)PROP_HOST_CONNECTION_STATE, (Comparator)Comparator.NOT_EQUALS, (Object)HostSystem.ConnectionState.connected.name());
        Constraint hostConstraint = QueryUtil.combineIntoSingleConstraint((Constraint[])new Constraint[]{dvsHostConstraint, hostConnectionPropConstraint}, (Conjoiner)Conjoiner.AND);
        QuerySpec hostSpec = QueryUtil.buildQuerySpec((Constraint)hostConstraint, (String[])new String[]{"name"});
        ResultSet hostResults = QueryUtil.getData((DataService)this._dataService, (QuerySpec)hostSpec);
        Util.validateResultSet("query-host-props", hostResults);
        ArrayList<String> hostNames = new ArrayList<String>();
        if (hostResults.items != null) {
            for (ResultItem ri : hostResults.items) {
                if (ri.properties == null || ri.properties.length != 1 || !"name".equals(ri.properties[0].propertyName)) continue;
                hostNames.add((String)ri.properties[0].value);
            }
        }
        return hostNames.toArray(new String[hostNames.size()]);
    }
}

