/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.dvs.ports;

import com.vmware.vim.binding.vim.dvs.DistributedVirtualPortgroup;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.Constraint;
import com.vmware.vise.data.PropertySpec;
import com.vmware.vise.data.ResourceSpec;
import com.vmware.vise.data.query.Comparator;
import com.vmware.vise.data.query.CompositeConstraint;
import com.vmware.vise.data.query.Conjoiner;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.query.util.QueryUtil;
import com.vmware.vsphere.client.dvs.ports.FetchedProperties;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

enum BatchComputedProperties {
    portgroupName{
        private static final String PORTGROUP_NAME = "name";

        @Override
        void compute(ResultItem pgItem, List<ResultItem> portItems, Map<BatchComputedProperties, Integer> batchPropertyIndices) {
            String pgValue = (String)BatchComputedProperties.getPropertyValueByName((String)PORTGROUP_NAME, (ResultItem)pgItem).value;
            for (ResultItem item : portItems) {
                item.properties[batchPropertyIndices.get((Object)((Object)this)).intValue()].value = pgValue;
            }
        }

        @Override
        String[] sourceProperties() {
            return new String[]{PORTGROUP_NAME};
        }

        @Override
        FetchedProperties[] requiredProperties() {
            return new FetchedProperties[]{FetchedProperties.portgroupKey};
        }
    }
    ,
    isNsxPort{
        private static final String IS_NSX_PORTGROUP = "isNsxPortgroup";

        @Override
        void compute(ResultItem pgItem, List<ResultItem> portItems, Map<BatchComputedProperties, Integer> batchPropertyIndices) {
            Boolean pgValue = (Boolean)BatchComputedProperties.getPropertyValueByName((String)IS_NSX_PORTGROUP, (ResultItem)pgItem).value;
            for (ResultItem item : portItems) {
                item.properties[batchPropertyIndices.get((Object)((Object)this)).intValue()].value = pgValue;
            }
        }

        @Override
        String[] sourceProperties() {
            return new String[]{IS_NSX_PORTGROUP};
        }

        @Override
        FetchedProperties[] requiredProperties() {
            return new FetchedProperties[]{FetchedProperties.portgroupKey};
        }
    };


    abstract FetchedProperties[] requiredProperties();

    abstract String[] sourceProperties();

    abstract void compute(ResultItem var1, List<ResultItem> var2, Map<BatchComputedProperties, Integer> var3);

    PropertyValue getPropertyValue(ResultItem item) {
        PropertyValue pv = new PropertyValue();
        pv.resourceObject = item.resourceObject;
        pv.propertyName = this.toString();
        pv.value = null;
        return pv;
    }

    static void processBatch(DataService dataService, ResultItem[] items, Map<FetchedProperties, Integer> propertyIndices, Map<BatchComputedProperties, Integer> batchPropertyIndices, ManagedObjectReference dvsRef, List<BatchComputedProperties> batch) throws Exception {
        Map<String, List<ResultItem>> keys = BatchComputedProperties.parsePortgroupKeys(items, propertyIndices.get((Object)FetchedProperties.portgroupKey));
        ResultSet result = BatchComputedProperties.fetchPropertiesForPortgroups(keys, dvsRef, dataService, batch);
        BatchComputedProperties.assignPortgroupProperties(keys, result, batch, batchPropertyIndices);
    }

    private static Map<String, List<ResultItem>> parsePortgroupKeys(ResultItem[] items, int propertyIndex) {
        HashMap<String, List<ResultItem>> result = new HashMap<String, List<ResultItem>>();
        for (ResultItem item : items) {
            PropertyValue pValue = item.properties[propertyIndex];
            String pgKey = (String)pValue.value;
            if (StringUtils.isEmpty((CharSequence)pgKey)) continue;
            if (!result.containsKey(pgKey)) {
                result.put(pgKey, new ArrayList());
            }
            ((List)result.get(pgKey)).add(item);
        }
        return result;
    }

    private static ResultSet fetchPropertiesForPortgroups(Map<String, List<ResultItem>> portgroupKeys, ManagedObjectReference dvsRef, DataService dataService, List<BatchComputedProperties> batch) throws Exception {
        String[] pgKeys = portgroupKeys.keySet().toArray(new String[portgroupKeys.keySet().size()]);
        CompositeConstraint compositeConstraint = new CompositeConstraint();
        compositeConstraint.conjoiner = Conjoiner.OR;
        compositeConstraint.nestedConstraints = new Constraint[pgKeys.length];
        for (int i = 0; i < pgKeys.length; ++i) {
            compositeConstraint.nestedConstraints[i] = QueryUtil.createPropertyConstraint((String)DistributedVirtualPortgroup.class.getSimpleName(), (String)"key", (Comparator)Comparator.EQUALS, (Object)pgKeys[i]);
        }
        PropertySpec propertySpec = new PropertySpec();
        ArrayList<String> propertyNames = new ArrayList<String>(batch.size() + 1);
        propertyNames.add("key");
        for (BatchComputedProperties batchItem : batch) {
            propertyNames.addAll(Arrays.asList(batchItem.sourceProperties()));
        }
        propertySpec.propertyNames = propertyNames.toArray(new String[propertyNames.size()]);
        propertySpec.type = DistributedVirtualPortgroup.class.getSimpleName();
        CompositeConstraint rootCompositeConstraint = new CompositeConstraint();
        rootCompositeConstraint.conjoiner = Conjoiner.AND;
        rootCompositeConstraint.nestedConstraints = new Constraint[2];
        rootCompositeConstraint.nestedConstraints[0] = compositeConstraint;
        rootCompositeConstraint.nestedConstraints[1] = QueryUtil.createRelationalConstraint((String)"portgroup", (Constraint)QueryUtil.createObjectIdentityConstraint((Object)dvsRef), (Boolean)true, (String)dvsRef.getType());
        ResourceSpec resourceSpec = new ResourceSpec();
        resourceSpec.constraint = rootCompositeConstraint;
        resourceSpec.propertySpecs = new PropertySpec[]{propertySpec};
        QuerySpec querySpec = new QuerySpec();
        querySpec.resourceSpec = resourceSpec;
        return QueryUtil.getData((DataService)dataService, (QuerySpec)querySpec);
    }

    private static void assignPortgroupProperties(Map<String, List<ResultItem>> portgroupKeys, ResultSet resultSet, List<BatchComputedProperties> batch, Map<BatchComputedProperties, Integer> batchPropertyIndices) {
        if (resultSet != null && resultSet.items != null && resultSet.error == null) {
            for (ResultItem pgItem : resultSet.items) {
                String pgKey = (String)BatchComputedProperties.getPropertyValueByName((String)"key", (ResultItem)pgItem).value;
                for (BatchComputedProperties batchProp : batch) {
                    batchProp.compute(pgItem, portgroupKeys.get(pgKey), batchPropertyIndices);
                }
            }
        }
    }

    private static PropertyValue getPropertyValueByName(String propertyName, ResultItem item) {
        PropertyValue result = null;
        for (PropertyValue pv : item.properties) {
            if (!propertyName.equals(pv.propertyName)) continue;
            result = pv;
            break;
        }
        return result;
    }
}

