/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.switchdiagram.impl;

import com.vmware.vim.binding.vim.VirtualMachine;
import com.vmware.vim.binding.vim.vm.FaultToleranceConfigInfo;
import com.vmware.vim.binding.vim.vm.device.VirtualDevice;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.Constraint;
import com.vmware.vise.data.query.CompositeConstraint;
import com.vmware.vise.data.query.Conjoiner;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.ObjectIdentityConstraint;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.RelationalConstraint;
import com.vmware.vise.data.query.RequestSpec;
import com.vmware.vise.data.query.Response;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.query.internal.PropertyProviderBean;
import com.vmware.vise.data.query.type;
import com.vmware.vise.data.query.util.QueryUtil;
import com.vmware.vsphere.client.network.switchdiagram.api.spec.StandardNetworkSpec;
import com.vmware.vsphere.client.network.switchdiagram.api.spec.SwitchDiagramVmSpec;
import com.vmware.vsphere.client.networking.util.Util;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class VssDiagramPropertyProvider
implements PropertyProviderBean {
    private static final String HOST_STANDARD_NETWORK_RELATION = "standardnetwork";
    private static final String HOST_VM_PROPERTY = "vm";
    private static final String VM_STANDARD_NETWORK_PROPERTY = "standardnetwork";
    private static final String VM_NAME_PROPERTY = "name";
    private static final String VM_DEVICE_STD_BACKING_PROPERTY = "virtualEthernetStandardBacking";
    private static final String VM_POWER_STATE_PROPERTY = "runtime.powerState";
    private static final String VM_FT_INFO_PROPERTY = "config.ftInfo";
    private static final String VM_CONNECTION_STATE_PROPERTY = "runtime.connectionState";
    private static final String[] VSS_DIAGRAM_VM_PROPERTIES = new String[]{"name", "virtualEthernetStandardBacking", "runtime.powerState", "config.ftInfo", "runtime.connectionState"};
    private static final String STANDARD_NETWORK_NAME_PROPERTY = "name";
    private static final String STANDARD_NETWORK_VM_PROPERTY = "vm";
    private static final String VSS_DIAGRAM_VM_NET_QUERY_SPEC = "ns-vssdiagram-vmnet";
    private static final String VSS_DIAGRAM_NET_PROPS_QUERY_SPEC = "ns-vssdiagram-network-props";
    private static final String VSS_DIAGRAM_VMS_QUERY_SPEC = "ns-vssdiagram-vms";
    private static Log _logger = LogFactory.getLog(VssDiagramPropertyProvider.class);
    private final DataService _dataService;

    public VssDiagramPropertyProvider(DataService dataService) {
        this._dataService = dataService;
    }

    @type(value="HostSystem")
    public StandardNetworkSpec[] getStandardNetworkSpec(ManagedObjectReference hostSystemRef) throws Exception {
        long startTimeMs = System.currentTimeMillis();
        RequestSpec requestSpec = new RequestSpec();
        requestSpec.querySpec = this.getNetworksAndVmsQuerySpecs(hostSystemRef);
        Response response = this._dataService.getData(requestSpec);
        ResultSet pgResults = Util.findResultSetByName(VSS_DIAGRAM_NET_PROPS_QUERY_SPEC, response);
        Util.validateResultSet(VSS_DIAGRAM_NET_PROPS_QUERY_SPEC, pgResults);
        Map<ManagedObjectReference, StandardNetworkSpec> stdNetworkMap = this.getStandardNetworkSpecMap(pgResults);
        ResultSet vmResults = Util.findResultSetByName(VSS_DIAGRAM_VM_NET_QUERY_SPEC, response);
        Util.validateResultSet(VSS_DIAGRAM_VM_NET_QUERY_SPEC, vmResults);
        this.updateVmCounts(stdNetworkMap, vmResults);
        List<StandardNetworkSpec> stdNetworkList = stdNetworkMap.values().stream().filter(spec -> Util.isFieldInitialized(spec.name != null, spec.getClass(), "name") && Util.isFieldInitialized(spec.provider != null, spec.getClass(), "provider")).collect(Collectors.toList());
        if (_logger.isDebugEnabled()) {
            this.logStandardNetworkRetrievalDuration(stdNetworkList, System.currentTimeMillis() - startTimeMs);
        }
        return stdNetworkList.toArray(new StandardNetworkSpec[stdNetworkList.size()]);
    }

    @type(value="HostSystem")
    public SwitchDiagramVmSpec[] getVmsForStandardNetworks(ManagedObjectReference hostSystemRef, Object[] networkRefs) throws Exception {
        SwitchDiagramVmSpec[] vmArray;
        if (ArrayUtils.isEmpty((Object[])networkRefs)) {
            return new SwitchDiagramVmSpec[0];
        }
        long startTimeMs = System.currentTimeMillis();
        QuerySpec querySpecVms = this.getVmsQuerySpec(hostSystemRef, networkRefs);
        Response response = null;
        if (querySpecVms != null) {
            RequestSpec requestSpec = new RequestSpec();
            requestSpec.querySpec = new QuerySpec[]{querySpecVms};
            response = this._dataService.getData(requestSpec);
        }
        if (response != null && !ArrayUtils.isEmpty((Object[])response.resultSet)) {
            Util.validateResultSet(VSS_DIAGRAM_VMS_QUERY_SPEC, response.resultSet[0]);
            List<SwitchDiagramVmSpec> vmList = this.getVmSpecList(response.resultSet[0]);
            vmArray = vmList.toArray(new SwitchDiagramVmSpec[vmList.size()]);
        } else {
            vmArray = new SwitchDiagramVmSpec[]{};
        }
        if (_logger.isDebugEnabled()) {
            this.logVirtualMachineRetrievalDuration(networkRefs, vmArray, System.currentTimeMillis() - startTimeMs);
        }
        return vmArray;
    }

    private QuerySpec[] getNetworksAndVmsQuerySpecs(ManagedObjectReference hostSystemRef) {
        ArrayList<QuerySpec> querySpecs = new ArrayList<QuerySpec>();
        ObjectIdentityConstraint hostConstraint = QueryUtil.createObjectIdentityConstraint((Object)hostSystemRef);
        RelationalConstraint hostsVmsConstraint = QueryUtil.createRelationalConstraint((String)"vm", (Constraint)hostConstraint, (Boolean)true, (String)VirtualMachine.class.getSimpleName());
        QuerySpec querySpecVms = QueryUtil.buildQuerySpec((Constraint)hostsVmsConstraint, (String[])new String[]{"standardnetwork"});
        querySpecVms.name = VSS_DIAGRAM_VM_NET_QUERY_SPEC;
        querySpecs.add(querySpecVms);
        RelationalConstraint hostsNetworksConstraint = QueryUtil.createRelationalConstraint((String)"standardnetwork", (Constraint)hostConstraint, (Boolean)true, (String)VirtualMachine.class.getSimpleName());
        QuerySpec querySpecNetworks = QueryUtil.buildQuerySpec((Constraint)hostsNetworksConstraint, (String[])new String[]{"name"});
        querySpecNetworks.name = VSS_DIAGRAM_NET_PROPS_QUERY_SPEC;
        querySpecs.add(querySpecNetworks);
        return querySpecs.toArray(new QuerySpec[querySpecs.size()]);
    }

    private Map<ManagedObjectReference, StandardNetworkSpec> getStandardNetworkSpecMap(ResultSet pgResultSet) {
        HashMap<ManagedObjectReference, StandardNetworkSpec> stdNetworkMap = new HashMap<ManagedObjectReference, StandardNetworkSpec>();
        if (pgResultSet.items == null) {
            return stdNetworkMap;
        }
        for (ResultItem ri : pgResultSet.items) {
            String networkName = (String)Util.getPropertyValue(ri, "name");
            if (networkName == null || !(ri.resourceObject instanceof ManagedObjectReference)) continue;
            StandardNetworkSpec spec = new StandardNetworkSpec();
            spec.name = networkName;
            spec.provider = (ManagedObjectReference)ri.resourceObject;
            spec.vmCount = 0;
            stdNetworkMap.put(spec.provider, spec);
        }
        return stdNetworkMap;
    }

    private void updateVmCounts(Map<ManagedObjectReference, StandardNetworkSpec> stdNetworkMap, ResultSet vmResults) {
        if (vmResults.items == null) {
            return;
        }
        for (ResultItem ri : vmResults.items) {
            Object[] networks = (Object[])Util.getPropertyValue(ri, "standardnetwork");
            if (networks == null) continue;
            for (Object mor : networks) {
                StandardNetworkSpec spec = stdNetworkMap.get(mor);
                if (spec != null) {
                    ++spec.vmCount;
                    continue;
                }
                if (!_logger.isWarnEnabled()) continue;
                _logger.warn((Object)String.format("Virtual machine %s is assigned to network %s, which is not available on the host.", ri.resourceObject instanceof ManagedObjectReference ? ((ManagedObjectReference)ri.resourceObject).getValue() : null, mor instanceof ManagedObjectReference ? ((ManagedObjectReference)mor).getValue() : null));
            }
        }
    }

    private QuerySpec getVmsQuerySpec(ManagedObjectReference hostSystemRef, Object[] networkRefs) {
        ObjectIdentityConstraint hostConstraint = QueryUtil.createObjectIdentityConstraint((Object)hostSystemRef);
        RelationalConstraint hostsVmsConstraint = QueryUtil.createRelationalConstraint((String)"vm", (Constraint)hostConstraint, (Boolean)true, (String)VirtualMachine.class.getSimpleName());
        ArrayList<RelationalConstraint> networksConstraintList = new ArrayList<RelationalConstraint>();
        for (Object networkObj : networkRefs) {
            if (!(networkObj instanceof ManagedObjectReference)) continue;
            ObjectIdentityConstraint networkConstraint = QueryUtil.createObjectIdentityConstraint((Object)networkObj);
            RelationalConstraint networkVmsConstraint = QueryUtil.createRelationalConstraint((String)"vm", (Constraint)networkConstraint, (Boolean)true, (String)VirtualMachine.class.getSimpleName());
            networksConstraintList.add(networkVmsConstraint);
        }
        QuerySpec querySpec = null;
        if (!networksConstraintList.isEmpty()) {
            CompositeConstraint networksVmsConstraint = QueryUtil.createCompositeConstraint((Constraint[])((Constraint[])networksConstraintList.toArray(new RelationalConstraint[networksConstraintList.size()])), (Conjoiner)Conjoiner.OR);
            CompositeConstraint constraint = QueryUtil.createCompositeConstraint((Constraint[])new Constraint[]{hostsVmsConstraint, networksVmsConstraint}, (Conjoiner)Conjoiner.AND);
            querySpec = QueryUtil.buildQuerySpec((Constraint)constraint, (String[])VSS_DIAGRAM_VM_PROPERTIES);
            querySpec.name = VSS_DIAGRAM_VMS_QUERY_SPEC;
        }
        return querySpec;
    }

    private List<SwitchDiagramVmSpec> getVmSpecList(ResultSet vmResultSet) {
        ArrayList<SwitchDiagramVmSpec> vmList = new ArrayList<SwitchDiagramVmSpec>();
        if (vmResultSet.items == null) {
            return vmList;
        }
        for (ResultItem ri : vmResultSet.items) {
            SwitchDiagramVmSpec vmSpec = new SwitchDiagramVmSpec();
            vmSpec.provider = (ManagedObjectReference)ri.resourceObject;
            for (PropertyValue pv : ri.properties) {
                this.populateVmProperty(vmSpec, pv);
            }
            if (!Util.isFieldInitialized(vmSpec.name != null, vmSpec.getClass(), "name") || !Util.isFieldInitialized(vmSpec.provider != null, vmSpec.getClass(), "provider") || !Util.isFieldInitialized(!ArrayUtils.isEmpty((Object[])vmSpec.devices), vmSpec.getClass(), "devices")) continue;
            vmList.add(vmSpec);
        }
        return vmList;
    }

    private void populateVmProperty(SwitchDiagramVmSpec vmSpec, PropertyValue pv) {
        if (Util.checkPropertyValueNameType(pv, "name", String.class)) {
            vmSpec.name = (String)pv.value;
        } else if (Util.checkPropertyValueNameType(pv, VM_DEVICE_STD_BACKING_PROPERTY, VirtualDevice[].class)) {
            vmSpec.devices = (VirtualDevice[])pv.value;
        } else if (Util.checkPropertyValueNameType(pv, VM_CONNECTION_STATE_PROPERTY, VirtualMachine.ConnectionState.class)) {
            vmSpec.connectionState = (VirtualMachine.ConnectionState)pv.value;
        } else if (Util.checkPropertyValueNameType(pv, VM_FT_INFO_PROPERTY, FaultToleranceConfigInfo.class)) {
            vmSpec.ftInfo = (FaultToleranceConfigInfo)pv.value;
        } else if (Util.checkPropertyValueNameType(pv, VM_POWER_STATE_PROPERTY, VirtualMachine.PowerState.class)) {
            vmSpec.powerState = (VirtualMachine.PowerState)pv.value;
        }
    }

    private void logStandardNetworkRetrievalDuration(List<StandardNetworkSpec> networkSpecs, long durationMs) {
        double durationS = (double)durationMs / 1000.0;
        try {
            int networkCount = networkSpecs.size();
            int vmCount = 0;
            for (StandardNetworkSpec spec : networkSpecs) {
                vmCount += spec.vmCount;
            }
            String messageFormat = "Standard networks retrieved in %.3fs (Net %d VM %d)";
            _logger.debug((Object)String.format("Standard networks retrieved in %.3fs (Net %d VM %d)", durationS, networkCount, vmCount));
        }
        catch (RuntimeException ex) {
            _logger.error((Object)"Could not write performance data.", (Throwable)ex);
        }
    }

    private void logVirtualMachineRetrievalDuration(Object[] networkRefs, SwitchDiagramVmSpec[] vmSpecs, long durationMs) {
        double durationS = (double)durationMs / 1000.0;
        try {
            int networkCount = networkRefs != null ? networkRefs.length : 0;
            int vmCount = vmSpecs != null ? vmSpecs.length : 0;
            String messageFormat = "Virtual machines for standard networks retrieved in %.3fs (VM %d Net %d)";
            _logger.debug((Object)String.format("Virtual machines for standard networks retrieved in %.3fs (VM %d Net %d)", durationS, vmCount, networkCount));
        }
        catch (RuntimeException ex) {
            _logger.error((Object)"Could not write performance data.", (Throwable)ex);
        }
    }
}

