/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.wcp;

import com.vmware.vim.binding.vim.Task;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.core.model.monitor.ClientTaskInfo;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.query.util.QueryExecutor;
import com.vmware.vise.mvc.tasks.TaskQueryUtil;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class WCPUtils {
    private static final int TASK_LOOKUP_RETRY_DELAY_MS = 1000;
    private static final Log LOG = LogFactory.getLog(WCPUtils.class);

    public static String getFullIdFromMoRef(ManagedObjectReference objectRef) {
        return String.format("%s:%s", objectRef.getValue(), objectRef.getServerGuid());
    }

    public static Task findLatestTaskByObjectAndType(QueryExecutor executor, ManagedObjectReference clusterRef, String taskType) throws Exception {
        Thread.sleep(1000L);
        ManagedObjectReference taskRef = WCPUtils.findLatestTaskRefByObjectAndType(executor, clusterRef, taskType);
        if (taskRef == null) {
            Thread.sleep(1000L);
            ManagedObjectReference taskRefRetried = WCPUtils.findLatestTaskRefByObjectAndType(executor, clusterRef, taskType);
            if (taskRefRetried == null) {
                throw new IllegalStateException("Could not retrieve task of type '" + taskType + "' for object " + clusterRef);
            }
            return (Task)ManagedObjectUtil.getManagedObject((ManagedObjectReference)taskRefRetried);
        }
        return (Task)ManagedObjectUtil.getManagedObject((ManagedObjectReference)taskRef);
    }

    private static ManagedObjectReference findLatestTaskRefByObjectAndType(QueryExecutor executor, ManagedObjectReference clusterRef, String taskType) throws Exception {
        QuerySpec query = TaskQueryUtil.createTaskQuerySpec((Object)clusterRef, (boolean)false, (boolean)true, null, null, (int)100, (int)0);
        ResultSet resultSet = executor.getData(query);
        if (resultSet.error != null) {
            throw new IllegalStateException("Could not query state of task of type " + taskType + " for object " + clusterRef, resultSet.error);
        }
        if (ArrayUtils.isEmpty((Object[])resultSet.items)) {
            LOG.warn((Object)("Could not find expected task of type " + taskType + " for object " + clusterRef));
            return null;
        }
        ManagedObjectReference taskRef = null;
        Date latestStartTime = null;
        for (ResultItem item : resultSet.items) {
            ManagedObjectReference taskCandidateRef = (ManagedObjectReference)item.resourceObject;
            for (PropertyValue pv : item.properties) {
                if (!"info".equals(pv.propertyName)) {
                    throw new IllegalStateException("Only info property should be retrieved for tasks. Unexpected property " + pv.propertyName);
                }
                ClientTaskInfo cti = (ClientTaskInfo)pv.value;
                if (!taskType.equals(cti.taskTypeId)) continue;
                if (cti.startTime == null) {
                    LOG.info((Object)("Returning task " + taskCandidateRef + " in state " + cti.state + " with null start time."));
                    return taskCandidateRef;
                }
                if (latestStartTime != null && !cti.startTime.after(latestStartTime)) continue;
                LOG.info((Object)("Switching to task " + taskCandidateRef + " in state " + cti.state + " with startTime" + SimpleDateFormat.getInstance().format(cti.startTime)));
                taskRef = taskCandidateRef;
                latestStartTime = cti.startTime;
            }
        }
        return taskRef;
    }
}

