/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.wcp.cluster;

import com.vmware.cis.data.api.PropertyPredicate;
import com.vmware.cis.data.api.QueryService;
import com.vmware.cis.data.api.ResourceItem;
import com.vmware.cis.data.api.ResultSet;
import com.vmware.cis.data.model.PropertyProvider;
import com.vmware.cis.data.query.util.QueryServiceFactory;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vsphere.client.h5.wcp.cluster.model.EnableWcpCompatibilityData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;

public class ClusterPropertyProvider {
    private final String VPXD_CLUSTER_MODEL = "com.vmware.wcp.VpxdClusterComputeResourceModel";
    private final String ERRORS = "errors";
    private final String VDS_ERRORS = "vds_errors";
    private final String WCP_COMPATIBLE = "wcp_compatible";
    private final String WCP_VDS_COMPATIBLE = "wcp_vds_compatible";
    private final String WCP_DHCP_NETWORK_MODE_SUPPORTED = "dhcp_network_mode_supported";
    private QueryService _queryService;

    public ClusterPropertyProvider(QueryServiceFactory queryServiceFactory) {
        this._queryService = queryServiceFactory.getQueryService();
    }

    @PropertyProvider(value="ClusterComputeResource/enableWcpCompatibilityInfo")
    public List<EnableWcpCompatibilityData> getEnableWcpCompatibilityInfo(Collection<ManagedObjectReference> clusterRefs) {
        ArrayList<EnableWcpCompatibilityData> result = new ArrayList<EnableWcpCompatibilityData>();
        if (clusterRefs == null || clusterRefs.isEmpty()) {
            return result;
        }
        HashMap<ManagedObjectReference, EnableWcpCompatibilityData> resultMap = new HashMap<ManagedObjectReference, EnableWcpCompatibilityData>();
        for (ManagedObjectReference clusterRef : clusterRefs) {
            EnableWcpCompatibilityData compatibilityData = new EnableWcpCompatibilityData();
            result.add(compatibilityData);
            resultMap.put(clusterRef, compatibilityData);
        }
        ResultSet queryResult = this._queryService.select(new String[]{"errors", "wcp_compatible", "wcp_vds_compatible", "vds_errors", "dhcp_network_mode_supported"}).from(new String[]{"com.vmware.wcp.VpxdClusterComputeResourceModel"}).where("@modelKey", PropertyPredicate.ComparisonOperator.IN, clusterRefs).fetch();
        if (queryResult != null && queryResult.getItems() != null) {
            for (ResourceItem item : queryResult.getItems()) {
                EnableWcpCompatibilityData compatibilityData = (EnableWcpCompatibilityData)resultMap.get(item.getKey());
                if (compatibilityData == null) continue;
                compatibilityData.nsxtIncompatibilityErrors = (List)item.get("errors");
                compatibilityData.wcpNsxtCompatible = (Boolean)item.get("wcp_compatible");
                compatibilityData.wcpVdsCompatible = (Boolean)item.get("wcp_vds_compatible");
                compatibilityData.vdsIncompatibilityErrors = (List)item.get("vds_errors");
                compatibilityData.wcpDhcpNetworkModeSupportedKey = (Boolean)item.get("dhcp_network_mode_supported");
            }
        }
        return result;
    }
}

