/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.wcp.cluster.filter;

import com.vmware.cis.data.api.Filter;
import com.vmware.cis.data.api.LogicalOperator;
import com.vmware.cis.data.api.PropertyPredicate;
import com.vmware.cis.data.api.QueryService;
import com.vmware.cis.data.api.ResourceItem;
import com.vmware.cis.data.api.ResultSet;
import com.vmware.cis.data.query.util.QueryServiceFactory;
import com.vmware.vim.binding.vim.ClusterComputeResource;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.common.api.filters.QueryFilterBuilder;
import com.vmware.vise.common.api.filters.annotations.QueryFilter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class WCPClusterFilterBuilder
implements QueryFilterBuilder {
    private static final Log logger = LogFactory.getLog(WCPClusterFilterBuilder.class);
    private static final String PROPERTY_INSTANCE_UUID = "@instanceUuid";
    private static final String PROPERTY_UPDATE_AVAILABLE = "has_upgrades";
    private static final String PROPERTY_LICENSE_EXPIRED = "license_expired";
    private static final String PROPERTY_APPLY_LICENSE_EXPIRY_RESTRICTIONS = "apply_license_expiry_restrictions";
    private static final String WCP_CLUSTER_MODEL_TYPE = "com.vmware.wcp.AnySupervisorModel";
    private static final ManagedObjectReference NON_EXISTING_CLUSTER = new ManagedObjectReference(ClusterComputeResource.class.getSimpleName(), "noObjectId", "noServerGuid");
    private final QueryService _queryService;

    public WCPClusterFilterBuilder(QueryServiceFactory queryServiceFactory) {
        this._queryService = queryServiceFactory.getQueryService();
    }

    @QueryFilter(value="wcp-cluster-with-updates-on-vc-filter")
    public Filter wcpClusterOnAVCenterWithUpdatesFilter(String objectId, String[] filterParams) {
        ArrayList<PropertyPredicate> criteria = new ArrayList<PropertyPredicate>();
        PropertyPredicate upgradeAvailablePredicate = new PropertyPredicate(PROPERTY_UPDATE_AVAILABLE, PropertyPredicate.ComparisonOperator.EQUAL, (Object)true);
        criteria.add(upgradeAvailablePredicate);
        criteria.add(this.createSupervisorPropertyPredicate());
        if (filterParams[0] != null) {
            PropertyPredicate objectsByVCPredicate = new PropertyPredicate(PROPERTY_INSTANCE_UUID, PropertyPredicate.ComparisonOperator.EQUAL, (Object)filterParams[0]);
            criteria.add(objectsByVCPredicate);
        }
        return new Filter(criteria, LogicalOperator.AND);
    }

    private PropertyPredicate createSupervisorPropertyPredicate() {
        ResultSet resultSet = this._queryService.select(new String[]{"@modelKey"}).from(new String[]{WCP_CLUSTER_MODEL_TYPE}).where(LogicalOperator.OR, new PropertyPredicate[]{new PropertyPredicate(PROPERTY_LICENSE_EXPIRED, PropertyPredicate.ComparisonOperator.EQUAL, (Object)false), new PropertyPredicate(PROPERTY_APPLY_LICENSE_EXPIRY_RESTRICTIONS, PropertyPredicate.ComparisonOperator.EQUAL, (Object)false)}).fetch();
        List wcpSupervisorItems = resultSet.getItems();
        HashSet<Object> supervisors = new HashSet<Object>();
        for (ResourceItem wcpSupervisorItem : wcpSupervisorItems) {
            supervisors.add(wcpSupervisorItem.getKey());
        }
        if (supervisors.isEmpty()) {
            supervisors.add(NON_EXISTING_CLUSTER);
        }
        return new PropertyPredicate("@modelKey", PropertyPredicate.ComparisonOperator.IN, supervisors);
    }
}

